/*
 * Decompiled with CFR 0.152.
 */
package com.huateng.lc;

import com.huateng.lc.LicenseInfo;
import com.huateng.lc.Puk;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class License {
    private static final Logger Log = LoggerFactory.getLogger(License.class);
    private byte[] licenseKey;
    private LicenseInfo licenseInfo;
    private boolean isValid = false;
    private PublicKey puk = License.getPuk();
    private static License instance = null;

    private License() {
    }

    public String getCustomerName() {
        return this.licenseInfo == null ? null : this.licenseInfo.getCustomerName();
    }

    public byte[] getLicenseKey() {
        return this.licenseKey;
    }

    public boolean getIsValid() {
        return this.isValid;
    }

    public String getBase64LicenseKey() {
        return Base64.encodeBase64String((byte[])this.licenseKey);
    }

    public int getUserCount() {
        return this.licenseInfo == null ? 0 : this.licenseInfo.getMaxUserCount();
    }

    public LicenseInfo getlLicenseInfo() {
        return this.licenseInfo == null ? null : this.licenseInfo.deepClone();
    }

    public boolean verify(String base64Lc) {
        byte[] lc = Base64.decodeBase64((String)base64Lc);
        return this.verify(lc);
    }

    public boolean verify(byte[] lc) {
        LicenseInfo info = this.vv0(lc);
        return info != null;
    }

    public boolean verify(File file) {
        if (file.length() <= 0L || file.length() > 21000L) {
            return false;
        }
        return this.verify(this.readFile(file));
    }

    public boolean update(String base64Lc) {
        byte[] lc = Base64.decodeBase64((String)base64Lc);
        return this.update(lc);
    }

    public boolean update(File file) {
        if (file.length() <= 0L || file.length() > 1024L) {
            return false;
        }
        return this.update(this.readFile(file));
    }

    public boolean update(byte[] lc) {
        LicenseInfo info = this.vv0(lc);
        if (info != null) {
            this.licenseKey = Arrays.copyOf(lc, lc.length);
            this.licenseInfo = info;
            this.isValid = true;
            return true;
        }
        return false;
    }

    /*
     * Loose catch block
     */
    private byte[] readFile(File file) {
        FileInputStream fin = null;
        fin = new FileInputStream(file);
        byte[] bs = new byte[(int)file.length()];
        fin.read(bs);
        byte[] byArray = bs;
        try {
            fin.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
        catch (Exception e) {
            try {
                fin.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
            catch (Throwable throwable) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static PublicKey getPuk() {
        StringBuilder sb = new StringBuilder(90);
        License.addKeyPart(sb, Puk.Keys2);
        License.addKeyPart(sb, Puk.Keys1);
        int i = (4 - sb.length() % 4) % 4;
        while (i-- > 0) {
            sb.append('=');
        }
        String key = sb.toString();
        key = key.replace('#', '+');
        key = key.replace('@', '/');
        try {
            byte[] bs = Base64.decodeBase64((byte[])key.getBytes("ASCII"));
            X509EncodedKeySpec puks = new X509EncodedKeySpec(bs);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(puks);
        }
        catch (Exception e) {
            Log.error("getPuk error", (Throwable)e);
            return null;
        }
    }

    private static void addKeyPart(StringBuilder sb, String[] keyParts) {
        int i = 0;
        while (i < keyParts.length) {
            sb.append(keyParts[i]);
            ++i;
        }
    }

    private LicenseInfo vv0(byte[] license) {
        if (license != null && license.length > 16 && license.length < 21000) {
            int blockSize;
            Cipher cp;
            block8: {
                cp = Cipher.getInstance("RSA");
                cp.init(2, this.puk);
                blockSize = cp.getOutputSize(license.length);
                if (blockSize > 0) break block8;
                return null;
            }
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
                int off = 0;
                while (off < license.length) {
                    bout.write(cp.doFinal(license, off, blockSize));
                    off += blockSize;
                }
                byte[] result = bout.toByteArray();
                byte[] smd5 = Arrays.copyOfRange(result, 0, 16);
                byte[] data = Arrays.copyOfRange(result, 16, result.length);
                result = null;
                byte[] md5 = DigestUtils.md5((byte[])data);
                if (Arrays.equals(md5, smd5)) {
                    return LicenseInfo.parseInfo(data);
                }
            }
            catch (BadPaddingException ex) {
                if (Log.isDebugEnabled()) {
                    Log.debug("verify fail", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                Log.error("verify error", (Throwable)ex);
            }
        }
        return null;
    }

    public boolean vv() {
        if (this.licenseKey != null && this.licenseKey.length > 0) {
            return this.vv0(this.licenseKey) != null;
        }
        return false;
    }

    public static synchronized License getInstance() {
        if (instance == null) {
            instance = new License();
        }
        return instance;
    }
}

