/*
 * Decompiled with CFR 0.152.
 */
package com.huateng.lc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class LicenseInfo {
    public static final int MAX_LEN = 20480;
    private byte v = 1;
    private int maxUserCount = 0;
    private String customerName;
    private Date buyDate;
    private Date serviceEnd;
    private String buyer;
    private String customerID;
    private String productID;
    private List<ExtInfo> extInfos;

    public byte getV() {
        return this.v;
    }

    public void setV(byte v) {
        this.v = v;
    }

    public int getMaxUserCount() {
        return this.maxUserCount;
    }

    public void setMaxUserCount(int maxUserCount) {
        this.maxUserCount = maxUserCount;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Date getBuyDate() {
        return this.buyDate;
    }

    public void setBuyDate(Date serviceStart) {
        this.buyDate = serviceStart;
    }

    public Date getServiceEnd() {
        return this.serviceEnd;
    }

    public void setServiceEnd(Date serviceEnd) {
        this.serviceEnd = serviceEnd;
    }

    public String getBuyer() {
        return this.buyer;
    }

    public void setBuyer(String buyer) {
        this.buyer = buyer;
    }

    public String getCustomerID() {
        return this.customerID;
    }

    public void setCustomerID(String customerID) {
        this.customerID = customerID;
    }

    public String getProductID() {
        return this.productID;
    }

    public void setProductID(String productID) {
        this.productID = productID;
    }

    public List<ExtInfo> getExtInfos() {
        return this.extInfos;
    }

    public void setExtInfos(List<ExtInfo> extInfos) {
        this.extInfos = extInfos;
    }

    public void addExtInfo(String name, String content) {
        this.checkExtInfos();
        this.extInfos.add(new ExtInfo(name, content));
    }

    private synchronized void checkExtInfos() {
        if (this.extInfos == null) {
            this.extInfos = new ArrayList<ExtInfo>();
        }
    }

    public LicenseInfo deepClone() {
        LicenseInfo info = new LicenseInfo();
        info.v = this.v;
        info.buyDate = this.buyDate;
        info.serviceEnd = this.serviceEnd;
        info.buyer = this.buyer;
        info.customerID = this.customerID;
        info.customerName = this.customerName;
        info.maxUserCount = this.maxUserCount;
        info.productID = this.productID;
        if (this.extInfos != null) {
            info.extInfos = new ArrayList<ExtInfo>(this.extInfos.size());
            for (ExtInfo einfo : this.extInfos) {
                info.extInfos.add(einfo.clone());
            }
        }
        return info;
    }

    public byte[] toBytes() {
        ByteArrayOutputStream out = new ByteArrayOutputStream(512);
        DataOutputStream dout = new DataOutputStream(out);
        try {
            dout.writeByte(this.v);
            dout.writeInt(this.maxUserCount);
            dout.writeLong(this.buyDate.getTime());
            dout.writeLong(this.serviceEnd.getTime());
            dout.writeUTF(this.customerName);
            dout.writeUTF(this.customerID != null ? this.customerID : "");
            dout.writeUTF(this.buyer != null ? this.buyer : "");
            dout.writeUTF(this.productID != null ? this.productID : "");
            if (this.extInfos == null) {
                dout.writeInt(0);
            } else {
                dout.writeInt(this.extInfos.size());
                for (ExtInfo extInfo : this.extInfos) {
                    dout.writeUTF(extInfo.name);
                    dout.writeUTF(extInfo.content != null ? extInfo.content : "");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public static LicenseInfo parseInfo(byte[] bytes) {
        return LicenseInfo.parseInfo(bytes, 0, bytes.length);
    }

    public static LicenseInfo parseInfo(byte[] bytes, int off, int len) {
        LicenseInfo info = new LicenseInfo();
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes, off, len);
        DataInputStream din = new DataInputStream(bin);
        try {
            info.v = din.readByte();
            info.maxUserCount = din.readInt();
            info.buyDate = new Date(din.readLong());
            info.serviceEnd = new Date(din.readLong());
            info.customerName = din.readUTF();
            info.customerID = din.readUTF();
            info.buyer = din.readUTF();
            info.productID = din.readUTF();
            int en = din.readInt();
            if (en > 0) {
                ArrayList<ExtInfo> einfs = new ArrayList<ExtInfo>(en);
                int i = 0;
                while (i < en) {
                    einfs.add(new ExtInfo(din.readUTF(), din.readUTF()));
                    ++i;
                }
                info.extInfos = einfs;
            }
            return info;
        }
        catch (EOFException e) {
            throw new RuntimeException("\u8f93\u5165\u5b57\u8282\u683c\u5f0f\u6709\u8bef\uff01");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static class ExtInfo {
        private String name;
        private String content;

        public ExtInfo(String name, String content) {
            this.name = name;
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public ExtInfo clone() {
            return new ExtInfo(this.name, this.content);
        }
    }
}

