/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.multipart;

import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JakartaMultiPartRequest
implements MultiPartRequest {
    static final Logger LOG = LoggerFactory.getLogger(MultiPartRequest.class);
    protected Map<String, List<FileItem>> files = new HashMap<String, List<FileItem>>();
    protected Map<String, List<String>> params = new HashMap<String, List<String>>();
    protected List<String> errors = new ArrayList<String>();
    protected long maxSize;

    @Inject(value="struts.multipart.maxSize")
    public void setMaxSize(String maxSize) {
        this.maxSize = Long.parseLong(maxSize);
    }

    @Override
    public void parse(HttpServletRequest request, String saveDir) throws IOException {
        try {
            this.processUpload(request, saveDir);
        }
        catch (FileUploadException e) {
            LOG.warn("Unable to parse request", (Throwable)e, new String[0]);
            this.errors.add(e.getMessage());
        }
    }

    private void processUpload(HttpServletRequest request, String saveDir) throws FileUploadException, UnsupportedEncodingException {
        for (FileItem item : this.parseRequest(request, saveDir)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found item " + item.getFieldName(), new String[0]);
            }
            if (item.isFormField()) {
                this.processNormalFormField(item, request.getCharacterEncoding());
                continue;
            }
            this.processFileField(item);
        }
    }

    private void processFileField(FileItem item) {
        LOG.debug("Item is a file upload", new String[0]);
        if (item.getName() == null || item.getName().trim().length() < 1) {
            LOG.debug("No file has been uploaded for the field: " + item.getFieldName(), new String[0]);
            return;
        }
        List<FileItem> values = this.files.get(item.getFieldName()) != null ? this.files.get(item.getFieldName()) : new ArrayList<FileItem>();
        values.add(item);
        this.files.put(item.getFieldName(), values);
    }

    private void processNormalFormField(FileItem item, String charset) throws UnsupportedEncodingException {
        LOG.debug("Item is a normal form field", new String[0]);
        List<Object> values = this.params.get(item.getFieldName()) != null ? this.params.get(item.getFieldName()) : new ArrayList();
        if (charset != null) {
            values.add(item.getString(charset));
        } else {
            values.add(item.getString());
        }
        this.params.put(item.getFieldName(), values);
    }

    private List<FileItem> parseRequest(HttpServletRequest servletRequest, String saveDir) throws FileUploadException {
        DiskFileItemFactory fac = this.createDiskFileItemFactory(saveDir);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fac);
        upload.setSizeMax(this.maxSize);
        return upload.parseRequest(this.createRequestContext(servletRequest));
    }

    private DiskFileItemFactory createDiskFileItemFactory(String saveDir) {
        DiskFileItemFactory fac = new DiskFileItemFactory();
        fac.setSizeThreshold(0);
        if (saveDir != null) {
            fac.setRepository(new File(saveDir));
        }
        return fac;
    }

    @Override
    public Enumeration<String> getFileParameterNames() {
        return Collections.enumeration(this.files.keySet());
    }

    @Override
    public String[] getContentType(String fieldName) {
        List<FileItem> items = this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> contentTypes = new ArrayList<String>(items.size());
        for (FileItem fileItem : items) {
            contentTypes.add(fileItem.getContentType());
        }
        return contentTypes.toArray(new String[contentTypes.size()]);
    }

    @Override
    public File[] getFile(String fieldName) {
        List<FileItem> items = this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>(items.size());
        for (FileItem fileItem : items) {
            File storeLocation;
            block5: {
                storeLocation = ((DiskFileItem)fileItem).getStoreLocation();
                if (fileItem.isInMemory() && storeLocation != null && !storeLocation.exists()) {
                    try {
                        storeLocation.createNewFile();
                    }
                    catch (IOException e) {
                        if (!LOG.isErrorEnabled()) break block5;
                        LOG.error("Cannot write uploaded empty file to disk: " + storeLocation.getAbsolutePath(), (Throwable)e, new String[0]);
                    }
                }
            }
            fileList.add(storeLocation);
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    @Override
    public String[] getFileNames(String fieldName) {
        List<FileItem> items = this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>(items.size());
        for (FileItem fileItem : items) {
            fileNames.add(this.getCanonicalName(fileItem.getName()));
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    @Override
    public String[] getFilesystemName(String fieldName) {
        List<FileItem> items = this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>(items.size());
        for (FileItem fileItem : items) {
            fileNames.add(((DiskFileItem)fileItem).getStoreLocation().getName());
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    @Override
    public String getParameter(String name) {
        List<String> v = this.params.get(name);
        if (v != null && v.size() > 0) {
            return v.get(0);
        }
        return null;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.params.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        List<String> v = this.params.get(name);
        if (v != null && v.size() > 0) {
            return v.toArray(new String[v.size()]);
        }
        return null;
    }

    @Override
    public List getErrors() {
        return this.errors;
    }

    private String getCanonicalName(String filename) {
        int forwardSlash = filename.lastIndexOf("/");
        int backwardSlash = filename.lastIndexOf("\\");
        if (forwardSlash != -1 && forwardSlash > backwardSlash) {
            filename = filename.substring(forwardSlash + 1, filename.length());
        } else if (backwardSlash != -1 && backwardSlash >= forwardSlash) {
            filename = filename.substring(backwardSlash + 1, filename.length());
        }
        return filename;
    }

    private RequestContext createRequestContext(final HttpServletRequest req) {
        return new RequestContext(){

            public String getCharacterEncoding() {
                return req.getCharacterEncoding();
            }

            public String getContentType() {
                return req.getContentType();
            }

            public int getContentLength() {
                return req.getContentLength();
            }

            public InputStream getInputStream() throws IOException {
                ServletInputStream in = req.getInputStream();
                if (in == null) {
                    throw new IOException("Missing content in the request");
                }
                return req.getInputStream();
            }
        };
    }
}

