/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.util;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;

public class UrlHelper {
    private static final Logger LOG = LoggerFactory.getLogger(UrlHelper.class);
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String AMP = "&amp;";

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params) {
        return UrlHelper.buildUrl(action, request, response, params, null, true, true);
    }

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params, String scheme, boolean includeContext, boolean encodeResult) {
        return UrlHelper.buildUrl(action, request, response, params, scheme, includeContext, encodeResult, false);
    }

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params, String scheme, boolean includeContext, boolean encodeResult, boolean forceAddSchemeHostAndPort) {
        return UrlHelper.buildUrl(action, request, response, params, scheme, includeContext, encodeResult, forceAddSchemeHostAndPort, true);
    }

    public static String buildUrl(String action, HttpServletRequest request, HttpServletResponse response, Map params, String scheme, boolean includeContext, boolean encodeResult, boolean forceAddSchemeHostAndPort, boolean escapeAmp) {
        StringBuilder link = new StringBuilder();
        boolean changedScheme = false;
        Container cont = ActionContext.getContext().getContainer();
        int httpPort = Integer.parseInt((String)cont.getInstance(String.class, "struts.url.http.port"));
        int httpsPort = Integer.parseInt((String)cont.getInstance(String.class, "struts.url.https.port"));
        if (forceAddSchemeHostAndPort) {
            String reqScheme = request.getScheme();
            changedScheme = true;
            link.append(scheme != null ? scheme : reqScheme);
            link.append("://");
            link.append(request.getServerName());
            if (scheme != null) {
                if (!scheme.equals(reqScheme)) {
                    if (scheme.equals("http") && httpPort != 80 || scheme.equals("https") && httpsPort != 443) {
                        link.append(":");
                        link.append(scheme.equals("http") ? httpPort : httpsPort);
                    }
                } else {
                    int reqPort = request.getServerPort();
                    if (scheme.equals("http") && reqPort != 80 || scheme.equals("https") && reqPort != 443) {
                        link.append(":");
                        link.append(reqPort);
                    }
                }
            }
        } else if (scheme != null && !scheme.equals(request.getScheme())) {
            changedScheme = true;
            link.append(scheme);
            link.append("://");
            link.append(request.getServerName());
            if (scheme.equals("http") && httpPort != 80 || scheme.equals("https") && httpsPort != 443) {
                link.append(":");
                link.append(scheme.equals("http") ? httpPort : httpsPort);
            }
        }
        if (action != null) {
            if (action.startsWith("/") && includeContext) {
                String contextPath = request.getContextPath();
                if (!contextPath.equals("/")) {
                    link.append(contextPath);
                }
            } else if (changedScheme) {
                String uri = (String)request.getAttribute("javax.servlet.forward.request_uri");
                if (uri == null) {
                    uri = request.getRequestURI();
                }
                link.append(uri.substring(0, uri.lastIndexOf(47) + 1));
            }
            link.append(action);
        } else {
            String requestURI = (String)request.getAttribute("struts.request_uri");
            if (requestURI == null) {
                requestURI = (String)request.getAttribute("javax.servlet.forward.request_uri");
            }
            if (requestURI == null) {
                requestURI = request.getRequestURI();
            }
            link.append(requestURI);
        }
        if (escapeAmp) {
            UrlHelper.buildParametersString(params, link);
        } else {
            UrlHelper.buildParametersString(params, link, "&");
        }
        String result = link.toString();
        while (result.indexOf("<script>") > 0) {
            result = result.replaceAll("<script>", "script");
        }
        try {
            result = encodeResult ? response.encodeURL(result) : result;
        }
        catch (Exception ex) {
            result = link.toString();
        }
        return result;
    }

    public static void buildParametersString(Map params, StringBuilder link) {
        UrlHelper.buildParametersString(params, link, AMP);
    }

    public static void buildParametersString(Map params, StringBuilder link, String paramSeparator) {
        if (params != null && params.size() > 0) {
            if (link.toString().indexOf("?") == -1) {
                link.append("?");
            } else {
                link.append(paramSeparator);
            }
            Iterator iter = params.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Iterable) {
                    Iterator iterator = ((Iterable)value).iterator();
                    while (iterator.hasNext()) {
                        Object paramValue = iterator.next();
                        link.append(UrlHelper.buildParameterSubstring(name, paramValue.toString()));
                        if (!iterator.hasNext()) continue;
                        link.append(paramSeparator);
                    }
                } else if (value instanceof Object[]) {
                    Object[] array = (Object[])value;
                    for (int i = 0; i < array.length; ++i) {
                        Object paramValue = array[i];
                        link.append(UrlHelper.buildParameterSubstring(name, paramValue.toString()));
                        if (i >= array.length - 1) continue;
                        link.append(paramSeparator);
                    }
                } else {
                    link.append(UrlHelper.buildParameterSubstring(name, value != null ? value.toString() : ""));
                }
                if (!iter.hasNext()) continue;
                link.append(paramSeparator);
            }
        }
    }

    private static String buildParameterSubstring(String name, String value) {
        StringBuilder builder = new StringBuilder();
        builder.append(UrlHelper.translateAndEncode(name));
        builder.append('=');
        builder.append(UrlHelper.translateAndEncode(value));
        return builder.toString();
    }

    public static String translateAndEncode(String input) {
        String translatedInput = UrlHelper.translateVariable(input);
        String encoding = UrlHelper.getEncodingFromConfiguration();
        try {
            return URLEncoder.encode(translatedInput, encoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Could not encode URL parameter '" + input + "', returning value un-encoded", new String[0]);
            return translatedInput;
        }
    }

    public static String translateAndDecode(String input) {
        String translatedInput = UrlHelper.translateVariable(input);
        String encoding = UrlHelper.getEncodingFromConfiguration();
        try {
            return URLDecoder.decode(translatedInput, encoding);
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Could not encode URL parameter '" + input + "', returning value un-encoded", new String[0]);
            return translatedInput;
        }
    }

    private static String translateVariable(String input) {
        ValueStack valueStack = ServletActionContext.getContext().getValueStack();
        String output = TextParseUtil.translateVariables((String)input, (ValueStack)valueStack);
        return output;
    }

    private static String getEncodingFromConfiguration() {
        Container cont = ActionContext.getContext().getContainer();
        String customEncoding = (String)cont.getInstance(String.class, "struts.i18n.encoding");
        String encoding = customEncoding != null ? customEncoding : "UTF-8";
        return encoding;
    }

    public static Map parseQueryString(String queryString) {
        return UrlHelper.parseQueryString(queryString, false);
    }

    public static Map parseQueryString(String queryString, boolean forceValueArray) {
        LinkedHashMap<String, Object> queryParams = new LinkedHashMap<String, Object>();
        if (queryString != null) {
            String[] params = queryString.split("&");
            for (int a = 0; a < params.length; ++a) {
                if (params[a].trim().length() <= 0) continue;
                String[] tmpParams = params[a].split("=");
                String paramName = null;
                String paramValue = "";
                if (tmpParams.length > 0) {
                    paramName = tmpParams[0];
                }
                if (tmpParams.length > 1) {
                    paramValue = tmpParams[1];
                }
                if (paramName == null) continue;
                paramName = UrlHelper.translateAndDecode(paramName);
                String translatedParamValue = UrlHelper.translateAndDecode(paramValue);
                if (queryParams.containsKey(paramName) || forceValueArray) {
                    Object currentParam = queryParams.get(paramName);
                    if (currentParam instanceof String) {
                        queryParams.put(paramName, new String[]{(String)currentParam, translatedParamValue});
                        continue;
                    }
                    String[] currentParamValues = (String[])currentParam;
                    if (currentParamValues != null) {
                        ArrayList<String> paramList = new ArrayList<String>(Arrays.asList(currentParamValues));
                        paramList.add(translatedParamValue);
                        String[] newParamValues = new String[paramList.size()];
                        queryParams.put(paramName, paramList.toArray(newParamValues));
                        continue;
                    }
                    queryParams.put(paramName, new String[]{translatedParamValue});
                    continue;
                }
                queryParams.put(paramName, translatedParamValue);
            }
        }
        return queryParams;
    }
}

