/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth;

import com.sun.security.auth.PolicyFile;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.Vector;

class PolicyPermissions
extends PermissionCollection {
    private static final long serialVersionUID = -1954188373270545523L;
    private CodeSource codesource;
    private Permissions perms;
    private PolicyFile policy;
    private boolean notInit;
    private Vector additionalPerms;

    PolicyPermissions(PolicyFile policyFile, CodeSource codeSource) {
        this.codesource = codeSource;
        this.policy = policyFile;
        this.perms = null;
        this.notInit = true;
        this.additionalPerms = null;
    }

    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException(PolicyFile.rb.getString("attempt to add a Permission to a readonly PermissionCollection"));
        }
        if (this.perms == null) {
            if (this.additionalPerms == null) {
                this.additionalPerms = new Vector();
            }
            this.additionalPerms.add(permission);
        } else {
            this.perms.add(permission);
        }
    }

    private synchronized void init() {
        if (this.notInit) {
            if (this.perms == null) {
                this.perms = new Permissions();
            }
            if (this.additionalPerms != null) {
                Enumeration enumeration = this.additionalPerms.elements();
                while (enumeration.hasMoreElements()) {
                    this.perms.add((Permission)enumeration.nextElement());
                }
                this.additionalPerms = null;
            }
            this.policy.getPermissions(this.perms, this.codesource);
            this.notInit = false;
        }
    }

    public boolean implies(Permission permission) {
        if (this.notInit) {
            this.init();
        }
        return this.perms.implies(permission);
    }

    public Enumeration elements() {
        if (this.notInit) {
            this.init();
        }
        return this.perms.elements();
    }

    public String toString() {
        if (this.notInit) {
            this.init();
        }
        return this.perms.toString();
    }
}

