/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.NumericValueExp;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryEval;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class BinaryOpValueExp
extends QueryEval
implements ValueExp {
    private static final long serialVersionUID = 1216286847881456786L;
    private int op;
    private ValueExp exp1;
    private ValueExp exp2;

    public BinaryOpValueExp() {
    }

    public BinaryOpValueExp(int n, ValueExp valueExp, ValueExp valueExp2) {
        this.op = n;
        this.exp1 = valueExp;
        this.exp2 = valueExp2;
    }

    public int getOperator() {
        return this.op;
    }

    public ValueExp getLeftValue() {
        return this.exp1;
    }

    public ValueExp getRightValue() {
        return this.exp2;
    }

    public ValueExp apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp valueExp = this.exp1.apply(objectName);
        ValueExp valueExp2 = this.exp2.apply(objectName);
        boolean bl = valueExp instanceof NumericValueExp;
        if (bl) {
            if (((NumericValueExp)valueExp).isLong()) {
                long l = ((NumericValueExp)valueExp).longValue();
                long l2 = ((NumericValueExp)valueExp2).longValue();
                switch (this.op) {
                    case 0: {
                        return Query.value(l + l2);
                    }
                    case 2: {
                        return Query.value(l * l2);
                    }
                    case 1: {
                        return Query.value(l - l2);
                    }
                    case 3: {
                        return Query.value(l / l2);
                    }
                }
            } else {
                double d = ((NumericValueExp)valueExp).doubleValue();
                double d2 = ((NumericValueExp)valueExp2).doubleValue();
                switch (this.op) {
                    case 0: {
                        return Query.value(d + d2);
                    }
                    case 2: {
                        return Query.value(d * d2);
                    }
                    case 1: {
                        return Query.value(d - d2);
                    }
                    case 3: {
                        return Query.value(d / d2);
                    }
                }
            }
        } else {
            String string = ((StringValueExp)valueExp).getValue();
            String string2 = ((StringValueExp)valueExp2).getValue();
            switch (this.op) {
                case 0: {
                    return new StringValueExp(string + string2);
                }
            }
            throw new BadStringOperationException(this.opString());
        }
        throw new BadBinaryOpValueExpException(this);
    }

    public String toString() {
        try {
            return this.exp1 + " " + this.opString() + " " + this.exp2;
        }
        catch (BadBinaryOpValueExpException badBinaryOpValueExpException) {
            return "invalid expression";
        }
    }

    private String opString() throws BadBinaryOpValueExpException {
        switch (this.op) {
            case 0: {
                return "+";
            }
            case 2: {
                return "*";
            }
            case 1: {
                return "-";
            }
            case 3: {
                return "/";
            }
        }
        throw new BadBinaryOpValueExpException(this);
    }
}

