/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpStatusException;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Map;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvminstr.JvmMemoryImpl;
import sun.management.snmp.jvmmib.EnumJvmMemPoolCollectThreshdSupport;
import sun.management.snmp.jvmmib.EnumJvmMemPoolState;
import sun.management.snmp.jvmmib.EnumJvmMemPoolThreshdSupport;
import sun.management.snmp.jvmmib.EnumJvmMemPoolType;
import sun.management.snmp.jvmmib.JvmMemPoolEntryMBean;
import sun.management.snmp.util.JvmContextFactory;
import sun.management.snmp.util.MibLogger;

public class JvmMemPoolEntryImpl
implements JvmMemPoolEntryMBean {
    protected final int jvmMemPoolIndex;
    static final String memoryTag = "jvmMemPoolEntry.getUsage";
    static final String peakMemoryTag = "jvmMemPoolEntry.getPeakUsage";
    static final String collectMemoryTag = "jvmMemPoolEntry.getCollectionUsage";
    static final MemoryUsage ZEROS = new MemoryUsage(0L, 0L, 0L, 0L);
    final String entryMemoryTag;
    final String entryPeakMemoryTag;
    final String entryCollectMemoryTag;
    final MemoryPoolMXBean pool;
    private long jvmMemPoolPeakReset = 0L;
    private static final EnumJvmMemPoolState JvmMemPoolStateValid = new EnumJvmMemPoolState("valid");
    private static final EnumJvmMemPoolState JvmMemPoolStateInvalid = new EnumJvmMemPoolState("invalid");
    private static final EnumJvmMemPoolType EnumJvmMemPoolTypeHeap = new EnumJvmMemPoolType("heap");
    private static final EnumJvmMemPoolType EnumJvmMemPoolTypeNonHeap = new EnumJvmMemPoolType("nonheap");
    private static final EnumJvmMemPoolThreshdSupport EnumJvmMemPoolThreshdSupported = new EnumJvmMemPoolThreshdSupport("supported");
    private static final EnumJvmMemPoolThreshdSupport EnumJvmMemPoolThreshdUnsupported = new EnumJvmMemPoolThreshdSupport("unsupported");
    private static final EnumJvmMemPoolCollectThreshdSupport EnumJvmMemPoolCollectThreshdSupported = new EnumJvmMemPoolCollectThreshdSupport("supported");
    private static final EnumJvmMemPoolCollectThreshdSupport EnumJvmMemPoolCollectThreshdUnsupported = new EnumJvmMemPoolCollectThreshdSupport("unsupported");
    static final MibLogger log = new MibLogger(JvmMemPoolEntryImpl.class);

    MemoryUsage getMemoryUsage() {
        try {
            Map map = JvmContextFactory.getUserData();
            if (map != null) {
                MemoryUsage memoryUsage = (MemoryUsage)map.get(this.entryMemoryTag);
                if (memoryUsage != null) {
                    log.debug("getMemoryUsage", this.entryMemoryTag + " found in cache.");
                    return memoryUsage;
                }
                MemoryUsage memoryUsage2 = this.pool.getUsage();
                if (memoryUsage2 == null) {
                    memoryUsage2 = ZEROS;
                }
                map.put(this.entryMemoryTag, memoryUsage2);
                return memoryUsage2;
            }
            log.trace("getMemoryUsage", "ERROR: should never come here!");
            return this.pool.getUsage();
        }
        catch (RuntimeException runtimeException) {
            log.trace("getMemoryUsage", "Failed to get MemoryUsage: " + runtimeException);
            log.debug("getMemoryUsage", runtimeException);
            throw runtimeException;
        }
    }

    MemoryUsage getPeakMemoryUsage() {
        try {
            Map map = JvmContextFactory.getUserData();
            if (map != null) {
                MemoryUsage memoryUsage = (MemoryUsage)map.get(this.entryPeakMemoryTag);
                if (memoryUsage != null) {
                    if (log.isDebugOn()) {
                        log.debug("getPeakMemoryUsage", this.entryPeakMemoryTag + " found in cache.");
                    }
                    return memoryUsage;
                }
                MemoryUsage memoryUsage2 = this.pool.getPeakUsage();
                if (memoryUsage2 == null) {
                    memoryUsage2 = ZEROS;
                }
                map.put(this.entryPeakMemoryTag, memoryUsage2);
                return memoryUsage2;
            }
            log.trace("getPeakMemoryUsage", "ERROR: should never come here!");
            return ZEROS;
        }
        catch (RuntimeException runtimeException) {
            log.trace("getPeakMemoryUsage", "Failed to get MemoryUsage: " + runtimeException);
            log.debug("getPeakMemoryUsage", runtimeException);
            throw runtimeException;
        }
    }

    MemoryUsage getCollectMemoryUsage() {
        try {
            Map map = JvmContextFactory.getUserData();
            if (map != null) {
                MemoryUsage memoryUsage = (MemoryUsage)map.get(this.entryCollectMemoryTag);
                if (memoryUsage != null) {
                    if (log.isDebugOn()) {
                        log.debug("getCollectMemoryUsage", this.entryCollectMemoryTag + " found in cache.");
                    }
                    return memoryUsage;
                }
                MemoryUsage memoryUsage2 = this.pool.getCollectionUsage();
                if (memoryUsage2 == null) {
                    memoryUsage2 = ZEROS;
                }
                map.put(this.entryCollectMemoryTag, memoryUsage2);
                return memoryUsage2;
            }
            log.trace("getCollectMemoryUsage", "ERROR: should never come here!");
            return ZEROS;
        }
        catch (RuntimeException runtimeException) {
            log.trace("getPeakMemoryUsage", "Failed to get MemoryUsage: " + runtimeException);
            log.debug("getPeakMemoryUsage", runtimeException);
            throw runtimeException;
        }
    }

    public JvmMemPoolEntryImpl(MemoryPoolMXBean memoryPoolMXBean, int n) {
        this.pool = memoryPoolMXBean;
        this.jvmMemPoolIndex = n;
        this.entryMemoryTag = "jvmMemPoolEntry.getUsage." + n;
        this.entryPeakMemoryTag = "jvmMemPoolEntry.getPeakUsage." + n;
        this.entryCollectMemoryTag = "jvmMemPoolEntry.getCollectionUsage." + n;
    }

    public Long getJvmMemPoolMaxSize() throws SnmpStatusException {
        long l = this.getMemoryUsage().getMax();
        if (l > -1L) {
            return new Long(l);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolUsed() throws SnmpStatusException {
        long l = this.getMemoryUsage().getUsed();
        if (l > -1L) {
            return new Long(l);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolInitSize() throws SnmpStatusException {
        long l = this.getMemoryUsage().getInit();
        if (l > -1L) {
            return new Long(l);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolCommitted() throws SnmpStatusException {
        long l = this.getMemoryUsage().getCommitted();
        if (l > -1L) {
            return new Long(l);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolPeakMaxSize() throws SnmpStatusException {
        long l = this.getPeakMemoryUsage().getMax();
        if (l > -1L) {
            return new Long(l);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolPeakUsed() throws SnmpStatusException {
        long l = this.getPeakMemoryUsage().getUsed();
        if (l > -1L) {
            return new Long(l);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolPeakCommitted() throws SnmpStatusException {
        long l = this.getPeakMemoryUsage().getCommitted();
        if (l > -1L) {
            return new Long(l);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolCollectMaxSize() throws SnmpStatusException {
        long l = this.getCollectMemoryUsage().getMax();
        if (l > -1L) {
            return new Long(l);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolCollectUsed() throws SnmpStatusException {
        long l = this.getCollectMemoryUsage().getUsed();
        if (l > -1L) {
            return new Long(l);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolCollectCommitted() throws SnmpStatusException {
        long l = this.getCollectMemoryUsage().getCommitted();
        if (l > -1L) {
            return new Long(l);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolThreshold() throws SnmpStatusException {
        if (!this.pool.isUsageThresholdSupported()) {
            return JvmMemoryImpl.Long0;
        }
        long l = this.pool.getUsageThreshold();
        if (l > -1L) {
            return new Long(l);
        }
        return JvmMemoryImpl.Long0;
    }

    public void setJvmMemPoolThreshold(Long l) throws SnmpStatusException {
        long l2 = l;
        if (l2 < 0L) {
            throw new SnmpStatusException(10);
        }
        this.pool.setUsageThreshold(l2);
    }

    public void checkJvmMemPoolThreshold(Long l) throws SnmpStatusException {
        if (!this.pool.isUsageThresholdSupported()) {
            throw new SnmpStatusException(12);
        }
        long l2 = l;
        if (l2 < 0L) {
            throw new SnmpStatusException(10);
        }
    }

    public EnumJvmMemPoolThreshdSupport getJvmMemPoolThreshdSupport() throws SnmpStatusException {
        if (this.pool.isUsageThresholdSupported()) {
            return EnumJvmMemPoolThreshdSupported;
        }
        return EnumJvmMemPoolThreshdUnsupported;
    }

    public Long getJvmMemPoolThreshdCount() throws SnmpStatusException {
        if (!this.pool.isUsageThresholdSupported()) {
            return JvmMemoryImpl.Long0;
        }
        long l = this.pool.getUsageThresholdCount();
        if (l > -1L) {
            return new Long(l);
        }
        return JvmMemoryImpl.Long0;
    }

    public Long getJvmMemPoolCollectThreshold() throws SnmpStatusException {
        if (!this.pool.isCollectionUsageThresholdSupported()) {
            return JvmMemoryImpl.Long0;
        }
        long l = this.pool.getCollectionUsageThreshold();
        if (l > -1L) {
            return new Long(l);
        }
        return JvmMemoryImpl.Long0;
    }

    public void setJvmMemPoolCollectThreshold(Long l) throws SnmpStatusException {
        long l2 = l;
        if (l2 < 0L) {
            throw new SnmpStatusException(10);
        }
        this.pool.setCollectionUsageThreshold(l2);
    }

    public void checkJvmMemPoolCollectThreshold(Long l) throws SnmpStatusException {
        if (!this.pool.isCollectionUsageThresholdSupported()) {
            throw new SnmpStatusException(12);
        }
        long l2 = l;
        if (l2 < 0L) {
            throw new SnmpStatusException(10);
        }
    }

    public EnumJvmMemPoolCollectThreshdSupport getJvmMemPoolCollectThreshdSupport() throws SnmpStatusException {
        if (this.pool.isCollectionUsageThresholdSupported()) {
            return EnumJvmMemPoolCollectThreshdSupported;
        }
        return EnumJvmMemPoolCollectThreshdUnsupported;
    }

    public Long getJvmMemPoolCollectThreshdCount() throws SnmpStatusException {
        if (!this.pool.isCollectionUsageThresholdSupported()) {
            return JvmMemoryImpl.Long0;
        }
        long l = this.pool.getCollectionUsageThresholdCount();
        if (l > -1L) {
            return new Long(l);
        }
        return JvmMemoryImpl.Long0;
    }

    public static EnumJvmMemPoolType jvmMemPoolType(MemoryType memoryType) throws SnmpStatusException {
        if (memoryType.equals((Object)MemoryType.HEAP)) {
            return EnumJvmMemPoolTypeHeap;
        }
        if (memoryType.equals((Object)MemoryType.NON_HEAP)) {
            return EnumJvmMemPoolTypeNonHeap;
        }
        throw new SnmpStatusException(10);
    }

    public EnumJvmMemPoolType getJvmMemPoolType() throws SnmpStatusException {
        return JvmMemPoolEntryImpl.jvmMemPoolType(this.pool.getType());
    }

    public String getJvmMemPoolName() throws SnmpStatusException {
        return JVM_MANAGEMENT_MIB_IMPL.validJavaObjectNameTC(this.pool.getName());
    }

    public Integer getJvmMemPoolIndex() throws SnmpStatusException {
        return new Integer(this.jvmMemPoolIndex);
    }

    public EnumJvmMemPoolState getJvmMemPoolState() throws SnmpStatusException {
        if (this.pool.isValid()) {
            return JvmMemPoolStateValid;
        }
        return JvmMemPoolStateInvalid;
    }

    public synchronized Long getJvmMemPoolPeakReset() throws SnmpStatusException {
        return new Long(this.jvmMemPoolPeakReset);
    }

    public synchronized void setJvmMemPoolPeakReset(Long l) throws SnmpStatusException {
        long l2 = l;
        if (l2 > this.jvmMemPoolPeakReset) {
            long l3 = System.currentTimeMillis();
            this.pool.resetPeakUsage();
            this.jvmMemPoolPeakReset = l3;
            log.debug("setJvmMemPoolPeakReset", "jvmMemPoolPeakReset=" + l3);
        }
    }

    public void checkJvmMemPoolPeakReset(Long l) throws SnmpStatusException {
    }
}

