/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.id;

import java.util.Map;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.id.AbstractIdMapper;
import org.hibernate.envers.entities.mapper.id.SimpleIdMapperBuilder;
import org.hibernate.envers.entities.mapper.id.SingleIdMapper;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.tools.Tools;

public abstract class AbstractCompositeIdMapper
extends AbstractIdMapper
implements SimpleIdMapperBuilder {
    protected Map<PropertyData, SingleIdMapper> ids = Tools.newLinkedHashMap();
    protected String compositeIdClass;

    protected AbstractCompositeIdMapper(String compositeIdClass) {
        this.compositeIdClass = compositeIdClass;
    }

    public void add(PropertyData propertyData) {
        this.ids.put(propertyData, new SingleIdMapper(propertyData));
    }

    public Object mapToIdFromMap(Map data) {
        Object ret;
        if (data == null) {
            return null;
        }
        try {
            ret = Thread.currentThread().getContextClassLoader().loadClass(this.compositeIdClass).newInstance();
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
        for (SingleIdMapper mapper : this.ids.values()) {
            mapper.mapToEntityFromMap(ret, data);
        }
        return ret;
    }
}

