/*
 * Decompiled with CFR 0.152.
 */
package com.handsome.ip;

import com.handsome.ip.IPEntry;
import com.handsome.ip.IPLocation;
import com.handsome.ip.LogFactory;
import com.handsome.ip.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;

public class IPSeeker {
    private String IP_FILE;
    private String INSTALL_DIR;
    private static final int IP_RECORD_LENGTH = 7;
    private static final byte REDIRECT_MODE_1 = 1;
    private static final byte REDIRECT_MODE_2 = 2;
    private Map<String, IPLocation> ipCache;
    private RandomAccessFile ipFile;
    private MappedByteBuffer mbb;
    private long ipBegin;
    private long ipEnd;
    private IPLocation loc;
    private byte[] buf;
    private byte[] b4;
    private byte[] b3;

    /*
     * Unable to fully structure code
     */
    public IPSeeker(String fileName, String dir) {
        block10: {
            super();
            this.IP_FILE = "QQWry.Dat";
            this.INSTALL_DIR = "f:/qqwry";
            this.INSTALL_DIR = dir;
            this.IP_FILE = fileName;
            this.ipCache = new HashMap<String, IPLocation>();
            this.loc = new IPLocation();
            this.buf = new byte[100];
            this.b4 = new byte[4];
            this.b3 = new byte[3];
            try {
                this.ipFile = new RandomAccessFile(this.IP_FILE, "r");
                break block10;
            }
            catch (FileNotFoundException e) {
                filename = new File(this.IP_FILE).getName().toLowerCase();
                files = new File(this.INSTALL_DIR).listFiles();
                i = 0;
                ** while (i < files.length)
            }
lbl-1000:
            // 1 sources

            {
                if (files[i].isFile() && files[i].getName().toLowerCase().equals(filename)) {
                    try {
                        this.ipFile = new RandomAccessFile(files[i], "r");
                    }
                    catch (FileNotFoundException e1) {
                        LogFactory.log("IP\u5730\u5740\u4fe1\u606f\u6587\u4ef6\u6ca1\u6709\u627e\u5230\uff0cIP\u663e\u793a\u529f\u80fd\u5c06\u65e0\u6cd5\u4f7f\u7528", Level.ERROR, e1);
                        this.ipFile = null;
                    }
                    break;
                }
                ++i;
                continue;
            }
        }
        if (this.ipFile != null) {
            try {
                this.ipBegin = this.readLong4(0L);
                this.ipEnd = this.readLong4(4L);
                if (this.ipBegin == -1L || this.ipEnd == -1L) {
                    this.ipFile.close();
                    this.ipFile = null;
                }
            }
            catch (IOException e) {
                LogFactory.log("IP\u5730\u5740\u4fe1\u606f\u6587\u4ef6\u683c\u5f0f\u6709\u9519\u8bef\uff0cIP\u663e\u793a\u529f\u80fd\u5c06\u65e0\u6cd5\u4f7f\u7528", Level.ERROR, e);
                this.ipFile = null;
            }
        }
    }

    public List getIPEntriesDebug(String s) {
        ArrayList<IPEntry> ret = new ArrayList<IPEntry>();
        long endOffset = this.ipEnd + 4L;
        long offset = this.ipBegin + 4L;
        while (offset <= endOffset) {
            IPLocation ipLoc;
            long temp = this.readLong3(offset);
            if (temp != -1L && ((ipLoc = this.getIPLocation(temp)).getCountry().indexOf(s) != -1 || ipLoc.getArea().indexOf(s) != -1)) {
                IPEntry entry = new IPEntry();
                entry.country = ipLoc.getCountry();
                entry.area = ipLoc.getArea();
                this.readIP(offset - 4L, this.b4);
                entry.beginIp = Util.getIpStringFromBytes(this.b4);
                this.readIP(temp, this.b4);
                entry.endIp = Util.getIpStringFromBytes(this.b4);
                ret.add(entry);
            }
            offset += 7L;
        }
        return ret;
    }

    public IPLocation getIPLocation(String ip) {
        IPLocation location = new IPLocation();
        location.setArea(this.getArea(ip));
        location.setCountry(this.getCountry(ip));
        return location;
    }

    public List<IPEntry> getIPEntries(String s) {
        ArrayList<IPEntry> ret = new ArrayList<IPEntry>();
        try {
            if (this.mbb == null) {
                FileChannel fc = this.ipFile.getChannel();
                this.mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.ipFile.length());
                this.mbb.order(ByteOrder.LITTLE_ENDIAN);
            }
            int endOffset = (int)this.ipEnd;
            int offset = (int)this.ipBegin + 4;
            while (offset <= endOffset) {
                IPLocation ipLoc;
                int temp = this.readInt3(offset);
                if (temp != -1 && ((ipLoc = this.getIPLocation(temp)).getCountry().indexOf(s) != -1 || ipLoc.getArea().indexOf(s) != -1)) {
                    IPEntry entry = new IPEntry();
                    entry.country = ipLoc.getCountry();
                    entry.area = ipLoc.getArea();
                    this.readIP(offset - 4, this.b4);
                    entry.beginIp = Util.getIpStringFromBytes(this.b4);
                    this.readIP(temp, this.b4);
                    entry.endIp = Util.getIpStringFromBytes(this.b4);
                    ret.add(entry);
                }
                offset += 7;
            }
        }
        catch (IOException e) {
            LogFactory.log("", Level.ERROR, e);
        }
        return ret;
    }

    private int readInt3(int offset) {
        this.mbb.position(offset);
        return this.mbb.getInt() & 0xFFFFFF;
    }

    private int readInt3() {
        return this.mbb.getInt() & 0xFFFFFF;
    }

    public String getCountry(byte[] ip) {
        if (this.ipFile == null) {
            return "IP\u5730\u5740\u5e93\u6587\u4ef6\u9519\u8bef";
        }
        String ipStr = Util.getIpStringFromBytes(ip);
        if (this.ipCache.containsKey(ipStr)) {
            IPLocation ipLoc = this.ipCache.get(ipStr);
            return ipLoc.getCountry();
        }
        IPLocation ipLoc = this.getIPLocation(ip);
        this.ipCache.put(ipStr, ipLoc.getCopy());
        return ipLoc.getCountry();
    }

    public String getCountry(String ip) {
        return this.getCountry(Util.getIpByteArrayFromString(ip));
    }

    public String getArea(byte[] ip) {
        if (this.ipFile == null) {
            return "IP\u5730\u5740\u5e93\u6587\u4ef6\u9519\u8bef";
        }
        String ipStr = Util.getIpStringFromBytes(ip);
        if (this.ipCache.containsKey(ipStr)) {
            IPLocation ipLoc = this.ipCache.get(ipStr);
            return ipLoc.getArea();
        }
        IPLocation ipLoc = this.getIPLocation(ip);
        this.ipCache.put(ipStr, ipLoc.getCopy());
        return ipLoc.getArea();
    }

    public String getArea(String ip) {
        return this.getArea(Util.getIpByteArrayFromString(ip));
    }

    private IPLocation getIPLocation(byte[] ip) {
        IPLocation info = null;
        long offset = this.locateIP(ip);
        if (offset != -1L) {
            info = this.getIPLocation(offset);
        }
        if (info == null) {
            info = new IPLocation();
            info.setCountry("\u672a\u77e5\u56fd\u5bb6");
            info.setArea("\u672a\u77e5\u5730\u533a");
        }
        return info;
    }

    private long readLong4(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            ret |= (long)(this.ipFile.readByte() & 0xFF);
            ret |= (long)(this.ipFile.readByte() << 8 & 0xFF00);
            ret |= (long)(this.ipFile.readByte() << 16 & 0xFF0000);
            return ret |= (long)(this.ipFile.readByte() << 24 & 0xFF000000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3(long offset) {
        long ret = 0L;
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long readLong3() {
        long ret = 0L;
        try {
            this.ipFile.readFully(this.b3);
            ret |= (long)(this.b3[0] & 0xFF);
            ret |= (long)(this.b3[1] << 8 & 0xFF00);
            return ret |= (long)(this.b3[2] << 16 & 0xFF0000);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private void readIP(long offset, byte[] ip) {
        try {
            this.ipFile.seek(offset);
            this.ipFile.readFully(ip);
            byte temp = ip[0];
            ip[0] = ip[3];
            ip[3] = temp;
            temp = ip[1];
            ip[1] = ip[2];
            ip[2] = temp;
        }
        catch (IOException e) {
            LogFactory.log("", Level.ERROR, e);
        }
    }

    private void readIP(int offset, byte[] ip) {
        this.mbb.position(offset);
        this.mbb.get(ip);
        byte temp = ip[0];
        ip[0] = ip[3];
        ip[3] = temp;
        temp = ip[1];
        ip[1] = ip[2];
        ip[2] = temp;
    }

    private int compareIP(byte[] ip, byte[] beginIp) {
        int i = 0;
        while (i < 4) {
            int r = this.compareByte(ip[i], beginIp[i]);
            if (r != 0) {
                return r;
            }
            ++i;
        }
        return 0;
    }

    private int compareByte(byte b1, byte b2) {
        if ((b1 & 0xFF) > (b2 & 0xFF)) {
            return 1;
        }
        if ((b1 ^ b2) == 0) {
            return 0;
        }
        return -1;
    }

    private long locateIP(byte[] ip) {
        long m = 0L;
        this.readIP(this.ipBegin, this.b4);
        int r = this.compareIP(ip, this.b4);
        if (r == 0) {
            return this.ipBegin;
        }
        if (r < 0) {
            return -1L;
        }
        long i = this.ipBegin;
        long j = this.ipEnd;
        while (i < j) {
            m = this.getMiddleOffset(i, j);
            this.readIP(m, this.b4);
            r = this.compareIP(ip, this.b4);
            if (r > 0) {
                i = m;
                continue;
            }
            if (r < 0) {
                if (m == j) {
                    m = j -= 7L;
                    continue;
                }
                j = m;
                continue;
            }
            return this.readLong3(m + 4L);
        }
        m = this.readLong3(m + 4L);
        this.readIP(m, this.b4);
        r = this.compareIP(ip, this.b4);
        if (r <= 0) {
            return m;
        }
        return -1L;
    }

    private long getMiddleOffset(long begin, long end) {
        long records = (end - begin) / 7L;
        if ((records >>= 1) == 0L) {
            records = 1L;
        }
        return begin + records * 7L;
    }

    private IPLocation getIPLocation(long offset) {
        try {
            this.ipFile.seek(offset + 4L);
            byte b = this.ipFile.readByte();
            if (b == 1) {
                long countryOffset = this.readLong3();
                this.ipFile.seek(countryOffset);
                b = this.ipFile.readByte();
                if (b == 2) {
                    this.loc.setCountry(this.readString(this.readLong3()));
                    this.ipFile.seek(countryOffset + 4L);
                } else {
                    this.loc.setCountry(this.readString(countryOffset));
                }
                this.loc.setArea(this.readArea(this.ipFile.getFilePointer()));
            } else if (b == 2) {
                this.loc.setCountry(this.readString(this.readLong3()));
                this.loc.setArea(this.readArea(offset + 8L));
            } else {
                this.loc.setCountry(this.readString(this.ipFile.getFilePointer() - 1L));
                this.loc.setArea(this.readArea(this.ipFile.getFilePointer()));
            }
            return this.loc;
        }
        catch (IOException e) {
            return null;
        }
    }

    private IPLocation getIPLocation(int offset) {
        this.mbb.position(offset + 4);
        byte b = this.mbb.get();
        if (b == 1) {
            int countryOffset = this.readInt3();
            this.mbb.position(countryOffset);
            b = this.mbb.get();
            if (b == 2) {
                this.loc.setCountry(this.readString(this.readInt3()));
                this.mbb.position(countryOffset + 4);
            } else {
                this.loc.setCountry(this.readString(countryOffset));
            }
            this.loc.setArea(this.readArea(this.mbb.position()));
        } else if (b == 2) {
            this.loc.setCountry(this.readString(this.readInt3()));
            this.loc.setArea(this.readArea(offset + 8));
        } else {
            this.loc.setCountry(this.readString(this.mbb.position() - 1));
            this.loc.setArea(this.readArea(this.mbb.position()));
        }
        return this.loc;
    }

    private String readArea(long offset) throws IOException {
        this.ipFile.seek(offset);
        byte b = this.ipFile.readByte();
        if (b == 1 || b == 2) {
            long areaOffset = this.readLong3(offset + 1L);
            if (areaOffset == 0L) {
                return "\u672a\u77e5\u5730\u533a";
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readArea(int offset) {
        this.mbb.position(offset);
        byte b = this.mbb.get();
        if (b == 1 || b == 2) {
            int areaOffset = this.readInt3();
            if (areaOffset == 0) {
                return "\u672a\u77e5\u5730\u533a";
            }
            return this.readString(areaOffset);
        }
        return this.readString(offset);
    }

    private String readString(long offset) {
        try {
            this.ipFile.seek(offset);
            int i = 0;
            this.buf[i] = this.ipFile.readByte();
            while (this.buf[i] != 0) {
                this.buf[++i] = this.ipFile.readByte();
            }
            if (i != 0) {
                return Util.getString(this.buf, 0, i, "GBK");
            }
        }
        catch (IOException e) {
            LogFactory.log("", Level.ERROR, e);
        }
        return "";
    }

    private String readString(int offset) {
        try {
            this.mbb.position(offset);
            int i = 0;
            this.buf[i] = this.mbb.get();
            while (this.buf[i] != 0) {
                this.buf[++i] = this.mbb.get();
            }
            if (i != 0) {
                return Util.getString(this.buf, 0, i, "GBK");
            }
        }
        catch (IllegalArgumentException e) {
            LogFactory.log("", Level.ERROR, e);
        }
        return "";
    }
}

