/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.StringUtil;

public class StringChunk
extends Chunk {
    private static final String DEFAULT_ENCODING = "CP1252";
    private String encoding7Bit = "CP1252";
    private byte[] rawValue;
    private String value;

    public StringChunk(String namePrefix, int chunkId, int type) {
        super(namePrefix, chunkId, type);
    }

    public StringChunk(int chunkId, int type) {
        super(chunkId, type);
    }

    public String get7BitEncoding() {
        return this.encoding7Bit;
    }

    public void set7BitEncoding(String encoding) {
        this.encoding7Bit = encoding;
        if (this.type == 30) {
            this.parseString();
        }
    }

    public void readValue(InputStream value) throws IOException {
        this.rawValue = IOUtils.toByteArray((InputStream)value);
        this.parseString();
    }

    private void parseString() {
        String tmpValue;
        switch (this.type) {
            case 30: {
                tmpValue = StringChunk.parseAs7BitData(this.rawValue, this.encoding7Bit);
                break;
            }
            case 31: {
                tmpValue = StringUtil.getFromUnicodeLE((byte[])this.rawValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type " + this.type + " for String Chunk");
            }
        }
        this.value = tmpValue.replace("\u0000", "");
    }

    public void writeValue(OutputStream out) throws IOException {
        out.write(this.rawValue);
    }

    private void storeString() {
        switch (this.type) {
            case 30: {
                try {
                    this.rawValue = this.value.getBytes(this.encoding7Bit);
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Encoding not found - " + this.encoding7Bit, e);
                }
            }
            case 31: {
                this.rawValue = new byte[this.value.length() * 2];
                StringUtil.putUnicodeLE((String)this.value, (byte[])this.rawValue, (int)0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type " + this.type + " for String Chunk");
            }
        }
    }

    public String getValue() {
        return this.value;
    }

    public byte[] getRawValue() {
        return this.rawValue;
    }

    public void setValue(String str) {
        this.value = str;
        this.storeString();
    }

    public String toString() {
        return this.value;
    }

    protected static String parseAs7BitData(byte[] data) {
        return StringChunk.parseAs7BitData(data, DEFAULT_ENCODING);
    }

    protected static String parseAs7BitData(byte[] data, String encoding) {
        try {
            return new String(data, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding not found - " + encoding, e);
        }
    }
}

