var HT_SELECT={
	WIN_WIDTH:550,
	WIN_HEIGHT:420,
	WIN_RESIZABLE:1,
	TREE_URL:'TreeAction!toTreeSelect.action',
	treeSelect:function(cfg){
		var cfg1=this.clone(cfg);
		delete cfg1.valueDom;
		delete cfg1.textDom;
		if(!cfg1.data){
			cfg1.data=this.getDomValue(cfg);
		}
		var re=window.showModalDialog(cfg1.turl||this.TREE_URL,cfg1,this.getFeature(cfg1));
		this.setDomValue(cfg,re);
		return re;
	},
	select:function(cfg){
		var param={isSingle:!!cfg.isSingle};
		if(cfg.data)
			param.data=cfg.data;
		else
		   param.data=this.getDomValue(cfg);
		if(cfg.title) param.title=cfg.title;
		var re=window.showModalDialog(cfg.url,param,this.getFeature(cfg));
		this.setDomValue(cfg,re);
		return re;
	},
	userSelect:function(data,isSingle,cascadeLoad,rootId){
		var cfg={
			url:'TreeAction!getOrgUserTree.action',
			isLeafOnly:true,
			isSingle:!!isSingle,
			title:'用户选择',
			cascadeLoad:cascadeLoad!==false
		};
		this.appendInitData(data,cfg);
		if(rootId) cfg.asyncRootParam={id:rootId};
		return this.treeSelect(cfg);
	},
	lawyerTreeSelect:function(data,isSingle,cascadeLoad,rootId){
		var cfg={
			url:'TreeAction!getOrgLawyerTree.action',
			isLeafOnly:true,
			isSingle:!!isSingle,
			title:'用户选择',
			cascadeLoad:cascadeLoad!==false
		};
		this.appendInitData(data,cfg);
		if(rootId) cfg.asyncRootParam={id:rootId};
		return this.treeSelect(cfg);
	},
	clientSelect:function(data,isSingle,cascadeLoad,rootId){
		var cfg={
			url:'LawClientAction!clientSelect.action',
			isLeafOnly:true,
			isSingle:!!isSingle,
			title:'客户选择',
			cascadeLoad:cascadeLoad!==false
		};
		this.appendInitData(data,cfg);
		if(rootId) cfg.asyncRootParam={id:rootId};
		return this.treeSelect(cfg);
	},
	
	teamSelect:function(data,isSingle,cascadeLoad,rootId){
		var cfg={
			url:'LawTeamAction!getTeamTree.action',
			isLeafOnly:false,
			isSingle:!!isSingle,
			title:'客户组选择',
			cascadeLoad:cascadeLoad!==false
		};
		this.appendInitData(data,cfg);
		if(rootId) cfg.asyncRootParam={id:rootId};
		return this.treeSelect(cfg);
	},
	orgSelect:function(data,isSingle,rootId){
		var cfg={
			url:'TreeAction!getOrgTree.action',
			isSingle:!!isSingle,
			title:'部门选择',
			checkType:{Y:'',N:''}
		};
		this.appendInitData(data,cfg);
		if(rootId) cfg.asyncRootParam={id:rootId};
		return this.treeSelect(cfg);
	},
	officeSelect:function(data,isSingle){
		var cfg={
			url:'TreeAction!getOfficeSelect.action',
			isSingle:!!isSingle,
			title:'职务选择'
		};
		this.appendInitData(data,cfg)
		return this.select(cfg);
	},
	roleSelect:function(data,isSingle){
		var cfg={
			url:'TreeAction!getRoleSelect.action',
			isSingle:!!isSingle,
			title:'角色选择'
		};
		this.appendInitData(data,cfg)
		return this.select(cfg);
	},
	extendsProgressTypeSelect:function(data,isSingle){
		var cfg={
			url:'LawExtendsProgressTypeAction!getExtendsTypeSelect.action',
			isSingle:!!isSingle,
			title:'自定义类型选择'
		};
		this.appendInitData(data,cfg)
		return this.select(cfg);
	},
	lawTypeSelect:function(data,isSingle,rootId){
		var cfg={
			url:'LawTypeAction!getTree.action',
			isLeafOnly:false,
			isSingle:!!isSingle,
			title:'类型选择'
		};
		this.appendInitData(data,cfg)
		return this.treeSelect(cfg);
	},
	selectLawyer:function(data,isSingle){
		var cfg={
			url:'LawyerAction!getLawyerSelect.action',
			isSingle:!!isSingle,
			title:'律师选择'
		};
		this.appendInitData(data,cfg)
		return this.select(cfg);
	},
	appendInitData:function(data,cfg){
		if(typeof data=="string"){
			cfg.data=data;
		}
		else if(data){
			cfg.valueDom=data.valueDom;
			cfg.textDom=data.textDom;
		}
	},
	getFeature:function(cfg){
		var width=cfg.width||this.WIN_WIDTH;
		var height=cfg.height||this.WIN_HEIGHT;
		var resizable=cfg.resizable==undefined?this.WIN_RESIZABLE:cfg.resizable;
		if(resizable) resizable=1
		else resizable=0;
		return "dialogHeight="+height+"px;dialogWidth="+width+"px;resizable="+resizable;
	},
	getDomValue:function(cfg){
		var doms=this.getSelDoms(cfg);
		if(!doms||!doms.valueDom||!doms.textDom) return null;
		return doms.textDom.value+"|"+doms.valueDom.value;

	},
	setDomValue:function(cfg,value){
		if(!value) return;
		var doms=this.getSelDoms(cfg);
		if(!doms) return;
		var its=value.split("|");
		if(doms.textDom) doms.textDom.value=its[0];
		if(doms.valueDom) doms.valueDom.value=its[1];
	},
	getSelDoms:function(cfg){
		if(!cfg||!cfg.valueDom||!cfg.textDom) return null;
		var valueDom,textDom;
		if(cfg.valueDom.tagName) valueDom=cfg.valueDom;
		else valueDom=document.getElementById(cfg.valueDom);
		if(cfg.textDom.tagName) textDom=cfg.textDom;
		else textDom=document.getElementById(cfg.textDom);
		return {valueDom:valueDom,textDom:textDom};
	},
	clone:function(o){
		if(typeof o=='object'){
			var re;
			if(o instanceof Array) re=[];
			else re={};
			for(p in o){
				if(o.hasOwnProperty(p)) 
					re[p]=o[p];
			}
			return re;
		}
		return o;
	}
	
	
}