var flowStatus = null;
var ended_color = '#00ea4d';
var active_color = '#56b1ff';
var normal_color = '#eee';
$(function(){
	if (!window.ActiveXObject){
        $("#center").html('<br />&nbsp;&nbsp;&nbsp;<span style="color:red;font-size:20px;font-weight:bold;">请使用IE浏览器浏览</span>');
        return;
    }
	$.ajax({
		type: 'POST',
		url: action + "!getFlowChart.action",
		data: {'processId':processId},
		success: function(data){
			data = eval("(" + data + ")");
			flowStatus = data.flowStatus;
			XmlToProcess(data.flowChart);
		}
	});
});
var xml = null;
//初始设置流程定义
function initProcess(){	
	if(xml == null){
		//节点计数器
		taskNum = 1;
		lineNum = 1;
		endNum = 1;
		boolNum = 1;
		joinNum = 1;
		forkNum = 1;
		mailNum = 1;
		signNum = 1;
	}
	//创建xml对象
	createXml();
}
//创建xml
function createXml(){
	if(xml == null){
		xml = new ActiveXObject("Microsoft.XMLDOM");
		var p = xml.createProcessingInstruction("xml","version='1.0' encoding='UTF-8'");
		xml.appendChild(p);
		var root = xml.createElement("process");
		root.setAttribute("name","新建流程");
		root.setAttribute("xmlns","http://jbpm.org/4.4/jpdl");
		xml.appendChild(root);
	}
}
//给节点填充颜色
function nodeFillColor(){
	//start节点
	if(flowStatus.ended.length !=0 || flowStatus.active.length != 0){
		flowNode = $("[flowtype=start]")[0];
		flowNode.fillcolor = ended_color;
		var transition = $("line[source=start]")[0];
		transition.strokeColor = ended_color;
	}
	//已完成节点
	var endNodes = [];//已完成节点集合
	for(var i=0;i<flowStatus.ended.length;i++){
		var node = flowStatus.ended[i];
		flowNodes = $("[flowtype="+node.type+"]");
		for(var ii=0;ii<flowNodes.length;ii++){
			if(flowNodes[ii].title == node.name){
				flowNodes[ii].fillcolor = ended_color;
				endNodes.push(flowNodes[ii]);
				break;
			}
		}
	}
	//结束节点
	if(flowStatus.over != null){
		flowNodes = $("[flowtype=end]");
		for(var k=0;k<flowNodes.length;k++){
			if(flowNodes[k].title == flowStatus.over){
				flowNodes[k].fillcolor = ended_color;
				break;
			}
		}
	}
	//为已完成节点的outcome填充颜色
	for(var i=0;i<flowStatus.ended.length;i++){
		var node = flowStatus.ended[i];
		if(node.outcome != null){
			var transitions = $("line[source="+endNodes[i].id+"]");
			if(transitions.length == 1){
				transitions[0].strokeColor = ended_color;
			}else{
				for(var ti=0;ti<transitions.length;ti++){
					if(transitions[ti].title == node.outcome){
						transitions[ti].strokeColor = ended_color;
						var fork_join = $("#"+transitions[ti].project)[0];
						fork_join.fillcolor = ended_color;
						if(fork_join.flowtype == "fork" || fork_join.flowtype == "join"){
							var fj_transitions = $("line[source="+fork_join.id+"]");
							if(fork_join.flowtype == "fork"){
								for(var fj=0;fj<fj_transitions.length;fj++)
									fj_transitions[fj].strokeColor = ended_color;
							}else{
								var joinNode = $("#"+fj_transitions[0].project)[0];
								if(joinNode.fillcolor == ended_color)
									fj_transitions[0].strokeColor = ended_color;
							}	
						}
						break;
					}
				}
			}
		}
	}
	//活动中节点
	for(var j=0;j<flowStatus.active.length;j++){
		var node = flowStatus.active[j];
		var fillNode = null;
		flowNodes = $("[flowtype="+node.type+"]");
		for(var jj=0;jj<flowNodes.length;jj++){
			if(flowNodes[jj].title == node.name){
				flowNodes[jj].fillcolor = active_color;
				fillNode = flowNodes[jj];
				break;
			}
		}
		if(fillNode != null){
			var transitions = $("line[source="+fillNode.id+"]");
			for(var ji=0;ji<transitions.length;ji++){
				transitions[ji].strokeColor = active_color;
			}
		}
	}
}
//XML的逆向转换，将XML转换成为流程图
function XmlToProcess(loadXml){
	//清空已有的流程图
	$("#center").html();
	//初始化流程信息
	initProcess();
	xml.loadXML(loadXml);
	var root = findXmlNode("process");
	var rootChilds = root.childNodes;
	for(var i=0;i<rootChilds.length;i++)
		XmltoNode(rootChilds[i]);
	var lines = xml.getElementsByTagName("transition");
	for(i=0;i<lines.length;i++)
		XmltoLine(lines[i]);
	nodeFillColor();
}
//XML的逆向转换，生成节点
function XmltoNode(child){
	var showNode = true;//是否创建节点
	var locations = child.getAttribute("g")!=null?child.getAttribute("g").split(","):[0,0,110,50];
	var node = document.createElement("v:roundrect");
	node.inset = '2pt,2pt,2pt,2pt';
	node.style.pixelLeft = locations[0];
	node.style.pixelTop = locations[1];
	node.style.pixelWidth = locations[2];
	node.style.pixelHeight = locations[3];
	node.strokeColor = "#27548d";
	node.fillcolor= normal_color;
	$(node).addClass("node");
	switch(child.tagName){
		case "start":
			node.id = "start";
			node.title = child.getAttribute("name");
			node.flowtype = "start";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_start' inset='1pt,2pt,1pt,1pt'><b>Start</b><br />"+child.getAttribute("name")+"</v:textbox>";
			break
		case "task":	
			var title = "TaskNode";
			//标识泳道
			if(child.getAttribute("swimlane") != null&&child.getAttribute("swimlane") != "")
				title += "<span title='"+child.getAttribute("swimlane")+"' class='sign'>泳</span>";
			node.id = "task" + taskNum;
			node.title = child.getAttribute("name");
			node.flowtype = "task";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_task' inset='1pt,2pt,1pt,1pt'><b>"+title+"</b><br />"+child.getAttribute("name")+"</v:textbox>";
			taskNum ++;
			break
		case "custom":	
			var title = "SignNode";
			//标识泳道
			if(child.getAttribute("swimlane") != null&&child.getAttribute("swimlane") != "")
				title += "<span title='"+child.getAttribute("swimlane")+"' class='sign'>泳</span>";
			node.id = "sign" + signNum;
			node.title = child.getAttribute("name");
			node.flowtype = "custom";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_sign' inset='1pt,2pt,1pt,1pt'><b>"+title+"</b><br />"+child.getAttribute("name")+"</v:textbox>";
			signNum ++;
			break
		case "end":
			node.id = "end" + endNum;
			node.title = child.getAttribute("name");
			node.flowtype = "end";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_end' inset='1pt,2pt,1pt,1pt'><b>End</b><br />"+child.getAttribute("name")+"</v:textbox>";
			endNum ++;
			break;
		case "decision":
			node.id = "decision" + boolNum;
			node.title = child.getAttribute("name");
			node.flowtype = "decision";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_bool' inset='1pt,2pt,1pt,1pt'><b>Decision</b><br />"+child.getAttribute("name")+"</v:textbox>";
			boolNum ++;
			break;
		case "mail":
			node.id = "mail" + mailNum;
			node.title = child.getAttribute("name");
			node.flowtype = "mail";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_mail' inset='1pt,2pt,1pt,1pt'><b>Mail</b><br />"+child.getAttribute("name")+"</v:textbox>";
			mailNum ++;
			break;
		case "join":
			node.style.pixelWidth = 50;
			node.style.pixelHeight = 50;
			node.id = "join" + joinNum;
			node.title = child.getAttribute("name");
			node.flowtype = "join";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_join' inset='1pt,2pt,1pt,1pt'><br /></v:textbox>";
			joinNum ++;
			break;
		case "fork":
			node.style.pixelWidth = 50;
			node.style.pixelHeight = 50;
			node.id = "fork" + forkNum;
			node.title = child.getAttribute("name");
			node.flowtype = "fork";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_fork' inset='1pt,2pt,1pt,1pt'><br /></v:textbox>";
			forkNum ++;
			break;
		default:
			showNode = false;
	}
	if(showNode)
		document.getElementById("center").appendChild(node);
}
//XML的逆向转换，生成连线及文本节点
function XmltoLine(child){
	srcRect = findNodeXml(child.parentNode);
	desRect = findNodeXml(child.getAttribute("to"));
	var locations = child.getAttribute("g")!=null?child.getAttribute("g").split(","):[0,0];
	var line = document.createElement("v:line");
	direction();
	line.title = child.getAttribute("name");
	line.from = x0+","+y0;
	line.to = x1+","+y1;
	line.style.pixelLeft = x0 + 'px';
	line.style.pixelTop = y0 + 'px';
	line.style.position = "absolute";
	line.style.display = "block";
	line.id = "line" + lineNum;
	line.flowtype = "transition";
	line.strokeWeight = "1pt";
	line.style.cursor = "pointer";
	line.strokeColor = "#666666";
	line.source = srcRect.id;
	line.project = desRect.id;
	//创建箭头
	line.innerHTML = "<v:stroke endarrow='Classic' />";
	document.getElementById("center").appendChild(line);

	//生成文本节点
	var textNode = document.createElement("span");
	textNode.style.pixelLeft = locations[0];
	textNode.style.pixelTop = locations[1];
	textNode.innerHTML = child.getAttribute("name");
	$(textNode).addClass("font_node");
	textNode.title = "line" + lineNum;
	textNode.id = "text" + lineNum;
	document.getElementById("center").appendChild(textNode);
	lineNum ++;
}
//通过流程图节点查找XML节点
function findXmlNode(node){
	if(node == "process")
		return xml.documentElement;//返回根节点
	if(node == null || node.flowtype == null)
		return null;
	var nodes = xml.getElementsByTagName(node.flowtype);
	var sameNodes = [];
	
	for(var i=0;i<nodes.length;i++){
		//判断是连线还是节点，是节点的话用节点坐标比较，是连线的话，用连线对应的文本节点坐标比较
		if(node.flowtype == "transition"){
			var font = Ext.DomQuery.select("span[title="+node.id+"]")[0];
			//for(i=0;i<nodes.length;i++){
				if(nodes[i].getAttribute("g") == font.style.pixelLeft+","+font.style.pixelTop)
					sameNodes.push(nodes[i]);
			//}
		}else{
			//for(i=0;i<nodes.length;i++){
				if(nodes[i].getAttribute("g") == node.style.pixelLeft+","+node.style.pixelTop+","+node.style.pixelWidth+","+node.style.pixelHeight)
					sameNodes.push(nodes[i]);
			//}	
		}
	}
	if(sameNodes.length == 1){
		return sameNodes[0];
	}else{
		for(var i=0;i<sameNodes.length;i++){
			if(sameNodes[i].getAttribute("name") == node.title){
				return sameNodes[i];
			}
		}
	}
	return null;
}
//通过XML节点查找流程图节点，当前只用到通过name查找roundrect节点
function findNodeXml(xmlNode){	
	var nodes = [];
	var sameNodes = [];
	//如果不是节点的话通过title查找，如果是节点的话通过flowtype查找
	if(typeof xmlNode == "object"){	
		nodes = $("[flowtype="+xmlNode.tagName+"]");
		for(var i=0;i<nodes.length;i++){
			if(xmlNode.getAttribute("name") == nodes[i].title)
				sameNodes.push(nodes[i]);
		}
		if(sameNodes.length == 1){
			return sameNodes[0];
		}else{
			for(i=0;i<sameNodes.length;i++){
				if(xmlNode.getAttribute("g") == sameNodes[i].style.pixelLeft+","+sameNodes[i].style.pixelTop+","+sameNodes[i].style.pixelWidth+","+sameNodes[i].style.pixelHeight)
					return sameNodes[i];
			}	
		}
	}else{
		//如果有多个title相同的节点，只能返回第一个
		return $("roundrect[title="+xmlNode+"]")[0];
	}
	return null;
}
//箭头方向判断
function direction(){
	if (srcRect.style.pixelLeft > desRect.style.pixelLeft){
		if ((srcRect.style.pixelLeft - desRect.style.pixelLeft) <= desRect.style.pixelWidth){
			x0 = srcRect.style.pixelLeft + srcRect.style.pixelWidth / 2;
			x1 = desRect.style.pixelLeft + desRect.style.pixelWidth / 2;
			if (srcRect.style.pixelTop >  desRect.style.pixelTop){
				y0 = srcRect.style.pixelTop;
				y1 = desRect.style.pixelTop  + desRect.style.pixelHeight;
			}else{
				y0 = srcRect.style.pixelTop + srcRect.style.pixelHeight;
				y1 = desRect.style.pixelTop;
			}
		}else{
			x0 = srcRect.style.pixelLeft;
			x1 = desRect.style.pixelLeft + desRect.style.pixelWidth;
			y0 = srcRect.style.pixelTop + srcRect.style.pixelHeight / 2;
			y1 = desRect.style.pixelTop + desRect.style.pixelHeight / 2;
		}
	}else{
		if ((desRect.style.pixelLeft - srcRect.style.pixelLeft) <= desRect.style.pixelWidth){
			x0 = srcRect.style.pixelLeft + srcRect.style.pixelWidth / 2;
			x1 = desRect.style.pixelLeft + desRect.style.pixelWidth / 2;
			if (srcRect.style.pixelTop >  desRect.style.pixelTop){
			   y0 = srcRect.style.pixelTop;
			   y1 = desRect.style.pixelTop  + desRect.style.pixelHeight;
			}else{
			   y0 = srcRect.style.pixelTop + srcRect.style.pixelHeight;
			   y1 = desRect.style.pixelTop;
			}
		}else{
			x0 = srcRect.style.pixelLeft + srcRect.style.pixelWidth;
			x1 = desRect.style.pixelLeft;
			y0 = srcRect.style.pixelTop + srcRect.style.pixelHeight / 2;
			y1 = desRect.style.pixelTop + desRect.style.pixelHeight / 2;
		}
	}
}