Ext.namespace("ContactConfig");

var ContactConfig = {
	store: null,
	Contact: null,
	grid: null,
	editor: null,
	//联系人数据
	name: '',
	relationship: '',
	sex: '',
	birthday: '',
	phone: '',
	workAddress: '',
	address: '',
	initContact : function(){
		Huateng.Util.DictMgr.setDictMap('sex','402881852c2fbd56012c30080e930025');
		Huateng.Util.DictMgr.setDictMap('relationship','402881852c4e803b012c4f9efaf40002');
		//var width = Ext.getDom('contactGrid').getAttribute("style").width;
		//联系人对象
		
		ContactConfig.Contact = Ext.data.Record.create([{
			name: 'contactId',
			type: 'string'
		},{
	        name: 'name',
	        type: 'string'
	    }, {
	        name: 'relationship',
	        type: 'string'
	    }, {
	        name: 'sex',
	        type: 'string'
	    }, {
	        name: 'birthday',
	        type: 'string',
	        dateFormat: 'Y年m月d日'
	    },{
	    	name: 'position',
	    	type: 'string'
	    },{
	    	name: 'email',
	    	type: 'string'
	    },{
	    	name: 'tel',
	    	type: 'string'
	    },{
	        name: 'phone',
	        type: 'string'
	    },{
	        name: 'workAddress',
	        type: 'string'
	    },{
	        name: 'address',
	        type: 'string'
	    }]);
	
	    ContactConfig.store = new Ext.data.GroupingStore({
	        reader: new Ext.data.JsonReader({fields: ContactConfig.Contact})
	        //sortInfo: {field: 'relationship', direction: 'ASC'}
	    });
	
	    ContactConfig.editor = new Ext.ux.grid.RowEditor({
	        saveText: '确定',
	        cancelText: '取消'
	    });
//		//将性别的1、2转化为男、女
//		function change(val) {
//	        if (val == 1) {
//	            return '男';
//	        } else if (val == 2) {
//	            return '女';
//	        }
//	        return val;
//	    };
//	    //亲属关系数值转换
//	    function change1(val){
//	    	if(val == 1){
//	    		return '父亲';
//	    	}else if( val == 2){
//	    		return '母亲';
//	    	}else if( val == 3){
//	    		return '妻子';
//	    	}else if( val == 4){
//	    		return '哥哥';
//	    	}else if( val == 5){
//	    		return '弟弟';
//	    	}else if( val == 6){
//	    		return '儿子';
//	    	}else if( val == 7){
//	    		return '女儿';
//	    	}else if( val == 8){
//	    		return '其他';
//	    	}
//	    	return val;
//	    };
	    //根据com_or_per判断是企业客户还是个人客户，然后生成对应联系人的字段
	    var columns;
	    var title;
	    var autoExpandColumn;
	    if(com_or_per){
	    	autoExpandColumn = "email",
	    	title = "企业联系人信息";
	    	columns = [
		        new Ext.grid.RowNumberer(),
		        {
		            id: 'name',
		            header: '联系人',
		            dataIndex: 'name',
		            width: 100,
		            sortable: true,
		            editor: {
		                xtype: 'textfield',
		                allowBlank: true
		            }
		        },{
		            header: '性别',
		            dataIndex: 'sex',
		            width: 100,
		            sortable: true,
		            renderer:Huateng.Util.DictMgr.getDictMapFun('sex'),
		            editor: {
		                xtype: 'combo',
		                store: new Ext.data.SimpleStore({
		                	fields: ['value','text'],
		                	data: []
		                }),
		                displayField: 'text',
		                valueField: 'value',
		                editable: false,
		                mode: 'local',
		                triggerAction: 'all',
		                emptyText: '请选择',
		                allowBlank: true
		            }
		        },{
		            xtype: 'datecolumn',
		            header: '出生日期',
		            dataIndex: 'birthday',
		            format: 'Y年m月d日',
		            width: 100,
		            sortable: true,
		            groupRenderer: Ext.util.Format.dateRenderer('M y'),
		            editor: {
		                xtype: 'datefield',
		                allowBlank: true,
		                editable: false,
		                /**
		                 * 最小日期与小于最小日期的提示信息
		                 */
		                //minValue: '01/01/2006',
		                //minText: 'Can\'t have a start date before the company existed!',
		                //最大日期为当天
		                maxValue: (new Date()).format('m/d/Y')
		            }
		        },{
		            header: '职位',
		            dataIndex: 'position',
		            width: 100,
		            sortable: true,
		            editor: {
		                xtype: 'textfield',
		                allowBlank: true
		            }
		        },{
		            header: '联系电话',
		            dataIndex: 'tel',
		            width: 100,
		            sortable: true,
		            editor: {
		                xtype: 'textfield',
		                allowBlank: true
		            }
		        },{
		            header: '移动电话',
		            dataIndex: 'phone',
		            width: 200,
		            sortable: true,
		            editor: {
		                xtype: 'textfield',
		                allowBlank: true
		            }
		        },{
		        	id: 'email',
		            header: '电子邮件',
		            dataIndex: 'email',
		            width: 200,
		            sortable: true,
		            editor: {
		                xtype: 'textfield',
		                allowBlank: true
		            }
		        }
			];
	    }else{
	    	autoExpandColumn = "address",
	    	title = "亲属联系信息";
	    	columns = [
		        new Ext.grid.RowNumberer(),
		        {
		            id: 'name',
		            header: '姓名',
		            dataIndex: 'name',
		            width: 100,
		            sortable: true,
		            editor: {
		                xtype: 'textfield',
		                allowBlank: true
		            }
		        },{
		            header: '性别',
		            dataIndex: 'sex',
		            width: 100,
		            sortable: true,
		            renderer:Huateng.Util.DictMgr.getDictMapFun('sex'),
		            editor: {
		                xtype: 'combo',
		                store: new Ext.data.SimpleStore({
		                	fields: ['value','text'],
		                	data:[]
		                }),
		                displayField: 'text',
		                valueField: 'value',
		                editable: false,
		                mode: 'local',
		                triggerAction: 'all',
		                emptyText: '请选择',
		                allowBlank: true
		            }
		        },{
		            header: '亲属关系',
		            dataIndex: 'relationship',
		            width: 100,
		            renderer: Huateng.Util.DictMgr.getDictMapFun('relationship'),
		            sortable: true,
		            editor: {
		                xtype: 'combo',
		                store: new Ext.data.SimpleStore({
		                	fields: ['value','text'],
		                	data: []
		                }),
		                displayField: 'text',
		                valueField: 'value',
		                editable: false,
		                mode: 'local',
		                triggerAction: 'all',
		                emptyText: '请选择',
		                allowBlank: true
		            }
		        },{
		            xtype: 'datecolumn',
		            header: '出生日期',
		            dataIndex: 'birthday',
		            format: 'Y年m月d日',
		            width: 100,
		            sortable: true,
		            groupRenderer: Ext.util.Format.dateRenderer('M y'),
		            editor: {
		                xtype: 'datefield',
		                allowBlank: true,
		                editable: false,
		                /**
		                 * 最小日期与小于最小日期的提示信息
		                 */
		                //minValue: '01/01/2006',
		                //minText: 'Can\'t have a start date before the company existed!',
		                //最大日期为当天
		                maxValue: (new Date()).format('m/d/Y')
		            }
		        },{
		            header: '电话',
		            dataIndex: 'phone',
		            width: 100,
		            sortable: true,
		            editor: {
		                xtype: 'textfield',
		                allowBlank: true
		            }
		        },{
		            header: '工作地址/学校',
		            dataIndex: 'workAddress',
		            width: 200,
		            sortable: true,
		            editor: {
		                xtype: 'textfield',
		                allowBlank: true
		            }
		        },{
		        	id: 'address',
		            header: '居住地址',
		            dataIndex: 'address',
		            width: 200,
		            sortable: true,
		            editor: {
		                xtype: 'textfield',
		                allowBlank: true
		            }
		        }
			];
	    }
	    function comboDict(dict,opts){
	    	var dd=[];
    		for(var i=0;i<dict.length;i++){
    			var d=dict[i];
    			dd.push([d.value,d.name]);
    		}
    		this.editor.store.loadData(dd);
	    }
    	Huateng.Util.DictMgr.loadDict("402881852c2fbd56012c30080e930025",comboDict,columns[2]);
    	if(!com_or_per)
    		Huateng.Util.DictMgr.loadDict("402881852c4e803b012c4f9efaf40002",comboDict,columns[3]);
	    //var sm = new Ext.grid.CheckboxSelectionModel();
	    ContactConfig.grid = new Ext.grid.GridPanel({
	    	title: title,
	        store: ContactConfig.store,
	        el: 'contactGrid',
	        layout: 'fit',
	        width: 1055,
	        height: 200,
	        autoExpandColumn: autoExpandColumn,
	        plugins: [ContactConfig.editor],
	        //配置按列分组信息
	        view: new Ext.grid.GroupingView({
	            markDirty: false
	        }),
	        viewConfig: {
				columnsText: '显示的列',
				scrollOffset: 16,
				sortAscText: '升序',
				sortDescText: '降序'
			},
	        tbar: [{
	            iconCls: 'icon10',
	            text: '添加联系人',
	            handler: function(){
	            	var e;
	            	if(com_or_per){
	            		e = new ContactConfig.Contact({
		                	contactId: '',
		                    name: '',
		                    position: '',
		                    sex: '请选择',
		                    birthday: (new Date()).clearTime(),
		                    phone: '',
		                    tel: '',
		                    email: ''
		                });
	            	}else{
	            		e = new ContactConfig.Contact({
		                	contactId: '',
		                    name: '',
		                    relationship: '请选择',
		                    sex: '请选择',
		                    birthday: (new Date()).clearTime(),
		                    phone: '',
		                    workAddress: '',
		                    address: ''
		                });
	            	}
	                ContactConfig.editor.stopEditing();
	                ContactConfig.store.insert(0, e);
	                ContactConfig.grid.getView().refresh();
	                ContactConfig.grid.getSelectionModel().selectRow(0);
	                ContactConfig.editor.startEditing(0);
	            }
	        },{
	            iconCls: 'icon14',
	            text: '删除联系人',
	            disabled: false,
	            handler: function(){
	                ContactConfig.editor.stopEditing();
	                var s = ContactConfig.grid.getSelectionModel().getSelections();
	                var contactId = "";
	                for(var i = 0, r; r = s[i]; i++){         
	                	contactId += r.get("contactId") + ",";
	                    ContactConfig.store.remove(r);
	                }
	                if(com_or_per){
		                if(!ComClientConfig.isNewClient){
	                    	if(contactId != null){
	                    		Ext.Ajax.request({
	                    			url: "CClientAction!delContact.action",
	                    			method: 'post',
	                    			success: function(response){
	                    				
	                    			},
	                    			params: {contacts: contactId}
	                    		})
	                    	}
		                }
                    }else{
	                	if(!PerClientConfig.isNewClient){
	                    	if(contactId != null){
	                    		Ext.Ajax.request({
	                    			url: "PClientAction!delContact.action",
	                    			method: 'post',
	                    			success: function(response){
	                    				
	                    			},
	                    			params: {contacts: contactId}
	                    		})
	                    	}
	                	}
                    }
	            }
	        }],
	        columns: columns
	    });
	    ContactConfig.grid.render();
	}
}