Ext.namespace("PerClientConfig");
PerClientConfig = {
	bbar: null,
	ds: null,
	perClientWin: null,
	isNewClient: true,
	data1: null,//资料管理人
	data2: null,//负责职位
	data3: null,//资料使用人
	data4: null,//用户平台账号
	//个人客户属性
	cusId: '',
	isSave: false, //是否保存，若保存，不用删除图片
	//初始化布局
	initPerClient : function(){
		Huateng.Util.Validator.defaultGetMsgName=function(el){
			return el.parentNode.previousSibling.innerHTML;
		};
		Huateng.Util.DictMgr.setDictMap('sex','402881852c2fbd56012c30080e930025');
		//日期控件
		new Ext.form.DateField({   
	      applyTo : 'birthday',   
	      width: 130,   
	      format: 'Y年m月d日',   
	      emptyText: '请选择日期 ...',
	      editable: false
	     });
     	new Ext.Button({  
	     	text: '搜索',
	     	iconCls: 'icon307',
	      	applyTo : 'searchButton',
	      	handler:PerClientConfig.searchPerClient
	    });
	    new Ext.Button({  
	     	text: '全部',
	     	iconCls: 'icon252',
	      	applyTo : 'searchAllButton',
	      	handler:PerClientConfig.searchAllPerClient
	    });
		var perClientPanel = new Ext.Panel({
			contentEl: 'perCilentSearch',
			region: 'north',
			title: '搜索',
			iconCls: 'icon307',
			collapsible: true,
			layout:'fit',
			height: 90,
			frame:true,
			border: true
		});
		//创建复选框
		var sm = new Ext.grid.CheckboxSelectionModel();
		var cm = new Ext.grid.ColumnModel([
			new Ext.grid.RowNumberer(),	//自动行号
			sm,
			{header: '客户编号',dataIndex: 'code',width: 100},
			{header: '姓名',dataIndex: 'name',width: 100},
			{header: '性别',dataIndex: 'sex',renderer:Huateng.Util.DictMgr.getDictMapFun('sex'),width: 100},
			{header: '出生日期',dataIndex: 'birthday',width: 100},
			{header: '联系电话',dataIndex: 'phone',width: 100},
			{header: '创建人',dataIndex: 'createUser',width: 100},
			{header: '创建时间',dataIndex: 'createDate',width: 100,renderer:Ext.util.Format.dateRenderer('Y年m月d日')},
			{header: '更新时间',dataIndex: 'updateDate',width: 100,renderer:Ext.util.Format.dateRenderer('Y年m月d日')}
		]);
		cm.defaultSortable = true;
		PerClientConfig.ds = new Ext.data.Store({
			proxy: new Ext.data.HttpProxy({url:'PClientAction!getPClientList.action'}),
			reader: new Ext.data.JsonReader({totalProperty: 'totalProperty',root: 'root'},[
				{name:'cusId'},
				{name: 'code'},
				{name: 'name'},
				{name: 'sex'},
				{name: 'birthday'},
				{name: 'phone'},
				{name: 'createUser'},
				{name: 'createDate'},
				{name: 'updateDate'}
			])
		});
		//将性别的1、2转化为男、女
		function change(val) {
	        if (val == 1) {
	            return '男';
	        } else if (val == 2) {
	            return '女';
	        }
	        return val;
	    };
		PerClientConfig.bbar = new Ext.PagingToolbar({
				pageSize: 20,
				store: PerClientConfig.ds,
				displayInfo: true,
				displayMsg: '显示第{0}条到{1}条记录，一共{2}条',
				emptyMsg: '没有记录',
				plugins : [new Ext.ux.PageSizePlugin()]
			})
		var fileItems = [];
		if(HT_ACTIONS.hasAction('addPerClient')) fileItems.push(HT_A.getCfg('addPerClient',{handler: PerClientConfig.addPerClient}),'-');
	  	if(HT_ACTIONS.hasAction('editPerClient')) fileItems.push(HT_A.getCfg('editPerClient',{handler: PerClientConfig.editPerClient}),'-');
	  	if(HT_ACTIONS.hasAction('deletePerClient')) fileItems.push(HT_A.getCfg('deletePerClient',{handler: PerClientConfig.delPerClient}),'-');
	  	fileItems.push({text:'刷新',iconCls:'icon276',handler: function(){PerClientConfig.ds.load({params:{start:0,limit:PerClientConfig.bbar.pageSize}});}},'-');
	  	fileItems.push({text: '共享客户',iconCls: 'icon178',handler: function(){PerClientConfig.sharePClient();}},'-');
	  	fileItems.push({text: '取消共享',iconCls: 'icon285',handler: function(){PerClientConfig.delSharePClient();}});
		PerClientConfig.grid = new Ext.grid.GridPanel({
			region: 'center',
			el: 'perClientHtml',
			layout: 'fit',
			title: '个人客户列表',
			iconCls: htIcon,
			border: true,
			tbar: new Ext.Toolbar([
				fileItems,'-',
				new Ext.form.Checkbox({
	        		name: 'saveInfo',
	        		id: 'saveInfo',
	        		fieldLabel: '1',
	       	   		boxLabel: '操作成功时有提示',
	       	   		checked: true
	       	   	})
			]),
			viewConfig: {
				columnsText: '显示的列',
				scrollOffset: 16,
				sortAscText: '升序',
				sortDescText: '降序',
				forceFit:true//自填充，把表格填充满。
			},
			loadMask: new Ext.LoadMask(Ext.getDom("perClientHtml"), {msg:"加载中..."}),
            autoScroll: false,
            stripeRows: true,
			ds: PerClientConfig.ds,
			cm: cm,
			sm: sm,
			bbar: PerClientConfig.bbar
		});
		//创建布局
		var perClientViewport = new Ext.Viewport({
			layout: 'border',
			items: [perClientPanel,PerClientConfig.grid]
		});
		PerClientConfig.ds.load({params:{start:0,limit:PerClientConfig.bbar.pageSize}});
		if(HT_ACTIONS.hasAction('editPerClient'))
			PerClientConfig.grid.on('rowdblclick',PerClientConfig.editPerClient);
//		//初始化个人客户窗口
//		PerClientConfig.perClientWin = new Ext.Window({
//	        title: '新建个人客户',
//	        layout: 'fit',
//	        width: 800,
//	        height: 400,
//	  		autoScroll: true,
//	  		bodyStyle: {background: '#ffffff'},
//	        plain: false,
//	  		modal: true,
//	  		iconCls: htIcon,
//	  		closeAction: 'hide',
//	  		contentEl: 'perClientItem',
//	        buttons: [
//	        	{
//	            	text: '保存并新增下一个',
//	            	iconCls: 'icon187',
//	            	handler: function(){if(PerClientConfig.savePerClient())PerClientConfig.addPerClient()}
//	        	},{
//	            	text: '保存并关闭',
//	            	iconCls: 'icon153',
//	            	handler: function(){PerClientConfig.savePerClient();}
//	        	},{
//	            	text: '取消',
//	            	iconCls: 'icon163',
//	            	handler: function(){PerClientConfig.perClientWin.hide();}
//	    	}]
//   	   	});
//   	   	PerClientConfig.perClientWin.show();
//   		PerClientConfig.perClientWin.hide();
//   		PerClientConfig.perClientWin.maximize();
//   		PerClientConfig.perClientWin.on('hide',function(){ if(!PerClientConfig.isSave)PerClientConfig.deletePhoto();});
   		//上传照片
	  	new Ext.ux.IFrameComponent({
			title: 'photo',
			id: 'uphoto',
			renderTo: 'upload-photo',
			width: 200,
			border: true,
			height: 190,
			url: htSystemPath + 'sys/jsp/util/upload_photo.jsp?action=PClientAction!uploadPhoto.action&path=upload/lawyer/clientPhoto/'
	  	});
//   	   	Ext.getDom('perClientItem').style.display = "block";
   	   	Ext.getDom('perCilentSearch').style.display = "block";
	},
	perClientWinInit : function(){
		if(!PerClientConfig.perClientWin){
			//初始化个人客户窗口
			PerClientConfig.perClientWin = new Ext.Window({
		        title: '新建个人客户',
		        layout: 'fit',
		        width: 800,
		        height: 400,
		  		autoScroll: true,
		  		bodyStyle: {background: '#ffffff'},
		        plain: false,
		  		modal: true,
		  		iconCls: htIcon,
		  		closeAction: 'hide',
		  		contentEl: 'perClientItem',
		        buttons: [
		        	{
		            	text: '保存并新增下一个',
		            	iconCls: 'icon187',
		            	handler: function(){if(PerClientConfig.savePerClient())PerClientConfig.addPerClient()}
		        	},{
		            	text: '保存并关闭',
		            	iconCls: 'icon153',
		            	handler: function(){PerClientConfig.savePerClient();}
		        	},{
		            	text: '取消',
		            	iconCls: 'icon163',
		            	handler: function(){PerClientConfig.perClientWin.hide();}
		    	}]
	   	   	});
	   	   	PerClientConfig.perClientWin.show();
	   		PerClientConfig.perClientWin.hide();
	   		PerClientConfig.perClientWin.maximize();
	   		PerClientConfig.perClientWin.on('hide',function(){ if(!PerClientConfig.isSave)PerClientConfig.deletePhoto();});
	   	   	Ext.getDom('perClientItem').style.display = "block";
		}
	},
	deletePhoto : function(){
		var photoName = document.getElementById("iframe-uphoto").contentWindow.document.getElementById("photoName").value;
		Ext.Ajax.request({
				url: 'PClientAction!deletePhoto.action',
				method: 'post',
				success: function(response){
				},
				params: {fileName : photoName}
			});
	},
	addPerClient : function(){
		PerClientConfig.perClientWinInit();
		PerClientConfig.isSave = false;
		PerClientConfig.perClientWin.setTitle("新建个人客户");
		Ext.getDom('sex').style.display = "block";
		Ext.getDom('maritalStatus').style.display = "block";
		Ext.getDom('nationality').style.display = "block";
		Ext.getDom('nation').style.display = "block";
		Ext.getDom('status2').style.display = "block";
		PerClientConfig.perClientWin.buttons[0].show();
		PerClientConfig.isNewClient = true;
		Huateng.Util.Form.formClear("perClientForm");
		//移除联系人数据
		ContactConfig.store.removeAll();
		//清空通用选择框的值
		PerClientConfig.data1 = '';
		PerClientConfig.data2 = '';
		PerClientConfig.data3 = '';
		PerClientConfig.data4 = '';
		//隐藏头像
		document.getElementById("iframe-uphoto").contentWindow.document.getElementById("photoName").value = '';
		document.getElementById("iframe-uphoto").contentWindow.document.getElementById("fileName").value = '';
		Ext.getDom('photo').value = '';
		var p = document.getElementById("iframe-uphoto").contentWindow.document.getElementById("photo-info");
		var el = Ext.fly(p);
    	el.update("");
		el.show();
		Ext.getDom('code2').value = new Date().getTime();
		PerClientConfig.perClientWin.show();
		//让滚动条回到顶部
		Ext.getDom("perClientItem").scrollTop=0;
	},
	editPerClient : function(){
		var row = PerClientConfig.grid.getSelectionModel().getSelections();
		if(row.length == 1){
			PerClientConfig.perClientWinInit();
			PerClientConfig.isSave = false;
			PerClientConfig.perClientWin.buttons[0].hide();
			PerClientConfig.perClientWin.setTitle("编辑个人客户");	
			Ext.getDom('sex').style.display = "block";
			Ext.getDom('maritalStatus').style.display = "block";
			Ext.getDom('nationality').style.display = "block";
			Ext.getDom('nation').style.display = "block";
			Ext.getDom('status2').style.display = "block";
			PerClientConfig.isNewClient = false;
			PerClientConfig.cusId = row[0].get("cusId");
			Ext.Ajax.request({
				url: 'PClientAction!getPerClient.action',
				method: 'post',
				success: function(response){
					var json = eval("(" + response.responseText + ")");
					//放入头像
					document.getElementById("iframe-uphoto").contentWindow.document.getElementById("photoName").value = '';
					document.getElementById("iframe-uphoto").contentWindow.document.getElementById("fileName").value = '';
					var p = document.getElementById("iframe-uphoto").contentWindow.document.getElementById("photo-info");
					var el = Ext.fly(p);
					if(json.photo != "null"){
			        	el.update("<img width='140px' height='130px' src='"+htSystemPath+"upload/lawyer/clientPhoto/"+json.photo+"'/>");
					}else{
						el.update('');
						Ext.getDom('photo').value = '';
					}  
					el.show();
					Huateng.Util.Form.formFill("perClientForm",json);
	                ContactConfig.store.loadData(json.contacts);
	                //为通用选择框重新赋值
					PerClientConfig.data1 = "[{name:'" + json.managerName + "',id:'" + json.manager + "'}]";
					PerClientConfig.data2 = "[{name:'"+json.positionsName +"',id:'" + json.positions + "'}]";
					PerClientConfig.data3 = json.users;
					PerClientConfig.data4 = "[{name:'"+json.user +"',id:'" + json.userId + "'}]";
					Huateng.Util.DictMgr.refurbishItem("sex",json.sex);
					Huateng.Util.DictMgr.refurbishItem("maritalStatus",json.maritalStatus);
					Huateng.Util.DictMgr.refurbishItem("nationality",json.nationality);
					Huateng.Util.DictMgr.refurbishItem("nation",json.nation);
					Huateng.Util.DictMgr.refurbishItem("status2",json.status);
//					Ext.getDom("usersNames").value = "";
//					Ext.getDom("users").value = "";
//					for(var i=0;i<json.users.length;i++){
//						Ext.getDom("usersNames").value += json.users[i].name + ",";
//						Ext.getDom("users").value += json.users[i].id + ",";
//					}
					Ext.getDom('photo').value = '';
					PerClientConfig.perClientWin.show();
					//让滚动条回到顶部
					Ext.getDom("perClientItem").scrollTop=0;
				},
				params: {cusId: PerClientConfig.cusId}
			})
		}else if(row.length>1){
			Ext.MessageBox.alert(tip,'请选择单项进行编辑！');	
		}else{
			Ext.MessageBox.alert(tip,'请选择编辑项！');
		}
	},
	savePerClient : function(){
		if(!Huateng.Util.Validator.formValidate("perClientForm")){
			return ;
		}
		if(Ext.getDom('code2').value=='')
				Ext.getDom('code2').value = new Date().getTime();
		PerClientConfig.isSave = true;
		var contacts = "["
		for(var i=0;i<ContactConfig.store.getCount();i++){
			var c = ContactConfig.store.getAt(i);
			contacts += "{contactId:'" + c.get("contactId") + "',";
			contacts += "name:'" + c.get("name") + "',";
			contacts += "relationship:'" + c.get("relationship") + "',";
			contacts += "sex:'" + c.get("sex") + "',";
			contacts += "birthday:'" + c.get("birthday") + "',";
			contacts += "phone:'" + c.get("phone") + "',";
			contacts += "workAddress:'" + c.get("workAddress") + "',";
			contacts += "address:'" + c.get("address") + "'";
			if(i<ContactConfig.store.getCount()-1)
				contacts += "},";
			else
				contacts += "}";
		}
		contacts += "]";
		if(PerClientConfig.isNewClient){
			params = {'cusId': '','contacts': contacts};
		}else{
			params = {'cusId': PerClientConfig.cusId,'contacts': contacts};
		}
		Ext.Ajax.request({
			url: 'PClientAction!updateOrSavePClient.action',
			method: 'post',
			success: function(response){
				if(Ext.getDom("saveInfo").checked)
					Ext.MessageBox.alert(tip,'保存信息成功！');
				PerClientConfig.bbar.store.baseParams = {start:0,limit:PerClientConfig.bbar.pageSize};
				PerClientConfig.ds.load();
			},
			params: params,
			form: 'perClientForm'
		});
		PerClientConfig.perClientWin.hide();
		return true;
	},
	delPerClient : function(){
		var records = PerClientConfig.grid.getSelectionModel().getSelections();
		if(records.length<=0){
			Ext.MessageBox.alert(tip,"请选择要删除的记录");
		}else{
			Ext.MessageBox.confirm(tip,'确定删除数据？',function(btn){
				if(btn =='yes'){
					var jsonData = "";
					for(var i = 0,len = records.length;i<len;i++){
						if(i==0){
							jsonData += records[i].get("cusId");
						}else{
							jsonData += "," + records[i].get("cusId");
						}
						PerClientConfig.ds.remove(records[i]);
					}
					Ext.Ajax.request({
						url: 'PClientAction!deletePClient.action',
						method: 'post',
						success: function(response){
							if(Ext.getDom('saveInfo').checked){
								Ext.MessageBox.alert(tip,'删除数据成功！');
							}
							PerClientConfig.bbar.doLoad(PerClientConfig.bbar.cursor);
						},
						params: {cusId: jsonData}
					})
				}
			});
		}
	},
	searchPerClient : function(){
		var code = Ext.getDom('code1').value;
		var name = Ext.getDom('name1').value;
		var status = Ext.getDom('status1').value;
		var createPerson = Ext.getDom('createUser').value;
		var idCred = Ext.getDom('idCred').value;
		PerClientConfig.bbar.store.baseParams = {start:0,limit:PerClientConfig.bbar.pageSize,code:code,name:name,status:status,createPerson:createPerson,idCred:idCred};
		PerClientConfig.ds.load();
	},
	searchAllPerClient : function(){
		PerClientConfig.bbar.store.baseParams = {start:0,limit:PerClientConfig.bbar.pageSize};
		PerClientConfig.ds.load();
	},
	sharePClient : function(){
		PerClientConfig.data3 ='';
		var usersSelector;
		var records = PerClientConfig.grid.getSelectionModel().getSelections();
		if(records.length<=0){
			Ext.MessageBox.alert(tip,"请选择要共享的客户");
		}else{
			//共享的客户
			var jsonData = "";
			for(var i = 0,len = records.length;i<len;i++){
				if(i==0){
					jsonData += records[i].get("cusId");
				}else{
					jsonData += "," + records[i].get("cusId");
				}
			}
			//通用选择框
			if(!usersSelector) usersSelector=new Huateng.Util.Select({
				selects:[{
					type:'tree',
					dataUrl:'LawTreeAction!getOrgLawyerTree.action',
				  	rootId:'#',
				  	isLeafOnly:true
				}],
				dataItems:[],
				callback:function(data){
					var users='';
					for(var i=0;i<data.length;i++){
						var user = data[i];
						users += user.id + ",";
					}
					//保存共享
					Ext.Ajax.request({
						url: 'PClientAction!saveSharePClient.action',
						method: 'post',
						success: function(response){
							if(Ext.getDom('saveInfo').checked){
								Ext.MessageBox.alert(tip,'共享成功！');
							}
						},
						params: {cusId: jsonData,users: users}
					})
				}
			});
			usersSelector.dataItems = PerClientConfig.data3;
			usersSelector.show();
		}
	},
	delSharePClient : function(){
		var usersSelector;
		var records = PerClientConfig.grid.getSelectionModel().getSelections();
		if(records.length<=0){
			Ext.MessageBox.alert(tip,"请选择要取消共享的客户");
		}else{
			//共享的客户
			var jsonData = "";
			for(var i = 0,len = records.length;i<len;i++){
				if(i==0){
					jsonData += records[i].get("cusId");
				}else{
					jsonData += "," + records[i].get("cusId");
				}
			}
			Ext.Ajax.request({
				url: 'PClientAction!delSharePClient.action',
				method: 'post',
				success: function(response){
					if(Ext.getDom('saveInfo').checked){
						Ext.MessageBox.alert(tip,'取消共享成功！');
					}
				},
				params: {cusId: jsonData}
			})
		}
	}
};
//通用选择框
//资料管理人
var managerSelector;
function selectManager(){
	if(!managerSelector) managerSelector=new Huateng.Util.Select({
		selects:[{
			type:'tree',
			dataUrl:'LawTreeAction!getOrgLawyerTree.action',
		  	rootId:'#',
		  	isLeafOnly:true
		}],
		isSingle: true,
		dataItems:[],
		callback:function(data){
			Ext.getDom("managerName").value = '';
			Ext.getDom("manager").value = '';					
			for(var i=0;i<data.length;i++){
				var user = data[i];
				Ext.getDom("managerName").value += user.name;
				Ext.getDom("manager").value += user.id;
			}
			PerClientConfig.data1 = data;
		}
	});
	managerSelector.dataItems = PerClientConfig.data1;
	managerSelector.show();
}
//负责职位
var positionSelector;	
function selectPosition(){
	if(!positionSelector) positionSelector=new Huateng.Util.Select({
		selects:[{
			type:'select',
			dataUrl:'TreeAction!getOfficeTree.action',
		  	rootId:'#'
		}],
		isSingle:true,
		dataItems:[],
		callback:function(data){
			Ext.getDom("positionsName").value = '';
			Ext.getDom("positions").value = '';					
			for(var i=0;i<data.length;i++){
				var office = data[i];
				Ext.getDom("positionsName").value += office.name;
				Ext.getDom("positions").value += office.id;
			}
			PerClientConfig.data2 = data;
		}
	});	
	positionSelector.dataItems = PerClientConfig.data2;
	positionSelector.show();
}
//资料使用人
var usersSelector;
function selectUsers(){
	if(!usersSelector) usersSelector=new Huateng.Util.Select({
		selects:[{
			type:'tree',
			dataUrl:'LawTreeAction!getOrgLawyerTree.action',
		  	rootId:'#',
		  	isLeafOnly:true
		}],
		dataItems:[],
		callback:function(data){
			Ext.getDom("usersNames").value = '';
			Ext.getDom("users").value = '';					
			for(var i=0;i<data.length;i++){
				var user = data[i];
				Ext.getDom("usersNames").value += user.name + ",";
				Ext.getDom("users").value += user.id + ",";
			}
			PerClientConfig.data3 = data;
		}
	});
	usersSelector.dataItems = PerClientConfig.data3;
	usersSelector.show();
}
//用户平台账号
var userSelector;
function selectUser(){
	if(!userSelector) userSelector=new Huateng.Util.Select({
		selects:[{
			type:'tree',
			dataUrl:'TreeAction!getOrgUserTree.action',
		  	rootId:'#',
		  	isLeafOnly:true
		}],
		isSingle: true,
		dataItems:[],
		callback:function(data){
			Ext.getDom("user").value = '';
			Ext.getDom("userId").value = '';					
			for(var i=0;i<data.length;i++){
				var user = data[i];
				Ext.getDom("user").value += user.name;
				Ext.getDom("userId").value += user.id;
			}
			PerClientConfig.data4 = data;
		}
	});
	userSelector.dataItems = PerClientConfig.data4;
	userSelector.show();
}