var results={};
var isLeafOnly=false;
var isSingle=false;
var cascadeLoad=false;
var _trees={};
var activeTreeId="sseltree";
var resultTreeId="resultTree";

function ok(){
	var rTree=_trees[resultTreeId];
	var nodes=rTree.getNodes();
	var re=[[],[]];
	for(var i=0;i<nodes.length;i++){
    	re[0].push(nodes[i].text);
    	re[1].push(nodes[i].id);
	}
	var rv=re[0].join()+"|"+re[1].join();
	window.returnValue=rv;
	window.close();
}

function cancel(){
	window.close();
}

function onBeforeChange(treeId,treeNode){
	var sTree=_trees[treeId];
  	 var ct=sTree.setting.checkType;
  	 if(!treeNode.checked&&isSingle)  
  	 	sTree.checkAllNodes(false);
}

function onChange(evt,treeId,treeNode){
	var sTree=_trees[treeId];
	var ct=sTree.setting.checkType;
   if(treeNode.checked===true&&treeNode.isParent&&!isSingle&&cascadeLoad&&ct.Y.indexOf('s')>-1){
   		treeNode._cascadeLoad=true;
   		var childs=treeNode[sTree.setting.nodesCol];
   		if(childs && childs.length>0){
   			sTree.expandNode(treeNode,true);
   			for(var i=0;i<childs.length;i++){
   				onChange(evt,treeId,childs[i]);
   			}
   		}
   		else sTree.expandNode(treeNode,true);
	}
}
  
function onBeforeNodeCreate(treeId, treeNode,pNode){
		var sTree=$("#"+treeId).data("zTree");
		var ct=sTree.setting.checkType;
  		if(pNode&&!isSingle&&ct.Y.indexOf('s')>-1){
  			treeNode.checked=pNode.checked;
  			if(pNode._cascadeLoad&&cascadeLoad){
  				treeNode._cascadeLoad=true;
  				sTree.expandNode(treeNode,true);
  			}
  		}
}

function onClick(event,treeId,treeNode){
	var chk=$('#'+treeNode.tId+"_check");	
	if(chk[0]){
		chk.trigger('click');
	}
}
  
 function add(){
  	var rTree=_trees[resultTreeId];
  	var sTree=_trees[activeTreeId];
  	var nodes=sTree.getCheckedNodes(true);
  	for(var i=0;i<nodes.length;i++){
  		var node=nodes[i];
  		if(node._invalid!==true&&!results.hasOwnProperty(node.id)&&(!isLeafOnly||isLeafOnly&&node.leaf!==false&&!node.isParent)){
  			if(isSingle) removeAll();
  			var nn={id:node.id,text:node.text,iconCls:node.iconCls,iconSkin:node.iconSkin};
  			rTree.addNodes(null,nn,true);
  			results[node.id]=nn.tId;
  			if(isSingle) break;
  		}
  	}
  	selcountUpdate();
  }
  
function remove(){
	var rTree=_trees[resultTreeId];
	var sns=rTree.getSelectedNodes();
	for(var i=sns.length-1;i>=00;i--){
		var node=sns[i];
		delete results[node.id];
		rTree.removeNode(node);
	}
	selcountUpdate();
}

function removeAll(){
	var rTree=_trees[resultTreeId];
	rTree.clear();
	results={};
	selcountUpdate();
}

function addAll(){
	var sTree=_trees[activeTreeId];
	sTree.checkAllNodes(true);
	add();
}
 
 function dbclickRemove(event, treeId, treeNode){
 	var tree=_trees[treeId];
 	tree.removeNode(treeNode);
 	delete results[treeNode.id];
 	selcountUpdate();
 }
 
 function selcountUpdate(){
 	var rTree=_trees[resultTreeId];
 	$("#selcount").text(rTree.getNodes().length);
 }
 
 function init(){
   	var arg=window.dialogArguments;
   	var data="chen,afgf,你是你的|1,2,3";
   	var data;
   	if(arg)	data=arg.data;
	delete arg.data;
	createTree("sseltree",arg);
	var dest;
	if(arg) dest=arg.dest;
	initRTree(dest,data);
}

function initRTree(cfg,data){
  var resultTree=createResultTree("resultTree",cfg);
   if(data&&typeof data=='string'){
		var its=data.split("|");
		if(!its[1]) return;
		var ts=its[0].split(",");
		var vs=its[1].split(",");
		var nodes=[];
		var defaultIconCls=resultTree.setting.defaultIconCls;
		for(var i=0;i<vs.length;i++){
			if(!results.hasOwnProperty(vs[i]))
			results[vs[i]]=ts[i];
			var node={id:vs[i],text:ts[i],iconCls:defaultIconCls};
			nodes.push(node);
		}
		resultTree.addNodes(null,nodes);
		selcountUpdate();
   }
}

function createTree(ctId,arg){
	 var setting={
		checkable : true,
		checkType:{N:'s'},
		nameCol:'text',
		expandSpeed:'',
		asyncParam:["id"],
		callback:{
			beforeChange:onBeforeChange,
			change:onChange,
			beforeNodeCreate:onBeforeNodeCreate,
			click:onClick
		},
		autoLeaf:true
	}
	var isd=typeof isSimpleData=='undefined'?false:isSimpleData;
	var nodes=typeof treeNodes=='undefined'?null:nodes;
	if(arg&&typeof arg=="object"){
		if(arg.title) document.title=arg.title;
		isSingle=!!arg.isSingle;
		$.extend(setting,arg);
		if(!isd&&arg.url){
			setting.async=typeof arg.autoLoad!='undefined'?!!arg.autoLoad:true;
			setting.asyncUrl=arg.url;
		}
		if(isSingle&&!arg.checkType){
			setting.checkType={Y:'',N:''};
		}
		if(setting.isLeafOnly===true) 
			isLeafOnly=true;
		if(arg.cascadeLoad===true) cascadeLoad=true;
	}
	if(isd) setting.isSimpleData=true;
	if(nodes){
		setting.root={nodes:nodes};
	}
	var sTree=$("#"+ctId).zTree(setting);
	_trees[sTree.setting.treeObjId]=sTree;
	return sTree;
}

function createResultTree(ctId,cfg){
	cfg=cfg||{};
	 var setting={
		nameCol:'text',
		expandSpeed:'',
		showLine:false,
		showIcon:cfg.showIcon===true,
		defaultIconCls:cfg.defaultIconCls,
		selectMulti:true,
		wideNodeClickRange:true,
		callback:{
			dblclick:dbclickRemove
		}
	}
	var sTree=$("#"+ctId).zTree(setting);
	_trees[sTree.setting.treeObjId]=sTree;
	return sTree;
}

function initWin(){
	var ssel=$('#ssel');
	var rsel=$('#rsel');
	var width=$(document.body).width();
	var height=$(document.body).height();	
	if(height<300) height=300;
	if(height>600) height=650;
	if(width<300) width=300;
	if(width>800) width=600;
	ssel.height(height-70);
	rsel.height(height-70);
	ssel.width((width-105)/2);
	rsel.width((width-105)/2);
}