Ext.namespace("ActionConfig");
var ActionConfig = {
	actionWin: '',
	actionId: '',
	ds : '',
	grid : '',
	pageBar : '',
	isNewAction : true,
	initAction : function(){	
		var icons=new Array(313);
		for(var i=0;i<icons.length;i++){
			if(i<9) icons[i]="icon0"+(i+1);
			else  icons[i]="icon"+(i+1);
		}
		var iconMenu1=new Huateng.Util.IconMenu({
			icons:icons,
			width:230,
			height:145
		});
		icons=null;
		ActionConfig.actionIcon1=new Huateng.Util.IconSelect({
			renderTo: 'actionIcon1',
			iconMenu:iconMenu1,
			name:'icon'
		});
		
		var icons=new Array(32);
		for(var i=0;i<icons.length;i++){
			if(i<9) icons[i]="button_icon0"+(i+1);
			else  icons[i]="button_icon"+(i+1);
		}
		var iconMenu2=new Huateng.Util.IconMenu({
			icons:icons,
			width:238,
			iconSize:[32,32],
			height:150,
			rows:3,
			cols:6
		});
		icons=null;
		ActionConfig.actionIcon2=new Huateng.Util.IconSelect({
			renderTo: 'actionIcon2',
			iconMenu:iconMenu2,
			iconSize:[32,32],
			disabled:true,
			hidden:true,
			name:'icon'
		});
		Ext.fly('ismall').on('click',ActionConfig.onIconSizeChange);
		Ext.fly('ibig').on('click',ActionConfig.onIconSizeChange);
//		var actionPanel = new Ext.Panel({
//			renderTo: 'actionHtml',
//			border: false,
//			layout: 'fit',
//			tbar: new Ext.Toolbar([
//				{text: '新增',handler: ActionConfig.addAction},'-',
//				{text: '修改',handler: ActionConfig.editAction},'-',
//				{text: '删除',handler: ActionConfig.delAction}
//			]),
//			html: '<div id="actionGrid"></div>'
//		});
		var sm = new Ext.grid.CheckboxSelectionModel();
		var cm = new Ext.grid.ColumnModel([
			new Ext.grid.RowNumberer(),
			sm,
//			{header: '按钮ID',dataIndex: 'actionId',width:200},
			{header: '按钮名称',dataIndex: 'name',width:70},
			{xtype: 'actioncolumn', 
			 header: '图标',
			 width: 50,
			 height: 16,
			 items: [{
	            getClass: function(v, meta, rec) {          // Or return a class from a function
	                 return "icon16_16 "+rec.get('icon');
	            }
	        }]
           },
			{header: '所属表单',dataIndex: 'formName',width:100},
			{header: '方法名',dataIndex: 'key',width:100},
			{header: '授权',dataIndex: 'isAuthorized',width:100,renderer:function(value){if(value=='N'){return '<font color=\"green\">否</font>';}else return '<font color=\"blue\">是</font>';}},
			{header: '类型',dataIndex: 'type',width:100,renderer:function(value){if(value=='toolbar'){return '<font color=\"green\">工具条</font>';}else if(value=='rightMenu') return '<font color=\"blue\">树右键菜单</font>';else if(value=='all') return '<font color=\"red\">工具条及列表右键菜单</font>';}},
			{header: '排序',dataIndex: 'seqNo',width:50}
		]);
		cm.defaultSortable = true;
		//加载表单的按钮
		ActionConfig.ds = new Ext.data.Store({
			proxy : new Ext.data.HttpProxy({url:'FunAction!getActionList.action'}),
			reader: new Ext.data.JsonReader({totalProperty: 'totalProperty',root: 'root'},[
				{name: 'actionId'},
				{name: 'name'},
				{name: 'formName'},
				{name: 'callback'},
				{name: 'icon'},
				{name: 'key'},
				{name: 'description'},
				{name: 'isAuthorized'},
				{name: 'type'},
				{name: 'seqNo'}
			])
		});
		//加载分页插件
		ActionConfig.pageBar = new Ext.PagingToolbar({
			pageSize:10,
			store: ActionConfig.ds,
			displayInfo: true,
			displayMsg: '显示第{0}条到{1}条记录，一共{2}条',
			emptyMsg: '没有记录',
			plugins : [new Ext.ux.PageSizePlugin()]
		});
		ActionConfig.grid = new Ext.grid.GridPanel({
			title :'按钮',
			id: 'actionPanel',
			region: 'center',
			el: 'actionHtml',
			layout: 'fit',
			border: true,
			iconCls: 'icon294',
//			height: 400,
			tbar: new Ext.Toolbar([
				{text: '新增',iconCls: 'icon04',handler: ActionConfig.addAction},'-',
				{text: '修改',iconCls: 'icon122',handler: ActionConfig.editAction},'-',
				{text: '删除',iconCls: 'icon32',handler: ActionConfig.delAction}
			]),
			viewConfig: {
				forceFit: true,
				columnsText: '显示的列',
				scrollOffset: 16,
				sortAscText: '升序',
				sortDescText: '降序'
			},
			loadMask: new Ext.LoadMask(Ext.getDom('actionHtml'), {msg:"加载中..."}),
			autoScroll: false,
			stripeRows: true,
			ds: ActionConfig.ds,
			cm: cm,
			sm: sm,
			bbar: ActionConfig.pageBar
		});
//		ActionConfig.grid.render();//放到items中不要再渲染，不然会出现布局会出问题
		//为表单添加双击修改事件
		ActionConfig.grid.on('rowdblclick',ActionConfig.editAction);
		actionWin = new Ext.Window({
			title: '新建按钮',
			layout: 'fit',
			width: 660,
			height: 370,
			autoScroll: true,
			bodyStyle: {background: '#ffffff'},
			plain: false,
			modal: true,
			iconCls: 'icon231',
			closeAction: 'hide',
			contentEl: 'actionItem',
			buttons: [
				{
					text:'保存并新增下一个',
					iconCls: 'icon187',
					handler:function(){ActionConfig.saveAction();ActionConfig.addAction()}
				},{
					text:'保存并关闭',
					iconCls: 'icon153',
					handler:function(){ActionConfig.saveAction();}
				},{
					text:'取消',
					iconCls: 'icon163',
					handler:function(){actionWin.hide();}
				}
			]
		});
		actionWin.show();
		actionWin.hide();
		Ext.getDom("actionItem").style.display = "block";
	},
	clearIcon:function(){
		ActionConfig.actionIcon1.setValue('');
		ActionConfig.actionIcon2.setValue('');
	},
	setIcon:function(value){
		var active=ActionConfig.actionIcon1;
		if(value&&value.indexOf('button')!=-1){
			Ext.getDom('actionForm').ismall.checked=false;
			Ext.getDom('actionForm').ibig.checked=true;
			active=ActionConfig.actionIcon2;
		}
		else{
			Ext.getDom('actionForm').ismall.checked=true;
			Ext.getDom('actionForm').ibig.checked=false;
		}
		ActionConfig.onIconSizeChange();
		ActionConfig.clearIcon();
		active.setValue(value);
	},
	onIconSizeChange:function(){
		var c1=Ext.getDom('actionForm').ismall.checked;
		var c2=Ext.getDom('actionForm').ibig.checked;
		var active=ActionConfig.actionIcon1;
		var inactive=ActionConfig.actionIcon2;
		if(c2==true){
			active=ActionConfig.actionIcon2;
			inactive=ActionConfig.actionIcon1;
		}
		else if(c1!=true){
			Ext.getDom('actionForm').ismall.checked=true;
			Ext.getDom('actionForm').ibig.checked=false;
		}
		inactive.disable();
		inactive.hide();
		active.enable();
		active.show();
	},
	addAction : function(){
		if(FormTree.formId!=''){
			ActionConfig.isNewAction = true;
			ActionConfig.actionId = '';
			actionWin.buttons[0].show();
			Huateng.Util.Form.formClear("actionForm");
			actionWin.setTitle("新增按钮");
			actionWin.show();
			ActionConfig.setIcon('');
			Ext.getDom('actionForm').isAuthorized1.checked = true;
			Ext.getDom("actionForm").formName.value = FormTree.formName;
			Ext.getDom("actionForm").formId.value = FormTree.formId;
			Ext.getDom("actionForm").type1.checked = true;
		}else{
			Ext.MessageBox.alert(htTip,"请先选择表单，再添加");
			return;
		}
	},
	editAction : function(){
		ActionConfig.isNewAction = false;
		var allSelect = ActionConfig.grid.getSelectionModel().getSelections();
		var len = allSelect.length;
		if(len<1){
			Ext.MessageBox.alert(htTip,"请选择要修改的按钮");
			return ;
		}else if(len>1){
			Ext.MessageBox.alert(htTip,"请选择一项要修改的按钮")
		}else{
			actionWin.buttons[0].show();
			Huateng.Util.Form.formClear("actionForm");
			actionWin.setTitle("新增按钮");
			ActionConfig.actionId = allSelect[0].get("actionId");
			if(allSelect[0].get("name") != 'null')
				Ext.getDom("actionForm").actionName.value = allSelect[0].get("name")==null?'':allSelect[0].get("name");
			Ext.getDom("actionForm").formId.value = FormTree.formId;
			if(allSelect[0].get("formName") != 'null')
				Ext.getDom("actionForm").formName.value = allSelect[0].get("formName")==null?'':allSelect[0].get("formName");
			if(allSelect[0].get("callback") != 'null')
				Ext.getDom("actionForm").callback.value = allSelect[0].get("callback")==null?'':allSelect[0].get("callback");
			if(allSelect[0].get("description") != 'null')
				Ext.getDom("actionForm").desc.value = allSelect[0].get("description")==null?'':allSelect[0].get("description");
			if(allSelect[0].get("icon") != 'null')
				ActionConfig.setIcon(allSelect[0].get("icon"));
			else
				ActionConfig.setIcon('');
			if(allSelect[0].get("key") != 'null')
				Ext.getDom("actionForm").key.value = allSelect[0].get("key")==null?'':allSelect[0].get("key");
			if(allSelect[0].get("seqNo") != 'null')
				Ext.getDom("actionForm").seqNo.value = allSelect[0].get("seqNo")==null?'':allSelect[0].get("seqNo");
			if(allSelect[0].get("isAuthorized") != 'null'){
				if(allSelect[0].get("isAuthorized")=='Y'){
					Ext.getDom("actionForm").isAuthorized1.checked = true;
					Ext.getDom("actionForm").isAuthorized2.checked = false;
				}else{
					Ext.getDom("actionForm").isAuthorized1.checked = false;
					Ext.getDom("actionForm").isAuthorized2.checked = true;
				}
			}
			if(allSelect[0].get("type") != 'null'){
				if(allSelect[0].get("type")=='toolbar'){
					Ext.getDom("actionForm").type1.checked = true;
					Ext.getDom("actionForm").type2.checked = false;
					Ext.getDom("actionForm").type3.checked = false;
				}else if(allSelect[0].get("type")=='rightMenu'){
					Ext.getDom("actionForm").type1.checked = false;
					Ext.getDom("actionForm").type2.checked = true;
					Ext.getDom("actionForm").type3.checked = false;
				}else{
					Ext.getDom("actionForm").type1.checked = false;
					Ext.getDom("actionForm").type2.checked = false;
					Ext.getDom("actionForm").type3.checked = true;
				}
			}
			actionWin.show();
		}
	},
	delAction : function(){
		var allSelect = ActionConfig.grid.getSelectionModel().getSelections();
		var len = allSelect.length;
		if(len<1){
			Ext.MessageBox.alert(htTip,"请选择要删除的按钮！");
			return ;
		}
		var dataItems = '';
		for(var i=0;i<len;i++){
			dataItems += allSelect[i].get("actionId");
			if(i<len-1){
				dataItems += ",";
			}
		}
		Ext.MessageBox.confirm(htTip,'你确定要删除这些数据吗',function(btn){
			if(btn == 'yes'){
				Ext.Ajax.request({
					url : 'FunAction!delAction.action',
					method: 'post',
					success : function(response){
						if(Ext.getDom("saveInfo").checked){
							Ext.MessageBox.alert(htTip,"删除信息成功！");
							}
						ActionConfig.ds.load({params:{start:0,limit:ActionConfig.pageBar.pageSize}});
					},
					params: {actionId:dataItems}
				})
			}
		})
		
	},
	saveAction : function(){
		if(!Huateng.Util.Validator.formValidate("actionForm")){
			return ;
		}else{
			var params = '';
			if(ActionConfig.isNewAction){
				params = {actionId:'',name:Ext.getDom("actionForm").actionName.value,description:Ext.getDom("actionForm").desc.value}
			}else{
				params = {actionId: ActionConfig.actionId,name:Ext.getDom("actionForm").actionName.value,description:Ext.getDom("actionForm").desc.value}
			}
			Ext.Ajax.request({
					url: 'FunAction!addOrUpdata.action',
					method: 'post',
					success: function(response){
						if(Ext.getDom("saveInfo").checked){
							Ext.MessageBox.alert(htTip,"保存信息成功！");
						}
						ActionConfig.ds.load({params:{start:0,limit:ActionConfig.pageBar.pageSize}});
					},
					form: 'actionForm',
					params : params
			})
		}
		actionWin.hide();
	}
}