Ext.namespace("AppTree");
var AppTree = {
	//初始化布局
	tree: null,
	dictId: '',
	funId: '',
	name: '',
	value:'',
	leaf: '',
	htDict: '',
	loader: '',
	root: '',
	isNext: false,
	initApp : function(){
		Huateng.Util.Validator.defaultGetMsgName=function(el){
			return el.parentNode.previousSibling.innerHTML;
		};
		//创建字典树
		var baseAttrs={};
		AppTree.loader = new Ext.tree.TreeLoader({dataUrl:'AppAction!getAppTree.action',baseAttrs:baseAttrs});
		AppTree.root = new Ext.tree.AsyncTreeNode({
			id: '#',
			text: '子系统菜单',
			expanded: false,
			loader: AppTree.loader
		});

	    var ddAppendOnly=!HT_A.hasA('allowDD');
		var appTree = new Ext.tree.TreePanel({
			border: true,
			rootVisible: false,
			split: true,
			region: 'west',
			title: "子系统菜单",
			ddAppendOnly:ddAppendOnly,
			iconCls: htIcon,
			collapsible: true,
			autoScroll : true,
			width: 300,
			minSize: 300,
		    maxSize: 300,
			root: AppTree.root
		});
		this.tree = appTree;
		
		//创建工具区
		var fileItems=[];
		var editItems=[];
		if(HT_ACTIONS.hasAction('addAndEditApp'))fileItems.push({text: htTextFile,iconCls:'icon139',menu :{items:HT_A.getCfg('addAndEditApp')}});
	  	HT_A.addToArray(editItems,'deleteApp');
	  	if(HT_A.hasOA('deleteApp'))
	  		fileItems.push({text: htTextEdit, iconCls:'icon138',menu :editItems});
	  	
	  	//创建字典工具条
	  	var toolItems=[
			fileItems,
        	new Ext.form.Checkbox({
        		name: 'saveInfo',
        		id: 'saveInfo',
        		fieldLabel: '1',
    	   		boxLabel: htTextOperateSucTip,
    	   		checked: true
    	   	}),
			'->'
		];
		if(HT_ACTIONS.hasA('addAndEditApp')) toolItems.push(
			{id: 'buttonD',text: htTextSaveAndAdd,iconCls:'icon187',handler: this.saveNextApp},
			'-',
			{id: 'buttonE',text: htTextSave,iconCls:'icon153',handler: this.saveDirectApp}
			);
	  	var appBar = new Ext.Toolbar({
	  		height: 32,
	  		region: 'north',
	  		items:toolItems
	  		});
	  		
		//创建字典操作区
		var appMainPanel = new Ext.Panel({
			region: 'center',
			contentEl: 'appHtml',
			border: true
		});
		//创建布局
		var viewport = new Ext.Viewport({
			layout: 'border',
			items: [appTree,appBar,appMainPanel]
		});
		//为字典树添加点击事件
		appTree.on('click',function(nodeAttr){
			AppTree.getApp(nodeAttr);
		});
		//创建右键菜单
		var menuItems=[];
		HT_A.addToArray(menuItems,'addAndEditApp');
	  	HT_A.addToArray(menuItems,'deleteApp');
		var contextmenu=null;
		if(menuItems.length>0){
			contextmenu = new Ext.menu.Menu({
				items:menuItems
			});
		}
		//为字典树添加右键菜单
		appTree.on('contextmenu',function(nodeAttr,e){
			e.preventDefault();
			if(contextmenu)	contextmenu.showAt(e.getXY());
			this.fireEvent('click',nodeAttr);
		});
        Ext.getDom('appHtml').style.display = "block";
        
        //图标
		var icons=new Array(313);
		for(var i=0;i<icons.length;i++){
			if(i<9) icons[i]="icon0"+(i+1);
			else  icons[i]="icon"+(i+1);
		}
		var iconMenu=new Huateng.Util.IconMenu({
			icons:icons,
			width:230,
			height:145
 		});
		icons=null;
		AppTree.appIcon=new Huateng.Util.IconSelect({
    		renderTo: 'appIcon',
    		iconMenu:iconMenu,
    		name:'icon'
        });
        iconMenu=null;
	},
	//添加字典
	addApp : function(){
		Huateng.Util.Form.formClear("appForm");
		Ext.getDom("isActive1").checked=true;
		Ext.getDom("isActive2").checked=false;
		Ext.getDom("ismall").checked=true;
		Ext.getDom('name').focus(true);
	},
	//确定删除
	deleteMsg : function(){
		Ext.MessageBox.confirm(htTip,"确认删除",function(button,text){
			if(button=="yes"){
				Ext.Ajax.request({
					url: 'AppAction!delete.action',
					method: 'POST',
					success: function(response){
						if(Ext.getDom("saveInfo").checked)
							Ext.MessageBox.alert(htTip,htTipDelSuccess);
						Huateng.Util.Form.formClear("appForm");
					},
					params: {appId:AppTree.appId}
				});
				AppTree.getSelectNode().remove();
			}		
		});
	},
	//删除字典
	deleteApp : function() {
		//调用确定删除
		AppTree.deleteMsg();
	},
	//保存并新增下一个按钮
	saveNextApp : function(){
		AppTree.isNext = true;
		AppTree.saveApp();
	},
	//保存按钮
	saveDirectApp : function(){
		AppTree.isNext = false;
		AppTree.saveApp();
	},
	//保存方法
	saveApp : function(){
		if(!Huateng.Util.Validator.formValidate("appForm")){
		    return
		};
		var params = "";
		Ext.Ajax.request({
				url: 'AppAction!save.action',
				method: 'POST',
				success: function(response){
					if(Ext.getDom("saveInfo").checked)
						Ext.MessageBox.alert(htTip,htTipSaveSuccess);
					if(Ext.getDom('appId').value!=""){
						AppTree.getSelectNode().setText(Ext.getDom('name').value);
					}else{
						var json = eval("("+response.responseText+")");
						Huateng.Util.Form.formFill('appForm',json);
						var child = new Ext.tree.TreeNode({
							'id': json.appId,
							'text': json.name,
							'leaf': true,
							'sort': json.seqNo
						});
						AppTree.root.appendChild(child);
					}
					if(AppTree.isNext)
						AppTree.addApp();
				},
				form: 'appForm'
			});
		
	},
	//获取字典项
	getApp : function(nodeAttr){
		AppTree.appId = nodeAttr.id;
		//设定为修改
		Ext.Ajax.request({
				url: 'AppAction!getApp.action',
				method: 'POST',
				success: function(response){
					var json = response.responseText;
					json = eval("("+json+")");
					Huateng.Util.Form.formClear("appForm");
					Huateng.Util.Form.formFill('appForm',json);
					if(json.isActive){
						Ext.getDom("isActive1").checked=true;
						Ext.getDom("isActive2").checked=false;
					}else{
						Ext.getDom("isActive1").checked=false;
						Ext.getDom("isActive2").checked=true;
					}
					var modules = json.modules;
					var  mn=[],mv=[];
					for(var i=0;i<modules.length;i++){
						var module = modules[i];
						mv.push(module.moduleId);
						mn.push(module.name);
					}
					Ext.getDom("module").value=mn.join();
					Ext.getDom("moduleId").value=mv.join();
					AppTree.appIcon.setValue(json.icon);
				},
				params: {appId: nodeAttr.id}
			});
	},
	//取得选择点
	getSelectNode: function(){
		return AppTree.tree.getSelectionModel().getSelectedNode();	
	}
};
var selectModuleItem;	
function selectModule(){
	if(!selectModuleItem) selectModuleItem=new Huateng.Util.Select({
		selects:[{
			type:'tree',
			dataUrl:'ModuleAction!getModuleTree.action',
		  	isLeafOnly:true
		}],
		isSingle: false,
		dataItems:[],
		title: "选择模块",
		callback:function(data){
			var  mn=[],mv=[];
			for(var i=0;i<data.length;i++){
				var module = data[i];
				mv.push(module.id);
				mn.push(module.name);
			}
			Ext.getDom("appForm").moduleId.value=mv.join();
			Ext.getDom("appForm").module.value =mn.join();
		}
	});
	var mf=Ext.getDom('appForm');
	if(mf.moduleId.value!=''){	 
		var moduleIds = mf.moduleId.value.split(",");
		var modules = mf.module.value.split(",");
		var dataItem=[];
		for(var i=0;i<moduleIds.length;i++){
			dataItem.push({id:moduleIds[i],name:modules[i]});
		}
   		selectModuleItem.dataItems=dataItem;
   	}
	selectModuleItem.show();
}
