Ext.ns("Huateng", "Huateng.Sys", "Huateng.Util");   
Huateng.Sys.ChatTree = function(config){
	//通过Function类的call方法来改变Panel类的作用域为当前类的作用域
	//同时也把配置项也传递给Panel类，继承Ext.Panel类中的构建函数功能
	var d = Ext.apply({
		split: true,
		region: 'center',
		width: '100%',
		minSize: 200,
        maxSize: 200,
        defaults: {border: false},
        layoutConfig: {animate: true}},config||{});
        
    config = Ext.apply(d,{layout: 'accordion',collapsible: true});
	Huateng.Sys.ChatTree.superclass.constructor.call(this,config||{});
	for(var i=0;i<this.trees.length;i++){		
		this.add({
			id: 'panel_'+this.trees[i].getRootNode().id,
			title: this.trees[i].getRootNode().text,
			autoScroll: true,
			items: [this.trees[i]],
//			tools: [{id:'gear',qtip:'组内聊天',handler:function(event, toolEl, panel){
//					var treePanel = panel.items.get('tree_'+panel.id.substring(6));
//					var chatWin = Ext.get('client_'+treePanel.getRootNode().id);
//					if(!chatWin)
//						new  LawChat.ui.ChatWin(treePanel.getRootNode()).init('');
//					else
//						chatWin.show();
//				}}],
			iconCls:'icon58'
		});
	}
	this.addEvents('nodeClick');
	this.initTreeEvent();
}; 
//采用Ext.extend函数，把Panel类中所有的方法都继承到当前类来
Ext.extend(Huateng.Sys.ChatTree, Ext.Panel, {
	initTreeEvent : function() {
		if(!this.items) return;
		for (var i = 0;i < this.items.length; i++) {
			var p = this.items.itemAt(i);
			if (p)
				var t = p.items.itemAt(0);
			if(t)
			t.on( {
				'click' : function(node, event) {
					if (node && node.isLeaf()) {
						event.stopEvent();
						this.fireEvent('nodeClick', node.attributes);
					}
				},
				scope : this
			});
		}
	}
})