Ext.namespace('LawChat.ui');

LawChat.ui.ChatWin = function(_node){
	var node = _node;
	var win = Ext.getCmp('client_'+node.id);
	var newChatWin = function (){
		if (!win)
		{   
			win = new Ext.Window({
			title : chatTextAnd + node.text + chatTextChat,
			id : 'client_'+node.id,
			width : 520,
			height : 500,
			closeAction : 'close',
			collapsible : true,
			labelAlign : 'left',
			labelWidth : 60,
			hideLabel : false,
			maximizable : true,
			border : false,
			layout : 'border',
			frame : true,
//			tbar : chartTopTB,
			items : [{
						region : 'center',
						border : 0,
						height : 150,
						xtype : 'panel',
						id : 'showMsg_'+node.id,
						layout : 'fit',
						autoScroll : true,
						bodyStyle : 'padding:10px;'

					}, {
						region : 'south',
						minHeight : 150,
						split : true,
						xtype : 'form',
						border : false,
						hideLabels : true,
						bodyStyle : 'background:transparent;',
						height : 150,
						items : [{
							xtype : 'htmleditor',
							id : 'editMsg_'+node.id,
							fieldLabel : '',
							name : 'body',
							allowBlank : false,
							anchor : '0-50',
							frame: true,
							height :110,
    						autoHeight: false,
							autoScroll: true
						}],
						buttons : [{
									text : htTextSend,
									handler : sendMsg
								}, {
									text : htTextClose,
									handler : closeWin
								}]
					}]

			});
			win.show();
			win.hide();
		}	
		win.on('beforeclose',clearTemp);
		if(!chatWinss.isExists('client_'+node.id))
			{
				chatWinss.add('client_'+node.id,'client_'+node.id);
			}
}

		function sendMsg() {
			var message = Ext.get('editMsg_'+node.id).getValue();
			if(!message)
				message='<br/>';
			var toUserName = node.text;
			var fromUserName = user.name;
			// 将消息增加到消息显示框
			var sendDate = new Date().format('Y-m-d H:i:s');
			var showMsgPanel = Ext.getCmp('showMsg_'+node.id);
			var formatMsg = "<div class='_msgtitle' style='color:blue'>"
					+ fromUserName + " " + sendDate
					+ "</div><div class='_msg'>" + message + "</div>";
			showMsgPanel.body.insertHtml("beforeEnd", formatMsg);
			showMsgPanel.body.scroll('bottom', 9999);
			// 清空发送消息框
			Ext.getCmp('client_'+node.id).findById('editMsg_'+node.id).setValue('');
			// 发送消息至服务器端	
			Ext.Ajax.request({
					url: 'ChatAction!sendMsg.action', //获取分组
					method: 'POST',
					success: function(response){
						
					},
					failure : function(response) {
							   Ext.MessageBox.show({
					           title: htTip,
					           msg: htTipOperateFail,
					           buttons: Ext.MessageBox.OK
       		      		});
					},
					params : {					
					recevieId : node.id,
					content : encodeURIComponent(message),
					time : sendDate
				}
			});
		}
		function closeWin() {
			win.close();
		}
		var clearTemp = function(){
			chatWinss.remove(win.id);	
		} 
		// 显示接收数据
		function addMsg(msg) {
			if(msg)
			{   
				var showMsgPanel = Ext.getCmp('showMsg_'+node.id);
				var message = msg.message;
				var formatmsg = "<div class='_msgtitle' style='color:blue'>"
						+ node.text + "  " + msg.sendDate
						+ "</div><div class='_msg'>" + decodeURIComponent(message)
						+ "</div>";
				showMsgPanel.body.insertHtml(
						"beforeEnd", formatmsg);
				showMsgPanel.body.scroll("bottom",
						9999);
			}
		}
		return {
		/**
		 * @method init
		 * @public
		 * @description initializes the win
		 */
			init : function(msg) {
				if(!win&&msg)
					node.setIconCls("icon10_2");
				if (!win)
					newChatWin();
				if (msg==null){
					win.show();
					if(node.attributes.isOnline)
						node.setIconCls("icon10");
					else
						node.setIconCls("icon18");
						return;
				}
				addMsg(msg);
			}
		}
}