Ext.namespace("DeskItemPropertyConfig");
var DeskItemPropertyConfig = {
	propertyWin: '',
	ds : '',
	grid : '',
	pageBar : '',
	initProperty : function(){	
		var sm = new Ext.grid.CheckboxSelectionModel();
		var cm = new Ext.grid.ColumnModel({
			columns:[
				new Ext.grid.RowNumberer(),
				sm,
				{header: deskItemPropertyTextHeader1,dataIndex: 'deskItemPropertyId',width:200},
				{header: deskItemPropertyTextHeader2,dataIndex: 'header',width:200},
				{header: deskItemPropertyTextHeader3,dataIndex: 'dataIndex',width:100},
				{header: deskItemPropertyTextHeader4,dataIndex: 'width',width:100},
				{header: deskItemPropertyTextHeader5,dataIndex: 'dictId',width:100},
				{header: deskItemPropertyTextHeader6,dataIndex: 'seqNo',width:100}
			],
			defaultSortable: true
		});
		cm.defaultSortable = true;
		DeskItemPropertyConfig.ds = new Ext.data.Store({
			proxy : new Ext.data.HttpProxy({url:'DeskItemPropertyAction!getPropertyList.action'}),
			reader: new Ext.data.JsonReader({totalProperty: 'totalProperty',root: 'root'},[
				{name: 'deskItemPropertyId'},
				{name: 'header'},
				{name: 'dataIndex'},
				{name: 'width'},
				{name: 'dictId'},
				{name: 'seqNo'}
			])
		});
		//加载分页插件
		DeskItemPropertyConfig.pageBar = new Ext.PagingToolbar({
			pageSize:10,
			store: DeskItemPropertyConfig.ds,
			displayInfo: true,
			displayMsg: htTextDisplayMsg,
			emptyMsg: htTextEmptyMsg,
			plugins : [new Ext.ux.PageSizePlugin()]
		});
		DeskItemPropertyConfig.grid = new Ext.grid.GridPanel({
			region: 'center',
			el: 'propertyHtml',
			layout: 'fit',
			border: true,
//			height: 400,
			tbar: new Ext.Toolbar([
				{text: htTextAdd,iconCls: 'icon04',handler: DeskItemPropertyConfig.addProperty},'-',
				{text: htTextEdit,iconCls: 'icon122',handler: DeskItemPropertyConfig.editProperty},'-',
				{text: htTextDel,iconCls: 'icon32',handler: DeskItemPropertyConfig.delProperty}
			]),
//			viewConfig: {
//				forceFit: true,
//				columnsText: '显示的列',
//				scrollOffset: 16,
//				sortAscText: '升序',
//				sortDescText: '降序'
//			},
			loadMask: {msg:htTipMsg},
			autoScroll: false,
			stripeRows: true,
			ds: DeskItemPropertyConfig.ds,
			cm: cm,
			sm: sm,
			bbar: DeskItemPropertyConfig.pageBar
		});
		//为表单添加双击修改事件
		DeskItemPropertyConfig.grid.on('rowdblclick',DeskItemPropertyConfig.editProperty);
		propertyWin = new Ext.Window({
			title: htTextAdd+deskItemPropertyText,
			layout: 'fit',
			width: 600,
			height: 320,
			autoScroll: true,
			bodyStyle: {background: '#ffffff'},
			plain: false,
			modal: true,
			iconCls: 'icon231',
			closeAction: 'hide',
			contentEl: 'propertyItem',
			buttons: [
				{
					text:htTextSaveAndAdd,
					iconCls: 'icon187',
					handler:function(){DeskItemPropertyConfig.saveProperty();DeskItemPropertyConfig.addProperty()}
				},{
					text:htTextSaveAndClose,
					iconCls: 'icon153',
					handler:function(){DeskItemPropertyConfig.saveProperty();}
				},{
					text:htTextCancel,
					iconCls: 'icon163',
					handler:function(){propertyWin.hide();}
				}
			]
		});
		propertyWin.show();
		propertyWin.hide();
		Ext.getDom("propertyItem").style.display = "block";
	},
	addProperty : function(){
		if(DesktopItemTree.desktopItemId!=''){
			propertyWin.buttons[0].show();
			Huateng.Util.Form.formClear("propertyForm");
			propertyWin.setTitle(htTextAdd+deskItemPropertyText);
			propertyWin.show();
			document.getElementById("deskTopItemId").value = DesktopItemTree.desktopItemId;
			Ext.getDom("propertyItem").scrollTop=0;
		}else{
			Ext.MessageBox.alert(htTip,htTipSelectNode);
			return;
		}
	},
	editProperty : function(){
		var allSelect = DeskItemPropertyConfig.grid.getSelectionModel().getSelections();
		var len = allSelect.length;
		if(len<1){
			Ext.MessageBox.alert(htTip,htTipSelectEdit);
			return ;
		}else if(len>1){
			Ext.MessageBox.alert(htTip,htTipSelectOneEdit)
		}else{
			propertyWin.buttons[0].show();
			Huateng.Util.Form.formClear("propertyForm");
			propertyWin.setTitle(htTextEdit+deskItemPropertyText);
			Ext.Ajax.request({
					url : 'DeskItemPropertyAction!getProperty.action',
					method: 'post',
					success : function(response){
						var json = eval("("+response.responseText+")");
						Huateng.Util.Form.formFill("propertyForm",json);
						Ext.getDom("deskTopItemId").value = DesktopItemTree.desktopItemId;
					},
					params: {deskItemPropertyId:allSelect[0].get("deskItemPropertyId")}
			});
//			Ext.getDom("deskItemPropertyId").value = allSelect[0].get("deskItemPropertyId");
//			if(allSelect[0].get("header") != 'null')
//				Ext.getDom("header").value = allSelect[0].get("header")==null?'':allSelect[0].get("header");
//			if(allSelect[0].get("dataIndex") != 'null')
//				Ext.getDom("dataIndex").value = allSelect[0].get("dataIndex")==null?'':allSelect[0].get("dataIndex");
//			if(allSelect[0].get("width") != 'null')
//				Ext.getDom("width").value = allSelect[0].get("width")==null?'':allSelect[0].get("width");
//			if(allSelect[0].get("dictId") != 'null')
//				Ext.getDom("dictId").value = allSelect[0].get("dictId")==null?'':allSelect[0].get("dictId");
//			if(allSelect[0].get("seqNo") != 'null')
//				Ext.getDom("seqNo").value = allSelect[0].get("seqNo")==null?'':allSelect[0].get("seqNo");
			propertyWin.show();
		}
	},
	delProperty : function(){
		var allSelect = DeskItemPropertyConfig.grid.getSelectionModel().getSelections();
		var len = allSelect.length;
		if(len<1){
			Ext.MessageBox.alert(htTip,htTipSelectDelData);
			return ;
		}
		var dataItems = '';
		for(var i=0;i<len;i++){
			dataItems += allSelect[i].get("deskItemPropertyId");
			if(i<len-1){
				dataItems += ",";
			}
		}
		Ext.MessageBox.confirm(htTip,htTipSureDelData,function(btn){
			if(btn == 'yes'){
				Ext.Ajax.request({
					url : 'DeskItemPropertyAction!delProperty.action',
					method: 'post',
					success : function(response){
						if(Ext.getDom("saveInfo").checked){
							Ext.MessageBox.alert(htTip,htTipDelSuccess);
							}
						DeskItemPropertyConfig.ds.load({params:{start:0,limit:DeskItemPropertyConfig.pageBar.pageSize}});
					},
					params: {deskItemPropertyId:dataItems}
				})
			}
		})
		
	},
	saveProperty : function(){
		if(!Huateng.Util.Validator.formValidate("propertyForm")){
			return ;
		}else{
			Ext.Ajax.request({
					url: 'DeskItemPropertyAction!addOrUpdata.action',
					method: 'post',
					success: function(response){
						if(Ext.getDom("saveInfo").checked){
							Ext.MessageBox.alert(htTip,htTipSaveSuccess);
						}
						DeskItemPropertyConfig.ds.load({params:{start:0,limit:DeskItemPropertyConfig.pageBar.pageSize}});
					},
					form: 'propertyForm'
			})
		}
		propertyWin.hide();
	}
}