Ext.namespace("DesktopItemTree");
var DesktopItemTree = {
	contextMenu : '',
	loader: '',
	head: '',
	root: '',
	formMainPanel: '',
	deskName : '',
	desktopItemId: '',
	isNewForm : true,
	isLoader : true,
	tree: null,
	deskWin: '',
	actionIcon1: '',
	actionIcon2: '',
	initTree : function(){
		var icons=new Array(309);
		for(var i=0;i<icons.length;i++){
			if(i<9) icons[i]="icon0"+(i+1);
			else  icons[i]="icon"+(i+1);
		}
		var iconMenu1=new Huateng.Util.IconMenu({
			icons:icons,
			width:230,
			height:145
		});
		icons=null;
		DesktopItemTree.actionIcon1=new Huateng.Util.IconSelect({
			renderTo: 'actionIcon1',
			iconMenu:iconMenu1,
			name:'iconCls'
		});
		
		var icons=new Array(32);
		for(var i=0;i<icons.length;i++){
			if(i<9) icons[i]="button_icon0"+(i+1);
			else  icons[i]="button_icon"+(i+1);
		}
		var iconMenu2=new Huateng.Util.IconMenu({
			icons:icons,
			width:238,
			iconSize:[32,32],
			height:150,
			rows:3,
			cols:6
		});
		icons=null;
		DesktopItemTree.actionIcon2=new Huateng.Util.IconSelect({
			renderTo: 'actionIcon2',
			iconMenu:iconMenu2,
			iconSize:[32,32],
			disabled:true,
			hidden:true,
			name:'iconCls'
		});
		Ext.fly('ismall').on('click',DesktopItemTree.onIconSizeChange);
		Ext.fly('ibig').on('click',DesktopItemTree.onIconSizeChange);
		
		Huateng.Util.Validator.defaultGetMsgName=function(el){
			return el.parentNode.previousSibling.innerHTML;
		};
		//创建模块表单树
		DesktopItemTree.loader = new Ext.tree.TreeLoader({dataUrl:'DesktopItemAction!getDesktopItemList.action'});
		DesktopItemTree.root = new Ext.tree.AsyncTreeNode({
			id: '#',
			text: desktopText,
			expanded: true,
			loader: DesktopItemTree.loader
		});
		var deskTree = new Ext.tree.TreePanel({
			border: true,
			rootVisible: true,
			split: true,
			region: 'west',
			title: desktopText,
			iconCls: 'icon18',
			collapsible: true,
			autoScroll : true,
			width: 200,
			minSize: 200,
		    maxSize: 200,
		    root: DesktopItemTree.root
		});
		this.tree = deskTree;
		var buttonItems = [
			{text: htTextEdit+desktopText,iconCls: 'icon122',handler: DesktopItemTree.editDesk},'-',
			{text: htTextDel+desktopText,iconCls: 'icon32',handler: DesktopItemTree.delDesk}
		];
		//创建表单工具条
		var head = new Ext.Toolbar({
			region: 'north',
			border: false,
			height: 32,
			items: [
				{text: htTextFile,iconCls:'icon139',menu:{items:[{text: htTextAdd+desktopText,iconCls: 'icon04',handler:DesktopItemTree.addDesk}]}},'-',
				{text: htTextEdit,iconCls:'icon138',menu:{items: buttonItems}},'-',
				{text: htTextAdd+desktopText,iconCls: 'icon04',handler: DesktopItemTree.addDesk},'-',
	         	{text: htTextEdit+desktopText,iconCls: 'icon122',handler: DesktopItemTree.editDesk},'-',
	         	{text: htTextDel+desktopText,iconCls: 'icon32',handler: DesktopItemTree.delDesk},'-',
				new Ext.form.Checkbox({
					name: 'saveInfo',
					id:　'saveInfo',
					fieldLabel: '1',
					boxLabel: htTextOperateSucTip,
					checked: true
				})
			]
		});
		DesktopItemTree.head = head;
		//创建布局
		var formViewPort = new Ext.Viewport({
			layout: 'border',
			items: [head,deskTree,DeskItemPropertyConfig.grid]
		});
		//初始化窗口
		deskWin = new Ext.Window({
			title: htTextAdd+desktopText,
			layout: 'fit',
			width: 600,
	        height: 350,
	  		autoScroll: true,
	  		bodyStyle: {background: '#ffffff'}, 
	        plain: false,
	  		modal: true,
	  		iconCls: 'icon248',
	  		closeAction: 'hide',
	  		contentEl: 'desktopItemHtml',
	  		 buttons: [
	        	{
	            	text: htTextSaveAndAdd,
	            	iconCls: 'icon187',
	            	handler: function(){DesktopItemTree.saveDesk();deskWin.show();DesktopItemTree.addDesk();}
	        	},{
	            	text: htTextSaveAndClose,
	            	iconCls: 'icon153',
	            	handler: function(){DesktopItemTree.saveDesk();}
	        	},{
	            	text: htTextCancel,
	            	iconCls: 'icon163',
	            	handler: function(){deskWin.hide();}
	    	}]
		});
		deskWin.show();
		deskWin.hide();
		Ext.get("desktopItemHtml").dom.style.display = 'block';
		//默认选中节点
		deskTree.on('load',function(node){
			this.fireEvent('click',this.root);
		})
		//为表单模块树添加点击事件
		deskTree.on('click',function(nodeAttr){
			DesktopItemTree.getDesk(nodeAttr);
			DesktopItemTree.isLoader = true;
		})
		//创建右键菜单
		DesktopItemTree.contextMenu = new Ext.menu.Menu({
			id: 'menu',
			items:[{
				text: htTextAdd+desktopText,
				id:'add',
				iconCls: 'icon04',
				handler: DesktopItemTree.addDesk
			},{
				text: htTextEdit+desktopText,
				id: 'edit',
				iconCls: 'icon122',
				handler: DesktopItemTree.editDesk
			},{
				text: htTextDel+desktopText,
				id: 'del',
				iconCls: 'icon32',
				handler: DesktopItemTree.delDesk
			}]
		})
		//为表单模块树添加右击事件
		deskTree.on('contextMenu',function(nodeAttr,e){
			e.preventDefault();
			DesktopItemTree.contextMenu.showAt(e.getXY());
			nodeAttr.select();
			DesktopItemTree.isLoader = false;
			DesktopItemTree.getDesk(nodeAttr);
		})
	},
	clearIcon:function(){
		DesktopItemTree.actionIcon1.setValue('');
		DesktopItemTree.actionIcon2.setValue('');
	},
	setIcon:function(value){
		var active=DesktopItemTree.actionIcon1;
		if(value&&value.indexOf('button')!=-1){
			Ext.getDom('ismall').checked=false;
			Ext.getDom('ibig').checked=true;
			active=DesktopItemTree.actionIcon2;
		}
		else{
			Ext.getDom('ismall').checked=true;
			Ext.getDom('ibig').checked=false;
		}
		DesktopItemTree.onIconSizeChange();
		DesktopItemTree.clearIcon();
		active.setValue(value);
	},
	onIconSizeChange:function(){
		var c1=Ext.getDom('ismall').checked;
		var c2=Ext.getDom('ibig').checked;
		var active=DesktopItemTree.actionIcon1;
		var inactive=DesktopItemTree.actionIcon2;
		if(c2==true){
			active=DesktopItemTree.actionIcon2;
			inactive=DesktopItemTree.actionIcon1;
		}
		else if(c1!=true){
			Ext.getDom('ismall').checked=true;
			Ext.getDom('ibig').checked=false;
		}
		inactive.disable();
		inactive.hide();
		active.enable();
		active.show();
	},
	addDesk : function(){
		deskWin.setTitle(htTextAdd+desktopText);
		deskWin.buttons[0].show();
		Huateng.Util.Form.formClear("desktopItemForm");
		DesktopItemTree.setIcon('');
		Ext.getDom('desktopItemForm').isActive1.checked = true;
		deskWin.show();
		Ext.getDom("desktopItemHtml").scrollTop=0;
	},
	editDesk : function(){
		deskWin.buttons[0].hide();
		deskWin.setTitle(htTextEdit+desktopText);
		Ext.Ajax.request({
			url: 'DesktopItemAction!getDesk.action',
			method: 'post',
			success: function(response){
				var json = eval("("+response.responseText+")");
				Huateng.Util.Form.formFill("desktopItemForm",json);
				if(json.iconCls != 'null')
					DesktopItemTree.setIcon(json.iconCls);
				else
					DesktopItemTree.setIcon('');
				
				deskWin.show();
				Ext.getDom("desktopItemHtml").scrollTop=0;
			},
			params: {deskTopItemId:DesktopItemTree.desktopItemId}
		})
	},
	saveDesk : function(){
		if(!Huateng.Util.Validator.formValidate("desktopItemForm")){
			return ;
		}
		Ext.Ajax.request({
			url: 'DesktopItemAction!addOrUpdata.action',
			method: 'post',
			success: function(response){
				if(Ext.getDom("saveInfo").checked){
					Ext.MessageBox.alert(htTip,htTipSaveSuccess);
				}
				if(Ext.getDom('desktopItemForm').deskTopItemId.value==''){
					var json = eval("("+response.responseText+")")
					var child = new Ext.tree.TreeNode({
						'id': json.deskTopItemId,
						'text': json.title,
						'leaf': true
					})
					if(DesktopItemTree.getSelectNode()){
						DesktopItemTree.getSelectNode().appendChild(child);
						DesktopItemTree.getSelectNode().expand();
					}
				}else{
					DesktopItemTree.getSelectNode().setText(Ext.getDom("desktopItemForm").title.value);
				}
			},
			form: 'desktopItemForm'
		})
		deskWin.hide();
	},
	delDesk : function(){
		if(DesktopItemTree.desktopItemId==''||DesktopItemTree.desktopItemId==null){
			Ext.MessageBox.alert(htTip,htTipSelectDelData);
			return ;
		}else{
			Ext.MessageBox.confirm(htTip,htTipOperUnrecoverable,function(button,text){
				if(button=="yes"){
					Ext.Ajax.request({
						url: 'DesktopItemAction!delDesk.action',
						method: 'post',
						success: function(response){
							if(Ext.getDom("saveInfo").checked){
								Ext.MessageBox.alert(htTip,htTipDelSuccess);
							}
							DeskItemPropertyConfig.ds.load();
							DesktopItemTree.desktopItemId='';
							DesktopItemTree.getSelectNode().remove();
						},
						params: {deskTopItemId:DesktopItemTree.desktopItemId}
					})
				}
			})
		}
	},
	//初始化桌面项
	getDesk : function(nodeAttr){
		if(!nodeAttr.leaf){
			//根
			DesktopItemTree.desktopItemId = '';
			DesktopItemTree.deskName = '';
			DesktopItemTree.contextMenu.items.get('add').enable();
			DesktopItemTree.contextMenu.items.get('edit').disable();
			DesktopItemTree.contextMenu.items.get('del').disable();
			DesktopItemTree.head.items.itemAt(0).enable();
			DesktopItemTree.head.items.itemAt(2).disable();
			DesktopItemTree.head.items.itemAt(4).enable();
			DesktopItemTree.head.items.itemAt(6).disable();
			DesktopItemTree.head.items.itemAt(8).disable();
			return ;
		}else{
			DesktopItemTree.deskName = nodeAttr.text;
			DesktopItemTree.desktopItemId = nodeAttr.id;
			DesktopItemTree.contextMenu.items.get('add').disable();
			DesktopItemTree.contextMenu.items.get('edit').enable();
			DesktopItemTree.contextMenu.items.get('del').enable();
			DesktopItemTree.head.items.itemAt(0).disable();
			DesktopItemTree.head.items.itemAt(2).enable();
			DesktopItemTree.head.items.itemAt(4).disable();
			DesktopItemTree.head.items.itemAt(6).enable();
			DesktopItemTree.head.items.itemAt(8).enable();
		}
		DeskItemPropertyConfig.pageBar.store.baseParams = {deskTopItemId:nodeAttr.id};
		if(DesktopItemTree.isLoader){
			DeskItemPropertyConfig.ds.load({url:'DeskItemPropertyAction!getPropertyList.action',params:{start:0,limit:DeskItemPropertyConfig.pageBar.pageSize}})
		}
	},
	//取得选择点
	getSelectNode: function(){
		return DesktopItemTree.tree.getSelectionModel().getSelectedNode();	
	}

}
var selectFormItem;	
function selectForm(){
	if(!selectFormItem) selectFormItem=new Huateng.Util.Select({
		selects:[{
			type:'tree',
			dataUrl:'FormAction!getFormList.action',
		  	isLeafOnly:true
		}],
		isSingle: true,
		dataItems:[],
		title: "选择表单",
		callback:function(data){
			Ext.getDom("desktopItemForm").formId.value = '';
			for(var i=0;i<data.length;i++){
				var form = data[i];
				Ext.getDom("desktopItemForm").formId.value += form.id;
			}
		}
	});
	
//	selectFormItem.dataItems = UserConfig.data;
	selectFormItem.show();
}