Ext.namespace("DictTree");
var DictTree = {
	//初始化布局
	tree: null,
	dictId: '',
	funId: '',
	name: '',
	value:'',
	leaf: '',
	htDict: '',
	loader: '',
	root: '',
	isNext: '',
	isNewDict: false,
	initDict : function(){
		Huateng.Util.Validator.defaultGetMsgName=function(el){
			return el.parentNode.previousSibling.innerHTML;
		};
		//创建字典树
		var baseAttrs={};
		baseAttrs.allowChildren=HT_A.hasA('allowChildren');
		DictTree.loader = new Ext.tree.TreeLoader({dataUrl:'DictAction!getDictList.action',baseAttrs:baseAttrs});
		DictTree.root = new Ext.tree.AsyncTreeNode({
			id: '#',
			text: dictText,
			expanded: false,
			loader: DictTree.loader
		});
		var dictTreeBar =  new Ext.Toolbar({
	    	height: 25,
	    	items:[
	    		new Ext.form.TextField({
	        		name: 'filter',
	        		width: 220,
	        		id: 'dictSearch'
        	   	}),'-',{
                iconCls: 'icon-expand-all',
				tooltip: htTextAllExpand,
                handler: function(){ this.root.expand(true); },
                scope: this
	            }, '-', {
	                iconCls: 'icon-collapse-all',
	                tooltip: htTextAllCollapse,
	                handler: function(){ this.root.collapse(true); },
	                scope: this
	            }
	    	]
	    });

	    var ddAppendOnly=!HT_A.hasA('allowDD');
	    var enableDD=HT_A.hasA('allowChildren','allowDD');   
		var dictTree = new Ext.tree.TreePanel({
			border: true,
			rootVisible: false,
			split: true,
			region: 'west',
			title: dictTextPT,
			enableDD: enableDD,
			ddAppendOnly:ddAppendOnly,
			iconCls: htIcon,
			collapsible: true,
			autoScroll : true,
			width: 300,
			minSize: 300,
		    maxSize: 300,
		    tbar: dictTreeBar,
			root: DictTree.root
		});
		this.tree = dictTree;
		
		//创建工具区
		var fileItems=[];
		var editItems=[];
		if(HT_ACTIONS.hasAction('addAndEditDict'))fileItems.push({text: htTextFile,iconCls:'icon139',menu :{items:HT_A.getCfg('addAndEditDict')}});
	  	HT_A.addToArray(editItems,'renameDict');
	  	if(HT_A.hasA('renameDict','deleteDict')) editItems.push('-');
	  	HT_A.addToArray(editItems,'deleteDict');
	  	if(HT_A.hasOA('renameDict','deleteDict'))
	  		fileItems.push({text: htTextEdit, iconCls:'icon138',menu :editItems});
	  	
	  	//创建字典工具条
	  	var toolItems=[
			fileItems,
        	{text: htTextView,iconCls: 'icon137',menu :{items: [
        		{text: htTextExpand,id:"deptExpand",iconCls:'icon-expand-all',handler: DictTree.dictExpand},
        		{text: htTextCollapse,id:"deptCollapse",iconCls:'icon-collapse-all',handler: DictTree.dictCollapse},
        		{text: htTextAllExpand,id:"deptExpandAll",iconCls:'icon-expand-all',handler: DictTree.dictExpandAll},
        		{text: htTextAllCollapse,id:"deptCollapseAll",iconCls:'icon-collapse-all',handler: DictTree.dictCollapseAll}
        	]}},'-',
        	new Ext.form.Checkbox({
        		name: 'saveInfo',
        		id: 'saveInfo',
        		fieldLabel: '1',
    	   		boxLabel: htTextOperateSucTip,
    	   		checked: true
    	   	}),
			'->'
		];
		if(HT_ACTIONS.hasA('addAndEditDict')) toolItems.push(
			{id: 'buttonD',text: htTextSaveAndAdd,iconCls:'icon187',handler: this.saveNextDict},
			'-',
			{id: 'buttonE',text: htTextSave,iconCls:'icon153',handler: this.saveDirectDict}
			);
	  	var dictBar = new Ext.Toolbar({
	  		height: 32,
	  		region: 'north',
	  		items:toolItems
	  		});
	  		
		//创建字典操作区
		var dictMainPanel = new Ext.Panel({
			region: 'center',
			contentEl: 'dictHtml',
			border: true
		});
		//创建布局
		var dictViewport = new Ext.Viewport({
			layout: 'border',
			items: [dictTree,dictBar,dictMainPanel]
		});
		//为字典树添加点击事件
		dictTree.on('click',function(nodeAttr){
			DictTree.getDict(nodeAttr);
		});
		//为字典树添加拖拽事件
		dictTree.on("nodedrop",function(e){
		});
		dictTree.on("movenode",function(tree,node,oldP,newP,index){
			//console.dir(node.attributes);
			if(!node.isLast()){
		   	  var nnode=node.nextSibling;
		   	  node.attributes.seqNo=nnode.attributes.seqNo;
		   	  nnode.attributes.seqNo++;
		   	  while(nnode=nnode.nextSibling){
		   	  		nnode.attributes.seqNo++;
		   	  }
		  	}
		   	else{
		   	 node.attributes.seqNo=node.previousSibling.attributes.seqNo+1;
		   	}
		   	var params={dictId:node.id,seqNo:node.attributes.seqNo};
		  	if(oldP!=newP) params.funId=newP.id;
		  	Ext.Ajax.request({
			   	url:'DictAction!updateDictOrder.action',
			   	params:params,
			   	success:function(){
			   	}
			});
		});
		//创建右键菜单
		var menuItems=[];
		HT_A.addToArray(menuItems,'addAndEditDict');
	  	HT_A.addToArray(menuItems,'renameDict');
	  	if(HT_A.hasA('renameDict','deleteDict')) menuItems.push('-');
	  	HT_A.addToArray(menuItems,'deleteDict');
		var contextmenu=null;
		if(menuItems.length>0){
			contextmenu = new Ext.menu.Menu({
				items:menuItems
			});
		}
		//为字典树添加右键菜单
		dictTree.on('contextmenu',function(nodeAttr,e){
			e.preventDefault();
			if(contextmenu)	contextmenu.showAt(e.getXY());
			//nodeAttr.select();
			this.fireEvent('click',nodeAttr);
		});
        //设置默认选中节点
        dictTree.on('load', function(node){   
    		var fnode = node.firstChild;
    		if(node.id == '#'){
    			dictTree.selectPath("/"+DictTree.root.id+"/"+fnode.id);
    			this.fireEvent('click',fnode);
    			DictTree.dictExpand();
    		}
        });
        Ext.getDom('dictHtml').style.display = "block";
        //为字典树添加过滤器
		var filter = new Ext.tree.TreeFilter(dictTree, {
	        clearBlank: true,
	        autoClear: true
	    });
	
	    // 保存上次隐藏的空节点
	    var hiddenPkgs = [];
	    var field = Ext.get('dictSearch');
	
	    // 按键后触发事件
	    field.on('keyup', function(e) {
	        var text = field.dom.value;
			console.dir(text);
	        // 先要显示上次隐藏掉的节点
	        Ext.each(hiddenPkgs, function(n){
	            n.ui.show();
	        });
	
	        // 如果输入的数据不存在，就执行clear()
	        if(!text){
	            filter.clear();
	            return;
	        }
	        dictTree.expandAll();
	
	        // 根据输入制作一个正则表达式，'i'代表不区分大小写
	        var re = new RegExp(Ext.escapeRe(text), 'i');
	        filter.filterBy(function(n){
	            // 只过滤叶子节点，这样省去枝干被过滤的时候，底下的叶子都无法显示
	            return !n.isLeaf() || re.test(n.text);
	        });
	
	        // 如果这个节点不是叶子，而且下面没有子节点，就应该隐藏掉
	        hiddenPkgs = [];
	        dictTree.root.cascade(function(n) {
	            if(!n.isLeaf() && n.ui.ctNode.offsetHeight < 3){
	                n.ui.hide();
	                hiddenPkgs.push(n);
	            }
	            if(n.id!='#'){
		        	if(!n.isLeaf() && n.ui.ctNode.offsetHeight >= 3 && hasChild(n,re)==false){
                    	n.ui.hide();
                    	hiddenPkgs.push(n);
		            } 
		        }
	        });
	    });
	    function hasChild(n,re){ 
		    var str=false;
		    n.cascade(function(n1){
		    	if(n1.isLeaf() && re.test(n1.text)){
                	str=true;
                	return;
		        }
		    });
		    return str;
		}
	},
	//添加字典
	addDict : function(){
		Ext.getDom('name').value = "";
		Ext.getDom('value').value = "";
		Ext.getDom('dictId').value = "";
		Ext.getDom('name').focus(true);
		DictTree.isNewDict = true;
		DictTree.funId = DictTree.dictId;
	},
	//确定删除
	deleteMsg : function(){
		var deleteMesage = htTipDelCascade;
		if(DictTree.leaf){
			deleteMesage = htTipOperUnrecoverable;
		}
		Ext.MessageBox.confirm(htTip,deleteMesage,function(button,text){
			if(button=="yes"){
				Ext.Ajax.request({
					url: 'DictAction!deleteDict.action',
					method: 'POST',
					success: function(response){
						if(Ext.getDom("saveInfo").checked)
							Ext.MessageBox.alert(htTip,htTipDelSuccess);
						Huateng.Util.Form.formClear("dictForm");
					},
					params: {dictId:DictTree.dictId}
				});
				DictTree.getSelectNode().remove();
			}		
		});
	},
	//删除字典
	deleteDict : function() {
		if(DictTree.dictId == ""){
			Ext.MessageBox.alert(htTip,htTipSelectDetNode);
			return;
		}
		if(DictTree.htDict == "#"){
			Ext.MessageBox.alert(htTip,dictTipRootUndel);
			return ;	
		}
		//调用确定删除
		DictTree.deleteMsg();
	},
	//保存并新增下一个按钮
	saveNextDict : function(){
		DictTree.isNext = true;
		DictTree.saveDict();
	},
	//保存按钮
	saveDirectDict : function(){
		DictTree.isNext = false;
		DictTree.saveDict();
	},
	//保存方法
	saveDict : function(){
		if(DictTree.funId == ""){
			Ext.MessageBox.alert(htTip,htTipSelectRoot);
			return;
		}
		if(!Huateng.Util.Validator.formValidate("dictForm")){
		    return
		};
		var params = "";
		var isUpdate = false;
		var name = Ext.getDom("name").value;
		if(DictTree.isNewDict){
			params = {'funId': DictTree.dictId,'dictId': '','seqNo': '0'};
			isUpdate = false;
		}else{
			params = {'funId': DictTree.funId,'dictId': DictTree.dictId,'seqNo': '0'};
			isUpdate = true;
		}
		Ext.Ajax.request({
						url:'DictAction!verifyvalue.action',
						method: 'post',
						success: function(response){
							if(response.responseText=="false"){
								Ext.MessageBox.alert(htTip,dictTipValueSame);
								return;
							}
							Ext.Ajax.request({
									url: 'DictAction!updateOrSaveDict.action',
									method: 'POST',
									success: function(response){
										if(Ext.getDom("saveInfo").checked)
											Ext.MessageBox.alert(htTip,htTipSaveSuccess);
										if(isUpdate){
											DictTree.getSelectNode().setText(name);
										}else{
											var json = eval("("+response.responseText+")");
											Huateng.Util.Form.formFill('dictForm',json);
											var child = new Ext.tree.TreeNode({
												'id': json.dictId,
												'text': json.name,
												'leaf': true,
												'sort': json.seqNo,
												'funId': json.funId
											});
											DictTree.getSelectNode().leaf = false;
											DictTree.getSelectNode().appendChild(child);
											DictTree.getSelectNode().expand();
										}
										if(DictTree.isNext){
											DictTree.addDict();
										}
									},
									form: 'dictForm',
									params: params
								});
						},
						params:{dictId:DictTree.dictId,funId:DictTree.funId,value:Ext.getDom("value").value,isNewDict:DictTree.isNewDict}
					})
		
	},
	//刷新字典树(这个操作会刷新整个字典，体验不好，已用其他方法替代，
	reloadTree : function() {
		DictTree.loader.load(DictTree.root);
		DictTree.root.expand();
	},
	//获取字典项
	getDict : function(nodeAttr){
		//设定为修改
		DictTree.isNewDict = false;
		Ext.Ajax.request({
				url: 'DictAction!getDict.action',
				method: 'POST',
				success: function(response){
					var json = response.responseText;
					json = eval("("+json+")");
					Huateng.Util.Form.formFill('dictForm',json);
					DictTree.dictId = json.dictId;
					DictTree.funId = json.funId;
					DictTree.name = json.name;
					DictTree.value = json.value;
					DictTree.leaf = nodeAttr.leaf;
					if(json.funId == "#"){
						DictTree.htDict = "#";
					}else{ 
						DictTree.htDict = "";
					}
				},
				params: {dictId: nodeAttr.id}
			});
	},
	//取得选择点
	getSelectNode: function(){
		return DictTree.tree.getSelectionModel().getSelectedNode();	
	},
	//单个展开
	dictExpand: function(){
		DictTree.getSelectNode().expand();
	},
	//全部展开
	dictExpandAll: function(){
		DictTree.getSelectNode().expand(true);
	},
	//单个收缩
	dictCollapse: function(){
		DictTree.getSelectNode().collapse();
	},
	//全部收缩
	dictCollapseAll: function(){
		DictTree.getSelectNode().collapse(true);
	},
	//重命名
	dictRename: function(){
		Ext.Msg.prompt(htTip,htTipOldName+DictTree.name+htTipNewNameWrite,function(id,msg){
		 	if (id=="ok"){
		 		if (msg==""){
		 			Ext.Msg.alert(htTip,dictTipNameUnnull);
		 			return;
		 		}
		 		DictTree.name = msg;
				Ext.Ajax.request({
					url: 'DictAction!renameDict.action',
					method: 'POST',
					success: function(response){
						Ext.getDom('name').value = DictTree.name;
						if(Ext.getDom("saveInfo").checked)
							Ext.MessageBox.alert(htTip,htTipSaveSuccess);
					},
					params: {name: DictTree.name,value: DictTree.value,funId: DictTree.funId,dictId: DictTree.dictId,seqNo: '0'}
				});
				DictTree.getSelectNode().setText(msg);
			}
		},this);
	}
};

