Ext.namespace("DesignConfig");
var testProcess = '<?xml version="1.0"?>'
			+'<process name="借款流程" description="借款流程" xmlns="http://jbpm.org/4.4/jpdl">'
			+'<swimlane name="测试" candidate-users="402881852fd8e5f9012fd8fa94310003" users="wind" candidate-groups="40288185303e86d801303ec30578004f" roles="基础模块" candidate-roles="40288185303e86d801303ec30578004f" />'
			+'<swimlane name="测试1" candidate-users="402881b22da7dea9012da7e323cc0002" users="chen"/>'
			+'<start name="流程开始" g="478,3,110,50">'
				+'<transition name="借款发起" to="填写借款申请" g="499,65"/>'
			+'</start>'
			+'<task name="填写借款申请" candidate-users="402881852fd8e5f9012fd8fa94310003" users="wind" g="479,127,110,50">'
				+'<on event="start">'
					+'<event-listener name="测试邮件发送" type="mailto" class="com.huateng.jbpm.listener.MailListener">'
						+'<field name="mail_user">'
							+'<string value="402881852fd8e5f9012fd8fa94310003" name="wind" />'
						+'</field>'
					+'</event-listener>'
					+'<event-listener name="测试消息发送" type="notice" class="com.huateng.sys.jbpm.listener.NoticeListener">'
						+'<field name="notice_role">'
							+'<string value="40288185303e86d801303ec30578004f" name="基础模块" />'
						+'</field>'
					+'</event-listener>'
					+'<event-listener name="测试SQL脚本" type="sql" class="com.huateng.sys.jbpm.listener.SqlListener">'
						+'<field name="sql_script">'
							+'<string value="select * from TB_USER" />'
						+'</field>'
						+'<field name="sql_var">'
							+'<string value="userList" name="query" />'
						+'</field>'
					+'</event-listener>'
				+'</on>'
				+'<transition name="提交申请" to="部门经理审批" g="498,185"/>'
			+'</task>'
			+'<task name="部门经理审批" g="477,243,110,50" candidate-users="402881b22da7dea9012da7e323cc0002" users="chen" swimlane="测试">'
				+'<transition name="部门经理审批通过" to="金额判断" g="313,243"/>'
				+'<transition name="部门经理驳回" to="流程结束2" g="657,311"/>'
			+'</task>'
			+'<task name="总经理审批" g="108,374,110,50" swimlane="测试">'
				+'<transition name="总经理审批通过" to="财务拨款" g="314,376"/>'
			+'</task>'
			+'<task name="财务拨款" candidate-depts="402881852b9e2de1012b9e2e217b0001" depts="华腾平台" candidate-roles="402881932ca1da2e012ca249d8220008" roles="system" candidate-groups="402881932ca1da2e012ca249d8220008,402881852b9e2de1012b9e2e217b0001" g="480,378,110,50">'
				+'<transition name="邮件通知" to="流程结束2" g="655,379"/>'
			+'</task>'
			+'<decision name="金额判断" g="108,242,110,50">'
				+'<transition name="&gt;5000总经理审批" to="总经理审批" g="128,308"/>'
				+'<transition name="&lt;=5000财务拨款" to="财务拨款" g="314,310"/>'
			+'</decision>'
			+'<end name="流程结束2" g="789,380,110,50"/>'
			+'</process>';
var DesignConfig = {
		//初始化布局
		init : function(){		
		//全局变量
		currentBtn = "select";
		currentParam = "base";
		//--- 图形化设计 ---
		lineFlag = false;
		dragable = true;
		eventsrc = null;//eventsrc是当前触发事件的对象（节点对象）
		presrc = null; //前一个选中的对象
		xmlNode = null;//当前选中的XML节点
		x = 0,y = 0;  
		popeventsource = "";
		temp1 = 0;
		temp2 = 0;
		//--- 画线 ---
		//连线的源和目标
		srcRect=null,desRect=null;
		x0=0,x1=0,y0=0,y1=0;   //连线的头尾坐标
		fontX=0,fontY=0;	   //文字的坐标
		xml = null;//xml对象
		//各个节点所拥有的属性
		nodeParams = {
			base:["base"],//文本节点
			mail:["base","mailto"],//mail节点
			process:["base","swimlane","sql","notice","mailto"],//流程定义
			start:["base","sql","notice","mailto"],//start、end节点
			sign:["base","mailto","notice","signDelegate","method"],//会签节点
			task:["base","sql","notice","mailto","change","delegate","form"],//任务节点
			transition:["base","sql","notice","mailto","autoDelegate","case"]//transition
		}
		//虚线
		dashLine = null;
		//显示xml窗口
		xmlWin = null;
		designWin = null;
		var elePanel = new Ext.Panel({
			title: '工具栏',
			region: 'west',	
			iconCls: 'picon05',
			width: 150,
			split: true,
			minSize: 150,
			maxSize: 150,
			contentEl: 'west',
			collapsible: false,
			collapseFirst: false,
			tools:[{
				id: 'minimize',
				title: '最小化',
				handler: function(){
					elePanel.setTitle("");
					Ext.DomQuery.select(".picon05")[0].style.display = "none";
					elePanel.setWidth(32);
					this.hide();
					elePanel.getTool('maximize').show();
					designWin.doLayout();
				}
			},{
				id: 'maximize',
				qtip: '最大化',
				hidden: true,
				handler: function(){
					elePanel.setWidth(150);
					Ext.DomQuery.select(".picon05")[0].style.display = "inline";
					elePanel.setTitle("工具栏");
					this.hide();
					elePanel.getTool('minimize').show();
					designWin.doLayout();
				}
			}]		
		});
		var mainPanel = new Ext.Panel({
			region: 'center',
			autoScroll: true,
			contentEl: 'center',
			tbar: new Ext.Toolbar({
				height: 31,
				border: false,
				items: [
					{text: '&nbsp;新建流程【N】',iconCls: 'picon17',handler: this.newProcess},'-',
					{text: '&nbsp;导入流程【I】',iconCls: 'picon15',handler: function(){
						XmlToProcess(testProcess);
					}},'-',
					{text: '&nbsp;导出流程【O】',iconCls: 'picon16',handler: ''},'-',
					{text: '&nbsp;栅格【G】',iconCls: 'picon21',handler: function(){
						if(Ext.fly(Ext.getDom("center").parentNode).hasClass("center"))
							Ext.fly(Ext.getDom("center").parentNode).removeClass("center");
						else
							Ext.fly(Ext.getDom("center").parentNode).addClass("center");
					}},'-',
					{text: '&nbsp;查看XML【X】',iconCls: 'picon18',handler: showXml},'->',
					{text: '&nbsp;发布流程',iconCls: 'picon20',handler: ''},'-',
					{text: '&nbsp;保存流程',iconCls: 'picon19',handler: flowManage.saveFlow},
					{text: '&nbsp;退出',iconCls: 'icon36',handler: this.winHide}
				]
			})
		});
		var keyPanel = new Ext.Panel({
			x: 0,
			y: 0,
			layout: 'fit',
			border: false,
			anchor: '0 100%',
			contentEl: 'south_key'
		});
		var valuePanel = new Ext.Panel({
			border: false,
			layout: 'card',
			id: 'paramCard',
			activeItem: 0,
			x: 155,
			y:0,
			anchor: '0 100%',
			items: new Ext.form.FormPanel({
				id: 'base',
				border: false,
				bodyStyle: {background:"#dfe7f4",padding:"10 0 0 20"},
				labelAlign: 'left',
				labelWidth: 80,
				defaults: {width: '85%'},
				defaultType: 'textfield',
				items:[{
					fieldLabel: '名称',
					id: 'baseName',
					enableKeyEvents: true,
					listeners: {
						'keyup': function(e){
							if(presrc != null){
								if(presrc.tagName.toLowerCase()=="roundrect"){
									presrc.lastChild.lastChild.data = e.getValue();
									modifyXmlNodeAttr(presrc,"name",e.getValue());
									//修改指向该节点的transition的to属性
									var lines = Ext.DomQuery.select("line[project="+presrc.id+"]");
									for(var i=0;i<lines.length;i++)
										modifyXmlNodeAttr(lines[i],"to",e.getValue());
								}else if(presrc.tagName.toLowerCase()=="line"){
									Ext.DomQuery.select("span[title="+presrc.id+"]")[0].innerHTML = e.getValue();
									modifyXmlNodeAttr(presrc,"name",e.getValue());
									//修改动态委派节点相关属性
									var autoNode = findXmlNodeByTitle("event-listener",presrc.id,"autoDelegate");
									if(autoNode != null){
										autoNode.setAttribute("name",e.getValue());
										autoNode.firstChild.firstChild.setAttribute("value",e.getValue());
										var nextTask = findXmlNodeByName("task",xmlNode.getAttribute("to"),null);
										if(nextTask != null){
											if(!!nextTask.getAttribute("candidate-users")){
												nextTask.setAttribute("candidate-users","${users_"+hex_md5(e.getValue())+"}");
											}
											if(!!nextTask.getAttribute("candidate-groups")){
												nextTask.setAttribute("candidate-groups","${groups_"+hex_md5(e.getValue())+"}");
											}
										}
									}
								}else{
									presrc.innerHTML = e.getValue();
									modifyXmlNodeAttr(Ext.getDom(presrc.title),"name",e.getValue());
									//修改动态委派节点相关属性
									var autoNode = findXmlNodeByTitle("event-listener",presrc.title,"autoDelegate");
									if(autoNode != null){
										autoNode.setAttribute("name",e.getValue());
										autoNode.firstChild.firstChild.setAttribute("value",e.getValue());
										var nextTask = findXmlNodeByName("task",xmlNode.getAttribute("to"),null);
										if(nextTask != null){
											if(!!nextTask.getAttribute("candidate-users")){
												nextTask.setAttribute("candidate-users","${users_"+hex_md5(e.getValue())+"}");
											}
											if(!!nextTask.getAttribute("candidate-groups")){
												nextTask.setAttribute("candidate-groups","${groups_"+hex_md5(e.getValue())+"}");
											}
										}
									}
								}	
								if(presrc.tagName.toLowerCase() != "span")
									presrc.title = e.getValue();
							}else{//为空时表明是流程定义属性
								modifyXmlNodeAttr("process","name",e.getValue());
							}
						}
					}
				},{
					xtype: 'textarea',
					fieldLabel: '描述',
					id: 'baseDescrip',
					enableKeyEvents: true,
					listeners: {
						'keyup': function(e){
							if(presrc != null){
								//修改对应的XML
								if(presrc.tagName.toLowerCase() == "span"){
									modifyXmlNodeAttr(Ext.getDom(presrc.title),"description",e.getValue());
								}
								modifyXmlNodeAttr(presrc,"description",e.getValue());
							}else{
								modifyXmlNodeAttr("process","description",e.getValue());
							}
						}
					}
				}]
			})
		});
		var paraPanel = new Ext.Panel({
			title: '流程定义',
			region: 'south',
			id: 'paraPanel',
			iconCls: 'picon01',
			layout: 'absolute',
			collapsible: true,
			autoScroll: true,
			split: true,
			height: 145,
			items: [keyPanel,valuePanel],
			collapseFirst: false,
			tools:[{
				id: 'maximize',
				qtip: '最大化',
				handler: function(){
					paraPanel.setHeight(400);
					this.hide();
					paraPanel.getTool('minimize').show();
					designWin.doLayout();
				}
			},{
				id: 'minimize',
				qtip: '最小化',
				hidden: true,
				handler: function(){
					paraPanel.setHeight(145);
					this.hide();
					paraPanel.getTool('maximize').show();
					designWin.doLayout();
				}
			}]
		});
		designWin = new Ext.Window({
			title: '流程设计器',
			layout: 'border',
			iconCls: 'picon06',
			width: 900,
	        height: 600,
	  		autoScroll: false,
	        plain: false,
	  		modal: true,
	  		//maximizable: true,
			maximized: true,
	  		closeAction: 'hide',
			items:[elePanel,mainPanel,paraPanel]
		});
		designWin.show();
		designWin.hide();
		Ext.getDom("west").style.display = "block";
		Ext.getDom("south_key").style.display = "block";
		//初始流程属性
		initProcess();
		//为工具栏按钮注册事件
		Ext.get(Ext.DomQuery.select(".btn")).on("click",function(){
			if(!Ext.fly(this).hasClass("btn_down")){
				currentBtn = this.title;
				Ext.get(Ext.DomQuery.select(".btn_down")).removeClass("btn_down");
				Ext.fly(this).addClass("btn_down");
				setParams();
			}
		});
		//为属性栏按钮注册事件
		Ext.get(Ext.DomQuery.select(".key_btn")).on("click",function(){
			if(!Ext.fly(this).hasClass("key_btn_down")){
				currentParam = this.title;
				Ext.get(Ext.DomQuery.select(".key_btn_down")).removeClass("key_btn_down");
				Ext.fly(this).addClass("key_btn_down");
				//转换面板
				changeCard();
				//设置值
				if(this.title != "base"){
					if(presrc == null)
						XmlSetParams("process");
					else if(presrc.tagName.toLowerCase() == "span")
						XmlSetParams(Ext.getDom(presrc.title));
					else
						XmlSetParams(presrc);				
				}	
			}
		});
		//为流程区添加右键菜单
		var target = null;
		var contextmenu = new Ext.menu.Menu({
			items:[{
				text: '删除',	
				iconCls: 'picon13',
				handler: function(){
					if(presrc == target)
						initProcess();
					//删除与之相关的连线
					if(target.tagName.toLowerCase() == "roundrect"){
						var sources = Ext.DomQuery.select("line[source="+target.id+"]");
						var projects = Ext.DomQuery.select("line[project="+target.id+"]");			
						//删除与之对应的文本节点
						var lines = sources.concat(projects);
						for(var i=0;i<lines.length;i++){
							deleteXmlNode(lines[i]);
							Ext.get(Ext.DomQuery.select("span[title="+lines[i].id+"]")).remove();	
						}
						Ext.get(lines).remove();
					}
					//删除动态委派节点
					if(target.tagName.toLowerCase() == "line"){
						var autoNode = findXmlNodeByTitle("event-listener",eventsrc.id,"autoDelegate");
						if(autoNode != null){
							if(autoNode.parentNode.childNodes.length == 1)
								autoNode.parentNode.parentNode.removeChild(autoNode.parentNode);
							else
								autoNode.parentNode.removeChild(autoNode);
						}
					}
					if(target.tagName.toLowerCase() == "span"){
						target.innerHTML = "";
						modifyXmlNodeAttr(Ext.getDom(target.title),"name","");
						Ext.getDom(target.title).title = "";	
						target.style.border = 0;
						if(presrc != null && presrc.id == target.title)
							Ext.getCmp("baseName").setValue("");	
					}else{
						deleteXmlNode(target);
						Ext.fly(target).remove();
						//删除与之相关的文本节点
						if(target.tagName.toLowerCase() == "line")
							Ext.get(Ext.DomQuery.select("span[title="+target.id+"]")).remove();
					}
				}
			}]
		});
		//工具栏快捷键
		Ext.getBody().on("keydown",function(e){
			if(e.target.tagName.toLowerCase() != "input"&&e.target.tagName.toLowerCase() != "textarea"){
				var keyValue = String.fromCharCode(e.keyCode);
				if(e.keyCode == 46 || e.keyCode == 8)
					e.preventDefault();
				if(keyValue == "V")
					Ext.DomQuery.select("div[title=select]")[0].fireEvent("onclick");
				else if(keyValue == "R")
					Ext.DomQuery.select("div[title=transition]")[0].fireEvent("onclick");
				else if(keyValue == "S")
					Ext.DomQuery.select("div[title=start]")[0].fireEvent("onclick");
				else if(keyValue == "E")
					Ext.DomQuery.select("div[title=end]")[0].fireEvent("onclick");
				else if(keyValue == "T")
					Ext.DomQuery.select("div[title=task]")[0].fireEvent("onclick");
				else if(keyValue == "C")
					Ext.DomQuery.select("div[title=custom]")[0].fireEvent("onclick");
				else if(keyValue == "D")
					Ext.DomQuery.select("div[title=bool]")[0].fireEvent("onclick");
				else if(keyValue == "F")
					Ext.DomQuery.select("div[title=fork]")[0].fireEvent("onclick");
				else if(keyValue == "J")
					Ext.DomQuery.select("div[title=join]")[0].fireEvent("onclick");
				else if(keyValue == "N"){
					Ext.getDom("center").innerHTML = "";
					xml = null;
					initProcess();
				}else if(keyValue == "I")
					XmlToProcess(testProcess);
				else if(keyValue == "O")
					;
				else if(keyValue == "G"){
					if(Ext.fly(Ext.getDom("center").parentNode).hasClass("center"))
						Ext.fly(Ext.getDom("center").parentNode).removeClass("center");
					else
						Ext.fly(Ext.getDom("center").parentNode).addClass("center");
				}else if(keyValue == "X")
					showXml();
			}
		});
		//右键菜单
		Ext.get("center").on('mousedown',function(e){
			//判断是否是右键
			if(e.button != "2")
				downAction();
			else{
				target = e.target;
				//判断是否在center区域
				//if(!Ext.get(target).findParent("div[id=center]",Ext.getBody()))
				//	return false;
				if (e.target.tagName.toLowerCase() == 'textbox') 
					target = event.srcElement.parentElement;
				if (e.target.tagName.toLowerCase() == 'b') 
					target = event.srcElement.parentElement.parentElement;			
				var tagName = target.tagName.toLowerCase();
				if (tagName != "line" && tagName != "roundrect" && tagName != "span")
					return false;
				contextmenu.showAt(e.getXY());
			}
		});
		Ext.get("center").on('mouseup',function(e){
			upAction();
		});
		//禁用复制事件
		document.onselectstart = function(){
			if(event.srcElement.tagName.toLowerCase() != "input"&&event.srcElement.tagName.toLowerCase() != "textarea")
				return false;
		}
		document.oncontextmenu = function(){return false;}//禁用右键菜单
	},
	newProcess : function(){
		Ext.getDom("center").innerHTML = "";
		xml = null;
		initProcess();
	},
	winShow : function(){
		designWin.show();
	},
	winHide : function(){
		designWin.hide();	
	},
	getXml : function(){
		var str = xml.xml.replace(/></g,'>\n\r<');
		str = str.replace(/xmlns=\"\"/g,'');
		return str;
	},
	loadXml: function(tempXml){
		XmlToProcess(tempXml);
	},
	validate : function(){
		return false;
	}
};
//初始设置流程定义
function initProcess(){	
	presrc = null;
	if(xml == null){
		//节点计数器
		taskNum = 1;
		lineNum = 1;
		endNum = 1;
		boolNum = 1;
		joinNum = 1;
		forkNum = 1;
		mailNum = 1;
		signNum = 1;
		//树列表计数器
		swimlaneNum = 1;
		mailtoNum = 1;
		noticeNum = 1;
		sqlNum = 1;
	}
	createDashLine();
	showNodeParams(nodeParams.process,"流程定义","picon01");
	//创建xml对象
	createXml();
	//设置显示属性
	XmlSetParams("process");
}
//根据点击的按钮设置参数
function setParams(){
	switch(currentBtn){
		case "select":
			dragable = true;
			break
		case "grid":
			break
		case "transition":
			lineFlag = true;
			break
		default:
	}
}
//左键按下时方法
function downAction(){
	//判断是否是左键被按下
	if(event.button != 1)
		return;
	switch(currentBtn){
		case "select":		
			//拖动
			drags();
			//显示属性
			showParams();
			break
		case "transition":
			createLine();
			break
		default:
			createNode();
	}
}
//左键释放时方法
function upAction(){
	//if(Ext.get(eventsrc) != null&&!Ext.get(eventsrc).findParent("div[id=center]",Ext.getBody()))
	//	return false;
	switch(currentBtn){
		case "select":
			dragable = false;
			break
		case "transition":
			drawLine();
			break
		default:
	}
}
//创建节点
function createNode(){
	if(!nodeOrNot())
		return false;
	var node = document.createElement("v:roundrect");
	node.inset = '2pt,2pt,2pt,2pt';
	node.style.pixelLeft = event.x + Ext.getDom("center").parentNode.scrollLeft;
	node.style.pixelTop = event.y + Ext.getDom("center").parentNode.scrollTop;
	node.style.zIndex = 1;
	node.style.pixelWidth = 110;
	node.style.pixelHeight = 50;
	node.strokeColor = "#27548d";
	node.fillcolor= '#EEEEEE';
	Ext.fly(node).addClass("node");
	switch(currentBtn){
		case "start":
			node.id = "start";
			node.title = "流程开始";
			node.flowtype = "start";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_start' inset='1pt,2pt,1pt,1pt'><b>Start</b><br />流程开始</v:textbox>";
			break
		case "task":		
			node.id = "task" + taskNum;
			node.title = "任务节点" + taskNum;
			node.flowtype = "task";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_task' inset='1pt,2pt,1pt,1pt'><b>TaskNode</b><br />任务节点"+taskNum+"</v:textbox>";
			taskNum ++;
			break
		case "custom":		
			node.id = "sign" + signNum;
			node.title = "会签节点" + signNum;
			node.flowtype = "custom";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_sign' inset='1pt,2pt,1pt,1pt'><b>signNode</b><br />会签节点"+signNum+"</v:textbox>";
			signNum ++;
			break
		case "end":
			node.id = "end" + endNum;
			node.title = "流程结束" + endNum;
			node.flowtype = "end";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_end' inset='1pt,2pt,1pt,1pt'><b>End</b><br />流程结束"+endNum+"</v:textbox>";
			endNum ++;
			break;
		case "bool":
			node.id = "bool" + boolNum;
			node.title = "决策" + boolNum;
			node.flowtype = "decision";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_bool' inset='1pt,2pt,1pt,1pt'><b>Decision</b><br />决策"+boolNum+"</v:textbox>";
			boolNum ++;
			break;
		case "mail":
			node.id = "mail" + mailNum;
			node.title = "邮件" + mailNum;
			node.flowtype = "mail";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_mail' inset='1pt,2pt,1pt,1pt'><b>Mail</b><br />邮件"+mailNum+"</v:textbox>";
			mailNum ++;
			break;
		case "join":
			node.style.pixelWidth = 50;
			node.id = "join" + joinNum;
			node.title = "合并" + joinNum;
			node.flowtype = "join";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_join' inset='1pt,2pt,1pt,1pt'><br /></v:textbox>";
			joinNum ++;
			break;
		case "fork":
			node.style.pixelWidth = 50;
			node.id = "fork" + forkNum;
			node.title = "分支" + forkNum;
			node.flowtype = "fork";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_fork' inset='1pt,2pt,1pt,1pt'><br /></v:textbox>";
			forkNum ++;
			break;
		default:
	}
	document.getElementById("center").appendChild(node);
	addXmlNode(node);
}
//判断是否创建节点
function nodeOrNot(){
	//点击事件事是否发生在工作区
	//防止右键菜单弹出时点击阴影出错
	//if(event.srcElement == null || event.srcElement.firstChild == null) return false;
	//if(event.srcElement.firstChild.id != "center" && event.srcElement.id != "center")
	//	return false;
	//如果是start节点判断是否已经存在
	if(currentBtn == "start" && document.getElementById("start") != null){
		return false;
	}
	return true;
}
//将当前触发事件的节点内对象转为节点对象
function selectNode(){
	eventsrc = event.srcElement;
	//如果事件对象是span，并且有泳道标识的样式，将事件对象变为它的父对象的父对象的父对象【处理泳道标识被选中的问题】
	if (Ext.fly(eventsrc).hasClass("sign")){
		eventsrc = event.srcElement.parentElement.parentElement.parentElement;
	}
	//如果事件对象是textbox，将事件对象变为它的父对象
	if (event.srcElement.tagName.toLowerCase() == 'textbox') 
		eventsrc = event.srcElement.parentElement;
	//如果事件对象是b，将事件对象变为它的父对象的父对象
	if (event.srcElement.tagName.toLowerCase() == 'b') 
		eventsrc = event.srcElement.parentElement.parentElement;
	//如果是选择并且在center区域，执行下面的选中
	if(currentBtn == "select" && !!Ext.get(eventsrc).findParent("div[id=center]",Ext.getBody())){
		//如果前次选择与当前选中一致，不执行以下语句
		//alert(presrc.id + "," + eventsrc.id);
		if(presrc == eventsrc)
			return false;	
		if(presrc != null){
			if(presrc.tagName.toLowerCase() == "span"){
				presrc.style.border = "0";
			}else{
				presrc.strokeColor = "#27548d";
				presrc.strokeWeight = "1pt";
				presrc.style.zIndex = 1;
			}
		}
		switch(eventsrc.tagName.toLowerCase()){
			case "roundrect":
				eventsrc.strokeColor = "#ff0000";
				eventsrc.strokeWeight = "2pt";
				eventsrc.style.zIndex = 2;
				break
			case "line":
				eventsrc.strokeColor = "#ff0000";
				eventsrc.strokeWeight = "2pt";
				break
			case "span":
				eventsrc.style.border = "2px solid #ff0000";
				break
		}
		//将当前节点赋值给presrc
		presrc = eventsrc;
	}else if(currentBtn == "select"){
		if(presrc!=null&&eventsrc.tagName.toLowerCase()=="div"&&eventsrc.firstChild&&eventsrc.firstChild.id=="center"||eventsrc.id =="center"){
			if(presrc.tagName.toLowerCase() == "span"){
				presrc.style.border = "0";
			}else{
				presrc.strokeColor = "#27548d";
				presrc.strokeWeight = "1pt";
				presrc.style.zIndex = 1;
			}
			presrc = null;
		}
	}
}
function move(){
	if (event.button == 1 && dragable){
		var newleft = temp1 + event.x - x;
		var newtop = temp2 + event.y - y;
		//重新设置节点的坐标
		modifyXmlNodeAttr(eventsrc,"g",newleft+","+newtop+","+eventsrc.style.pixelWidth+","+eventsrc.style.pixelHeight);
		eventsrc.style.pixelLeft = newleft;
		eventsrc.style.pixelTop = newtop;
		//重画与节点相关的线和文字节点
		reDrawLine();
		return false;
	}
}
function lineMove(){
	//移动时的虚线随鼠标移动
	if(lineFlag){
		//判断是否有滚动条，有的话加上滚动条的滚动长度
		dashLine.to = (event.x+Ext.getDom("center").parentNode.scrollLeft) + "," + (event.y+Ext.getDom("center").parentNode.scrollTop);
		return false;
	}
}
//查看选择节点的属性
function showParams(){
	if(presrc==null&&eventsrc.tagName.toLowerCase()=="div"&&eventsrc.firstChild&&eventsrc.firstChild.id=="center"||eventsrc.id =="center"){
		//如果前次选中为null的话，显示流程定义属性
		initProcess();
		return false;
	}
	if(!Ext.get(eventsrc).findParent("div[id=center]",Ext.getBody()))
		return false;
	switch(eventsrc.flowtype){
		case "start":
			showNodeParams(nodeParams.start,"开始节点","picon08");
			break
		case "end":
			showNodeParams(nodeParams.start,"结束节点","picon09");
			break
		case "decision":
			showNodeParams(nodeParams.base,"决策节点","picon04");
			break		
		case "mail":
			showNodeParams(nodeParams.mail,"邮件节点","picon10");
			break	
		case "join":
			showNodeParams(nodeParams.base,"合并","picon11");
			break
		case "fork":
			showNodeParams(nodeParams.base,"分支","picon12");
			break	
		case "custom":			
			showNodeParams(nodeParams.sign,"会签节点","picon24");
			break;
		case "task":			
			showNodeParams(nodeParams.task,"任务节点","picon02");
			break
		case "transition":		
			showNodeParams(nodeParams.transition,"转换","picon03");
			break
		default:
			//当选中的是文本节点的话，转换成对应的连线
			eventsrc = Ext.getDom(eventsrc.title);
			showNodeParams(nodeParams.transition,"转换","picon03");
			break
	}
	//设置显示属性
	XmlSetParams(eventsrc);
}
//显示各节点对应的属性
function showNodeParams(params,title,icon){
	Ext.getCmp("paraPanel").setTitle(title);
	Ext.getCmp("paraPanel").setIconClass(icon);
	//隐藏所有属性
	Ext.get(Ext.DomQuery.select(".key_btn")).setDisplayed("none");
	//显示对应属性
	for(var i=0;i<params.length;i++){
		var param = Ext.DomQuery.select("div[title="+params[i]+"]")[0];
		param.style.display = "block";
		if(params[i] == "base"){
			param.fireEvent('onclick');
		}
	}
}
function drags(){
	if (event.button != 1)
		return;
	selectNode();
	if (eventsrc.tagName.toLowerCase() == 'roundrect'){
		dragable = true;
		temp1 = eventsrc.style.pixelLeft;
		temp2 = eventsrc.style.pixelTop;
		x = event.x;
		y = event.y;
		document.onmousemove = move;
	}
}
//创建虚线
function createDashLine(){
	if(document.getElementById("dashLine") == null){
		dashLine = document.createElement("v:line"); 
		dashLine.style.display = "none";
		dashLine.style.position = "absolute";
		dashLine.id = "dashLine";
		dashLine.strokeWeight = "2pt";
		dashLine.fillcolor = "#f441ff";
		dashLine.strokeColor = "#f441ff";
		dashLine.innerHTML = "<v:stroke dashstyle='longDash'/><v:shadow on='t' type='single' color='#cccccc' offset='1px,1px'/>";
		document.getElementById("center").appendChild(dashLine);
	}
}
function createLine() {
	selectNode();
	if (eventsrc.tagName == 'roundrect' && eventsrc.flowtype != "end"){
		srcRect = eventsrc;
		//将虚线显示，并将虚线的起点和终点设为点击事件对象的中心
		var dx = srcRect.style.pixelLeft + srcRect.style.pixelWidth / 2;
		var dy = srcRect.style.pixelTop + srcRect.style.pixelHeight / 2;
		dashLine.from =  dx + "," +	dy;
		dashLine.to =  dx + "," +	dy;
		dashLine.style.pixelLeft = dx + 'px';
        dashLine.style.pixelTop = dy + 'px';
		dashLine.style.display = "block";
		document.onmousemove = lineMove;
	}else{
		srcRect = null;
	}
}
function drawLine(){
	if(srcRect == null)
		return;
	selectNode();
	if (eventsrc.tagName == 'roundrect' && srcRect != eventsrc){
		desRect = eventsrc;
		//创建线
		//判断是否画线
		if(drawOrNot()){
			var line = document.createElement("v:line");
			direction();
			line.from = x0+","+y0;
			line.to = x1+","+y1;
			line.style.pixelLeft = x0 + 'px';
			line.style.pixelTop = y0 + 'px';
			line.style.position = "absolute";
			line.style.display = "block";
			line.id = "line" + lineNum;
			line.flowtype = "transition";
			line.strokeWeight = "1pt";
			line.style.cursor = "pointer";
			line.strokeColor = "#27548d";
			line.source = srcRect.id;
			line.project = desRect.id;
			//创建箭头
			line.innerHTML = "<v:stroke endarrow='Classic' />";
			document.getElementById("center").appendChild(line);	
			//在连线上生成文字
			var font = createFont();
			line.title = font.innerHTML;
			lineNum ++;
			addXmlNode(line,srcRect);
			//为文字绑定移动拖拽事件
			fontEvent(font);
		}
	}
	//onmouseup事件后隐藏虚线和取消移动事件
	dashLine.style.display = "none";
	document.onmousemove = null;
}
var fontDrag = false;
function fontEvent(font){
	var fxy = {};
	Ext.fly(font).on({
		"mousedown": function(){
			fontDrag = true;
			this.style.cursor = "move";
			fxy.x = event.x - parseInt(this.style.pixelLeft);
			fxy.y = event.y - parseInt(this.style.pixelTop);
			this.style.zIndex = 2;
		},
		"mouseup": function(){
			fontDrag = false;
			this.style.cursor = "default";
			this.style.zIndex = 1;
		},
		"mousemove": function(){
			if(fontDrag){
				var line = Ext.getDom(this.title);
				if(eventsrc == line){
					this.alt = 1;
					var transition = findXmlNode(line);
					this.style.pixelLeft = event.x - fxy.x;
					this.style.pixelTop = event.y - fxy.y;
					if(transition != null);
						transition.setAttribute("g",this.style.pixelLeft+","+this.style.pixelTop);
				}
			}
		}
	});
}
function reDrawLine(){
	var lines = Ext.DomQuery.select("line[project="+eventsrc.id+"]").concat(Ext.DomQuery.select("line[source="+eventsrc.id+"]"));
	for(var i=0;i<lines.length;i++){
		if(eventsrc.id == lines[i].source){
			//将源与目的赋值为线的源与目的
			srcRect = document.getElementById(lines[i].source);
			desRect = document.getElementById(lines[i].project);
			direction();
			lines[i].to = x1 + "," + y1;
			lines[i].from = x0 + "," + y0;
			//重新设置文本位置
			fontLocation();
			var font = Ext.DomQuery.select("span[title="+lines[i].id+"]")[0];
			if(font != null&& font.alt !=1){
				modifyXmlNodeAttr(lines[i],"g",fontX+","+fontY);
				font.style.pixelLeft = fontX;
				font.style.pixelTop = fontY;
			}
		}
		if(eventsrc.id == lines[i].project){
			//将源与目的赋值为线的源与目的
			srcRect = document.getElementById(lines[i].source);
			desRect = document.getElementById(lines[i].project);
			var locations = direction();
			lines[i].to = x1 + "," + y1;
			lines[i].from = x0 + "," + y0;
			//重新设置文本位置
			fontLocation();
			var font = Ext.DomQuery.select("span[title="+lines[i].id+"]")[0];
			if(font != null && font.alt !=1){
				//在修改坐标前先修改XML中的坐标，否则改完后找不到相应的节点
				modifyXmlNodeAttr(lines[i],"g",fontX+","+fontY);
				font.style.pixelLeft = fontX;
				font.style.pixelTop = fontY;
			}	
		}		
	}
}
//判断是否画线
function drawOrNot(){
	//目的地址不能是start
	if(desRect.flowtype == "start")
		return false;
	//是否已存在
	var lines = document.getElementsByTagName('line');
	for(var i=0;i<lines.length;i++){
		if(srcRect.id==lines[i].source&&desRect.id==lines[i].project)
			return false;
		if(srcRect.id == "start" && lines[i].source == "start")
			return false;
	}
	return true;
}
//在横线上生成文字
function createFont(){
	var textNode = document.createElement("span");
	fontLocation();
	textNode.style.pixelLeft = fontX;
	textNode.style.pixelTop = fontY;
	textNode.innerHTML = "to " + desRect.title;
	Ext.fly(textNode).addClass("font_node");
	textNode.title = "line" + lineNum;
	textNode.id = "text" + lineNum;
	document.getElementById("center").appendChild(textNode);
	return textNode;
}
//判断文字的位置
function fontLocation(){
	fontX = Math.round(x0+(x1-x0)/2 - 30);
	fontY = Math.round(y0+(y1-y0)/2 - 25);
}
//箭头方向判断
function direction(){
	if (srcRect.style.pixelLeft > desRect.style.pixelLeft){
		if ((srcRect.style.pixelLeft - desRect.style.pixelLeft) <= desRect.style.pixelWidth){
			x0 = srcRect.style.pixelLeft + srcRect.style.pixelWidth / 2;
			x1 = desRect.style.pixelLeft + desRect.style.pixelWidth / 2;
			if (srcRect.style.pixelTop >  desRect.style.pixelTop){
				y0 = srcRect.style.pixelTop;
				y1 = desRect.style.pixelTop  + desRect.style.pixelHeight;
			}else{
				y0 = srcRect.style.pixelTop + srcRect.style.pixelHeight;
				y1 = desRect.style.pixelTop;
			}
		}else{
			x0 = srcRect.style.pixelLeft;
			x1 = desRect.style.pixelLeft + desRect.style.pixelWidth;
			y0 = srcRect.style.pixelTop + srcRect.style.pixelHeight / 2;
			y1 = desRect.style.pixelTop + desRect.style.pixelHeight / 2;
		}
	}else{
		if ((desRect.style.pixelLeft - srcRect.style.pixelLeft) <= desRect.style.pixelWidth){
			x0 = srcRect.style.pixelLeft + srcRect.style.pixelWidth / 2;
			x1 = desRect.style.pixelLeft + desRect.style.pixelWidth / 2;
			if (srcRect.style.pixelTop >  desRect.style.pixelTop){
			   y0 = srcRect.style.pixelTop;
			   y1 = desRect.style.pixelTop  + desRect.style.pixelHeight;
			}else{
			   y0 = srcRect.style.pixelTop + srcRect.style.pixelHeight;
			   y1 = desRect.style.pixelTop;
			}
		}else{
			x0 = srcRect.style.pixelLeft + srcRect.style.pixelWidth;
			x1 = desRect.style.pixelLeft;
			y0 = srcRect.style.pixelTop + srcRect.style.pixelHeight / 2;
			y1 = desRect.style.pixelTop + desRect.style.pixelHeight / 2;
		}
	}
}

//------------	xml操作    -------------
//创建xml
function createXml(){
	if(xml == null){
		xml = new ActiveXObject("Microsoft.XMLDOM");
		var p = xml.createProcessingInstruction("xml","version='1.0' encoding='UTF-8'");
		xml.appendChild(p);
		var root = xml.createElement("process");
		root.setAttribute("name","新建流程");
		root.setAttribute("xmlns","http://jbpm.org/4.4/jpdl");
		xml.appendChild(root);
	}
}
//查看xml
function showXml(){
	var str = xml.xml.replace(/></g,'>\n\r<');
	str = str.replace(/xmlns=\"\"/g,'');
	if(xmlWin !=null){
		Ext.getCmp("xmlTextArea").setValue(str);
		xmlWin.show();
		return false;
	}
	xmlWin = new Ext.Window({
		title: '查看XML',
		width: 700,
		layout: 'fit',
		iconCls: 'picon18',
		height: 450,
		modal: true,
		closeAction: 'hide',
		maximizable: true,
		items: new Ext.form.TextArea({
			id: 'xmlTextArea',
			value: str
		}),
		buttons:[{
			text: '保存',
			iconCls: 'picon19',
			handler: function(){
				XmlToProcess(Ext.getCmp("xmlTextArea").getValue());
				xmlWin.hide();
			}
		},{
			text: '取消',
			iconCls: 'picon09',
			handler: function(){
				xmlWin.hide();
			}
		}]
	}).show();
}
//添加xml节点
function addXmlNode(node,parentNode){
	var newNode = null;//新节点
	var attr = null;//属性
	var parent = findXmlNode(parentNode);
	if(parent == null)
		parent = xml.documentElement;//指向根节点
	switch(node.flowtype){
		case "start":
			newNode = xml.createElement("start");
			break
		case "end":
			newNode = xml.createElement("end");
			break
		case "task":
			newNode = xml.createElement("task");
			break
		case "decision":
			newNode = xml.createElement("decision");
			break
		case "mail":
			newNode = xml.createElement("mail");
			break
		case "join":
			newNode = xml.createElement("join");
			break
		case "fork":
			newNode = xml.createElement("fork");	
			break
		case "custom":
			newNode = xml.createElement("custom");
			addXmlAttribute(newNode,"class","com.huateng.sys.jbpm.ex.countersign.CountersignActivity");
			break;
		case "transition":
			newNode = xml.createElement("transition");
			//当选择节点的文本值为null，包括的节点有(join,fork)
			addXmlAttribute(newNode,"name","to "+desRect.title);
			addXmlAttribute(newNode,"to",desRect.title);
			//设置transition节点的g属性的值为对应文本节点的位置
			var font = Ext.DomQuery.select("span[title="+node.id+"]")[0];
			addXmlAttribute(newNode,"g",font.style.pixelLeft+","+font.style.pixelTop);
			parent.appendChild(newNode);
			break
	}
	if(node.flowtype != "transition"){
		addXmlAttribute(newNode,"name",node.title);
		addXmlAttribute(newNode,"g",node.style.pixelLeft+","+node.style.pixelTop+","+node.style.pixelWidth+","+node.style.pixelHeight);
		parent.appendChild(newNode);
	}
}
//添加xml属性
function addXmlAttribute(node,attr,value){
	var attribute = xml.createAttribute(attr);
	attribute.value = value;
	node.setAttributeNode(attribute);
}
//通过XML节点查找流程图节点，当前只用到通过name查找roundrect节点
function findNodeXml(xmlNode){	
	var nodes = [];
	var sameNodes = [];
	//如果不是节点的话通过title查找，如果是节点的话通过flowtype查找
	if(typeof xmlNode == "object"){	
		nodes = Ext.DomQuery.select("[flowtype="+xmlNode.tagName+"]");
		for(var i=0;i<nodes.length;i++){
			if(xmlNode.getAttribute("name") == nodes[i].title)
				sameNodes.push(nodes[i]);
		}
		if(sameNodes.length == 1){
			return sameNodes[0];
		}else{
			for(i=0;i<sameNodes.length;i++){
				if(xmlNode.getAttribute("g") == sameNodes[i].style.pixelLeft+","+sameNodes[i].style.pixelTop+","+sameNodes[i].style.pixelWidth+","+sameNodes[i].style.pixelHeight)
					return sameNodes[i];
			}	
		}
	}else{
		//如果有多个title相同的节点，只能返回第一个
		return Ext.DomQuery.select("roundrect[title="+xmlNode+"]")[0];
	}
	return null;
}
//通过流程图节点查找XML节点
function findXmlNode(node){
	if(node == "process")
		return xml.documentElement;//返回根节点
	if(node == null || node.flowtype == null)
		return null;
	var nodes = xml.getElementsByTagName(node.flowtype);
	var sameNodes = [];
	for(var i=0;i<nodes.length;i++){
		//判断是连线还是节点，是节点的话用节点坐标比较，是连线的话，用连线对应的文本节点坐标比较
		if(node.flowtype == "transition"){
			var font = Ext.DomQuery.select("span[title="+node.id+"]")[0];
			//var font = Ext.getDom("text" + id.substring(id.length-1,id.length));
			//for(j=0;j<nodes.length;j++){
				if(nodes[i].getAttribute("g") == font.style.pixelLeft+","+font.style.pixelTop)
					sameNodes.push(nodes[i]);
			//}
		}else{
			//for(k=0;k<nodes.length;k++){
				if(nodes[i].getAttribute("g") == node.style.pixelLeft+","+node.style.pixelTop+","+node.style.pixelWidth+","+node.style.pixelHeight)
					sameNodes.push(nodes[i]);
			//}	
		}
	}
	if(sameNodes.length == 1){
		return sameNodes[0];
	}else{
		for(var i=0;i<sameNodes.length;i++){
			if(sameNodes[i].getAttribute("name") == node.title){
				return sameNodes[i];
			}
		}
	}
	/*
	 *下面是先通过title查找,再通过坐标查找,这样查找的次数比较多【sameNodes的长度比较小】
	 *上面面先通过坐标查找，再通过title查找，坐标相同的几率比较小
	 *因为移动的时候文本节点的坐标改变了，是用上面的方法无法定位到对应的transition
	 *【通过修改重画reDrawLine方法，在修改坐标前先修改XML这样就能定位到相应的transition】
	 *最终使用上面的方法
	 */
	
	//先用名字进行查找，如果找到相同的，在用坐标进行匹配，如果还有相同的，返回第一个
	/*for(var i=0;i<nodes.length;i++){
		if(nodes[i].getAttribute("name") == node.title){
			sameNodes.push(nodes[i]);
		}
	}
	if(sameNodes.length == 1){
		return sameNodes[0];
	}else{
		//判断是连线还是节点，是节点的话用节点坐标比较，是连线的话，用连线对应的文本节点坐标比较
		if(node.flowtype == "transition"){
			var font = Ext.DomQuery.select("span[title="+node.id+"]")[0];
			for(i=0;i<sameNodes.length;i++){
				if(sameNodes[i].getAttribute("g") == font.style.pixelLeft+","+font.style.pixelTop)
					return sameNodes[i];
			}
		}else{
			for(i=0;i<sameNodes.length;i++){
				if(sameNodes[i].getAttribute("g") == node.style.pixelLeft+","+node.style.pixelTop+","+node.style.pixelWidth+","+node.style.pixelHeight)
					return sameNodes[i];
			}	
		}
	}
	/*
	//通过一个code进行查找，每个节点必须带code，不通用，不能适用于其他的XML
	for(var i=0;i<nodes.length;i++){
		if(nodes[i].getAttribute("code") == node.id)
			return nodes[i];
	}
	*/
	return null;
}
//删除节点
function deleteXmlNode(node){
	//如果是文本节点，获取对应的transition节点，清空name属性
	if(node.tagName.toLowerCase() == "span"){
		node = findXmlNode(Ext.getDom(node.title));
		node.setAttribute("name","");
		return false;
	}
	//如果不是文本节点，获取父节点，通过父节点删除自己
	node = findXmlNode(node);
	if(node != null)
		node.parentNode.removeChild(node);
}
//修改节点对应的属性
function modifyXmlNodeAttr(node,param,value){
	node = findXmlNode(node);
	if(node != null)
		node.setAttribute(param,value);
}
//XML的逆向转换，生成节点
function XmltoNode(child){
	var showNode = true;//是否创建节点
	var locations = child.getAttribute("g")!=null?child.getAttribute("g").split(","):[0,0,110,50];
	var node = document.createElement("v:roundrect");
	node.inset = '2pt,2pt,2pt,2pt';
	node.style.pixelLeft = locations[0];
	node.style.pixelTop = locations[1];
	node.style.pixelWidth = locations[2];
	node.style.pixelHeight = locations[3];
	node.strokeColor = "#27548d";
	node.fillcolor= '#EEEEEE';
	Ext.fly(node).addClass("node");
	switch(child.tagName){
		case "start":
			node.id = "start";
			node.title = child.getAttribute("name");
			node.flowtype = "start";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_start' inset='1pt,2pt,1pt,1pt'><b>Start</b><br />"+child.getAttribute("name")+"</v:textbox>";
			break
		case "task":	
			var title = "TaskNode";
			//标识泳道
			if(child.getAttribute("swimlane") != null&&child.getAttribute("swimlane") != "")
				title += "<span title='"+child.getAttribute("swimlane")+"' class='sign'>泳</span>";
			node.id = "task" + taskNum;
			node.title = child.getAttribute("name");
			node.flowtype = "task";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_task' inset='1pt,2pt,1pt,1pt'><b>"+title+"</b><br />"+child.getAttribute("name")+"</v:textbox>";
			taskNum ++;
			break
		case "custom":	
			var title = "SignNode";
			//标识泳道
			if(child.getAttribute("swimlane") != null&&child.getAttribute("swimlane") != "")
				title += "<span title='"+child.getAttribute("swimlane")+"' class='sign'>泳</span>";
			node.id = "sign" + signNum;
			node.title = child.getAttribute("name");
			node.flowtype = "custom";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_sign' inset='1pt,2pt,1pt,1pt'><b>"+title+"</b><br />"+child.getAttribute("name")+"</v:textbox>";
			signNum ++;
			break
		case "end":
			node.id = "end" + endNum;
			node.title = child.getAttribute("name");
			node.flowtype = "end";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_end' inset='1pt,2pt,1pt,1pt'><b>End</b><br />"+child.getAttribute("name")+"</v:textbox>";
			endNum ++;
			break;
		case "decision":
			node.id = "decision" + boolNum;
			node.title = child.getAttribute("name");
			node.flowtype = "decision";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_bool' inset='1pt,2pt,1pt,1pt'><b>Decision</b><br />"+child.getAttribute("name")+"</v:textbox>";
			boolNum ++;
			break;
		case "mail":
			node.id = "mail" + mailNum;
			node.title = child.getAttribute("name");
			node.flowtype = "mail";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_mail' inset='1pt,2pt,1pt,1pt'><b>Mail</b><br />"+child.getAttribute("name")+"</v:textbox>";
			mailNum ++;
			break;
		case "join":
			node.style.pixelWidth = 50;
			node.style.pixelHeight = 50;
			node.id = "join" + joinNum;
			node.title = child.getAttribute("name");
			node.flowtype = "join";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_join' inset='1pt,2pt,1pt,1pt'><br /></v:textbox>";
			joinNum ++;
			break;
		case "fork":
			node.style.pixelWidth = 50;
			node.style.pixelHeight = 50;
			node.id = "fork" + forkNum;
			node.title = child.getAttribute("name");
			node.flowtype = "fork";
			node.innerHTML = "<v:shadow on='T' type='single' color='#b3b3b3' offset='2px,2px' />"
			+"<v:textbox class='node_fork' inset='1pt,2pt,1pt,1pt'><br /></v:textbox>";
			forkNum ++;
			break;
		default:
			showNode = false;
	}
	if(showNode)
		document.getElementById("center").appendChild(node);
}
//XML的逆向转换，生成连线及文本节点
function XmltoLine(child){
	srcRect = findNodeXml(child.parentNode);
	desRect = findNodeXml(child.getAttribute("to"));
	var locations = child.getAttribute("g")!=null?child.getAttribute("g").split(","):[0,0];
	var line = document.createElement("v:line");
	direction();
	line.title = child.getAttribute("name");
	line.from = x0+","+y0;
	line.to = x1+","+y1;
	line.style.pixelLeft = x0 + 'px';
	line.style.pixelTop = y0 + 'px';
	line.style.position = "absolute";
	line.style.display = "block";
	line.id = "line" + lineNum;
	line.flowtype = "transition";
	line.strokeWeight = "1pt";
	line.style.cursor = "pointer";
	line.strokeColor = "#27548d";
	line.source = srcRect.id;
	line.project = desRect.id;
	//重置动态委派title
	var autoNode = findXmlNodeByNameAndParent("event-listener",child.getAttribute("name"),child.parentNode,"autoDelegate");
	if(autoNode != null)
		autoNode.setAttribute("title","line"+lineNum);
	//创建箭头
	line.innerHTML = "<v:stroke endarrow='Classic' />";
	document.getElementById("center").appendChild(line);

	//生成文本节点
	var textNode = document.createElement("span");
	textNode.style.pixelLeft = locations[0];
	textNode.style.pixelTop = locations[1];
	textNode.innerHTML = child.getAttribute("name");
	Ext.fly(textNode).addClass("font_node");
	textNode.title = "line" + lineNum;
	textNode.id = "text" + lineNum;
	document.getElementById("center").appendChild(textNode);
	lineNum ++;
	fontEvent(textNode);
}
//XML的逆向转换，将XML转换成为流程图
function XmlToProcess(loadXml){
	//清空已有的流程图
	Ext.getDom("center").innerHTML = "";
	xml.loadXML(loadXml);
	//初始化流程信息
	initProcess();

	var root = findXmlNode("process");
	var rootChilds = root.childNodes;
	for(var i=0;i<rootChilds.length;i++)
		XmltoNode(rootChilds[i]);
	var lines = xml.getElementsByTagName("transition");
	for(i=0;i<lines.length;i++)
		XmltoLine(lines[i]);
}
//根据节点获取对应的XML节点，并对相应的属性页面赋值
function XmlSetParams(node){
	xmlNode = findXmlNode(node);
	if(xmlNode == null)
		return false;
	switch(currentParam){
		case "base":
			if(node != null){
				Ext.getCmp("baseName").setValue(xmlNode.getAttribute("name"));
				Ext.getCmp("baseDescrip").setValue(xmlNode.getAttribute("description"));
			}
			break
		case "form":
			if(xmlNode != null){
				if(xmlNode.getAttribute("form") == null || xmlNode.getAttribute("form") == "")
					Ext.getCmp("formName").setValue("");
				else
					Ext.getCmp("formName").setValue(xmlNode.getAttribute("form"));
			}
			break;
		case "delegate":
			//formClear("delegate");
			//初始化泳道下拉框
			var swimlanes = xml.getElementsByTagName("swimlane");
			var arrays = [];
			for(var i=0;i<swimlanes.length;i++){
				arrays.push([swimlanes[i].getAttribute("name"),swimlanes[i].getAttribute("name")]);
			}
			Ext.getCmp("delegateSwimlaneCombo").getStore().loadData(arrays);
			//判断是否有泳道，有的话进行赋值
			if(xmlNode.getAttribute("swimlane")!=""&&xmlNode.getAttribute("swimlane")!=null){
				Ext.getCmp("delegateSwimlaneCombo").setValue(xmlNode.getAttribute("swimlane"));
				partDisableOrEnable("delegateSwimlaneCheck","delegateSwimlaneCombo","enable");
			}else{
				Ext.getCmp("delegateSwimlaneCombo").setValue("");
				partDisableOrEnable("delegateSwimlaneCheck","delegateSwimlaneCombo","disable");
			}
			//为候选人赋值
			if(xmlNode.getAttribute("candidate-users")!=""&&xmlNode.getAttribute("candidate-users")!=null){
				Ext.getCmp("delegateUserIdBox").setValue(xmlNode.getAttribute("candidate-users"));
				Ext.getCmp("delegateUserBox").setValue(xmlNode.getAttribute("users"));
				partDisableOrEnable("delegateUserCheck","delegateUserBox","enable");
			}else{
				Ext.getCmp("delegateUserIdBox").setValue("");
				Ext.getCmp("delegateUserBox").setValue("");
				partDisableOrEnable("delegateUserCheck","delegateUserBox","disable");
			}
			//候选角色赋值
			if(xmlNode.getAttribute("candidate-roles")!=""&&xmlNode.getAttribute("candidate-roles")!=null){
				Ext.getCmp("delegateRoleIdBox").setValue(xmlNode.getAttribute("candidate-roles"));
				Ext.getCmp("delegateRoleBox").setValue(xmlNode.getAttribute("roles"));
				partDisableOrEnable("delegateRoleCheck","delegateRoleBox","enable");
			}else{
				Ext.getCmp("delegateRoleIdBox").setValue("");
				Ext.getCmp("delegateRoleBox").setValue("");
				partDisableOrEnable("delegateRoleCheck","delegateRoleBox","disable");
			}
			//候选部门赋值
			if(xmlNode.getAttribute("candidate-depts")!=""&&xmlNode.getAttribute("candidate-depts")!=null){
				Ext.getCmp("delegateDeptIdBox").setValue(xmlNode.getAttribute("candidate-depts"));
				Ext.getCmp("delegateDeptBox").setValue(xmlNode.getAttribute("depts"));
				partDisableOrEnable("delegateDeptCheck","delegateDeptBox","enable");
			}else{
				Ext.getCmp("delegateDeptIdBox").setValue("");
				Ext.getCmp("delegateDeptBox").setValue("");
				partDisableOrEnable("delegateDeptCheck","delegateDeptBox","disable");
			}
			//任务发起者与执行者
			node = findXmlNodeByParentNode("assignment-handler",xmlNode);
			if(node != null){
				fieldNode = findXmlAreaValueByName(node,"process_sponsor");
				Ext.getCmp("delegateSponsorCombo").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"include");
				fieldNode = findXmlAreaValueByName(node,"process_executor");
				Ext.getCmp("delegateExecutorCombo").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"include");
				fieldNode = findXmlAreaValueByName(node,"process_executor_area");
				Ext.getCmp("delegateExecutorTypeCombo").setValue(fieldNode?"one":"all");
				if(findXmlAreaValueByName(node,"process_sponsor") != null){
					partDisableOrEnable("delegateSponsorCheck","delegateSponsorCombo","enable");
					Ext.getCmp("delegateExecutorTypeCombo").enable();
				}else{
					partDisableOrEnable("delegateSponsorCheck","delegateSponsorCombo","disable");
				}
				if(findXmlAreaValueByName(node,"process_executor") != null){
					partDisableOrEnable("delegateExecutorCheck","delegateExecutorCombo","enable");
					if(findXmlAreaValueByName(node,"process_executor_area") != null){
						Ext.getCmp("delegateExecutorTypeCombo").enable();
						Ext.getCmp("delegateExecutorAreaCombo").enable();
						Ext.getCmp("delegateExecutorAreaCombo").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
					}else{
						Ext.getCmp("delegateExecutorAreaCombo").disable();
						Ext.getCmp("delegateExecutorAreaCombo").setValue("");
					}
				}else{
					partDisableOrEnable("delegateExecutorCheck","delegateExecutorCombo","disable");
					Ext.getCmp("delegateExecutorTypeCombo").disable();
					Ext.getCmp("delegateExecutorAreaCombo").disable();
					Ext.getCmp("delegateExecutorAreaCombo").setValue("");
				}
			}else{
				partDisableOrEnable("delegateSponsorCheck","delegateSponsorCombo","disable");
				Ext.getCmp("delegateExecutorTypeCombo").disable();
				Ext.getCmp("delegateExecutorAreaCombo").disable();
				partDisableOrEnable("delegateExecutorCheck","delegateExecutorCombo","disable");
				Ext.getCmp("delegateSponsorCombo").setValue("include");
				Ext.getCmp("delegateExecutorCombo").setValue("include");
				Ext.getCmp("delegateExecutorTypeCombo").setValue("all");
				Ext.getCmp("delegateExecutorAreaCombo").setValue("");
			}
			break
		case "signDelegate":
			//为候选人赋值
			if(xmlNode.getAttribute("candidate-users")!=""&&xmlNode.getAttribute("candidate-users")!=null){
				Ext.getCmp("signDelegateUserIdBox").setValue(xmlNode.getAttribute("candidate-users"));
				Ext.getCmp("signDelegateUserBox").setValue(xmlNode.getAttribute("users"));
				partDisableOrEnable("signDelegateUserCheck","signDelegateUserBox","enable");
			}else{
				Ext.getCmp("signDelegateUserIdBox").setValue("");
				Ext.getCmp("signDelegateUserBox").setValue("");
				partDisableOrEnable("signDelegateUserCheck","signDelegateUserBox","disable");
			}
			//候选角色赋值
			if(xmlNode.getAttribute("candidate-roles")!=""&&xmlNode.getAttribute("candidate-roles")!=null){
				Ext.getCmp("signDelegateRoleIdBox").setValue(xmlNode.getAttribute("candidate-roles"));
				Ext.getCmp("signDelegateRoleBox").setValue(xmlNode.getAttribute("roles"));
				partDisableOrEnable("signDelegateRoleCheck","signDelegateRoleBox","enable");
			}else{
				Ext.getCmp("signDelegateRoleIdBox").setValue("");
				Ext.getCmp("signDelegateRoleBox").setValue("");
				partDisableOrEnable("signDelegateRoleCheck","signDelegateRoleBox","disable");
			}
			//候选部门赋值
			if(xmlNode.getAttribute("candidate-depts")!=""&&xmlNode.getAttribute("candidate-depts")!=null){
				Ext.getCmp("signDelegateDeptIdBox").setValue(xmlNode.getAttribute("candidate-depts"));
				Ext.getCmp("signDelegateDeptBox").setValue(xmlNode.getAttribute("depts"));
				partDisableOrEnable("signDelegateDeptCheck","signDelegateDeptBox","enable");
			}else{
				Ext.getCmp("signDelegateDeptIdBox").setValue("");
				Ext.getCmp("signDelegateDeptBox").setValue("");
				partDisableOrEnable("signDelegateDeptCheck","signDelegateDeptBox","disable");
			}
			//任务发起者与执行者
			var fieldNode = findXmlAreaValueByName(xmlNode,"signCandidateHandler");
			var node  = null;
			if(fieldNode != null){
				node = findXmlNodeByParentNode("object",fieldNode);
			}
			if(node != null){
				fieldNode = findXmlAreaValueByName(node,"process_sponsor");
				Ext.getCmp("signDelegateSponsorCombo").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"include");
				fieldNode = findXmlAreaValueByName(node,"process_executor");
				Ext.getCmp("signDelegateExecutorCombo").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"include");
				fieldNode = findXmlAreaValueByName(node,"process_executor_area");
				Ext.getCmp("signDelegateExecutorTypeCombo").setValue(fieldNode?"one":"all");
				if(findXmlAreaValueByName(node,"process_sponsor") != null){
					partDisableOrEnable("signDelegateSponsorCheck","signDelegateSponsorCombo","enable");
					Ext.getCmp("signDelegateExecutorTypeCombo").enable();
				}else{
					partDisableOrEnable("signDelegateSponsorCheck","signDelegateSponsorCombo","disable");
				}
				if(findXmlAreaValueByName(node,"process_executor") != null){
					partDisableOrEnable("signDelegateExecutorCheck","signDelegateExecutorCombo","enable");
					Ext.getCmp("signDelegateExecutorTypeCombo").enable();
					if(findXmlAreaValueByName(node,"process_executor_area") != null){
						Ext.getCmp("signDelegateExecutorAreaCombo").enable();
						Ext.getCmp("signDelegateExecutorAreaCombo").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
					}else{
						Ext.getCmp("signDelegateExecutorAreaCombo").disable();
						Ext.getCmp("signDelegateExecutorAreaCombo").setValue("");
					}
				}else{
					partDisableOrEnable("signDelegateExecutorCheck","signDelegateExecutorCombo","disable");
					Ext.getCmp("signDelegateExecutorTypeCombo").disable();
					Ext.getCmp("signDelegateExecutorAreaCombo").disable();
					Ext.getCmp("signDelegateExecutorAreaCombo").setValue("");
				}
			}else{
				partDisableOrEnable("signDelegateSponsorCheck","signDelegateSponsorCombo","disable");
				Ext.getCmp("signDelegateExecutorTypeCombo").disable();
				Ext.getCmp("signDelegateExecutorAreaCombo").disable();
				partDisableOrEnable("signDelegateExecutorCheck","signDelegateExecutorCombo","disable");
				Ext.getCmp("signDelegateSponsorCombo").setValue("include");
				Ext.getCmp("signDelegateExecutorCombo").setValue("include");
				Ext.getCmp("signDelegateExecutorTypeCombo").setValue("all");
				Ext.getCmp("signDelegateExecutorAreaCombo").setValue("");
			}
			break
		case "swimlane":
			var xmlSwimlanes = xml.getElementsByTagName("swimlane");
			//因为泳道是属于整个流程的，所以只有页面列表和XML节点数目不同的时候加入
			//但是如果重新导入的流程泳道数与页面的泳道数相同，就会产生错误
			if(Ext.DomQuery.select(".swimlane_btn").length != xmlSwimlanes.length){
				Ext.getDom("swimlaneList").innerHTML = "";
				for(var i=0;i<xmlSwimlanes.length;i++){
					addTreeList(Ext.getDom("swimlaneList"),"S"+(i+1),xmlSwimlanes[i].getAttribute("name"),"swimlane");
					swimlaneNum ++;
				}
			}
			break
		case "mailto":
			var xmlMailtoListener = xml.getElementsByTagName("event-listener");
			var mailEventListener = [];
			for(var i=0;i<xmlMailtoListener.length;i++){
				if(xmlMailtoListener[i].getAttribute("type") == "mailto")
					mailEventListener.push(xmlMailtoListener[i]);
			}
			Ext.getDom("mailtoList").innerHTML = "";
			for(i=0;i<mailEventListener.length;i++){
				if(xmlNode.tagName == "transition"){
					if(mailEventListener[i].parentNode == xmlNode){
						addTreeList(Ext.getDom("mailtoList"),"M"+(i+1),mailEventListener[i].getAttribute("name"),"mailto");
						mailtoNum ++;
					}
				}else{
					if(mailEventListener[i].parentNode.tagName=="on"&&mailEventListener[i].parentNode.parentNode == xmlNode){
						addTreeList(Ext.getDom("mailtoList"),"M"+(i+1),mailEventListener[i].getAttribute("name"),"mailto");
						mailtoNum ++;
					}
				}
			}
			break
		case "notice":
			var xmlNoticeListener = xml.getElementsByTagName("event-listener");
			var noticeEventListener = [];
			for(var i=0;i<xmlNoticeListener.length;i++){
				if(xmlNoticeListener[i].getAttribute("type") == "notice")
					noticeEventListener.push(xmlNoticeListener[i]);
			}
			Ext.getDom("noticeList").innerHTML = "";
			for(i=0;i<noticeEventListener.length;i++){
				if(xmlNode.tagName == "transition"){
					if(noticeEventListener[i].parentNode == xmlNode){
						addTreeList(Ext.getDom("noticeList"),"N"+(i+1),noticeEventListener[i].getAttribute("name"),"notice");
						noticeNum ++;
					}
				}else{
					if(noticeEventListener[i].parentNode.tagName=="on"&&noticeEventListener[i].parentNode.parentNode == xmlNode){
						addTreeList(Ext.getDom("noticeList"),"N"+(i+1),noticeEventListener[i].getAttribute("name"),"notice");
						noticeNum ++;
					}
				}
			}
			break
		case "sql":
			var xmlSqlListener = xml.getElementsByTagName("event-listener");
			var sqlEventListener = [];
			for(var i=0;i<xmlSqlListener.length;i++){
				if(xmlSqlListener[i].getAttribute("type") == "sql")
					sqlEventListener.push(xmlSqlListener[i]);
			}
			Ext.getDom("sqlList").innerHTML = "";
			for(i=0;i<sqlEventListener.length;i++){
				if(xmlNode.tagName == "transition"){
					if(sqlEventListener[i].parentNode == xmlNode){
						addTreeList(Ext.getDom("sqlList"),"Q"+(i+1),sqlEventListener[i].getAttribute("name"),"sql");
						sqlNum ++;
					}
				}else{
					if(sqlEventListener[i].parentNode.tagName=="on"&&sqlEventListener[i].parentNode.parentNode == xmlNode){
						addTreeList(Ext.getDom("sqlList"),"Q"+(i+1),sqlEventListener[i].getAttribute("name"),"sql");
						sqlNum ++;
					}
				}
			}
			break
		case "autoDelegate":
			var xmlAutoDelegateListener = xml.getElementsByTagName("event-listener");
			var autoDelegateEventListener = [];
			for(var i=0;i<xmlAutoDelegateListener.length;i++){
				if(xmlAutoDelegateListener[i].getAttribute("type") == "autoDelegate")
					autoDelegateEventListener.push(xmlAutoDelegateListener[i]);
			}
			var currentAutoDelegate = null;
			for(var i=0;i<autoDelegateEventListener.length;i++){
				if(autoDelegateEventListener[i].getAttribute("name") == xmlNode.getAttribute("name")){
					currentAutoDelegate = autoDelegateEventListener [i];
					break;
				}
			}
			fieldNode = findXmlAreaValueByName(currentAutoDelegate,"auto_user");
			if(fieldNode == null){
				partDisableOrEnable("autoDelegateUserCheck","autoDelegateUserBox","disable");
				Ext.getCmp("autoDelegateUserBox").setValue("");
				Ext.getCmp("autoDelegateUserIdBox").setValue("");
			}else{
				partDisableOrEnable("autoDelegateUserCheck","autoDelegateUserBox","enable");
				Ext.getCmp("autoDelegateUserBox").setValue(fieldNode.firstChild.getAttribute("name"));
				Ext.getCmp("autoDelegateUserIdBox").setValue(fieldNode.firstChild.getAttribute("value"));
			}
			fieldNode = findXmlAreaValueByName(currentAutoDelegate,"auto_role");
			if(fieldNode == null){
				partDisableOrEnable("autoDelegateRoleCheck","autoDelegateRoleBox","disable");
				Ext.getCmp("autoDelegateRoleBox").setValue("");
				Ext.getCmp("autoDelegateRoleIdBox").setValue("");
			}else{
				partDisableOrEnable("autoDelegateRoleCheck","autoDelegateRoleBox","enable");
				Ext.getCmp("autoDelegateRoleBox").setValue(fieldNode.firstChild.getAttribute("name"));
				Ext.getCmp("autoDelegateRoleIdBox").setValue(fieldNode.firstChild.getAttribute("value"));
			}
			fieldNode = findXmlAreaValueByName(currentAutoDelegate,"auto_dept");
			if(fieldNode == null){
				partDisableOrEnable("autoDelegateDeptCheck","autoDelegateDeptBox","disable");
				Ext.getCmp("autoDelegateDeptBox").setValue("");
				Ext.getCmp("autoDelegateDeptIdBox").setValue("");
			}else{
				partDisableOrEnable("autoDelegateDeptCheck","autoDelegateDeptBox","enable");
				Ext.getCmp("autoDelegateDeptBox").setValue(fieldNode.firstChild.getAttribute("name"));
				Ext.getCmp("autoDelegateDeptIdBox").setValue(fieldNode.firstChild.getAttribute("value"));
			}
			break
		case "case":
			var conditionNode = findXmlNodeByNodeName(xmlNode,"condition");
			if(conditionNode != null)
				Ext.getCmp("caseExpressionBox").setValue(conditionNode.getAttribute("expr"));
			else
				Ext.getCmp("caseExpressionBox").setValue("");
			break
		case "method":
			//获取所有XML任务转移节点
			var transitions = xmlNode.childNodes;
			var arrays = [];
			for(var i=0;i<transitions.length;i++){
				if(transitions[i].tagName == "transition")
					arrays.push([transitions[i].getAttribute("name"),transitions[i].getAttribute("name")]);
			}
			Ext.getCmp("methodPassCombo").getStore().loadData(arrays);
			Ext.getCmp("methodNoPassCombo").getStore().loadData(arrays);
			
			var fieldNode = findXmlAreaValueByName(xmlNode,"judgeType");
			var fieldValue = findXmlAreaValueByName(xmlNode,"judgeParam");
			var judgeType =  null;
			var judgeParam = null;
			if(fieldNode != null)
				judgeType = fieldNode.firstChild.getAttribute("value");
			if(fieldValue != null)
				judgeParam = fieldValue.firstChild.getAttribute("value");
			var radios = Ext.getCmp("method").find("name","methodCompleteRadio");
			if(judgeType == "OnePass"){
				radios[0].setValue(true);
			}else if(judgeType == "AllPass"){
				radios[1].setValue(true);
			}else if(judgeType == "numPass"){
				Ext.getCmp("methodNumBox").setValue(judgeParam);
				radios[2].setValue(true);
			}else if(judgeType == "percentPass"){
				Ext.getCmp("methodPercentBox").setValue(judgeParam);
				radios[3].setValue(true);
			}else{
				for(var i=0;i<radios.length;i++)
					radios[i].setValue(false);
				Ext.getCmp("methodNumBox").disable();
				Ext.getCmp("methodNumBox").setValue("");
				Ext.getCmp("methodPercentBox").disable();
				Ext.getCmp("methodPercentBox").setValue("");
			}
			var passTran = findXmlAreaValueByName(xmlNode,"passTran");
			var noPassTran = findXmlAreaValueByName(xmlNode,"noPassTran");
			if(passTran != null)
				Ext.getCmp("methodPassCombo").setValue(passTran.firstChild.getAttribute("value"));
			else
				Ext.getCmp("methodPassCombo").setValue("");
			if(noPassTran != null)
				Ext.getCmp("methodNoPassCombo").setValue(noPassTran.firstChild.getAttribute("value"));
			else
				Ext.getCmp("methodNoPassCombo").setValue("");
			
			/*
			var assignNode = findXmlNodeByParentNode("assignment-handler",xmlNode);
			var radios = Ext.getCmp("method").find("name","methodCompleteRadio");
			if(assignNode == null){
				var conRadio = Ext.getCmp("method").find("name","methodDistributionRadio")[0];
				conRadio.setValue(true);
				for(var i=0;i<radios.length;i++){
					for(var i=0;i<radios.length;i++){
						radios[i].disable();
						radios[i].setValue(false);
					}
					Ext.getCmp("methodNumBox").disable();
					Ext.getCmp("methodNumBox").setValue("");
					Ext.getCmp("methodPercentBox").disable();
					Ext.getCmp("methodPercentBox").setValue("");
				}
			}else{
				var conRadio = Ext.getCmp("method").find("name","methodDistributionRadio")[1];
				conRadio.setValue(true);
				var fieldNode = findXmlAreaValueByName(assignNode,"method");
				var valueNode = findXmlAreaValueByName(assignNode,"methodValue");
				var method = fieldNode.firstChild.getAttribute("value");
				if(method == "one"){
					radios[0].setValue(true);
				}else if(method == "all"){
					radios[1].setValue(true);
				}else if(method == "number"){
					radios[2].setValue(true);
					if(valueNode.firstChild != null){
						Ext.getCmp("methodNumBox").setValue(valueNode.firstChild.getAttribute("value"));
						Ext.getCmp("methodPercentBox").setValue("");
					}
				}else if(method == "percent"){
					radios[3].setValue(true);
					if(valueNode.firstChild != null){
						Ext.getCmp("methodPercentBox").setValue(valueNode.firstChild.getAttribute("value"));
						Ext.getCmp("methodNumBox").setValue("");
					}
				}
			}*/
			break
		default:
			//alert(node.tagName);
	}
	//当面板有树时，触发按下树节点的onclick方法，将当前选中节点设为currentTreeNode
	if(Ext.DomQuery.select("."+currentParam+"_btn").length != 0){
		Ext.DomQuery.select("."+currentParam+"_btn")[0].fireEvent("onclick");
	}
}
//根据节点名字和类型以及标识查找XML节点
function findXmlNodeByName(nodeType,nodeName,code){
	var nodes = xml.getElementsByTagName(nodeType);
	for(var i=0;i<nodes.length;i++){
		if(code == null){
			if(nodes[i].getAttribute("name") == nodeName)
				return nodes[i];
		}else{
			if(nodes[i].getAttribute("name") == nodeName&&nodes[i].getAttribute("type") == code)
				return nodes[i];
		}
	}
}
//根据节点名字、类型、父节点以及标识查找XML节点
function findXmlNodeByNameAndParent(nodeType,nodeName,parentNode,code){
	var nodes = xml.getElementsByTagName(nodeType);
	for(var i=0;i<nodes.length;i++){
		//if(code == null){
		//	if(nodes[i].getAttribute("name") == nodeName)
		//		return nodes[i];
		//}else{
		if(nodes[i].getAttribute("name") == nodeName&&nodes[i].getAttribute("type") == code){
			if(nodes[i].parentNode != null && nodes[i].parentNode.parentNode == parentNode)
				return nodes[i];
		}
		//}
	}
	return null;
}
//根据节点名字和类型以及标识查找XML节点
function findXmlNodeByTitle(nodeType,nodeTitle,code){
	var nodes = xml.getElementsByTagName(nodeType);
	for(var i=0;i<nodes.length;i++){
		if(code == null){
			if(nodes[i].getAttribute("title") == nodeTitle)
				return nodes[i];
		}else{
			if(nodes[i].getAttribute("title") == nodeTitle&&nodes[i].getAttribute("type") == code)
				return nodes[i];
		}
	}
}
//删除树节点以及对应的xml节点
function deleteXmlNodeByType(nodeType,code){
	var treeNode = Ext.getDom(currentTreeNode);
	if(treeNode == null)
		return null;
	var node = findXmlNodeByName(nodeType,treeNode.title,code);
	var parentNode = node.parentNode;
	node.parentNode.removeChild(node);
	Ext.fly(treeNode).remove();
	currentTreeNode = null;
	return parentNode;
}
//获取监听节点里面的域值节点
function findXmlAreaValueByName(node,fieldName){
	if(node == null) return null;
	var childNodes = node.childNodes;
	for(var i=0;i<childNodes.length;i++){
		if(childNodes[i].getAttribute("name") == fieldName){
			return childNodes[i];
		}
	}
	return null;
}
//根据节点类型和父节点获取唯一的子节点
function findXmlNodeByParentNode(nodeType,parentNode){
	var nodes = xml.getElementsByTagName(nodeType);
	for(var i=0;i<nodes.length;i++){
		if(nodes[i].parentNode==parentNode){
			return nodes[i];
		}
	}
	return null;
}
//根据父节点和子节点的名字获取子节点
function findXmlNodeByNodeName(parentNode,nodeName){
	var childNodes = parentNode.childNodes;
	for(var i=0;i<childNodes.length;i++){
		if(childNodes[i].tagName == nodeName){
			return childNodes[i];
		}
	}
	return null;
}
//根据节点名字和类型添加节点
function addXmlNodeByName(nodeType,nodeName,parentNode){
	if(parentNode == null)
		parentNode = xml.documentElement;
	
	switch(nodeType){
		case "swimlane":
			var newNode = xml.createElement(nodeType);
			parentNode.appendChild(newNode);
			addXmlAttribute(newNode,"name",nodeName);
			
			var groups = "";
			var groupIds = "";
			if(!Ext.getCmp("swimlaneUserBox").disabled){
				addXmlAttribute(newNode,"candidate-users",Ext.getCmp("swimlaneUserIdBox").getValue());
				addXmlAttribute(newNode,"users",Ext.getCmp("swimlaneUserBox").getValue());
			}
			if(!Ext.getCmp("swimlaneRoleBox").disabled){
				groups += Ext.getCmp("swimlaneRoleBox").getValue()==""?"":Ext.getCmp("swimlaneRoleBox").getValue();
				groupIds += Ext.getCmp("swimlaneRoleIdBox").getValue()==""?"":Ext.getCmp("swimlaneRoleIdBox").getValue();
				addXmlAttribute(newNode,"candidate-roles",Ext.getCmp("swimlaneRoleIdBox").getValue());
				addXmlAttribute(newNode,"roles",Ext.getCmp("swimlaneRoleBox").getValue());
			}
			if(groups != ""&&!Ext.getCmp("swimlaneDeptBox").disabled&&Ext.getCmp("swimlaneDeptBox").getValue()!=""){
				groups += ",";
				groupIds += ",";
			}
			if(!Ext.getCmp("swimlaneDeptBox").disabled){
				groups += Ext.getCmp("swimlaneDeptBox").getValue()==""?"":Ext.getCmp("swimlaneDeptBox").getValue();
				groupIds += Ext.getCmp("swimlaneDeptIdBox").getValue()==""?"":Ext.getCmp("swimlaneDeptIdBox").getValue();
				addXmlAttribute(newNode,"candidate-depts",Ext.getCmp("swimlaneDeptIdBox").getValue());
				addXmlAttribute(newNode,"depts",Ext.getCmp("swimlaneDeptBox").getValue());
			}	
			if(groups != "")
				addXmlAttribute(newNode,"candidate-groups",groupIds);
			break
		case "mailto":
			var eventNode = null;//新增的监听节点或者已存在的监听节点
			if(parentNode.tagName != "transition"){
				var eventNodes = xml.getElementsByTagName("on");
//			if(parentNode.tagName == "process"){
//				for(var i=0;i<eventNodes.length;i++){
//					//监听节点是流程节点的直接子节点
//					if(eventNodes[i].getAttribute("event")==Ext.getCmp("mailtoCaseTypeBox").getValue()&&eventNodes[i].parentNode==parentNode){
//						eventNode = eventNodes[i];
//					}
//				}
//				if(eventNode == null){
//					eventNode = xml.createElement("on");
//					parentNode.appendChild(eventNode);
//					addXmlAttribute(eventNode,"event",Ext.getCmp("mailtoCaseTypeBox").getValue());
//				}
//			}else{
				for(var i=0;i<eventNodes.length;i++){
					//监听节点是当前选中节点的子节点
					if(eventNodes[i].getAttribute("event")==Ext.getCmp("mailtoCaseTypeBox").getValue()&&eventNodes[i].parentNode==parentNode){
						eventNode = eventNodes[i];
						break;
					}
				}
				if(eventNode == null){
					eventNode = xml.createElement("on");
					parentNode.appendChild(eventNode);
					addXmlAttribute(eventNode,"event",Ext.getCmp("mailtoCaseTypeBox").getValue());
				}
			}else{
				eventNode = parentNode;
			}
//			}
			var event_listener = xml.createElement("event-listener");
			event_listener.setAttribute("name",nodeName);
			event_listener.setAttribute("type",nodeType);
			event_listener.setAttribute("class","com.huateng.sys.jbpm.listener.MailListener");
			eventNode.appendChild(event_listener);
			//添加发送用户变量
			if(!Ext.getCmp("mailtoUserBox").disabled&&Ext.getCmp("mailtoUserBox").getValue() != ""){
				addEventXmlNode(event_listener,"mail_user","mailtoUserIdBox","mailtoUserBox");
			}
			//添加发送角色变量
			if(!Ext.getCmp("mailtoRoleBox").disabled&&Ext.getCmp("mailtoRoleBox").getValue() != ""){
				addEventXmlNode(event_listener,"mail_role","mailtoRoleIdBox","mailtoRoleBox");
			}
			//添加发送部门变量
			if(!Ext.getCmp("mailtoDeptBox").disabled&&Ext.getCmp("mailtoDeptBox").getValue() != ""){
				addEventXmlNode(event_listener,"mail_dept","mailtoDeptIdBox","mailtoDeptBox");
			}
			//添加发送外部邮件地址变量
			if(!Ext.getCmp("mailtoAddressBox").disabled&&Ext.getCmp("mailtoAddressBox").getValue() != ""){
				addEventXmlNode(event_listener,"mail_address","mailtoAddressBox");
			}
			//添加邮件标题变量
			if(Ext.getCmp("mailtoTitleBox").getValue() != ""){
				addEventXmlNode(event_listener,"mail_title","mailtoTitleBox");
			}
			//添加邮件内容变量
			if(Ext.getCmp("mailtoContentBox").getValue() != ""){
				addEventXmlNode(event_listener,"mail_content","mailtoContentBox");
			}
			//添加流程发起者变量
			if(!Ext.getCmp("mailtoSponsorCombo").disabled){
				addEventXmlNode(event_listener,"process_sponsor","mailtoSponsorCombo");
			}
			//添加流程执行者变量
			if(!Ext.getCmp("mailtoExecutorCombo").disabled){
				addEventXmlNode(event_listener,"process_executor","mailtoExecutorCombo");
				if(!Ext.getCmp("mailtoExecutorAreaCombo").disabled){
					if(Ext.getCmp("mailtoExecutorAreaCombo").getValue() != "")
						addEventXmlNode(event_listener,"process_executor_area","mailtoExecutorAreaCombo");
				}
			}
			break
		case "notice":
			var eventNode = null;//新增的监听节点或者已存在的监听节点
			if(parentNode.tagName != "transition"){
				var eventNodes = xml.getElementsByTagName("on");
				for(var i=0;i<eventNodes.length;i++){
					//监听节点是当前选中节点的子节点
					if(eventNodes[i].getAttribute("event")==Ext.getCmp("noticeCaseTypeCombo").getValue()&&eventNodes[i].parentNode==parentNode){
						eventNode = eventNodes[i];
						break;
					}
				}
				if(eventNode == null){
					eventNode = xml.createElement("on");
					parentNode.appendChild(eventNode);
					addXmlAttribute(eventNode,"event",Ext.getCmp("noticeCaseTypeCombo").getValue());
				}
			}else{
				eventNode = parentNode;
			}
			var event_listener = xml.createElement("event-listener");
			event_listener.setAttribute("name",nodeName);
			event_listener.setAttribute("type",nodeType);
			event_listener.setAttribute("class","com.huateng.sys.jbpm.listener.NoticeListener");
			eventNode.appendChild(event_listener);
			//添加发送用户变量
			if(!Ext.getCmp("noticeUserBox").disabled&&Ext.getCmp("noticeUserBox").getValue() != ""){
				addEventXmlNode(event_listener,"notice_user","noticeUserIdBox","noticeUserBox");
			}
			//添加发送角色变量
			if(!Ext.getCmp("noticeRoleBox").disabled&&Ext.getCmp("noticeRoleBox").getValue() != ""){
				addEventXmlNode(event_listener,"notice_role","noticeRoleIdBox","noticeRoleBox");
			}
			//添加发送部门变量
			if(!Ext.getCmp("noticeDeptBox").disabled&&Ext.getCmp("noticeDeptBox").getValue() != ""){
				addEventXmlNode(event_listener,"notice_dept","noticeDeptIdBox","noticeDeptBox");
			}
			//添加邮件内容变量
			if(Ext.getCmp("noticeContentBox").getValue() != ""){
				addEventXmlNode(event_listener,"notice_content","noticeContentBox");
			}
			//添加流程发起者变量
			if(!Ext.getCmp("noticeSponsorCombo").disabled){
				addEventXmlNode(event_listener,"process_sponsor","noticeSponsorCombo");
			}
			//添加流程执行者变量
			if(!Ext.getCmp("noticeExecutorCombo").disabled){
				addEventXmlNode(event_listener,"process_executor","noticeExecutorCombo");
				if(!Ext.getCmp("noticeExecutorAreaCombo").disabled){
					if(Ext.getCmp("noticeExecutorAreaCombo").getValue() != "")
						addEventXmlNode(event_listener,"process_executor_area","noticeExecutorAreaCombo");
				}
			}
			break
		case "sql":
			var eventNode = null;//新增的监听节点或者已存在的监听节点
			if(parentNode.tagName != "transition"){
				var eventNodes = xml.getElementsByTagName("on");
				for(var i=0;i<eventNodes.length;i++){
					//监听节点是当前选中节点的子节点
					if(eventNodes[i].getAttribute("event")==Ext.getCmp("sqlCaseTypeCombo").getValue()&&eventNodes[i].parentNode==parentNode){
						eventNode = eventNodes[i];
						break;
					}
				}
				if(eventNode == null){
					eventNode = xml.createElement("on");
					parentNode.appendChild(eventNode);
					addXmlAttribute(eventNode,"event",Ext.getCmp("sqlCaseTypeCombo").getValue());
				}
			}else{
				eventNode = parentNode;
			}
			var event_listener = xml.createElement("event-listener");
			event_listener.setAttribute("name",nodeName);
			event_listener.setAttribute("type",nodeType);
			event_listener.setAttribute("class","com.huateng.sys.jbpm.listener.SqlListener");
			eventNode.appendChild(event_listener);
			//添加SQL脚本变量
			if(Ext.getCmp("sqlScriptBox").getValue() != ""){
				addEventXmlNode(event_listener,"sql_script","sqlScriptBox");
			}
			//添加脚本类型及变量名称变量
			if(Ext.getCmp("sqlScriptTypeCombo").getValue() != ""){
				if(Ext.getCmp("sqlVarNameBox").disabled)
					Ext.getCmp("sqlVarNameBox").setValue("");
				addEventXmlNode(event_listener,"sql_var","sqlVarNameBox","sqlScriptTypeCombo");
			}
			break
		case "autoDelegate":
			var eventNode = null;//新增的监听节点或者已存在的监听节点
			var eventNodes = xml.getElementsByTagName("on");
			for(var i=0;i<eventNodes.length;i++){
				//监听节点是当前选中节点的子节点
				if(eventNodes[i].getAttribute("event")=="start"&&eventNodes[i].parentNode==parentNode){
					eventNode = eventNodes[i];
					break;
				}
			}
			if(eventNode == null){
				eventNode = xml.createElement("on");
				parentNode.appendChild(eventNode);
				addXmlAttribute(eventNode,"event","start");
			}
			var event_listener = xml.createElement("event-listener");
			event_listener.setAttribute("name",nodeName);
			event_listener.setAttribute("type",nodeType);
			event_listener.setAttribute("title",presrc.id);
			event_listener.setAttribute("class","com.huateng.sys.jbpm.listener.AutoDelegateListener");
			nodeField = addEventXmlNode(event_listener,"transition","baseName",null);
			eventNode.appendChild(event_listener);
			break
		default:
	}
}

//------------  属性表单操作   -----------
//重置表单
function formClear(formId){
	Ext.getCmp(formId).getForm().getEl().dom.reset();
}
//为表单赋值
function formFill(type){
	var node = findXmlNodeByName(type,Ext.getDom(currentTreeNode).title);
	switch(type){
		case "swimlane":
			Ext.getCmp("swimlaneDescriptionBox").setValue(node.getAttribute("name"));
			Ext.getCmp("swimlaneUserBox").setValue(node.getAttribute("users"));
			Ext.getCmp("swimlaneRoleBox").setValue(node.getAttribute("roles"));
			Ext.getCmp("swimlaneDeptBox").setValue(node.getAttribute("depts"));
			Ext.getCmp("swimlaneUserIdBox").setValue(node.getAttribute("candidate-users"));
			Ext.getCmp("swimlaneRoleIdBox").setValue(node.getAttribute("candidate-roles"));
			Ext.getCmp("swimlaneDeptIdBox").setValue(node.getAttribute("candidate-depts"));
			if(node.getAttribute("candidate-users")!=""&&node.getAttribute("candidate-users")!=null){
				partDisableOrEnable("swimlaneUserCheck","swimlaneUserBox","enable");
			}else{
				partDisableOrEnable("swimlaneUserCheck","swimlaneUserBox","disable");
			}
			if(node.getAttribute("candidate-roles")!=""&&node.getAttribute("candidate-roles")!=null){
				partDisableOrEnable("swimlaneRoleCheck","swimlaneRoleBox","enable");
			}else{
				partDisableOrEnable("swimlaneRoleCheck","swimlaneRoleBox","disable");
			}
			if(node.getAttribute("candidate-depts")!=""&&node.getAttribute("candidate-depts")!=null){
				partDisableOrEnable("swimlaneDeptCheck","swimlaneDeptBox","enable");
			}else{
				partDisableOrEnable("swimlaneDeptCheck","swimlaneDeptBox","disable");
			}
			break
		case "mailto":
			node = findXmlNodeByName("event-listener",Ext.getDom(currentTreeNode).title,type);
			Ext.getCmp("mailtoDescriptionBox").setValue(node.getAttribute("name"));
			//当节点为transition时不需要设置事件类型
			if(xmlNode.tagName != "transition"){
				Ext.getCmp("mailtoCaseTypeBox").setValue(node.parentNode.getAttribute("event"));
			}else{
				Ext.getCmp("mailtoCaseTypeBox").setValue("");
			}
			var mailtoFields = ["mail_user","mail_role","mail_dept","mail_address","mail_title","mail_content"];
			var fieldNode = null;
			fieldNode = findXmlAreaValueByName(node,mailtoFields[0]);
			Ext.getCmp("mailtoUserBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("name"):"");
			Ext.getCmp("mailtoUserIdBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
			fieldNode = findXmlAreaValueByName(node,mailtoFields[1]);
			Ext.getCmp("mailtoRoleBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("name"):"");
			Ext.getCmp("mailtoRoleIdBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
			fieldNode = findXmlAreaValueByName(node,mailtoFields[2]);
			Ext.getCmp("mailtoDeptBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("name"):"");
			Ext.getCmp("mailtoDeptIdBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
			fieldNode = findXmlAreaValueByName(node,mailtoFields[3]);
			Ext.getCmp("mailtoAddressBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
			fieldNode = findXmlAreaValueByName(node,mailtoFields[4]);
			Ext.getCmp("mailtoTitleBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
			fieldNode = findXmlAreaValueByName(node,mailtoFields[5]);
			Ext.getCmp("mailtoContentBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
			if(findXmlAreaValueByName(node,"mail_user") != null){
				partDisableOrEnable("mailtoUserCheck","mailtoUserBox","enable");
			}else{
				partDisableOrEnable("mailtoUserCheck","mailtoUserBox","disable");
			}
			if(findXmlAreaValueByName(node,"mail_role") != null){
				partDisableOrEnable("mailtoRoleCheck","mailtoRoleBox","enable");
			}else{
				partDisableOrEnable("mailtoRoleCheck","mailtoRoleBox","disable");
			}
			if(findXmlAreaValueByName(node,"mail_dept") != null){
				partDisableOrEnable("mailtoDeptCheck","mailtoDeptBox","enable");
			}else{
				partDisableOrEnable("mailtoDeptCheck","mailtoDeptBox","disable");
			}
			if(findXmlAreaValueByName(node,"mail_address") != null){
				partDisableOrEnable("mailtoAddressCheck","mailtoAddressBox","enable");
			}else{
				partDisableOrEnable("mailtoAddressCheck","mailtoAddressBox","disable");
			}
			//任务发起者与执行者
			fieldNode = findXmlAreaValueByName(node,"process_sponsor");
			Ext.getCmp("mailtoSponsorCombo").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"include");
			fieldNode = findXmlAreaValueByName(node,"process_executor");
			Ext.getCmp("mailtoExecutorCombo").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"include");
			fieldNode = findXmlAreaValueByName(node,"process_executor_area");
			Ext.getCmp("mailtoExecutorTypeCombo").setValue(fieldNode?"one":"all");
			if(findXmlAreaValueByName(node,"process_sponsor") != null){
				partDisableOrEnable("mailtoSponsorCheck","mailtoSponsorCombo","enable");
				Ext.getCmp("mailtoExecutorTypeCombo").enable();
			}else{
				partDisableOrEnable("mailtoSponsorCheck","mailtoSponsorCombo","disable");
			}
			if(findXmlAreaValueByName(node,"process_executor") != null){
				partDisableOrEnable("mailtoExecutorCheck","mailtoExecutorCombo","enable");
				if(findXmlAreaValueByName(node,"process_executor_area") != null){
					Ext.getCmp("mailtoExecutorTypeCombo").enable();
					Ext.getCmp("mailtoExecutorAreaCombo").enable();
					Ext.getCmp("mailtoExecutorAreaCombo").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
				}else{
					Ext.getCmp("mailtoExecutorAreaCombo").disable();
				}
			}else{
				partDisableOrEnable("mailtoExecutorCheck","mailtoExecutorCombo","disable");
				Ext.getCmp("mailtoExecutorTypeCombo").disable();
				Ext.getCmp("mailtoExecutorAreaCombo").disable();
			}
			break
		case "notice":
			node = findXmlNodeByName("event-listener",Ext.getDom(currentTreeNode).title,type);
			Ext.getCmp("noticeDescriptionBox").setValue(node.getAttribute("name"));
			//当节点为transition时不需要设置事件类型
			if(xmlNode.tagName != "transition"){
				Ext.getCmp("noticeCaseTypeCombo").setValue(node.parentNode.getAttribute("event"));
			}else{
				Ext.getCmp("noticeCaseTypeCombo").setValue("");
			}
			var noticeFields = ["notice_user","notice_role","notice_dept","notice_content"];
			var fieldNode = null;
			fieldNode = findXmlAreaValueByName(node,noticeFields[0]);
			Ext.getCmp("noticeUserBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("name"):"");
			Ext.getCmp("noticeUserIdBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
			fieldNode = findXmlAreaValueByName(node,noticeFields[1]);
			Ext.getCmp("noticeRoleBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("name"):"");
			Ext.getCmp("noticeRoleIdBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
			fieldNode = findXmlAreaValueByName(node,noticeFields[2]);
			Ext.getCmp("noticeDeptBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("name"):"");
			Ext.getCmp("noticeDeptIdBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
			fieldNode = findXmlAreaValueByName(node,noticeFields[3]);
			Ext.getCmp("noticeContentBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
			if(findXmlAreaValueByName(node,"notice_user") != null){
				partDisableOrEnable("noticeUserCheck","noticeUserBox","enable");
			}else{
				partDisableOrEnable("noticeUserCheck","noticeUserBox","disable");
			}
			if(findXmlAreaValueByName(node,"notice_role") != null){
				partDisableOrEnable("noticeRoleCheck","noticeRoleBox","enable");
			}else{
				partDisableOrEnable("noticeRoleCheck","noticeRoleBox","disable");
			}
			if(findXmlAreaValueByName(node,"notice_dept") != null){
				partDisableOrEnable("noticeDeptCheck","noticeDeptBox","enable");
			}else{
				partDisableOrEnable("noticeDeptCheck","noticeDeptBox","disable");
			}
			//任务发起者与执行者
			fieldNode = findXmlAreaValueByName(node,"process_sponsor");
			Ext.getCmp("noticeSponsorCombo").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"include");
			fieldNode = findXmlAreaValueByName(node,"process_executor");
			Ext.getCmp("noticeExecutorCombo").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"include");
			fieldNode = findXmlAreaValueByName(node,"process_executor_area");
			Ext.getCmp("noticeExecutorTypeCombo").setValue(fieldNode?"one":"all");
			if(findXmlAreaValueByName(node,"process_sponsor") != null){
				partDisableOrEnable("noticeSponsorCheck","noticeSponsorCombo","enable");
				Ext.getCmp("noticeExecutorTypeCombo").enable();
			}else{
				partDisableOrEnable("noticeSponsorCheck","noticeSponsorCombo","disable");
			}
			if(findXmlAreaValueByName(node,"process_executor") != null){
				partDisableOrEnable("noticeExecutorCheck","noticeExecutorCombo","enable");
				if(findXmlAreaValueByName(node,"process_executor_area") != null){
					Ext.getCmp("noticeExecutorTypeCombo").enable();
					Ext.getCmp("noticeExecutorAreaCombo").enable();
					Ext.getCmp("noticeExecutorAreaCombo").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
				}else{
					Ext.getCmp("noticeExecutorAreaCombo").disable();
				}
			}else{
				partDisableOrEnable("noticeExecutorCheck","noticeExecutorCombo","disable");
				Ext.getCmp("noticeExecutorTypeCombo").disable();
				Ext.getCmp("noticeExecutorAreaCombo").disable();
			}
			break
		case "sql":
			node = findXmlNodeByName("event-listener",Ext.getDom(currentTreeNode).title,type);
			Ext.getCmp("sqlDescriptionBox").setValue(node.getAttribute("name"));
			//当节点为transition时不需要设置事件类型
			if(xmlNode.tagName != "transition"){
				Ext.getCmp("sqlCaseTypeCombo").setValue(node.parentNode.getAttribute("event"));
			}else{
				Ext.getCmp("sqlCaseTypeCombo").setValue("");
			}
			var fieldNode = null;
			fieldNode = findXmlAreaValueByName(node,"sql_script");
			Ext.getCmp("sqlScriptBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
			fieldNode = findXmlAreaValueByName(node,"sql_var");
			Ext.getCmp("sqlScriptTypeCombo").setValue(fieldNode?fieldNode.firstChild.getAttribute("name"):"");
			Ext.getCmp("sqlVarNameBox").setValue(fieldNode?fieldNode.firstChild.getAttribute("value"):"");
			if(fieldNode != null){
				if(fieldNode.firstChild.getAttribute("value") != "")
					Ext.getCmp("sqlVarNameBox").enable();
				else
					Ext.getCmp("sqlVarNameBox").disable();
			}
			break
		default:
	}
}
//添加树列表
function addTreeList(tree,id,title,type){
	var treeNode = "<div title='" + title + "'"
	+" id='" + id + "' class='" + type + "_btn'>"
	+"<span class='icon_" + type + "'>" + title
	+"</span></div>";
	tree.innerHTML += treeNode;
	//注册事件
	Ext.get(Ext.DomQuery.select("."+type+"_btn")).on("click",function(){
		//即使选中了仍然可以点击
		//if(!Ext.fly(this).hasClass(type+"_btn_down")){
			Ext.get(Ext.DomQuery.select("."+type+"_btn_down")).removeClass(type+"_btn_down");
			Ext.fly(this).addClass(type+"_btn_down");
			currentTreeNode = this.id;
			formFill(type);
		//}
	});
}

//------------	属性操作   -------------
//根据属性按钮转换card布局面板
function changeCard(){
	var currentCard = Ext.getCmp(currentParam);
	if(currentCard == null){
		switch(currentParam){
			case "sql":
				currentCard = new Ext.form.FormPanel({
					id: currentParam,
					border: false,
					bodyStyle: {background:"#dfe7f4",padding:"10 0 0 20"},
					labelAlign: 'left',
					items: [{
						layout: 'column',
						border: false,
						bodyStyle: {background:"#dfe7f4"},
						items: [{
							layout: 'fit',
							width: 180,
							height: 350,
							border: false,
							items: [{
								xtype: 'panel',
								id: 'sqlListPanel',
								html: '<div class="panel_list" id="sqlList"></div>',
								tbar: new Ext.Toolbar({
									height: 31,
									border: false,
									items: [
										'->',
										{text: '&nbsp;添加',iconCls: 'picon23',handler: function(){
											if(Ext.getCmp("sqlDescriptionBox").getValue() == ""){
												Ext.MessageBox.alert(htTip,'SQL描述不能为空！');
												return false;
											}
											//通过节点类型、名字以及监听类型查找节点
											if(findXmlNodeByName("event-listener",Ext.getCmp("sqlDescriptionBox").getValue(),"sql") != null){
												Ext.MessageBox.alert(htTip,'SQL描述不能重复！');
												return false;
											}
											if(xmlNode.tagName !="transition"&&Ext.getCmp("sqlCaseTypeCombo").getValue() == ""){
												Ext.MessageBox.alert(htTip,'事件类型不能为空！');
												return false;
											}
											//添加SQL节点
											addXmlNodeByName("sql",Ext.getCmp("sqlDescriptionBox").getValue(),xmlNode);
											//移除事件
											Ext.get(Ext.DomQuery.select(".sql_btn")).un("click");
											//添加树列表
											var sqlId = "Q" + sqlNum;
											sqlNum ++;
											addTreeList(Ext.getDom("sqlList"),sqlId,Ext.getCmp("sqlDescriptionBox").getValue(),"sql");
											//触发事件
											Ext.getDom(sqlId).fireEvent('onclick');
										}},'-',
										{text: '&nbsp;删除',iconCls: 'picon13',handler: function(){
											var node = deleteXmlNodeByType("event-listener","sql");
											if(node != null&&node.childNodes.length == 0)
												node.parentNode.removeChild(node);
										}}
									]
								})
							}]
						},{
							border: false,
							bodyStyle: {background:"#dfe7f4",padding:"0 0 0 10"},
							items: [{
								layout: 'form',
								defaultType: 'textfield',
								labelWidth: 80,
								defaults: {width: '85%'},
								border: false,
								bodyStyle: {background:"#dfe7f4"},
								items: [{
									id: 'sqlDescriptionBox',
									fieldLabel: 'SQL描述',
									enableKeyEvents: true,
									listeners: {
										'keyup' : function(e){
											var node = findXmlNodeByName("event-listener",e.getValue(),"sql");
											if(node != null){
												var treeNodes = Ext.DomQuery.select("div[title="+e.getValue()+"]");
												for(var i=0;i<treeNodes.length;i++){
													if(Ext.fly(treeNodes[i]).hasClass("sql_btn")){
														treeNodes[i].fireEvent("onclick");
														break;
													}
												}
											}
										}
									}
								},{
									xtype: 'combo',
									fieldLabel: '事件类型',
									id: 'sqlCaseTypeCombo',
									width: 100,
									valueField: 'value',
									emptyText: '请选择',
									displayField: 'text',
									triggerAction: 'all',
									editable: false,
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data:[
											['start','流程开始'],
											['end','流程结束']								
										]
									}),
									listeners: {
										"select" : function(e){
											var node = findXmlNodeByName("event-listener",Ext.getCmp("sqlDescriptionBox").getValue(),"sql");
											if(node != null){
												if(xmlNode != null&&xmlNode.tagName == "transition") return false;
												if(e.getValue() != node.parentNode.getAttribute("event")){
													var eventNodes = xml.getElementsByTagName("on");
													var eventNode = null;//新增的监听节点或者已存在的监听节点
													var hisNode = node.parentNode;//事件节点的原始父节点
													for(var i=0;i<eventNodes.length;i++){
														if(eventNodes[i].getAttribute("event")==e.getValue()&&eventNodes[i].parentNode == xmlNode){
															eventNode = eventNodes[i];
															break;
														}
													}
													if(eventNode == null){
														eventNode = xml.createElement("on");
														xmlNode.appendChild(eventNode);
														eventNode.setAttribute("event",e.getValue());
													}
													eventNode.appendChild(node);
													//如果原始节点没有子节点，删除该节点
													if(hisNode.childNodes.length == 0){
														hisNode.parentNode.removeChild(hisNode);
													}
												}
											}
										}
									}
								}]	
							},{
								layout: 'column',
								border: false,
								bodyStyle: {background:"#dfe7f4"},
								labelWidth: 80,
								items: [{
									layout: 'form',
									border: false,
									bodyStyle: {background:"#dfe7f4"},
									width: 200,
									items: [{
										xtype: 'combo',
										fieldLabel: '脚本类型',
										id: 'sqlScriptTypeCombo',
										width: 100,
										editable: false,
										valueField: 'value',
										displayField: 'text',
										triggerAction: 'all',
										emptyText: '请选择',
										mode: 'local',
										store: new Ext.data.SimpleStore({
											fields: ['value','text'],
											data:[
												['query','查询'],
												['update','更新'],
												['delete','删除']
											]
										}),
										listeners: {
											"select" : function(e){
												if(e.getValue() == "query")
													Ext.getCmp("sqlVarNameBox").enable();
												else
													Ext.getCmp("sqlVarNameBox").disable();
												var node = findXmlNodeByName("event-listener",Ext.getCmp("sqlDescriptionBox").getValue(),"sql");
												if(node != null){	
													var nodeField = findXmlAreaValueByName(node,"sql_var");
													if(nodeField == null){
														if(Ext.getCmp("sqlVarNameBox").disabled)
															Ext.getCmp("sqlVarNameBox").setValue("");
														addEventXmlNode(node,"sql_var","sqlVarNameBox","sqlScriptTypeCombo");
													}else{
														nodeField.firstChild.setAttribute("name",e.getValue());
														if(!Ext.getCmp("sqlVarNameBox").disabled&&Ext.getCmp("sqlVarNameBox").getValue()!="")
															nodeField.firstChild.setAttribute("value",Ext.getCmp("sqlVarNameBox").getValue());
														else
															nodeField.firstChild.setAttribute("value","");
													}
												}
											}
										}
									}]
								},{
									layout: 'form',	
									border: false,
									width: 300,
									labelWidth: 55,
									bodyStyle: {background:"#dfe7f4"},
									items: [{
										id: 'sqlVarNameBox',
										xtype: 'textfield',
										width: 200,
										fieldLabel: '变量名称',
										disabled: true,
										enableKeyEvents: true,
										listeners: {
											'keyup' : function(e){
												var node = findXmlNodeByName("event-listener",Ext.getCmp("sqlDescriptionBox").getValue(),"sql");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"sql_var");
													if(nodeField != null){
														nodeField.firstChild.setAttribute("value",e.getValue());
													}
												}
											}
										}
									}]
								}]					
							},{
								layout: 'form',
								border: false,
								labelWidth: 80,
								bodyStyle: {background:"#dfe7f4"},
								items: [{
									id: 'sqlScriptBox',
									xtype: 'textarea',
									fieldLabel: '脚本',
									width: '85%',
									enableKeyEvents: true,
									listeners: {
										'keyup' : function(e){
											var node = findXmlNodeByName("event-listener",Ext.getCmp("sqlDescriptionBox").getValue(),"sql");
											if(node != null){
												var nodeField = findXmlAreaValueByName(node,"sql_script");
												if(nodeField == null){
													addEventXmlNode(node,"sql_script","sqlScriptBox");
												}else{
													nodeField.firstChild.setAttribute("value",e.getValue());
													if(e.getValue() == "")
														node.removeChild(nodeField);
												}
											}
										}
									}
								}]			
							},{
								layout: 'fit',
								border: false,
								bodyStyle: {background:"#dfe7f4",padding:"0 0 0 88"},
								items: [{
									xtype: 'panel',
									border: false,
									height: 16,
									bodyStyle: {background:"#dfe7f4"},
									html: '<span title="添加参数" style="margin-top:0;" class="img_btn picon23" />'
								}]
							},{
								layout: 'column',
								border: false,
								bodyStyle: {background:"#dfe7f4",padding:"0 0 0 88"},
								items: [{
									layout: 'form',
									border: false,
									width: 20,
									items: [{
										xtype: 'panel',
										border: false,
										height: 20,
										bodyStyle: {background:"#dfe7f4"},
										html: '<span title="删除参数" style="margin-top:4;" class="img_btn picon13" />'
									}]
								},{
									layout: 'form',
									border: false,
									width: 175,
									bodyStyle: {background:"#dfe7f4"},
									labelWidth: 55,
									defaultType: 'textfield',
									items: [{
										id: 'sqlParamNameBox1',
										fieldLabel: '参数名称',
										width: 100
									}]
								},{
									layout: 'form',
									border: false,
									width: 175,
									bodyStyle: {background:"#dfe7f4"},
									labelWidth: 55,
									defaultType: 'combo',
									items: [{
										fieldLabel: '参数类型',
										id: 'sqlParamTypeCombo1',
										width: 100,
										editable: false,
										valueField: 'value',
										displayField: 'text',
										triggerAction: 'all',
										emptyText: '请选择',
										mode: 'local',
										store: new Ext.data.SimpleStore({
											fields: ['value','text'],
											data:[
												['1','字符串'],
												['2','数字型'],
												['3','浮点型'],
												['4','布尔型']
											]
										})
									}]
								},{
									layout: 'form',
									border: false,
									width: 165,
									bodyStyle: {background:"#dfe7f4"},
									labelWidth: 45,
									defaultType: 'textfield',
									items: [{
										id: 'sqlParamValueBox1',
										fieldLabel: '参数值',
										width: 100
									}]				
								},{
									layout: 'form',
									border: false,
									width: 20,
									items: [{
										xtype: 'panel',
										border: false,
										height: 22,
										bodyStyle: {background:"#dfe7f4"},
										html: '<span title="引用变量" style="margin-top:4;" class="img_btn picon22" />'
									}]			
								}]			
							}]	
						}]
					}]
				});
				break
			case "swimlane":
				currentCard = new Ext.form.FormPanel({
					id: currentParam,
					border: false,
					bodyStyle: {background:"#dfe7f4",padding:"10 0 0 20"},
					labelAlign: 'left',									
					items: [{
						layout: 'column',
						border: false,
						bodyStyle: {background:"#dfe7f4"},
						items: [{
							layout: 'fit',
							width: 180,
							height: 350,
							border: false,
							items: [{
								xtype: 'panel',
								id: 'swimlaneListPanel',
								html: '<div class="panel_list" id="swimlaneList"></div>',
								tbar: new Ext.Toolbar({
									height: 31,
									border: false,
									items: [
										'->',
										{text: '&nbsp;添加',iconCls: 'picon23',handler: function(){
											if(Ext.getCmp("swimlaneDescriptionBox").getValue() == ""){
												Ext.MessageBox.alert(htTip,'泳道描述不能为空！');
												return false;
											}
											if(findXmlNodeByName("swimlane",Ext.getCmp("swimlaneDescriptionBox").getValue()) != null){
												Ext.MessageBox.alert(htTip,'泳道描述不能重复！');
												return false;
											}
											//添加泳道节点
											addXmlNodeByName("swimlane",Ext.getCmp("swimlaneDescriptionBox").getValue());
											//移除事件
											Ext.get(Ext.DomQuery.select(".swimlane_btn")).un("click");
											//添加树列表
											var swimlineId = "S" + swimlaneNum;
											swimlaneNum ++;
											addTreeList(Ext.getDom("swimlaneList"),swimlineId,Ext.getCmp("swimlaneDescriptionBox").getValue(),"swimlane");
											//触发事件
											Ext.getDom(swimlineId).fireEvent('onclick');
									}},'-',
										{text: '&nbsp;删除',iconCls: 'picon13',handler: function(){
											deleteXmlNodeByType("swimlane");		
									}}
									]
								})
							}]
						},{
							border: false,
							bodyStyle: {background:"#dfe7f4",padding:"0 0 0 10"},
							items: [{
								layout: 'form',
								bodyStyle: {background:"#dfe7f4"},
								border: false,
								labelWidth: 80,
								items: [{
									id: 'swimlaneDescriptionBox',
									xtype: 'textfield',
									width: '85%',
									fieldLabel: '泳道描述',
									enableKeyEvents: true,
									listeners: {
										'keyup' : function(e){
											var node = findXmlNodeByName("swimlane",e.getValue());
											if(node != null){
												var treeNodes = Ext.DomQuery.select("div[title="+e.getValue()+"]");
												for(var i=0;i<treeNodes.length;i++){
													if(Ext.fly(treeNodes[i]).hasClass("swimlane_btn")){
														treeNodes[i].fireEvent("onclick");
														break;
													}
												}
											}
										}
									}
								}]
							},{
								bodyStyle: {background:"#dfe7f4"},
								border: false,
								layout: 'column',	
								items: [{
									width: 135,
									labelWidth: 80,
									border: false,
									layout: 'form',
									defaults: {height: 22},
									bodyStyle: {background:"#dfe7f4"},
									defaultType: 'checkbox',
									items: [{
										boxLabel: '用户',
										fieldLabel: '参与者',
										id: 'swimlaneUserCheck',
										listeners: {
											"check": function(){
												Ext.getCmp("swimlaneUserBox").disabled?Ext.getCmp("swimlaneUserBox").enable():Ext.getCmp("swimlaneUserBox").disable();
												var node = findXmlNodeByName("swimlane",Ext.getCmp("swimlaneDescriptionBox").getValue());
												if(node != null){
													if(Ext.getCmp("swimlaneUserBox").disabled){
														node.removeAttribute("candidate-users");
														node.removeAttribute("users");
													}else{
														if(Ext.getCmp("swimlaneUserBox").getValue() != ""){
															node.setAttribute("candidate-users",Ext.getCmp("swimlaneUserIdBox").getValue());
															node.setAttribute("users",Ext.getCmp("swimlaneUserBox").getValue());
														}
													}
												}
											}
										}	
									},{
										boxLabel: '角色',
										id: 'swimlaneRoleCheck',
										listeners: {
											"check": function(){
												Ext.getCmp("swimlaneRoleBox").disabled?Ext.getCmp("swimlaneRoleBox").enable():Ext.getCmp("swimlaneRoleBox").disable();
												var node = findXmlNodeByName("swimlane",Ext.getCmp("swimlaneDescriptionBox").getValue());
												if(node != null){
													if(Ext.getCmp("swimlaneRoleBox").disabled){
														node.removeAttribute("candidate-roles");
														node.removeAttribute("roles");
														node.setAttribute("candidate-groups",Ext.getCmp("swimlaneDeptBox").disabled?"":Ext.getCmp("swimlaneDeptIdBox").getValue());
														if(node.getAttribute("candidate-groups") == "")
															node.removeAttribute("candidate-groups");
													}else{
														if(Ext.getCmp("swimlaneRoleBox").getValue() != ""){
															node.setAttribute("candidate-roles",Ext.getCmp("swimlaneRoleIdBox").getValue());
															node.setAttribute("roles",Ext.getCmp("swimlaneRoleBox").getValue());
															if(node.getAttribute("candidate-groups")!=""&&node.getAttribute("candidate-groups")!=null){
																node.setAttribute("candidate-groups",node.getAttribute("candidate-groups")+","+Ext.getCmp("swimlaneRoleIdBox").getValue());
															}else{
																node.setAttribute("candidate-groups",Ext.getCmp("swimlaneRoleIdBox").getValue());
															}
														}
													}
												}
											}
										}
									},{
										boxLabel: '部门',
										id: 'swimlaneDeptCheck',
										listeners: {
											"check": function(){
												Ext.getCmp("swimlaneDeptBox").disabled?Ext.getCmp("swimlaneDeptBox").enable():Ext.getCmp("swimlaneDeptBox").disable();
												var node = findXmlNodeByName("swimlane",Ext.getCmp("swimlaneDescriptionBox").getValue());
												if(node != null){
													if(Ext.getCmp("swimlaneDeptBox").disabled){
														node.removeAttribute("candidate-depts");
														node.removeAttribute("depts");
														node.setAttribute("candidate-groups",Ext.getCmp("swimlaneRoleBox").disabled?"":Ext.getCmp("swimlaneRoleIdBox").getValue());
														if(node.getAttribute("candidate-groups") == "")
															node.removeAttribute("candidate-groups");
													}else{
														if(Ext.getCmp("swimlaneRoleBox").getValue() != ""){
															node.setAttribute("candidate-depts",Ext.getCmp("swimlaneDeptIdBox").getValue());
															node.setAttribute("depts",Ext.getCmp("swimlaneDeptBox").getValue());
															if(node.getAttribute("candidate-groups")!=""&&node.getAttribute("candidate-groups")!=null){
																node.setAttribute("candidate-groups",node.getAttribute("candidate-groups")+","+Ext.getCmp("swimlaneDeptIdBox").getValue());
															}else{
																node.setAttribute("candidate-groups",Ext.getCmp("swimlaneDeptIdBox").getValue());
															}
														}
													}
												}
											}
										}
									}]
								},{
									layout: 'form',
									labelWidth: 10,
									bodyStyle: {background:"#dfe7f4"},
									border: false,
									defaults: {width: '83%'},
									items: [{
										xtype: 'textfield',
										id: 'swimlaneUserBox',
										readOnly: true,
										disabled: true,
										listeners: {
											'focus' : function(){
												selectUser(currentParam,currentParam+"UserBox",currentParam+"UserIdBox");
											}
										}
									},{
										xtype: 'textfield',
										id: 'swimlaneRoleBox',
										readOnly: true,
										disabled: true,
										listeners: {
											'focus' : function(){
												selectRole(currentParam,currentParam+"RoleBox",currentParam+"RoleIdBox");
											}
										}
									},{
										xtype: 'textfield',
										id: 'swimlaneDeptBox',
										readOnly: true,
										disabled: true,
										listeners: {
											'focus' : function(){
												selectDept(currentParam,currentParam+"DeptBox",currentParam+"DeptIdBox");
											}
										}
									},{
										xtype: 'hidden',
										id: 'swimlaneUserIdBox'
									},{
										xtype: 'hidden',
										id: 'swimlaneRoleIdBox'
									},{
										xtype: 'hidden',
										id: 'swimlaneDeptIdBox'
									}]			
								}]							
							}]
						}]
					}]
				});		
				break
			case "notice":
				currentCard = new Ext.form.FormPanel({
					id: currentParam,
					border: false,
					bodyStyle: {background:"#dfe7f4",padding:"10 0 0 20"},
					labelAlign: 'left',									
					items: [{
						layout: 'column',
						border: false,
						bodyStyle: {background:"#dfe7f4"},
						items: [{
							layout: 'fit',
							width: 180,
							height: 350,
							border: false,
							items: [{
								xtype: 'panel',
								id: 'noticeListPanel',
								html: '<div class="panel_list" id="noticeList"></div>',
								tbar: new Ext.Toolbar({
									height: 31,
									border: false,
									items: [
										'->',
										{text: '&nbsp;添加',iconCls: 'picon23',handler: function(){
											if(Ext.getCmp("noticeDescriptionBox").getValue() == ""){
												Ext.MessageBox.alert(htTip,'消息描述不能为空！');
												return false;
											}
											//通过节点类型、名字以及监听类型查找节点
											if(findXmlNodeByName("event-listener",Ext.getCmp("noticeDescriptionBox").getValue(),"notice") != null){
												Ext.MessageBox.alert(htTip,'消息描述不能重复！');
												return false;
											}
											if(xmlNode.tagName !="transition"&&Ext.getCmp("noticeCaseTypeCombo").getValue() == ""){
												Ext.MessageBox.alert(htTip,'事件类型不能为空！');
												return false;
											}
											//添加消息节点
											addXmlNodeByName("notice",Ext.getCmp("noticeDescriptionBox").getValue(),xmlNode);
											//移除事件
											Ext.get(Ext.DomQuery.select(".notice_btn")).un("click");
											//添加树列表
											var noticeId = "N" + noticeNum;
											noticeNum ++;
											addTreeList(Ext.getDom("noticeList"),noticeId,Ext.getCmp("noticeDescriptionBox").getValue(),"notice");
											//触发事件
											Ext.getDom(noticeId).fireEvent('onclick');
										}},'-',
										{text: '&nbsp;删除',iconCls: 'picon13',handler: function(){
											var node = deleteXmlNodeByType("event-listener","notice");
											if(node != null&&node.childNodes.length == 0)
												node.parentNode.removeChild(node);
										}}
									]
								})
							}]
						},{
							border: false,
							bodyStyle: {background:"#dfe7f4",padding:"0 0 0 10"},
							items: [{
								layout: 'form',
								bodyStyle: {background:"#dfe7f4"},
								border: false,
								labelWidth: 80,
								items: [{
									id: 'noticeDescriptionBox',
									xtype: 'textfield',
									width: '85%',
									fieldLabel: '消息描述',
									enableKeyEvents: true,
									listeners: {
										'keyup' : function(e){
											var node = findXmlNodeByName("event-listener",e.getValue(),"notice");
											if(node != null){
												var treeNodes = Ext.DomQuery.select("div[title="+e.getValue()+"]");
												for(var i=0;i<treeNodes.length;i++){
													if(Ext.fly(treeNodes[i]).hasClass("notice_btn")){
														treeNodes[i].fireEvent("onclick");
														break;
													}
												}
											}
										}
									}
								},{
									xtype: 'combo',
									fieldLabel: '事件类型',
									id: 'noticeCaseTypeCombo',
									width: 100,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data:[
											['start','流程开始'],
											['end','流程结束']								
										]
									}),
									listeners: {
										"select" : function(e){
											var node = findXmlNodeByName("event-listener",Ext.getCmp("noticeDescriptionBox").getValue(),"notice");
											if(node != null){
												if(xmlNode != null&&xmlNode.tagName == "transition") return false;
												if(e.getValue() != node.parentNode.getAttribute("event")){
													var eventNodes = xml.getElementsByTagName("on");
													var eventNode = null;//新增的监听节点或者已存在的监听节点
													var hisNode = node.parentNode;//事件节点的原始父节点
													for(var i=0;i<eventNodes.length;i++){
														if(eventNodes[i].getAttribute("event")==e.getValue()&&eventNodes[i].parentNode == xmlNode){
															eventNode = eventNodes[i];
															break;
														}
													}
													if(eventNode == null){
														eventNode = xml.createElement("on");
														xmlNode.appendChild(eventNode);
														eventNode.setAttribute("event",e.getValue());
													}
													eventNode.appendChild(node);
													//如果原始节点没有子节点，删除该节点
													if(hisNode.childNodes.length == 0){
														hisNode.parentNode.removeChild(hisNode);
													}
												}
											}
										}
									}
								}]
							},{
								bodyStyle: {background:"#dfe7f4"},
								border: false,
								layout: 'column',	
								items: [{
									width: 170,
									labelWidth: 80,
									border: false,
									layout: 'form',
									defaults: {height: 22},
									bodyStyle: {background:"#dfe7f4"},
									defaultType: 'checkbox',
									items: [{
										id: 'noticeSponsorCheck',
										fieldLabel: '接收者',
										boxLabel: '流程发起者',
										listeners: {
											"check": function(){
												Ext.getCmp("noticeSponsorCombo").disabled?Ext.getCmp("noticeSponsorCombo").enable():Ext.getCmp("noticeSponsorCombo").disable();
												var node = findXmlNodeByName("event-listener",Ext.getCmp("noticeDescriptionBox").getValue(),"notice");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"process_sponsor");
													if(Ext.getCmp("noticeSponsorCombo").disabled){
														if(nodeField!=null)
															node.removeChild(nodeField);
													}else{
														if(nodeField == null){
															addEventXmlNode(node,"process_sponsor","noticeSponsorCombo",null);
														}else{
															nodeField.firstChild.setAttribute("value",Ext.getCmp("noticeSponsorCombo").getValue());
														}
													}
												}
											}
										}	
									},{
										id: 'noticeExecutorCheck',
										boxLabel: '流程执行者',
										listeners: {
											"check": function(){
												Ext.getCmp("noticeExecutorCombo").disabled?Ext.getCmp("noticeExecutorCombo").enable():Ext.getCmp("noticeExecutorCombo").disable();
												Ext.getCmp("noticeExecutorTypeCombo").disabled?Ext.getCmp("noticeExecutorTypeCombo").enable():Ext.getCmp("noticeExecutorTypeCombo").disable();
												if(Ext.getCmp("noticeExecutorTypeCombo").getValue() == "one" && !Ext.getCmp("noticeExecutorTypeCombo").disabled)
													Ext.getCmp("noticeExecutorAreaCombo").enable();
												else
													Ext.getCmp("noticeExecutorAreaCombo").disable();
												var node = findXmlNodeByName("event-listener",Ext.getCmp("noticeDescriptionBox").getValue(),"notice");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"process_executor");
													var nodeField1 = findXmlAreaValueByName(node,"process_executor_area");
													if(Ext.getCmp("noticeExecutorCombo").disabled){
														if(nodeField!=null)
															node.removeChild(nodeField);
														if(nodeField1!=null)
															node.removeChild(nodeField1);
													}else{
														if(nodeField == null){
															addEventXmlNode(node,"process_executor","noticeExecutorCombo",null);
														}else{
															nodeField.firstChild.setAttribute("value",Ext.getCmp("noticeExecutorCombo").getValue());
														}
														if(!Ext.getCmp("noticeExecutorAreaCombo").disabled){
															if(Ext.getCmp("noticeExecutorAreaCombo").getValue() != "")
																addEventXmlNode(node,"process_executor_area","noticeExecutorAreaCombo",null);
														}
													}
												}
											}
										}	
									},{
										id: 'noticePartnerCheck',
										boxLabel: '流程参与者',
										listeners: {
											"check": function(){
												Ext.getCmp("noticePartnerCombo").disabled?Ext.getCmp("noticePartnerCombo").enable():Ext.getCmp("noticePartnerCombo").disable();
												Ext.getCmp("noticePartnerTypeCombo").disabled?Ext.getCmp("noticePartnerTypeCombo").enable():Ext.getCmp("noticePartnerTypeCombo").disable();
												if(Ext.getCmp("noticePartnerTypeCombo").getValue() == "one" && !Ext.getCmp("noticePartnerTypeCombo").disabled)
													Ext.getCmp("noticePartnerAreaCombo").enable();
												else
													Ext.getCmp("noticePartnerAreaCombo").disable();
											}
										}	
									},{
										boxLabel: '用户',
										id: 'noticeUserCheck',
										listeners: {
											"check": function(){
												Ext.getCmp("noticeUserBox").disabled?Ext.getCmp("noticeUserBox").enable():Ext.getCmp("noticeUserBox").disable();
												var node = findXmlNodeByName("event-listener",Ext.getCmp("noticeDescriptionBox").getValue(),"notice");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"notice_user");
													if(Ext.getCmp("noticeUserBox").disabled){
														if(nodeField!=null)
															node.removeChild(nodeField);
													}else{
														if(nodeField == null){
															if(Ext.getCmp("noticeUserBox").getValue() != "")
																addEventXmlNode(node,"notice_user","noticeUserIdBox","noticeUserBox");
														}else{
															nodeField.firstChild.setAttribute("value",Ext.getCmp("noticeUserIdBox").getValue());
															nodeField.firstChild.setAttribute("name",Ext.getCmp("noticeUserBox").getValue());
														}
													}
												}
											}
										}	
									},{
										boxLabel: '角色',
										id: 'noticeRoleCheck',
										listeners: {
											"check": function(){
												Ext.getCmp("noticeRoleBox").disabled?Ext.getCmp("noticeRoleBox").enable():Ext.getCmp("noticeRoleBox").disable();
												var node = findXmlNodeByName("event-listener",Ext.getCmp("noticeDescriptionBox").getValue(),"notice");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"notice_role");
													if(Ext.getCmp("noticeRoleBox").disabled){
														if(nodeField!=null)
															node.removeChild(nodeField);
													}else{
														if(nodeField == null){
															if(Ext.getCmp("noticeRoleBox").getValue() != "")
																addEventXmlNode(node,"notice_role","noticeRoleIdBox","noticeRoleBox");
														}else{
															nodeField.firstChild.setAttribute("value",Ext.getCmp("noticeRoleIdBox").getValue());
															nodeField.firstChild.setAttribute("name",Ext.getCmp("noticeRoleBox").getValue());
														}
													}
												}
											}
										}
									},{
										boxLabel: '部门',
										id: 'noticeDeptCheck',
										listeners: {
											"check": function(){
												Ext.getCmp("noticeDeptBox").disabled?Ext.getCmp("noticeDeptBox").enable():Ext.getCmp("noticeDeptBox").disable();
												var node = findXmlNodeByName("event-listener",Ext.getCmp("noticeDescriptionBox").getValue(),"notice");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"notice_dept");
													if(Ext.getCmp("noticeDeptBox").disabled){
														if(nodeField!=null)
															node.removeChild(nodeField);
													}else{
														if(nodeField == null){
															if(Ext.getCmp("noticeDeptBox").getValue() != "")
																addEventXmlNode(node,"notice_dept","noticeDeptIdBox","noticeDeptBox");
														}else{
															nodeField.firstChild.setAttribute("value",Ext.getCmp("noticeDeptIdBox").getValue());
															nodeField.firstChild.setAttribute("name",Ext.getCmp("noticeDeptBox").getValue());
														}
													}
												}
											}
										}
									}]
								},{
									layout: 'column',
									border: false,
									bodyStyle: {background:"#dfe7f4"},
									items: [{
										layout: 'form',
										labelWidth: 10,
										bodyStyle: {background:"#dfe7f4"},
										border: false,
										width: 130,
										defaultType: 'combo',
										items:[{
											id: 'noticeSponsorCombo',
											width: 100,
											disabled: true,
											editable: false,
											valueField: 'value',
											displayField: 'text',
											triggerAction: 'all',
											emptyText: '请选择',
											mode: 'local',
											store: new Ext.data.SimpleStore({
												fields: ['value','text'],
												data:[
													['include','包含'],
													['except','除外']								
												]
											}),
											scope: this,
											listeners: {
												"select" : function(e){
													var node = findXmlNodeByName("event-listener",Ext.getCmp("noticeDescriptionBox").getValue(),"notice");
													if(node != null){
														var nodeField = findXmlAreaValueByName(node,"process_sponsor");
														nodeField.firstChild.setAttribute("value",e.getValue());
													}
												},
												"beforerender": function(){
													this.setValue('include');
												}
											}
										},{
											id: 'noticeExecutorCombo',
											width: 100,
											disabled: true,
											editable: false,
											valueField: 'value',
											displayField: 'text',
											triggerAction: 'all',
											emptyText: '请选择',
											mode: 'local',
											store: new Ext.data.SimpleStore({
												fields: ['value','text'],
												data:[
													['include','包含'],
													['except','除外']								
												]
											}),
											scope: this,
											listeners: {
												"select" : function(e){
													var node = findXmlNodeByName("event-listener",Ext.getCmp("noticeDescriptionBox").getValue(),"notice");
													if(node != null){
														var nodeField = findXmlAreaValueByName(node,"process_executor");
														nodeField.firstChild.setAttribute("value",e.getValue());
													}
												},
												"beforerender": function(){
													this.setValue('include');
												}
											}
										},{
											id: 'noticePartnerCombo',
											width: 100,
											disabled: true,
											editable: false,
											valueField: 'value',
											displayField: 'text',
											triggerAction: 'all',
											emptyText: '请选择',
											mode: 'local',
											store: new Ext.data.SimpleStore({
												fields: ['value','text'],
												data:[
													['include','包含'],
													['except','除外']								
												]
											}),
											scope: this,
											listeners: {
												"beforerender": function(){
													this.setValue('include');
												}
											}
										}]			
									},{
										layout: 'form',
										labelWidth: 33,
										bodyStyle: {background:"#dfe7f4"},
										border: false,
										width: 170,
										defaultType: 'combo',
										items:[{
											xtype: 'label',
											height: 25
										},{
											id: 'noticeExecutorTypeCombo',
											fieldLabel: '类型',
											width: 120,
											disabled: true,
											editable: false,
											valueField: 'value',
											displayField: 'text',
											triggerAction: 'all',
											emptyText: '请选择',
											mode: 'local',
											store: new Ext.data.SimpleStore({
												fields: ['value','text'],
												data:[
													['all','整个流程执行者'],
													['one','某个节点执行者']								
												]
											}),
											scope: this,
											listeners: {
												"select": function(){
													if(this.getValue() == "all"){
														Ext.getCmp("noticeExecutorAreaCombo").disable();
													}else{
														//获取所有XML任务节点
														var tasks = xml.getElementsByTagName("task");
														var arrays = [];
														for(var i=0;i<tasks.length;i++){
															arrays.push([tasks[i].getAttribute("name"),tasks[i].getAttribute("name")]);
														}
														Ext.getCmp("noticeExecutorAreaCombo").enable();
														if(node != null){
															if(Ext.getCmp("noticeExecutorAreaCombo").getValue() != "")
																addEventXmlNode(node,"process_executor_area","noticeExecutorAreaCombo");
														}
													}
												},
												"beforerender": function(){
													this.setValue('all');								
												}
											}
										},{
											id: 'noticePartnerTypeCombo',
											fieldLabel: '类型',
											width: 120,
											disabled: true,
											editable: false,
											valueField: 'value',
											displayField: 'text',
											triggerAction: 'all',
											emptyText: '请选择',
											mode: 'local',
											store: new Ext.data.SimpleStore({
												fields: ['value','text'],
												data:[
													['all','整个流程参与者'],
													['one','某个节点参与者']								
												]
											}),
											scope: this,
											listeners: {
												"select": function(){
													if(this.getValue() == "all"){
														Ext.getCmp("noticePartnerAreaCombo").disable();
													}else{
														//获取所有XML任务节点
														var tasks = xml.getElementsByTagName("task");
														var arrays = [];
														for(var i=0;i<tasks.length;i++){
															arrays.push([tasks[i].getAttribute("name"),tasks[i].getAttribute("name")]);
														}
														Ext.getCmp("noticePartnerAreaCombo").enable();
													}
												},
												"beforerender": function(){
													this.setValue('all');								
												}
											}	
										}]
									},{
										layout: 'form',
										labelWidth: 33,
										bodyStyle: {background:"#dfe7f4"},
										border: false,
										width: 170,
										defaultType: 'combo',
										items:[{
											xtype: 'label',
											height: 25
										},{
											id: 'noticeExecutorAreaCombo',
											fieldLabel: '节点',
											width: 120,
											disabled: true,
											editable: false,
											valueField: 'value',
											displayField: 'text',
											triggerAction: 'all',
											emptyText: '请选择',
											mode: 'local',
											store: new Ext.data.SimpleStore({
												fields: ['value','text'],
												data: []
											}),
											listeners: {
												"select" : function(e){
													var node = findXmlNodeByName("event-listener",Ext.getCmp("noticeDescriptionBox").getValue(),"notice");
													if(node != null){
														var nodeField = findXmlAreaValueByName(node,"process_executor_area");
														if(nodeField == null){
															addEventXmlNode(node,"process_executor_area","noticeExecutorAreaCombo",null);
														}else{
															nodeField.firstChild.setAttribute("value",e.getValue());
														}
													}
												}
											}	
										},{
											id: 'noticePartnerAreaCombo',
											fieldLabel: '节点',
											width: 120,
											disabled: true,
											editable: false,
											valueField: 'value',
											displayField: 'text',
											triggerAction: 'all',
											emptyText: '请选择',
											mode: 'local',
											store: new Ext.data.SimpleStore({
												fields: ['value','text'],
												data: []
											})
										}]				
									}]
								},{
									layout: 'form',
									labelWidth: 10,
									bodyStyle: {background:"#dfe7f4"},
									border: false,
									defaults: {width: '83%'},
									items: [{
										xtype: 'textfield',
										id: 'noticeUserBox',
										readOnly: true,
										disabled: true,
										listeners: {
											'focus' : function(){
												selectUser(currentParam,currentParam+"UserBox",currentParam+"UserIdBox");
											}
										}
									},{
										xtype: 'textfield',
										id: 'noticeRoleBox',
										readOnly: true,
										disabled: true,
										listeners: {
											'focus' : function(){
												selectRole(currentParam,currentParam+"RoleBox",currentParam+"RoleIdBox");
											}
										}
									},{
										xtype: 'textfield',
										id: 'noticeDeptBox',
										readOnly: true,
										disabled: true,
										listeners: {
											'focus' : function(){
												selectDept(currentParam,currentParam+"DeptBox",currentParam+"DeptIdBox");
											}
										}
									},{
										xtype: 'hidden',
										id: 'noticeUserIdBox'
									},{
										xtype: 'hidden',
										id: 'noticeRoleIdBox'
									},{
										xtype: 'hidden',
										id: 'noticeDeptIdBox'
									}]
								}]							
							},{
								layout: 'form',
								bodyStyle: {background:"#dfe7f4"},
								border: false,
								labelWidth: 80,
								items: [{
									xtype: 'textarea',
									fieldLabel: '消息内容',
									id: 'noticeContentBox',
									width: '85%',
									enableKeyEvents: true,
									listeners: {
										'keyup' : function(e){
											var node = findXmlNodeByName("event-listener",Ext.getCmp("noticeDescriptionBox").getValue(),"notice");
											if(node != null){
												var nodeField = findXmlAreaValueByName(node,"notice_content");
												if(nodeField == null){
													addEventXmlNode(node,"notice_content","noticeContentBox");
												}else{
													nodeField.firstChild.setAttribute("value",e.getValue());
													if(e.getValue() == "")
														node.removeChild(nodeField);
												}
											}
										}
									}
								}]
							},{
								layout: 'fit',
								border: false,
								bodyStyle: {background:"#dfe7f4",padding:"0 0 0 88"},
								items: [{
									xtype: 'panel',
									border: false,
									height: 16,
									bodyStyle: {background:"#dfe7f4"},
									html: '<span title="插入变量" style="margin-top:0;" class="img_btn picon22" />'
								}]		
							}]
						}]
					}]
				});		
				break
			case "mailto":
				currentCard = new Ext.form.FormPanel({
					id: currentParam,
					border: false,
					bodyStyle: {background:"#dfe7f4",padding:"10 0 0 20"},
					labelAlign: 'left',
					items: [{
						layout: 'column',
						border: false,
						bodyStyle: {background:"#dfe7f4"},
						items: [{
							layout: 'fit',
							width: 180,
							height: 350,
							border: false,
							items: [{
								xtype: 'panel',
								id: 'mailtoListPanel',
								html: '<div class="panel_list" id="mailtoList"></div>',
								tbar: new Ext.Toolbar({
									height: 31,
									border: false,
									items: [
										'->',
										{text: '&nbsp;添加',iconCls: 'picon23',handler: function(){
											if(Ext.getCmp("mailtoDescriptionBox").getValue() == ""){
												Ext.MessageBox.alert(htTip,'邮件描述不能为空！');
												return false;
											}
											//通过节点类型、名字以及监听类型查找节点
											if(findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto") != null){
												Ext.MessageBox.alert(htTip,'邮件描述不能重复！');
												return false;
											}
											//当节点为transition时不需要判断事件类型
											if(xmlNode.tagName !="transition"&&Ext.getCmp("mailtoCaseTypeBox").getValue() == ""){
												Ext.MessageBox.alert(htTip,'事件类型不能为空！');
												return false;
											}
											//添加邮件节点
											addXmlNodeByName("mailto",Ext.getCmp("mailtoDescriptionBox").getValue(),xmlNode);
											//移除事件
											Ext.get(Ext.DomQuery.select(".mailto_btn")).un("click");
											//添加树列表
											var mailtoId = "M" + mailtoNum;
											mailtoNum ++;
											addTreeList(Ext.getDom("mailtoList"),mailtoId,Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
											//触发事件
											Ext.getDom(mailtoId).fireEvent('onclick');
										}},'-',
										{text: '&nbsp;删除',iconCls: 'picon13',handler: function(){
											var node = deleteXmlNodeByType("event-listener","mailto");
											if(node != null&&node.childNodes.length == 0)
												node.parentNode.removeChild(node);
										}}
									]
								})
							}]
						},{
							border: false,
							bodyStyle: {background:"#dfe7f4",padding:"0 0 0 10"},
							items: [{
								layout: 'form',
								defaultType: 'checkbox',
								labelWidth: 80,
								defaults: {width: '85%'},
								border: false,
								bodyStyle: {background:"#dfe7f4"},
								items: [{
									id: 'mailtoDescriptionBox',
									xtype: 'textfield',
									fieldLabel: '邮件描述',
									enableKeyEvents: true,
									listeners: {
										'keyup' : function(e){
											var node = findXmlNodeByName("event-listener",e.getValue(),"mailto");
											if(node != null){
												var treeNodes = Ext.DomQuery.select("div[title="+e.getValue()+"]");
												for(var i=0;i<treeNodes.length;i++){
													if(Ext.fly(treeNodes[i]).hasClass("mailto_btn")){
														treeNodes[i].fireEvent("onclick");
														break;
													}
												}
											}
										}
									}
								},{
									xtype: 'combo',
									fieldLabel: '事件类型',
									id: 'mailtoCaseTypeBox',
									width: 100,
									valueField: 'value',
									displayField: 'text',
									editable: false,
									emptyText: '请选择',
									triggerAction: 'all',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data:[
											['start','流程开始'],
											['end','流程结束']								
										]
									}),
									listeners: {
										"select" : function(e){
											var node = findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
											if(node != null){
												if(xmlNode != null&&xmlNode.tagName == "transition") return false;
												if(e.getValue() != node.parentNode.getAttribute("event")){
													var eventNodes = xml.getElementsByTagName("on");
													var eventNode = null;//新增的监听节点或者已存在的监听节点
													var hisNode = node.parentNode;//事件节点的原始父节点
													for(var i=0;i<eventNodes.length;i++){
														if(eventNodes[i].getAttribute("event")==e.getValue()&&eventNodes[i].parentNode == xmlNode){
															eventNode = eventNodes[i];
															break;
														}
													}
													if(eventNode == null){
														eventNode = xml.createElement("on");
														xmlNode.appendChild(eventNode);
														eventNode.setAttribute("event",e.getValue());
													}
													eventNode.appendChild(node);
													//如果原始节点没有子节点，删除该节点
													if(hisNode.childNodes.length == 0){
														hisNode.parentNode.removeChild(hisNode);
													}
												}
											}
										}
									}
								}]
							},{
								bodyStyle: {background:"#dfe7f4"},
								border: false,
								layout: 'column',	
								items: [{
									width: 170,
									labelWidth: 80,
									border: false,
									layout: 'form',
									defaults: {height: 22},
									bodyStyle: {background:"#dfe7f4"},
									defaultType: 'checkbox',
									items: [{
										id: 'mailtoSponsorCheck',
										fieldLabel: '接收者',
										boxLabel: '流程发起者',
										listeners: {
											"check": function(){
												Ext.getCmp("mailtoSponsorCombo").disabled?Ext.getCmp("mailtoSponsorCombo").enable():Ext.getCmp("mailtoSponsorCombo").disable();
												var node = findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"process_sponsor");
													if(Ext.getCmp("mailtoSponsorCombo").disabled){
														if(nodeField!=null)
															node.removeChild(nodeField);
													}else{
														if(nodeField == null){
															addEventXmlNode(node,"process_sponsor","mailtoSponsorCombo",null);
														}else{
															nodeField.firstChild.setAttribute("value",Ext.getCmp("mailtoSponsorCombo").getValue());
														}
													}
												}
											}
										}	
									},{
										id: 'mailtoExecutorCheck',
										boxLabel: '流程执行者',
										listeners: {
											"check": function(){
												Ext.getCmp("mailtoExecutorCombo").disabled?Ext.getCmp("mailtoExecutorCombo").enable():Ext.getCmp("mailtoExecutorCombo").disable();
												Ext.getCmp("mailtoExecutorTypeCombo").disabled?Ext.getCmp("mailtoExecutorTypeCombo").enable():Ext.getCmp("mailtoExecutorTypeCombo").disable();
												if(Ext.getCmp("mailtoExecutorTypeCombo").getValue() == "one" && !Ext.getCmp("mailtoExecutorTypeCombo").disabled)
													Ext.getCmp("mailtoExecutorAreaCombo").enable();
												else
													Ext.getCmp("mailtoExecutorAreaCombo").disable();
												var node = findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"process_executor");
													var nodeField1 = findXmlAreaValueByName(node,"process_executor_area");
													if(Ext.getCmp("mailtoExecutorCombo").disabled){
														if(nodeField!=null)
															node.removeChild(nodeField);
														if(nodeField1!=null)
															node.removeChild(nodeField1);
													}else{
														if(nodeField == null){
															addEventXmlNode(node,"process_executor","mailtoExecutorCombo",null);
														}else{
															nodeField.firstChild.setAttribute("value",Ext.getCmp("mailtoExecutorCombo").getValue());
														}
														if(!Ext.getCmp("mailtoExecutorAreaCombo").disabled){
															if(Ext.getCmp("mailtoExecutorAreaCombo").getValue() != "")
																addEventXmlNode(node,"process_executor_area","mailtoExecutorAreaCombo",null);
														}
													}
												}
											}
										}	
									},{
										id: 'mailtoPartnerCheck',
										boxLabel: '流程参与者',
										listeners: {
											"check": function(){
												Ext.getCmp("mailtoPartnerCombo").disabled?Ext.getCmp("mailtoPartnerCombo").enable():Ext.getCmp("mailtoPartnerCombo").disable();
												Ext.getCmp("mailtoPartnerTypeCombo").disabled?Ext.getCmp("mailtoPartnerTypeCombo").enable():Ext.getCmp("mailtoPartnerTypeCombo").disable();
												if(Ext.getCmp("mailtoPartnerTypeCombo").getValue() == "one" && !Ext.getCmp("mailtoPartnerTypeCombo").disabled)
													Ext.getCmp("mailtoPartnerAreaCombo").enable();
												else
													Ext.getCmp("mailtoPartnerAreaCombo").disable();
											}
										}	
									},{
										boxLabel: '用户',
										id: 'mailtoUserCheck',
										listeners: {
											"check": function(){
												Ext.getCmp("mailtoUserBox").disabled?Ext.getCmp("mailtoUserBox").enable():Ext.getCmp("mailtoUserBox").disable();
												var node = findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"mail_user");
													if(Ext.getCmp("mailtoUserBox").disabled){
														if(nodeField!=null)
															node.removeChild(nodeField);
													}else{
														if(nodeField == null){
															if(Ext.getCmp("mailtoUserBox").getValue() != "")
																addEventXmlNode(node,"mail_user","mailtoUserIdBox","mailtoUserBox");
														}else{
															nodeField.firstChild.setAttribute("value",Ext.getCmp("mailtoUserIdBox").getValue());
															nodeField.firstChild.setAttribute("name",Ext.getCmp("mailtoUserBox").getValue());
														}
													}
												}
											}
										}	
									},{
										boxLabel: '角色',
										id: 'mailtoRoleCheck',
										listeners: {
											"check": function(){
												Ext.getCmp("mailtoRoleBox").disabled?Ext.getCmp("mailtoRoleBox").enable():Ext.getCmp("mailtoRoleBox").disable();
												var node = findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"mail_role");
													if(Ext.getCmp("mailtoRoleBox").disabled){
														if(nodeField!=null)
															node.removeChild(nodeField);
													}else{
														if(nodeField == null){
															if(Ext.getCmp("mailtoRoleBox").getValue() != "")
																addEventXmlNode(node,"mail_role","mailtoRoleIdBox","mailtoRoleBox");
														}else{
															nodeField.firstChild.setAttribute("value",Ext.getCmp("mailtoRoleIdBox").getValue());
															nodeField.firstChild.setAttribute("name",Ext.getCmp("mailtoRoleBox").getValue());
														}
													}
												}
											}
										}
									},{
										boxLabel: '部门',
										id: 'mailtoDeptCheck',
										listeners: {
											"check": function(){
												Ext.getCmp("mailtoDeptBox").disabled?Ext.getCmp("mailtoDeptBox").enable():Ext.getCmp("mailtoDeptBox").disable();
												var node = findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"mail_dept");
													if(Ext.getCmp("mailtoDeptBox").disabled){
														if(nodeField!=null)
															node.removeChild(nodeField);
													}else{
														if(nodeField == null){
															if(Ext.getCmp("mailtoDeptBox").getValue() != "")
																addEventXmlNode(node,"mail_dept","mailtoDeptIdBox","mailtoDeptBox");
														}else{
															nodeField.firstChild.setAttribute("value",Ext.getCmp("mailtoDeptIdBox").getValue());
															nodeField.firstChild.setAttribute("name",Ext.getCmp("mailtoDeptBox").getValue());
														}
													}
												}
											}
										}
									},{
										boxLabel: '邮箱地址',
										id: 'mailtoAddressCheck',
										listeners: {
											"check": function(){
												Ext.getCmp("mailtoAddressBox").disabled?Ext.getCmp("mailtoAddressBox").enable():Ext.getCmp("mailtoAddressBox").disable();
												var node = findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"mail_address");
													if(Ext.getCmp("mailtoAddressBox").disabled){
														if(nodeField!=null)
															node.removeChild(nodeField);
													}else{
														if(nodeField == null){
															if(Ext.getCmp("mailtoAddressBox").getValue() != "")
																addEventXmlNode(node,"mail_address","mailtoAddressBox");
														}else{
															nodeField.firstChild.setAttribute("value",Ext.getCmp("mailtoAddressBox").getValue());
														}
													}
												}
											}
										}
									}]
								},{
									layout: 'column',
									border: false,
									bodyStyle: {background:"#dfe7f4"},
									items: [{
										layout: 'form',
										labelWidth: 10,
										bodyStyle: {background:"#dfe7f4"},
										border: false,
										width: 130,
										defaultType: 'combo',
										items:[{
											id: 'mailtoSponsorCombo',
											width: 100,
											disabled: true,
											editable: false,
											valueField: 'value',
											displayField: 'text',
											triggerAction: 'all',
											emptyText: '请选择',
											mode: 'local',
											store: new Ext.data.SimpleStore({
												fields: ['value','text'],
												data:[
													['include','包含'],
													['except','除外']								
												]
											}),
											scope: this,
											listeners: {
												"select" : function(e){
													var node = findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
													if(node != null){
														var nodeField = findXmlAreaValueByName(node,"process_sponsor");
														nodeField.firstChild.setAttribute("value",e.getValue());
													}
												},
												"beforerender": function(){
													this.setValue('include');
												}
											}
										},{
											id: 'mailtoExecutorCombo',
											width: 100,
											disabled: true,
											editable: false,
											valueField: 'value',
											displayField: 'text',
											triggerAction: 'all',
											emptyText: '请选择',
											mode: 'local',
											store: new Ext.data.SimpleStore({
												fields: ['value','text'],
												data:[
													['include','包含'],
													['except','除外']								
												]
											}),
											scope: this,
											listeners: {
												"select" : function(e){
													var node = findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
													if(node != null){
														var nodeField = findXmlAreaValueByName(node,"process_executor");
														nodeField.firstChild.setAttribute("value",e.getValue());
													}
												},
												"beforerender": function(){
													this.setValue('include');
												}
											}
										},{
											id: 'mailtoPartnerCombo',
											width: 100,
											disabled: true,
											editable: false,
											valueField: 'value',
											displayField: 'text',
											triggerAction: 'all',
											emptyText: '请选择',
											mode: 'local',
											store: new Ext.data.SimpleStore({
												fields: ['value','text'],
												data:[
													['include','包含'],
													['except','除外']								
												]
											}),
											scope: this,
											listeners: {
												"beforerender": function(){
													this.setValue('include');
												}
											}
										}]			
									},{
										layout: 'form',
										labelWidth: 33,
										bodyStyle: {background:"#dfe7f4"},
										border: false,
										width: 170,
										defaultType: 'combo',
										items:[{
											xtype: 'label',
											height: 25
										},{
											id: 'mailtoExecutorTypeCombo',
											fieldLabel: '类型',
											width: 120,
											disabled: true,
											editable: false,
											valueField: 'value',
											displayField: 'text',
											triggerAction: 'all',
											emptyText: '请选择',
											mode: 'local',
											store: new Ext.data.SimpleStore({
												fields: ['value','text'],
												data:[
													['all','整个流程执行者'],
													['one','某个节点执行者']								
												]
											}),
											scope: this,
											listeners: {
												"select": function(){
													var node = findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
													if(this.getValue() == "all"){
														Ext.getCmp("mailtoExecutorAreaCombo").disable();
														if(node != null){
															var nodeField = findXmlAreaValueByName(node,"process_executor_area");
															if(nodeField != null)
																node.removeChild(nodeField);
														}
													}else{
														//获取所有XML任务节点
														var tasks = xml.getElementsByTagName("task");
														var arrays = [];
														for(var i=0;i<tasks.length;i++){
															arrays.push([tasks[i].getAttribute("name"),tasks[i].getAttribute("name")]);
														}
														Ext.getCmp("mailtoExecutorAreaCombo").getStore().loadData(arrays);
														Ext.getCmp("mailtoExecutorAreaCombo").enable();
														if(node != null){
															if(Ext.getCmp("mailtoExecutorAreaCombo").getValue() != "")
																addEventXmlNode(node,"process_executor_area","mailtoExecutorAreaCombo");
														}
													}
												},
												"beforerender": function(){
													this.setValue('all');								
												}
											}
										},{
											id: 'mailtoPartnerTypeCombo',
											fieldLabel: '类型',
											width: 120,
											disabled: true,
											editable: false,
											valueField: 'value',
											displayField: 'text',
											triggerAction: 'all',
											emptyText: '请选择',
											mode: 'local',
											store: new Ext.data.SimpleStore({
												fields: ['value','text'],
												data:[
													['all','整个流程参与者'],
													['one','某个节点参与者']								
												]
											}),
											scope: this,
											listeners: {
												"select": function(){
													if(this.getValue() == "all"){
														Ext.getCmp("mailtoPartnerAreaCombo").disable();
													}else{
														//获取所有XML任务节点
														var tasks = xml.getElementsByTagName("task");
														var arrays = [];
														for(var i=0;i<tasks.length;i++){
															arrays.push([tasks[i].getAttribute("name"),tasks[i].getAttribute("name")]);
														}
														Ext.getCmp("mailtoPartnerAreaCombo").getStore().loadData(arrays);
														Ext.getCmp("mailtoPartnerAreaCombo").enable();
													}
												},
												"beforerender": function(){
													this.setValue('all');								
												}
											}	
										}]
									},{
										layout: 'form',
										labelWidth: 33,
										bodyStyle: {background:"#dfe7f4"},
										border: false,
										width: 170,
										defaultType: 'combo',
										items:[{
											xtype: 'label',
											height: 25
										},{
											id: 'mailtoExecutorAreaCombo',
											fieldLabel: '节点',
											width: 120,
											disabled: true,
											editable: false,
											valueField: 'value',
											displayField: 'text',
											triggerAction: 'all',
											emptyText: '请选择',
											mode: 'local',
											store: new Ext.data.SimpleStore({
												fields: ['value','text'],
												data: []
											}),
											listeners: {
												"select" : function(e){
													var node = findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
													if(node != null){
														var nodeField = findXmlAreaValueByName(node,"process_executor_area");
														if(nodeField == null){
															addEventXmlNode(node,"process_executor_area","mailtoExecutorAreaCombo",null);
														}else{
															nodeField.firstChild.setAttribute("value",e.getValue());
														}
													}
												}
											}
										},{
											id: 'mailtoPartnerAreaCombo',
											fieldLabel: '节点',
											width: 120,
											disabled: true,
											editable: false,
											valueField: 'value',
											displayField: 'text',
											triggerAction: 'all',
											emptyText: '请选择',
											mode: 'local',
											store: new Ext.data.SimpleStore({
												fields: ['value','text'],
												data: []
											})
										}]				
									}]
								},{
									layout: 'form',
									labelWidth: 10,
									bodyStyle: {background:"#dfe7f4"},
									border: false,
									defaults: {width: '83%'},
									items: [{
										xtype: 'textfield',
										id: 'mailtoUserBox',
										readOnly: true,
										disabled: true,
										listeners: {
											'focus' : function(){
												selectUser(currentParam,currentParam+"UserBox",currentParam+"UserIdBox");
											}
										}
									},{
										xtype: 'textfield',
										id: 'mailtoRoleBox',
										readOnly: true,
										disabled: true,
										listeners: {
											'focus' : function(){
												selectRole(currentParam,currentParam+"RoleBox",currentParam+"RoleIdBox");
											}
										}
									},{
										xtype: 'textfield',
										id: 'mailtoDeptBox',
										readOnly: true,
										disabled: true,
										listeners: {
											'focus' : function(){
												selectDept(currentParam,currentParam+"DeptBox",currentParam+"DeptIdBox");
											}
										}
									},{
										xtype: 'hidden',
										id: 'mailtoUserIdBox'
									},{
										xtype: 'hidden',
										id: 'mailtoRoleIdBox'
									},{
										xtype: 'hidden',
										id: 'mailtoDeptIdBox'
									},{
										xtype: 'textfield',
										id: 'mailtoAddressBox',
										disabled: true,
										enableKeyEvents: true,
										listeners: {
											'keyup' : function(e){
												var node = findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"mail_address");
													if(nodeField == null){
														addEventXmlNode(node,"mail_address","mailtoAddressBox");
													}else{
														nodeField.firstChild.setAttribute("value",e.getValue());
														if(e.getValue() == "")
															node.removeChild(nodeField);
													}
												}
											}
										}
									}]
								}]							
							},{
								layout: 'column',
								bodyStyle: {background:"#dfe7f4"},
								border: false,	
								items: [{
									layout: 'form',
									border: false,
									bodyStyle: {background:"#dfe7f4"},
									labelWidth: 80,
									width: 500,
									items: [{
										xtype: 'textfield',
										fieldLabel: '邮件标题',
										id: 'mailtoTitleBox',
										width: '400',
										enableKeyEvents: true,
										listeners: {
											'keyup' : function(e){
												var node = findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"mail_title");
													if(nodeField == null){
														addEventXmlNode(node,"mail_title","mailtoTitleBox");
													}else{
														nodeField.firstChild.setAttribute("value",e.getValue());
														if(e.getValue() == "")
															node.removeChild(nodeField);
													}
												}
											}
										}
									}]
								},{
									layout: 'fit',
									border: false,
									bodyStyle: {background:"#dfe7f4"},
									items: [{
										xtype: 'panel',
										border: false,
										height: 20,
										bodyStyle: {background:"#dfe7f4"},
										html: '<span title="插入变量" class="img_btn picon22" />'
									}]	
								}]
							},{
								layout: 'column',
								bodyStyle: {background:"#dfe7f4"},
								border: false,	
								items: [{
									layout: 'form',
									bodyStyle: {background:"#dfe7f4"},
									border: false,
									labelWidth: 80,
									width: 600,
									items: [{
										xtype: 'textarea',
										fieldLabel: '邮件内容',
										id: 'mailtoContentBox',
										width: '500',
										enableKeyEvents: true,
										listeners: {
											'keyup' : function(e){
												var node = findXmlNodeByName("event-listener",Ext.getCmp("mailtoDescriptionBox").getValue(),"mailto");
												if(node != null){
													var nodeField = findXmlAreaValueByName(node,"mail_content");
													if(nodeField == null){
														addEventXmlNode(node,"mail_content","mailtoContentBox");
													}else{
														nodeField.firstChild.setAttribute("value",e.getValue());
														if(e.getValue() == "")
															node.removeChild(nodeField);
													}
												}
											}
										}
									}]
								},{
									layout: 'fit',
									border: false,
									bodyStyle: {background:"#dfe7f4"},
									items: [{
										xtype: 'panel',
										border: false,
										height: 20,
										bodyStyle: {background:"#dfe7f4"},
										html: '<span title="插入变量" class="img_btn picon22" />'
									}]	
								}]
							}]
						}]
					}]
				});		
				break
			case "change":
				currentCard = new Ext.form.FormPanel({
					id: currentParam,
					border: false,
					bodyStyle: {background:"#dfe7f4",padding:"10 0 0 20"},
					labelAlign: 'left',
					labelWidth: 80,
					defaultType: 'radio',
					items:[{
						fieldLabel: '转换模式',
						boxLabel: '手动流转',
						name: 'changeMethodRadio',
						value: '1',
						checked: true,
						width: 'auto'					
					},{
						boxLabel: '自动流转',
						name: 'changeMethodRadio',
						value: '2',
						width: 'auto'
					}]
				});		
				break
			case "delegate":
				currentCard = new Ext.form.FormPanel({
					id: currentParam,
					border: false,
					bodyStyle: {background:"#dfe7f4",padding:"10 0 0 20"},
					labelAlign: 'left',							
					items:[{
						bodyStyle: {background:"#dfe7f4"},
						border: false,
						layout: 'column',	
						items: [{
							width: 170,
							labelWidth: 80,
							border: false,
							layout: 'form',
							defaults: {height: 22},
							bodyStyle: {background:"#dfe7f4"},
							defaultType: 'checkbox',
							items: [{
								id: 'delegateSponsorCheck',
								fieldLabel: '任务委派',
								boxLabel: '流程发起者',
								listeners: {
									"check": function(){
										Ext.getCmp("delegateSponsorCombo").disabled?Ext.getCmp("delegateSponsorCombo").enable():Ext.getCmp("delegateSponsorCombo").disable();
										if(xmlNode != null){
											var assignNode = findXmlNodeByParentNode("assignment-handler",xmlNode);
											if(Ext.getCmp("delegateSponsorCombo").disabled){
												var nodeField = findXmlAreaValueByName(assignNode,"process_sponsor");
												if(nodeField!=null){
													assignNode.removeChild(nodeField);
												}
											}else{
												if(assignNode == null){
													var assignNode = xml.createElement("assignment-handler");
													assignNode.setAttribute("class","com.huateng.sys.jbpm.listener.CandidateHandler");
													xmlNode.appendChild(assignNode);
												}
												addEventXmlNode(assignNode,"process_sponsor","delegateSponsorCombo",null);
											}
										}
									}
								}	
							},{
								id: 'delegateExecutorCheck',
								boxLabel: '流程执行者',
								listeners: {
									"check": function(){
										Ext.getCmp("delegateExecutorCombo").disabled?Ext.getCmp("delegateExecutorCombo").enable():Ext.getCmp("delegateExecutorCombo").disable();
										Ext.getCmp("delegateExecutorTypeCombo").disabled?Ext.getCmp("delegateExecutorTypeCombo").enable():Ext.getCmp("delegateExecutorTypeCombo").disable();
										if(Ext.getCmp("delegateExecutorTypeCombo").getValue() == "one" && !Ext.getCmp("delegateExecutorTypeCombo").disabled)
											Ext.getCmp("delegateExecutorAreaCombo").enable();
										else
											Ext.getCmp("delegateExecutorAreaCombo").disable();
										if(xmlNode != null){
											var assignNode = findXmlNodeByParentNode("assignment-handler",xmlNode);
											if(Ext.getCmp("delegateExecutorCombo").disabled){
												var nodeField = findXmlAreaValueByName(assignNode,"process_executor");
												var nodeField1 = findXmlAreaValueByName(assignNode,"process_executor_area");
												if(nodeField!=null)
													assignNode.removeChild(nodeField);
												if(nodeField1!=null)
													assignNode.removeChild(nodeField1);
											}else{
												if(assignNode == null){
													var assignNode = xml.createElement("assignment-handler");
													assignNode.setAttribute("class","com.huateng.sys.jbpm.listener.CandidateHandler");
													xmlNode.appendChild(assignNode);
												}
												addEventXmlNode(assignNode,"process_executor","delegateExecutorCombo",null);
												if(!Ext.getCmp("delegateExecutorAreaCombo").disabled){
													if(Ext.getCmp("delegateExecutorAreaCombo").getValue() != "")
														addEventXmlNode(assignNode,"process_executor_area","delegateExecutorAreaCombo",null);
												}
											}
										}
									}
								}	
							},{
								id: 'delegatePartnerCheck',
								boxLabel: '流程参与者',
								listeners: {
									"check": function(){
										Ext.getCmp("delegatePartnerCombo").disabled?Ext.getCmp("delegatePartnerCombo").enable():Ext.getCmp("delegatePartnerCombo").disable();
										Ext.getCmp("delegatePartnerTypeCombo").disabled?Ext.getCmp("delegatePartnerTypeCombo").enable():Ext.getCmp("delegatePartnerTypeCombo").disable();
										if(Ext.getCmp("delegatePartnerTypeCombo").getValue() == "one" && !Ext.getCmp("delegatePartnerTypeCombo").disabled)
											Ext.getCmp("delegatePartnerAreaCombo").enable();
										else
											Ext.getCmp("delegatePartnerAreaCombo").disable();
									}
								}	
							},{
								boxLabel: '用户',
								id: 'delegateUserCheck',
								listeners: {
									"check": function(){
										Ext.getCmp("delegateUserBox").disabled?Ext.getCmp("delegateUserBox").enable():Ext.getCmp("delegateUserBox").disable();
										if(xmlNode != null){
											if(Ext.getCmp("delegateUserBox").disabled){
												xmlNode.removeAttribute("candidate-users");
												xmlNode.removeAttribute("users");
											}else{
												if(Ext.getCmp("delegateUserBox").getValue() != ""){
													xmlNode.setAttribute("candidate-users",Ext.getCmp("delegateUserIdBox").getValue());
													xmlNode.setAttribute("users",Ext.getCmp("delegateUserBox").getValue());
												}
											}
										}
									}
								}	
							},{
								boxLabel: '角色',
								id: 'delegateRoleCheck',
								listeners: {
									"check": function(){
										Ext.getCmp("delegateRoleBox").disabled?Ext.getCmp("delegateRoleBox").enable():Ext.getCmp("delegateRoleBox").disable();
										if(xmlNode != null){
											if(Ext.getCmp("delegateRoleBox").disabled){
												xmlNode.removeAttribute("candidate-roles");
												xmlNode.removeAttribute("roles");
												xmlNode.setAttribute("candidate-groups",Ext.getCmp("delegateDeptBox").disabled?"":Ext.getCmp("delegateDeptIdBox").getValue());
												if(xmlNode.getAttribute("candidate-groups") == "")
													xmlNode.removeAttribute("candidate-groups");
											}else{
												if(Ext.getCmp("delegateRoleBox").getValue() != ""){
													xmlNode.setAttribute("candidate-roles",Ext.getCmp("delegateRoleIdBox").getValue());
													xmlNode.setAttribute("roles",Ext.getCmp("delegateRoleBox").getValue());
													if(xmlNode.getAttribute("candidate-groups")!=""&&xmlNode.getAttribute("candidate-groups")!=null){
														xmlNode.setAttribute("candidate-groups",xmlNode.getAttribute("candidate-groups")+","+Ext.getCmp("delegateRoleIdBox").getValue());
													}else{
														xmlNode.setAttribute("candidate-groups",Ext.getCmp("delegateRoleIdBox").getValue());
													}
												}
											}
										}
									}
								}
							},{
								boxLabel: '部门',
								id: 'delegateDeptCheck',
								listeners: {
									"check": function(){
										Ext.getCmp("delegateDeptBox").disabled?Ext.getCmp("delegateDeptBox").enable():Ext.getCmp("delegateDeptBox").disable();
										if(xmlNode != null){
											if(Ext.getCmp("delegateDeptBox").disabled){
												xmlNode.removeAttribute("candidate-depts");
												xmlNode.removeAttribute("depts");
												xmlNode.setAttribute("candidate-groups",Ext.getCmp("delegateRoleBox").disabled?"":Ext.getCmp("delegateRoleIdBox").getValue());
												if(xmlNode.getAttribute("candidate-groups") == "")
													xmlNode.removeAttribute("candidate-groups");
											}else{
												if(Ext.getCmp("delegateDeptBox").getValue() != ""){
													xmlNode.setAttribute("candidate-depts",Ext.getCmp("delegateDeptIdBox").getValue());
													xmlNode.setAttribute("depts",Ext.getCmp("delegateDeptBox").getValue());
													if(xmlNode.getAttribute("candidate-groups")!=""&&xmlNode.getAttribute("candidate-groups")!=null){
														xmlNode.setAttribute("candidate-groups",xmlNode.getAttribute("candidate-groups")+","+Ext.getCmp("delegateDeptIdBox").getValue());
													}else{
														xmlNode.setAttribute("candidate-groups",Ext.getCmp("delegateDeptIdBox").getValue());
													}
												}
											}
										}
									}
								}
							},{
								boxLabel: '泳道',
								id: 'delegateSwimlaneCheck',
								listeners: {
									"check": function(){
										Ext.getCmp("delegateSwimlaneCombo").disabled?Ext.getCmp("delegateSwimlaneCombo").enable():Ext.getCmp("delegateSwimlaneCombo").disable();
										if(this.checked){
											if(Ext.getCmp("delegateSwimlaneCombo").getValue()){
												xmlNode.setAttribute("swimlane",Ext.getCmp("delegateSwimlaneCombo").getValue());
												if(Ext.getCmp("delegateSwimlaneCombo").getValue() != "")
													presrc.lastChild.firstChild.innerHTML = "TaskNode<span title='"+Ext.getCmp("delegateSwimlaneCombo").getValue()+"' class='sign'>泳</span>";
											}
										}else{
											xmlNode.removeAttribute("swimlane");
											presrc.lastChild.firstChild.innerHTML = "TaskNode";
										}
									}
								}
							}]
						},{
							layout: 'column',
							border: false,
							bodyStyle: {background:"#dfe7f4"},
							items: [{
								layout: 'form',
								labelWidth: 10,
								bodyStyle: {background:"#dfe7f4"},
								border: false,
								width: 130,
								defaultType: 'combo',
								items:[{
									id: 'delegateSponsorCombo',
									width: 100,
									disabled: true,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data:[
											['include','包含'],
											['except','除外']								
										]
									}),
									scope: this,
									listeners: {
										"beforerender" : function(){
											this.setValue('include');
										},
										"select" : function(e){
											var assignNode = findXmlNodeByParentNode("assignment-handler",xmlNode);
											if(assignNode != null){
												var nodeField = findXmlAreaValueByName(assignNode,"process_sponsor");
												nodeField.firstChild.setAttribute("value",e.getValue());
											}
										}
									}
								},{
									id: 'delegateExecutorCombo',
									width: 100,
									disabled: true,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data:[
											['include','包含'],
											['except','除外']								
										]
									}),
									scope: this,
									listeners: {
										"beforerender": function(){
											this.setValue('include');
										},
										"select" : function(e){
											var assignNode = findXmlNodeByParentNode("assignment-handler",xmlNode);
											if(assignNode != null){
												var nodeField = findXmlAreaValueByName(assignNode,"process_executor");
												nodeField.firstChild.setAttribute("value",e.getValue());
											}
										}
									}
								},{
									id: 'delegatePartnerCombo',
									width: 100,
									disabled: true,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data:[
											['include','包含'],
											['except','除外']									
										]
									}),
									scope: this,
									listeners: {
										"beforerender": function(){
											this.setValue('include');
										}
									}
								}]			
							},{
								layout: 'form',
								labelWidth: 33,
								bodyStyle: {background:"#dfe7f4"},
								border: false,
								width: 170,
								defaultType: 'combo',
								items:[{
									xtype: 'label',
									height: 25
								},{
									id: 'delegateExecutorTypeCombo',
									fieldLabel: '类型',
									width: 120,
									disabled: true,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data:[
											['all','整个流程执行者'],
											['one','某个节点执行者']								
										]
									}),
									scope: this,
									listeners: {
										"select": function(){
											var assignNode = findXmlNodeByParentNode("assignment-handler",xmlNode);
											if(this.getValue() == "all"){
												Ext.getCmp("delegateExecutorAreaCombo").disable();
												var nodeField = findXmlAreaValueByName(assignNode,"process_executor_area");
												if(nodeField != null)
													assignNode.removeChild(nodeField);
											}else{
												//获取所有XML任务节点
												var tasks = xml.getElementsByTagName("task");
												var arrays = [];
												for(var i=0;i<tasks.length;i++){
													arrays.push([tasks[i].getAttribute("name"),tasks[i].getAttribute("name")]);
												}
												Ext.getCmp("delegateExecutorAreaCombo").getStore().loadData(arrays);
												Ext.getCmp("delegateExecutorAreaCombo").enable();
												if(Ext.getCmp("delegateExecutorAreaCombo").getValue() != "")
													addEventXmlNode(assignNode,"process_executor_area","delegateExecutorAreaCombo");
											}
										},
										"beforerender": function(){
											this.setValue('all');								
										}
									}
								},{
									id: 'delegatePartnerTypeCombo',
									fieldLabel: '类型',
									width: 120,
									disabled: true,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data:[
											['all','整个流程参与者'],
											['one','某个节点参与者']								
										]
									}),
									scope: this,
									listeners: {
										"select": function(){
											if(this.getValue() == 'all'){
												Ext.getCmp("delegatePartnerAreaCombo").disable();
											}else{
												//获取所有XML任务节点
												var tasks = xml.getElementsByTagName("task");
												var arrays = [];
												for(var i=0;i<tasks.length;i++){
													arrays.push([tasks[i].getAttribute("name"),tasks[i].getAttribute("name")]);
												}
												Ext.getCmp("delegatePartnerAreaCombo").getStore().loadData(arrays);
												Ext.getCmp("delegatePartnerAreaCombo").enable();
											}
										},
										"beforerender": function(){
											this.setValue('all');								
										}
									}	
								}]
							},{
								layout: 'form',
								labelWidth: 33,
								bodyStyle: {background:"#dfe7f4"},
								border: false,
								width: 170,
								defaultType: 'combo',
								items:[{
									xtype: 'label',
									height: 25
								},{
									id: 'delegateExecutorAreaCombo',
									fieldLabel: '节点',
									width: 120,
									disabled: true,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data: []
									}),
									listeners: {
										"select" : function(e){
											var assignNode = findXmlNodeByParentNode("assignment-handler",xmlNode);
											if(assignNode != null){
												var nodeField = findXmlAreaValueByName(assignNode,"process_executor_area");
												if(nodeField == null){
													addEventXmlNode(assignNode,"process_executor_area","delegateExecutorAreaCombo",null);
												}else{
													nodeField.firstChild.setAttribute("value",e.getValue());
												}
											}
										}
									}	
								},{
									id: 'delegatePartnerAreaCombo',
									fieldLabel: '节点',
									width: 120,
									disabled: true,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data: []
									})	
								}]				
							}]
						},{
							layout: 'form',
							labelWidth: 10,
							bodyStyle: {background:"#dfe7f4"},
							border: false,
							defaults: {width: '85%'},
							items: [{
								xtype: 'textfield',
								id: 'delegateUserBox',
								readOnly: true,
								disabled: true,
								listeners: {
									'focus' : function(){
										selectUser(currentParam,currentParam+"UserBox",currentParam+"UserIdBox");
									}
								}
							},{
								xtype: 'textfield',
								id: 'delegateRoleBox',
								readOnly: true,
								disabled: true,
								listeners: {
									'focus' : function(){
										selectRole(currentParam,currentParam+"RoleBox",currentParam+"RoleIdBox");
									}
								}
							},{
								xtype: 'textfield',
								id: 'delegateDeptBox',
								readOnly: true,
								disabled: true,
								listeners: {
									'focus' : function(){
										selectDept(currentParam,currentParam+"DeptBox",currentParam+"DeptIdBox");
									}
								}
							},{
								xtype: 'hidden',
								id: 'delegateUserIdBox'
							},{
								xtype: 'hidden',
								id: 'delegateRoleIdBox'
							},{
								xtype: 'hidden',
								id: 'delegateDeptIdBox'
							},{
								xtype: 'combo',
								id: 'delegateSwimlaneCombo',	
								width: 150,
								disabled: true,
								editable: false,
								valueField: 'value',
								displayField: 'text',
								triggerAction: 'all',
								emptyText: '请选择',
								mode: 'local',
								store: new Ext.data.SimpleStore({
									id: 'delegateSwimlaneStore',
									fields: ['value','text'],
									data: []
								}),
								listeners: {
									"select": function(e){
										xmlNode.setAttribute("swimlane",e.getValue());
										presrc.lastChild.firstChild.innerHTML = "TaskNode<span title='"+e.getValue()+"' class='sign'>泳</span>";
									}
								}
							}]
						}]							
					}]
				});		
				break
			case "signDelegate":
				currentCard = new Ext.form.FormPanel({
					id: currentParam,
					border: false,
					bodyStyle: {background:"#dfe7f4",padding:"10 0 0 20"},
					labelAlign: 'left',							
					items:[{
						bodyStyle: {background:"#dfe7f4"},
						border: false,
						layout: 'column',	
						items: [{
							width: 170,
							labelWidth: 80,
							border: false,
							layout: 'form',
							defaults: {height: 22},
							bodyStyle: {background:"#dfe7f4"},
							defaultType: 'checkbox',
							items: [{
								id: 'signDelegateSponsorCheck',
								fieldLabel: '会签委派',
								boxLabel: '流程发起者',
								listeners: {
									"check": function(){
										Ext.getCmp("signDelegateSponsorCombo").disabled?Ext.getCmp("signDelegateSponsorCombo").enable():Ext.getCmp("signDelegateSponsorCombo").disable();
										if(xmlNode != null){
											var fieldNode = findXmlAreaValueByName(xmlNode,"signCandidateHandler");
											var fieldObject  = null;
											if(fieldNode != null){
												fieldObject = findXmlNodeByParentNode("object",fieldNode);
											}
											if(Ext.getCmp("signDelegateSponsorCombo").disabled){
												if(fieldObject != null){
													var nodeField = findXmlAreaValueByName(fieldObject,"process_sponsor");
													if(nodeField!=null){
														fieldObject.removeChild(nodeField);
													}
												}
											}else{
												signField(fieldNode,fieldObject,"process_sponsor","signDelegateSponsorCombo");
											}
										}
									}
								}	
							},{
								id: 'signDelegateExecutorCheck',
								boxLabel: '流程执行者',
								listeners: {
									"check": function(){
										Ext.getCmp("signDelegateExecutorCombo").disabled?Ext.getCmp("signDelegateExecutorCombo").enable():Ext.getCmp("signDelegateExecutorCombo").disable();
										Ext.getCmp("signDelegateExecutorTypeCombo").disabled?Ext.getCmp("signDelegateExecutorTypeCombo").enable():Ext.getCmp("signDelegateExecutorTypeCombo").disable();
										if(Ext.getCmp("signDelegateExecutorTypeCombo").getValue() == "one" && !Ext.getCmp("signDelegateExecutorTypeCombo").disabled)
											Ext.getCmp("signDelegateExecutorAreaCombo").enable();
										else
											Ext.getCmp("signDelegateExecutorAreaCombo").disable();
										if(xmlNode != null){
											var fieldNode = findXmlAreaValueByName(xmlNode,"signCandidateHandler");
											var fieldObject  = null;
											if(fieldNode != null){
												fieldObject = findXmlNodeByParentNode("object",fieldNode);
											}
											if(Ext.getCmp("signDelegateExecutorCombo").disabled){
												if(fieldObject != null){
													var nodeField = findXmlAreaValueByName(fieldObject,"process_executor");
													var nodeField1 = findXmlAreaValueByName(fieldObject,"process_executor_area");
													if(nodeField!=null)
														fieldObject.removeChild(nodeField);
													if(nodeField1!=null)
														fieldObject.removeChild(nodeField1);
												}
											}else{
												signField(fieldNode,fieldObject,"process_executor","signDelegateExecutorCombo");
												if(!Ext.getCmp("signDelegateExecutorAreaCombo").disabled){
													if(Ext.getCmp("signDelegateExecutorAreaCombo").getValue() != "")
														addEventXmlNode(fieldObject,"process_executor_area","signDelegateExecutorAreaCombo",null);
												}
											}
										}
									}
								}	
							},{
								id: 'signDelegatePartnerCheck',
								boxLabel: '流程参与者',
								listeners: {
									"check": function(){
										Ext.getCmp("signDelegatePartnerCombo").disabled?Ext.getCmp("signDelegatePartnerCombo").enable():Ext.getCmp("signDelegatePartnerCombo").disable();
										Ext.getCmp("signDelegatePartnerTypeCombo").disabled?Ext.getCmp("signDelegatePartnerTypeCombo").enable():Ext.getCmp("signDelegatePartnerTypeCombo").disable();
										if(Ext.getCmp("signDelegatePartnerTypeCombo").getValue() == "one" && !Ext.getCmp("signDelegatePartnerTypeCombo").disabled)
											Ext.getCmp("signDelegatePartnerAreaCombo").enable();
										else
											Ext.getCmp("signDelegatePartnerAreaCombo").disable();
									}
								}	
							},{
								boxLabel: '用户',
								id: 'signDelegateUserCheck',
								listeners: {
									"check": function(){
										Ext.getCmp("signDelegateUserBox").disabled?Ext.getCmp("signDelegateUserBox").enable():Ext.getCmp("signDelegateUserBox").disable();
										if(xmlNode != null){
											var fieldNode = findXmlAreaValueByName(xmlNode,"signCandidateHandler");
											var fieldObject  = null;
											if(fieldNode != null){
												fieldObject = findXmlNodeByParentNode("object",fieldNode);
											}
											if(Ext.getCmp("signDelegateUserBox").disabled){
												xmlNode.removeAttribute("candidate-users");
												xmlNode.removeAttribute("users");
												if(fieldObject != null){
													var nodeField = findXmlAreaValueByName(fieldObject,"sign_users");
													if(nodeField!=null){
														fieldObject.removeChild(nodeField);
													}
												}
											}else{
												if(Ext.getCmp("signDelegateUserBox").getValue() != ""){
													xmlNode.setAttribute("candidate-users",Ext.getCmp("signDelegateUserIdBox").getValue());
													xmlNode.setAttribute("users",Ext.getCmp("signDelegateUserBox").getValue());
												}
												signField(fieldNode,fieldObject,"sign_users","signDelegateUserIdBox");
											}
										}
									}
								}	
							},{
								boxLabel: '角色',
								id: 'signDelegateRoleCheck',
								listeners: {
									"check": function(){
										Ext.getCmp("signDelegateRoleBox").disabled?Ext.getCmp("signDelegateRoleBox").enable():Ext.getCmp("signDelegateRoleBox").disable();
										if(xmlNode != null){
											var fieldNode = findXmlAreaValueByName(xmlNode,"signCandidateHandler");
											var fieldObject  = null;
											if(fieldNode != null){
												fieldObject = findXmlNodeByParentNode("object",fieldNode);
											}
											if(Ext.getCmp("signDelegateRoleBox").disabled){
												xmlNode.removeAttribute("candidate-roles");
												xmlNode.removeAttribute("roles");
												xmlNode.setAttribute("candidate-groups",Ext.getCmp("signDelegateDeptBox").disabled?"":Ext.getCmp("signDelegateDeptIdBox").getValue());
												if(xmlNode.getAttribute("candidate-groups") == "")
													xmlNode.removeAttribute("candidate-groups");
												if(fieldObject != null){
													var nodeField = findXmlAreaValueByName(fieldObject,"sign_roles");
													if(nodeField!=null){
														fieldObject.removeChild(nodeField);
													}
												}
											}else{
												if(Ext.getCmp("signDelegateRoleBox").getValue() != ""){
													xmlNode.setAttribute("candidate-roles",Ext.getCmp("signDelegateRoleIdBox").getValue());
													xmlNode.setAttribute("roles",Ext.getCmp("signDelegateRoleBox").getValue());
													if(xmlNode.getAttribute("candidate-groups")!=""&&xmlNode.getAttribute("candidate-groups")!=null){
														xmlNode.setAttribute("candidate-groups",xmlNode.getAttribute("candidate-groups")+","+Ext.getCmp("signDelegateRoleIdBox").getValue());
													}else{
														xmlNode.setAttribute("candidate-groups",Ext.getCmp("signDelegateRoleIdBox").getValue());
													}
												}
												signField(fieldNode,fieldObject,"sign_roles","signDelegateRoleIdBox");
											}
										}
									}
								}
							},{
								boxLabel: '部门',
								id: 'signDelegateDeptCheck',
								listeners: {
									"check": function(){
										Ext.getCmp("signDelegateDeptBox").disabled?Ext.getCmp("signDelegateDeptBox").enable():Ext.getCmp("signDelegateDeptBox").disable();
										if(xmlNode != null){
											var fieldNode = findXmlAreaValueByName(xmlNode,"signCandidateHandler");
											var fieldObject  = null;
											if(fieldNode != null){
												fieldObject = findXmlNodeByParentNode("object",fieldNode);
											}
											if(Ext.getCmp("signDelegateDeptBox").disabled){
												xmlNode.removeAttribute("candidate-depts");
												xmlNode.removeAttribute("depts");
												xmlNode.setAttribute("candidate-groups",Ext.getCmp("signDelegateRoleBox").disabled?"":Ext.getCmp("signDelegateRoleIdBox").getValue());
												if(xmlNode.getAttribute("candidate-groups") == "")
													xmlNode.removeAttribute("candidate-groups");
												if(fieldObject != null){
													var nodeField = findXmlAreaValueByName(fieldObject,"sign_depts");
													if(nodeField!=null){
														fieldObject.removeChild(nodeField);
													}
												}
											}else{
												if(Ext.getCmp("signDelegateDeptBox").getValue() != ""){
													xmlNode.setAttribute("candidate-depts",Ext.getCmp("signDelegateDeptIdBox").getValue());
													xmlNode.setAttribute("depts",Ext.getCmp("signDelegateDeptBox").getValue());
													if(xmlNode.getAttribute("candidate-groups")!=""&&xmlNode.getAttribute("candidate-groups")!=null){
														xmlNode.setAttribute("candidate-groups",xmlNode.getAttribute("candidate-groups")+","+Ext.getCmp("signDelegateDeptIdBox").getValue());
													}else{
														xmlNode.setAttribute("candidate-groups",Ext.getCmp("signDelegateDeptIdBox").getValue());
													}
												}
												signField(fieldNode,fieldObject,"sign_depts","signDelegateDeptIdBox");
											}
										}
									}
								}
							}]
						},{
							layout: 'column',
							border: false,
							bodyStyle: {background:"#dfe7f4"},
							items: [{
								layout: 'form',
								labelWidth: 10,
								bodyStyle: {background:"#dfe7f4"},
								border: false,
								width: 130,
								defaultType: 'combo',
								items:[{
									id: 'signDelegateSponsorCombo',
									width: 100,
									disabled: true,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data:[
											['include','包含'],
											['except','除外']								
										]
									}),
									scope: this,
									listeners: {
										"beforerender" : function(){
											this.setValue('include');
										},
										"select" : function(e){
											var fieldNode = findXmlAreaValueByName(xmlNode,"signCandidateHandler");
											var fieldObject  = null;
											if(fieldNode != null){
												fieldObject = findXmlNodeByParentNode("object",fieldNode);
											}
											if(fieldObject != null){
												var nodeField = findXmlAreaValueByName(fieldObject,"process_sponsor");
												nodeField.firstChild.setAttribute("value",e.getValue());
											}
										}
									}
								},{
									id: 'signDelegateExecutorCombo',
									width: 100,
									disabled: true,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data:[
											['include','包含'],
											['except','除外']								
										]
									}),
									scope: this,
									listeners: {
										"beforerender": function(){
											this.setValue('include');
										},
										"select" : function(e){
											var fieldNode = findXmlAreaValueByName(xmlNode,"signCandidateHandler");
											var fieldObject  = null;
											if(fieldNode != null){
												fieldObject = findXmlNodeByParentNode("object",fieldNode);
											}
											if(fieldObject != null){
												var nodeField = findXmlAreaValueByName(fieldObject,"process_executor");
												nodeField.firstChild.setAttribute("value",e.getValue());
											}
										}
									}
								},{
									id: 'signDelegatePartnerCombo',
									width: 100,
									disabled: true,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data:[
											['include','包含'],
											['except','除外']									
										]
									}),
									scope: this,
									listeners: {
										"beforerender": function(){
											this.setValue('include');
										}
									}
								}]			
							},{
								layout: 'form',
								labelWidth: 33,
								bodyStyle: {background:"#dfe7f4"},
								border: false,
								width: 170,
								defaultType: 'combo',
								items:[{
									xtype: 'label',
									height: 25
								},{
									id: 'signDelegateExecutorTypeCombo',
									fieldLabel: '类型',
									width: 120,
									disabled: true,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data:[
											['all','整个流程执行者'],
											['one','某个节点执行者']								
										]
									}),
									scope: this,
									listeners: {
										"select": function(){
											var fieldNode = findXmlAreaValueByName(xmlNode,"signCandidateHandler");
											var fieldObject  = null;
											if(fieldNode != null){
												fieldObject = findXmlNodeByParentNode("object",fieldNode);
											}
											if(this.getValue() == "all"){
												Ext.getCmp("signDelegateExecutorAreaCombo").disable();
												if(fieldObject != null){
													var nodeField = findXmlAreaValueByName(fieldObject,"process_executor_area");
													if(nodeField != null)
														assignNode.removeChild(nodeField);
												}
											}else{
												//获取所有XML任务节点
												var tasks = xml.getElementsByTagName("task");
												var arrays = [];
												for(var i=0;i<tasks.length;i++){
													arrays.push([tasks[i].getAttribute("name"),tasks[i].getAttribute("name")]);
												}
												Ext.getCmp("signDelegateExecutorAreaCombo").getStore().loadData(arrays);
												Ext.getCmp("signDelegateExecutorAreaCombo").enable();
												if(Ext.getCmp("signDelegateExecutorAreaCombo").getValue() != "")
													signField(fieldNode,fieldObject,"process_executor_area","signDelegateExecutorAreaCombo");
											}
										},
										"beforerender": function(){
											this.setValue('all');								
										}
									}
								},{
									id: 'signDelegatePartnerTypeCombo',
									fieldLabel: '类型',
									width: 120,
									disabled: true,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data:[
											['all','整个流程参与者'],
											['one','某个节点参与者']								
										]
									}),
									scope: this,
									listeners: {
										"select": function(){
											if(this.getValue() == 'all'){
												Ext.getCmp("signDelegatePartnerAreaCombo").disable();
											}else{
												//获取所有XML任务节点
												var tasks = xml.getElementsByTagName("task");
												var arrays = [];
												for(var i=0;i<tasks.length;i++){
													arrays.push([tasks[i].getAttribute("name"),tasks[i].getAttribute("name")]);
												}
												Ext.getCmp("signDelegatePartnerAreaCombo").getStore().loadData(arrays);
												Ext.getCmp("signDelegatePartnerAreaCombo").enable();
											}
										},
										"beforerender": function(){
											this.setValue('all');								
										}
									}	
								}]
							},{
								layout: 'form',
								labelWidth: 33,
								bodyStyle: {background:"#dfe7f4"},
								border: false,
								width: 170,
								defaultType: 'combo',
								items:[{
									xtype: 'label',
									height: 25
								},{
									id: 'signDelegateExecutorAreaCombo',
									fieldLabel: '节点',
									width: 120,
									disabled: true,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data: []
									}),
									listeners: {
										"select" : function(e){
											var fieldNode = findXmlAreaValueByName(xmlNode,"signCandidateHandler");
											var fieldObject  = null;
											if(fieldNode != null){
												fieldObject = findXmlNodeByParentNode("object",fieldNode);
											}
											if(fieldObject != null){
												var nodeField = findXmlAreaValueByName(fieldObject,"process_executor_area");
												if(nodeField == null){
													signField(fieldNode,fieldObject,"process_executor_area","signDelegateExecutorAreaCombo");
												}else{
													nodeField.firstChild.setAttribute("value",e.getValue());
												}
											}
										}
									}	
								},{
									id: 'signDelegatePartnerAreaCombo',
									fieldLabel: '节点',
									width: 120,
									disabled: true,
									editable: false,
									valueField: 'value',
									displayField: 'text',
									triggerAction: 'all',
									emptyText: '请选择',
									mode: 'local',
									store: new Ext.data.SimpleStore({
										fields: ['value','text'],
										data: []
									})	
								}]				
							}]
						},{
							layout: 'form',
							labelWidth: 10,
							bodyStyle: {background:"#dfe7f4"},
							border: false,
							defaults: {width: '85%'},
							items: [{
								xtype: 'textfield',
								id: 'signDelegateUserBox',
								readOnly: true,
								disabled: true,
								listeners: {
									'focus' : function(){
										selectUser(currentParam,currentParam+"UserBox",currentParam+"UserIdBox");
									}
								}
							},{
								xtype: 'textfield',
								id: 'signDelegateRoleBox',
								readOnly: true,
								disabled: true,
								listeners: {
									'focus' : function(){
										selectRole(currentParam,currentParam+"RoleBox",currentParam+"RoleIdBox");
									}
								}
							},{
								xtype: 'textfield',
								id: 'signDelegateDeptBox',
								readOnly: true,
								disabled: true,
								listeners: {
									'focus' : function(){
										selectDept(currentParam,currentParam+"DeptBox",currentParam+"DeptIdBox");
									}
								}
							},{
								xtype: 'hidden',
								id: 'signDelegateUserIdBox'
							},{
								xtype: 'hidden',
								id: 'signDelegateRoleIdBox'
							},{
								xtype: 'hidden',
								id: 'signDelegateDeptIdBox'
							}]
						}]							
					}]
				});		
				break
			case "autoDelegate":
				currentCard = new Ext.form.FormPanel({
					id: currentParam,
					border: false,
					bodyStyle: {background:"#dfe7f4",padding:"10 0 0 20"},
					labelAlign: 'left',	
					items:[{
						bodyStyle: {background:"#dfe7f4"},
						border: false,
						layout: 'column',	
						items: [{
							width: 170,
							labelWidth: 80,
							border: false,
							layout: 'form',
							defaults: {height: 22},
							bodyStyle: {background:"#dfe7f4"},
							defaultType: 'checkbox',
							items: [{
								fieldLabel: '委派范围',
								boxLabel: '用户',
								id: 'autoDelegateUserCheck',
								listeners: {
									"check": function(){
										Ext.getCmp("autoDelegateUserBox").disabled?Ext.getCmp("autoDelegateUserBox").enable():Ext.getCmp("autoDelegateUserBox").disable();
										var node = findXmlNodeByTitle("event-listener",eventsrc.id,"autoDelegate");
										if(node == null){
											if(Ext.getCmp("autoDelegateUserBox").getValue() != ""&&!Ext.getCmp("autoDelegateUserBox").disabled){
												addXmlNodeByName("autoDelegate",Ext.getCmp("baseName").getValue(),xmlNode.parentNode);
												node = findXmlNodeByTitle("event-listener",eventsrc.id,"autoDelegate");
											}
										}
										if(node != null){
											var nodeField = findXmlAreaValueByName(node,"auto_user");
											var nextTask = findXmlNodeByName("task",xmlNode.getAttribute("to"),null);
											if(Ext.getCmp("autoDelegateUserBox").disabled){
												if(nodeField!=null)
													node.removeChild(nodeField);
												if(node.childNodes.length == 1){
													if(node.parentNode.childNodes.length == 1)
														node.parentNode.parentNode.removeChild(node.parentNode);
													else
														node.parentNode.removeChild(node);
												}
												if(nextTask != null)
													nextTask.removeAttribute("candidate-users");
											}else{
												if(nodeField == null){
													if(Ext.getCmp("autoDelegateUserBox").getValue() != "")
														addEventXmlNode(node,"auto_user","autoDelegateUserIdBox","autoDelegateUserBox");
												}else{
													nodeField.firstChild.setAttribute("value",Ext.getCmp("autoDelegateUserIdBox").getValue());
													nodeField.firstChild.setAttribute("name",Ext.getCmp("autoDelegateUserBox").getValue());
												}
												if(nextTask != null&&Ext.getCmp("autoDelegateUserBox").getValue() != "")
													nextTask.setAttribute("candidate-users","${users_"+hex_md5(Ext.getCmp("baseName").getValue())+"}");
											}
										}
									}
								}	
							},{
								boxLabel: '角色',
								id: 'autoDelegateRoleCheck',
								listeners: {
									"check": function(){
										Ext.getCmp("autoDelegateRoleBox").disabled?Ext.getCmp("autoDelegateRoleBox").enable():Ext.getCmp("autoDelegateRoleBox").disable();
										var node = findXmlNodeByTitle("event-listener",eventsrc.id,"autoDelegate");
										if(node == null){
											if(Ext.getCmp("autoDelegateRoleBox").getValue() != ""&&!Ext.getCmp("autoDelegateRoleBox").disabled){
												addXmlNodeByName("autoDelegate",Ext.getCmp("baseName").getValue(),xmlNode.parentNode);
												node = findXmlNodeByTitle("event-listener",eventsrc.id,"autoDelegate");
											}
										}
										if(node != null){
											var nodeField = findXmlAreaValueByName(node,"auto_role");
											var nextTask = findXmlNodeByName("task",xmlNode.getAttribute("to"),null);
											if(Ext.getCmp("autoDelegateRoleBox").disabled){
												if(nodeField!=null)
													node.removeChild(nodeField);
												if(node.childNodes.length == 1){
													if(node.parentNode.childNodes.length == 1)
														node.parentNode.parentNode.removeChild(node.parentNode);
													else
														node.parentNode.removeChild(node);
												}
												if(nextTask != null&&(Ext.getCmp("autoDelegateDeptBox").disabled||Ext.getCmp("autoDelegateDeptBox").getValue()==""))
													nextTask.removeAttribute("candidate-groups");
											}else{
												if(nodeField == null){
													if(Ext.getCmp("autoDelegateRoleBox").getValue() != "")
														addEventXmlNode(node,"auto_role","autoDelegateRoleIdBox","autoDelegateRoleBox");
												}else{
													nodeField.firstChild.setAttribute("value",Ext.getCmp("autoDelegateRoleIdBox").getValue());
													nodeField.firstChild.setAttribute("name",Ext.getCmp("autoDelegateRoleBox").getValue());
												}
												if(nextTask != null&&Ext.getCmp("autoDelegateRoleBox").getValue() != "")
													nextTask.setAttribute("candidate-groups","${groups_"+hex_md5(Ext.getCmp("baseName").getValue())+"}");
											}
										}
									}
								}
							},{
								boxLabel: '部门',
								id: 'autoDelegateDeptCheck',
								listeners: {
									"check": function(){
										Ext.getCmp("autoDelegateDeptBox").disabled?Ext.getCmp("autoDelegateDeptBox").enable():Ext.getCmp("autoDelegateDeptBox").disable();
										var node = findXmlNodeByTitle("event-listener",eventsrc.id,"autoDelegate");
										if(node == null){
											if(Ext.getCmp("autoDelegateDeptBox").getValue() != ""&&!Ext.getCmp("autoDelegateDeptBox").disabled){
												addXmlNodeByName("autoDelegate",Ext.getCmp("baseName").getValue(),xmlNode.parentNode);
												node = findXmlNodeByTitle("event-listener",eventsrc.id,"autoDelegate");
											}
										}
										if(node != null){
											var nodeField = findXmlAreaValueByName(node,"auto_dept");
											var nextTask = findXmlNodeByName("task",xmlNode.getAttribute("to"),null);
											if(Ext.getCmp("autoDelegateDeptBox").disabled){
												if(nodeField!=null)
													node.removeChild(nodeField);
												if(node.childNodes.length == 1){
													if(node.parentNode.childNodes.length == 1)
														node.parentNode.parentNode.removeChild(node.parentNode);
													else
														node.parentNode.removeChild(node);
												}
												if(nextTask != null&&(Ext.getCmp("autoDelegateRoleBox").disabled||Ext.getCmp("autoDelegateRoleBox").getValue()==""))
													nextTask.removeAttribute("candidate-groups");
											}else{
												if(nodeField == null){
													if(Ext.getCmp("autoDelegateDeptBox").getValue() != "")
														addEventXmlNode(node,"auto_dept","autoDelegateDeptIdBox","autoDelegateDeptBox");
												}else{
													nodeField.firstChild.setAttribute("value",Ext.getCmp("autoDelegateDeptIdBox").getValue());
													nodeField.firstChild.setAttribute("name",Ext.getCmp("autoDelegateDeptBox").getValue());
												}
												if(nextTask != null&&Ext.getCmp("autoDelegateDeptBox").getValue() != "")
													nextTask.setAttribute("candidate-groups","${groups_"+hex_md5(Ext.getCmp("baseName").getValue())+"}");
											}
										}
									}
								}
							}]
						},{
							layout: 'form',
							labelWidth: 10,
							bodyStyle: {background:"#dfe7f4"},
							border: false,
							defaults: {width: '85%'},
							items: [{
								xtype: 'textfield',
								id: 'autoDelegateUserBox',
								readOnly: true,
								disabled: true,
								listeners: {
									'focus': function(){
										selectUser(currentParam,currentParam+"UserBox",currentParam+"UserIdBox");
									}
								}
							},{
								xtype: 'textfield',
								id: 'autoDelegateRoleBox',
								readOnly: true,
								disabled: true,
								listeners: {
									'focus' : function(){
										selectRole(currentParam,currentParam+"RoleBox",currentParam+"RoleIdBox");
									}
								}
							},{
								xtype: 'textfield',
								id: 'autoDelegateDeptBox',
								readOnly: true,
								disabled: true,
								listeners: {
									'focus' : function(){
										selectDept(currentParam,currentParam+"DeptBox",currentParam+"DeptIdBox");
									}
								}
							},{
								xtype: 'hidden',
								id: 'autoDelegateUserIdBox'
							},{
								xtype: 'hidden',
								id: 'autoDelegateRoleIdBox'
							},{
								xtype: 'hidden',
								id: 'autoDelegateDeptIdBox'
							}]
						}]													
					}]
				});		
				break;
			case "method":
				currentCard = new Ext.form.FormPanel({
					id: currentParam,
					border: false,
					bodyStyle: {background:"#dfe7f4",padding:"10 0 0 20"},
					labelAlign: 'left',				
					items: [{
						layout: 'column',
						border: false,		
						bodyStyle: {background:"#dfe7f4"},
						items: [{
							width: 210,
							layout: 'form',
							defaultType: 'radio',
							defaults: {height: 22},
							bodyStyle: {background:"#dfe7f4"},
							border: false,
							labelWidth: 80,	
							items: [/*{
								fieldLabel: '分配策略',
								boxLabel: '任意分配给一个人',
								value: '1',
								name: 'methodDistributionRadio',
								checked: true
							},{
								boxLabel: '分配给所有人',
								value: '2',
								name: 'methodDistributionRadio',
								listeners: {
									"check": function(e){
										if(xmlNode != null){
											var radios = Ext.getCmp(currentParam).find("name","methodCompleteRadio");
											if(e.getValue()){
												for(var i=0;i<radios.length;i++){
													radios[i].enable();
												}
												//获取所有XML任务转移节点
												var transitions = xmlNode.childNodes;
												var arrays = [];
												for(var i=0;i<transitions.length;i++){
													if(transitions[i].tagName == "transition")
														arrays.push([transitions[i].getAttribute("name"),transitions[i].getAttribute("name")]);
												}
												Ext.getCmp("methodPassCombo").getStore().loadData(arrays);
												Ext.getCmp("methodNoPassCombo").getStore().loadData(arrays);
												Ext.getCmp("methodPassCombo").enable();
												Ext.getCmp("methodNoPassCombo").enable();
												var assignNode = findXmlNodeByParentNode("assignment-handler",xmlNode);
												if(assignNode == null){
													var assign_handler = xml.createElement("assignment-handler");
													assign_handler.setAttribute("class","com.huateng.sys.jbpm.listener.CandidateHandler");
													xmlNode.appendChild(assign_handler);
													var fieldNode = xml.createElement("field");
													fieldNode.setAttribute("name","method");
													assign_handler.appendChild(fieldNode);
													var valueNode = xml.createElement("string");
													fieldNode.appendChild(valueNode);
												}
											}else{
												for(var i=0;i<radios.length;i++){
													radios[i].disable();
													radios[i].setValue(false);
												}
												Ext.getCmp("methodNumBox").disable();
												Ext.getCmp("methodNumBox").setValue("");
												Ext.getCmp("methodPercentBox").disable();
												Ext.getCmp("methodPercentBox").setValue("");
												Ext.getCmp("methodPassCombo").disable();
												Ext.getCmp("methodNoPassCombo").disable();
												var assignNode = findXmlNodeByParentNode("assignment-handler",xmlNode);
												if(assignNode != null){
													xmlNode.removeChild(assignNode);
												}
											}
										}
									}
								}
							},*/{
								fieldLabel: '完成策略',
								boxLabel: '任意完成一个',
								value: '1',
								name: 'methodCompleteRadio',
								disabled: false,
								listeners: {
									"check": function(e){
										if(e.getValue()){
											var fieldNode = findXmlAreaValueByName(xmlNode,"judgeType");
											if(fieldNode != null){
												fieldNode.firstChild.setAttribute("value","OnePass");
											}else{
												var fieldNode = xml.createElement("field");
												fieldNode.setAttribute("name","judgeType");
												xmlNode.appendChild(fieldNode);
												var valueNode = xml.createElement("string");
												fieldNode.appendChild(valueNode);
												fieldNode.firstChild.setAttribute("value","OnePass");
											}
											fieldNode = findXmlAreaValueByName(xmlNode,"judgeParam");
											if(fieldNode != null)
												xmlNode.removeChild(fieldNode);
										}
									}
								}
							},{
								boxLabel: '必须完成所有',
								value: '2',
								name: 'methodCompleteRadio',
								disabled: false,
								listeners: {
									"check": function(e){
										if(e.getValue()){
											var fieldNode = findXmlAreaValueByName(xmlNode,"judgeType");
											if(fieldNode != null){
												fieldNode.firstChild.setAttribute("value","AllPass");
											}else{
												var fieldNode = xml.createElement("field");
												fieldNode.setAttribute("name","judgeType");
												xmlNode.appendChild(fieldNode);
												var valueNode = xml.createElement("string");
												fieldNode.appendChild(valueNode);
												fieldNode.firstChild.setAttribute("value","AllPass");
											}
											fieldNode = findXmlAreaValueByName(xmlNode,"judgeParam");
											if(fieldNode != null)
												xmlNode.removeChild(fieldNode);
										}
									}
								}
							},{
								boxLabel: '按完成个数',
								value: '3',
								name: 'methodCompleteRadio',
								disabled: false,
								listeners: {
									"check": function(e){
										Ext.getCmp("methodNumBox").disabled?Ext.getCmp("methodNumBox").enable():Ext.getCmp("methodNumBox").disable();
										if(e.getValue()){
											var fieldNode = findXmlAreaValueByName(xmlNode,"judgeType");
											if(fieldNode != null){
												fieldNode.firstChild.setAttribute("value","numPass");
											}else{
												var fieldNode = xml.createElement("field");
												fieldNode.setAttribute("name","judgeType");
												xmlNode.appendChild(fieldNode);
												var valueNode = xml.createElement("string");
												fieldNode.appendChild(valueNode);
												fieldNode.firstChild.setAttribute("value","numPass");
											}
											
											var fieldNode = findXmlAreaValueByName(xmlNode,"judgeParam");
											if(fieldNode != null){
												fieldNode.firstChild.setAttribute("value",Ext.getCmp("methodNumBox").getValue());
											}else{
												var fieldNode = xml.createElement("field");
												fieldNode.setAttribute("name","judgeParam");
												xmlNode.appendChild(fieldNode);
												var valueNode = xml.createElement("string");
												fieldNode.appendChild(valueNode);
												fieldNode.firstChild.setAttribute("value",Ext.getCmp("methodNumBox").getValue());
											}
										}
									}
								}
							},{
								boxLabel: '按完成百分比',
								value: '4',
								name: 'methodCompleteRadio',
								disabled: false,
								listeners: {
									"check": function(e){
										Ext.getCmp("methodPercentBox").disabled?Ext.getCmp("methodPercentBox").enable():Ext.getCmp("methodPercentBox").disable();
										if(e.getValue()){
											var fieldNode = findXmlAreaValueByName(xmlNode,"judgeType");
											if(fieldNode != null){
												fieldNode.firstChild.setAttribute("value","percentPass");
											}else{
												var fieldNode = xml.createElement("field");
												fieldNode.setAttribute("name","judgeType");
												xmlNode.appendChild(fieldNode);
												var valueNode = xml.createElement("string");
												fieldNode.appendChild(valueNode);
												fieldNode.firstChild.setAttribute("value","percentPass");
											}
											
											var fieldNode = findXmlAreaValueByName(xmlNode,"judgeParam");
											if(fieldNode != null){
												fieldNode.firstChild.setAttribute("value",Ext.getCmp("methodPercentBox").getValue());
											}else{
												var fieldNode = xml.createElement("field");
												fieldNode.setAttribute("name","judgeParam");
												xmlNode.appendChild(fieldNode);
												var valueNode = xml.createElement("string");
												fieldNode.appendChild(valueNode);
												fieldNode.firstChild.setAttribute("value",Ext.getCmp("methodPercentBox").getValue());
											}
										}
									}
								}
							},{
								xtype: 'combo',
								id: 'methodPassCombo',
								fieldLabel: '完成路径',
								width: 120,
								disabled: false,
								editable: false,
								valueField: 'value',
								displayField: 'text',
								triggerAction: 'all',
								emptyText: '请选择',
								mode: 'local',
								store: new Ext.data.SimpleStore({
									fields: ['value','text'],
									data: []
								}),
								listeners: {
									"select": function(e){
										if(e.getValue() != ""){
											var fieldNode = findXmlAreaValueByName(xmlNode,"passTran");
											if(fieldNode != null){
												fieldNode.firstChild.setAttribute("value",e.getValue());
											}else{
												var fieldNode = xml.createElement("field");
												fieldNode.setAttribute("name","passTran");
												xmlNode.appendChild(fieldNode);
												var valueNode = xml.createElement("string");
												fieldNode.appendChild(valueNode);
												fieldNode.firstChild.setAttribute("value",e.getValue());
											}
										}
									}
								}
							},{
								xtype: 'combo',
								id: 'methodNoPassCombo',
								fieldLabel: '否决路径',
								width: 120,
								disabled: false,
								editable: false,
								valueField: 'value',
								displayField: 'text',
								triggerAction: 'all',
								emptyText: '请选择',
								mode: 'local',
								store: new Ext.data.SimpleStore({
									fields: ['value','text'],
									data: []
								}),
								listeners: {
									"select": function(e){
										if(e.getValue() != ""){
											var fieldNode = findXmlAreaValueByName(xmlNode,"noPassTran");
											if(fieldNode != null){
												fieldNode.firstChild.setAttribute("value",e.getValue());
											}else{
												var fieldNode = xml.createElement("field");
												fieldNode.setAttribute("name","noPassTran");
												xmlNode.appendChild(fieldNode);
												var valueNode = xml.createElement("string");
												fieldNode.appendChild(valueNode);
												fieldNode.firstChild.setAttribute("value",e.getValue());
											}
										}
									}
								}
							}]
						},{
							width: 100,
							layout: 'form',
							bodyStyle: {background:"#dfe7f4"},
							border: false,
							defaultType: 'textfield',
							labelWidth: 5,
							items: [{
								xtype: 'label',
								height: 57
							},{
								width: 80,
								id: 'methodNumBox',
								disabled: true,
								enableKeyEvents: true,
								listeners: {
									"keyup" : function(e){
										var fieldNode = findXmlAreaValueByName(xmlNode,"judgeParam");
										if(fieldNode != null)
											fieldNode.firstChild.setAttribute("value",e.getValue());
									}
								}
							},{
								width: 80,
								id: 'methodPercentBox',
								disabled: true,
								enableKeyEvents: true,
								listeners: {
									"keyup" : function(e){
										var fieldNode = findXmlAreaValueByName(xmlNode,"judgeParam");
										if(fieldNode != null)
											fieldNode.firstChild.setAttribute("value",e.getValue());
									}
								}
							}]
						},{
							width: 60,
							layout: 'form',
							bodyStyle: {background:"#dfe7f4"},
							border: false,
							defaultType: 'label',
							items: [{
								height: 85
							},{
								text: '个',
								height: 30,
								width: 60
							},{
								text: '%',
								height: 30,
								width: 60
							}]
						}]
					}]	
				});		
				break
			case "form":
				currentCard = new Ext.form.FormPanel({
					id: currentParam,
					border: false,
					bodyStyle: {background:"#dfe7f4",padding:"10 0 0 20"},
					labelAlign: 'left',
					labelWidth: 80,
					items:[{
						xtype: 'textfield',
						fieldLabel: '表单名称',
						id: 'formName',
						width: '80%',
						enableKeyEvents: true,
						listeners: {
							'keyup': function(e){
								if(presrc != null){
									modifyXmlNodeAttr(presrc,"form",e.getValue());
									if(e.getValue() == ""){
										var task = findXmlNode(presrc);	
										task.removeAttribute("form");
									}
								}
							}
						}
					}]
				});		
				break
			case "case":
				currentCard = new Ext.form.FormPanel({
					id: currentParam,
					border: false,
					bodyStyle: {background:"#dfe7f4",padding:"10 0 0 20"},
					labelAlign: 'left',
					labelWidth: 80,
					items: [{
						layout: 'column',
						border: false,
						bodyStyle: {background:"#dfe7f4"},
						items: [{
							layout: 'form',
							width: 220,
							border: false,
							bodyStyle: {background:"#dfe7f4"},
							defaultType: 'textfield',
							items: [{
								id: 'caseLeftValueBox',
								fieldLabel: '判断条件',
								width: 120
							}]
						},{
							layout: 'fit',
							xtype: 'panel',
							border: false,
							height: 20,
							width: 20,
							bodyStyle: {background:"#dfe7f4"},
							html: '<span title="引用变量" class="img_btn picon22" />'
						},{
							layout: 'form',
							width: 135,
							border: false,
							labelWidth: 5,
							bodyStyle: {background:"#dfe7f4"},
							items: [{
								id: 'caseCompareCombo',
								xtype: 'combo',
								width: 120,
								valueField: 'value',
								editable: false,
								displayField: 'text',
								triggerAction: 'all',
								emptyText: '请选择',
								mode: 'local',
								store: new Ext.data.SimpleStore({
									fields: ['value','text'],
									data:[
										['<','小于'],
										['>','大于'],
										['==','等于'],
										['!=','不等于'],
										['<=','小于等于'],
										['>=','大于等于']
									]
								})
							}]		
						},{
							layout: 'form',
							width: 145,
							border: false,
							labelWidth: 5,
							bodyStyle: {background:"#dfe7f4"},
							items: [{
								id: 'caseRightValueBox',
								xtype: 'textfield',
								width: 120
							}]				
						},{
							layout: 'fit',
							xtype: 'panel',
							border: false,
							height: 20,
							width: 20,
							bodyStyle: {background:"#dfe7f4"},
							html: '<span title="引用变量" class="img_btn picon22" />'
						}]
					},{
						layout: 'column',
						border: false,
						bodyStyle: {background:"#dfe7f4"},
						items: [{
							layout: 'form',
							border: false,
							width: 220,
							bodyStyle: {background:"#dfe7f4"},
							items: [{
								id: 'caseRelationCombo',
								xtype: 'combo',
								width: 120,
								editable: false,
								valueField: 'value',
								displayField: 'text',
								triggerAction: 'all',
								emptyText: '请选择',
								mode: 'local',
								store: new Ext.data.SimpleStore({
									fields: ['value','text'],
									data:[
										['&&','并且(and)'],
										['||','或者(or)']
									]
								})
							}]
						},{
							layout: 'fit',
							xtype: 'panel',
							border: false,
							height: 20,
							width: 20,
							bodyStyle: {background:"#dfe7f4"},
							html: '<span title="添加" onclick="caseAddCase()" class="img_btn picon23" />'			
						}]
					},{
						layout: 'form',
						border: false,
						bodyStyle: {background:"#dfe7f4"},
						items: [{
							id: 'caseExpressionBox',
							xtype: 'textarea',
							fieldLabel: '表达式',
							width: '85%',
							enableKeyEvents: true,
							listeners: {
								'keyup' : function(e){
									if(xmlNode != null){
										var conditionNode = findXmlNodeByNodeName(xmlNode,"condition");
										if(conditionNode != null){
											conditionNode.setAttribute("expr",e.getValue());
											if(e.getValue() == "")
												xmlNode.removeChild(conditionNode);
										}else{
											conditionNode = xml.createElement("condition");
											xmlNode.appendChild(conditionNode);
											conditionNode.setAttribute("expr",e.getValue());
										}
									}
								}
							}
						}]
					}]
				});		
				break
		}
		Ext.getCmp('paramCard').add(currentCard);
	}
	Ext.getCmp('paramCard').layout.setActiveItem(currentParam);
}

/******************************通用选择框*****************************/
var selectUsers = null;
var selectDepts = null;
var selectRoles = null;
//用户选择器
function selectUser(type,userName,userId){
	var joindata = join(Ext.getCmp(userName).getValue(),Ext.getCmp(userId).getValue());
	if(!selectUsers) selectUsers=new Huateng.Util.Select({
		selects:[{
			type:'tree',
			dataUrl:'TreeAction!getOrgUserTree.action',
		  	rootId:'#',
		  	isLeafOnly:true
		}],
		title: '选择用户',
		callback:function(data){
			var userNames="";
			var userIds="";
			for(var i=0;i<data.length;i++){
				var user = data[i];
				userNames += user.name + ",";
				userIds += user.id + ",";
			}
			if(i>0){
				userNames = userNames.substring(0,userNames.length-1);
				userIds = userIds.substring(0,userIds.length-1);
			}
			Ext.getCmp(selectUsers._userName).setValue(userNames);
			Ext.getCmp(selectUsers._userId).setValue(userIds);

			if(selectUsers._type == "swimlane"){
				var node = findXmlNodeByName("swimlane",Ext.getCmp("swimlaneDescriptionBox").getValue());
				if(node != null){
					if(userIds == ""){
						node.removeAttribute("candidate-users");
						node.removeAttribute("users");
					}else{
						node.setAttribute("candidate-users",userIds);
						node.setAttribute("users",userNames);
					}
				}
			}else if(selectUsers._type == "mailto"||selectUsers._type == "notice"){
				var node = findXmlNodeByName("event-listener",Ext.getCmp(selectUsers._type+"DescriptionBox").getValue(),selectUsers._type);
				if(node != null){
					var rcode = selectUsers._type;
					if(selectUsers._type == "mailto")
						rcode = "mail";
					var nodeField = findXmlAreaValueByName(node,rcode+"_user");
					if(userIds == ""){
						if(nodeField != null)
							node.removeChild(nodeField);
					}else{
						if(nodeField == null)
							nodeField = addEventXmlNode(node,rcode+"_user",selectUsers._type+"UserIdBox",selectUsers._type+"UserBox");
						nodeField.firstChild.setAttribute("value",userIds);
						nodeField.firstChild.setAttribute("name",userNames);
					}
				}
			}else if(selectUsers._type == "autoDelegate"){
				var node = findXmlNodeByTitle("event-listener",eventsrc.id,"autoDelegate");
				if(node == null){
					addXmlNodeByName("autoDelegate",Ext.getCmp("baseName").getValue(),xmlNode.parentNode);
					node = findXmlNodeByTitle("event-listener",eventsrc.id,"autoDelegate");
				}
				if(node != null){
					var nodeField = findXmlAreaValueByName(node,"auto_user");
					var nextTask = findXmlNodeByName("task",xmlNode.getAttribute("to"),null);
					if(userIds == ""){
						if(nodeField != null)
							node.removeChild(nodeField);
						if(node.childNodes.length == 1){
							if(node.parentNode.childNodes.length == 1)
								node.parentNode.parentNode.removeChild(node.parentNode);
							else
								node.parentNode.removeChild(node);
						}
						if(nextTask != null)
							nextTask.removeAttribute("candidate-users");
					}else{
						if(nodeField == null)
							nodeField = addEventXmlNode(node,"auto_user",selectUsers._type+"UserIdBox",selectUsers._type+"UserBox");
						nodeField.firstChild.setAttribute("value",userIds);
						nodeField.firstChild.setAttribute("name",userNames);
						if(nextTask != null)
							nextTask.setAttribute("candidate-users","${users_"+hex_md5(Ext.getCmp("baseName").getValue())+"}");
					}
				}
			}else{
				if(xmlNode != null){
					if(userIds == ""){
						xmlNode.removeAttribute("candidate-users");
						xmlNode.removeAttribute("users");
					}else{
						xmlNode.setAttribute("candidate-users",userIds);
						xmlNode.setAttribute("users",userNames);
					}
				}
			}
			sign_callback("user",userIds);
		}
	});
	selectUsers.dataItems = joindata;
	selectUsers._type = type;
	selectUsers._userName = userName;
	selectUsers._userId = userId;
	selectUsers.show();
}
//角色选择器
function selectRole(type,roleName,roleId){
	var joindata = join(Ext.getCmp(roleName).getValue(),Ext.getCmp(roleId).getValue());
	if(!selectRoles) selectRoles=new Huateng.Util.Select({
		selects:[{
			type:'select',
			dataUrl:'TreeAction!getRoleTree.action',
		  	isLeafOnly:true
		}],
		title: '选择角色',
		dataItems: [],
		callback:function(data){
			var roleNames="";
			var roleIds="";
			for(var i=0;i<data.length;i++){
				var role = data[i];
				roleNames += role.name + ",";
				roleIds += role.id + ",";
			}
			if(i>0){
				roleNames = roleNames.substring(0,roleNames.length-1);
				roleIds = roleIds.substring(0,roleIds.length-1);
			}
			Ext.getCmp(selectRoles._roleName).setValue(roleNames);
			Ext.getCmp(selectRoles._roleId).setValue(roleIds);
			
			if(selectRoles._type == "mailto"||selectRoles._type == "notice"){
				var node = findXmlNodeByName("event-listener",Ext.getCmp(selectRoles._type+"DescriptionBox").getValue(),selectRoles._type);
				if(node != null){
					var rcode = selectRoles._type;
					if(selectRoles._type == "mailto")
						rcode = "mail";
					var nodeField = findXmlAreaValueByName(node,rcode+"_role");
					if(roleIds == ""){
						if(nodeField != null)
							node.removeChild(nodeField);
					}else{
						if(nodeField == null)
							nodeField = addEventXmlNode(node,rcode+"_role",selectRoles._type+"RoleIdBox",selectRoles._type+"RoleBox");
						nodeField.firstChild.setAttribute("value",roleIds);
						nodeField.firstChild.setAttribute("name",roleNames);
					}
				}
			}else if(selectRoles._type == "autoDelegate"){
				var node = findXmlNodeByTitle("event-listener",eventsrc.id,"autoDelegate");
				if(node == null){
					addXmlNodeByName("autoDelegate",Ext.getCmp("baseName").getValue(),xmlNode.parentNode);
					node = findXmlNodeByTitle("event-listener",eventsrc.id,"autoDelegate");
				}
				if(node != null){
					var nodeField = findXmlAreaValueByName(node,"auto_role");
					var nextTask = findXmlNodeByName("task",xmlNode.getAttribute("to"),null);
					if(roleIds == ""){
						if(nodeField != null)
							node.removeChild(nodeField);
						if(node.childNodes.length == 1){
							if(node.parentNode.childNodes.length == 1)
								node.parentNode.parentNode.removeChild(node.parentNode);
							else
								node.parentNode.removeChild(node);
						}
						if(nextTask != null&&(Ext.getCmp("autoDelegateDeptBox").disabled||Ext.getCmp("autoDelegateDeptBox").getValue()==""))
							nextTask.removeAttribute("candidate-groups");
					}else{
						if(nodeField == null)
							nodeField = addEventXmlNode(node,"auto_role",selectRoles._type+"RoleIdBox",selectRoles._type+"RoleBox");
						nodeField.firstChild.setAttribute("value",roleIds);
						nodeField.firstChild.setAttribute("name",roleNames);
						if(nextTask != null)
							nextTask.setAttribute("candidate-groups","${groups_"+hex_md5(Ext.getCmp("baseName").getValue())+"}");
					}
				}
			}else{
				selectChangeXml(selectRoles._type,roleIds,roleNames,"roles");
			}
			sign_callback("role",roleIds);
		}
	});
	selectRoles.dataItems = joindata;
	selectRoles._type = type;
	selectRoles._roleName = roleName;
	selectRoles._roleId = roleId;
	selectRoles.show();
}
//部门选择器
function selectDept(type,deptName,deptId){
	var joindata = join(Ext.getCmp(deptName).getValue(),Ext.getCmp(deptId).getValue());
	if(!selectDepts) selectDepts=new Huateng.Util.Select({
		selects:[{
			type:'tree',
			dataUrl:'TreeAction!getOrgTree.action',
		  	rootId:'#',
		  	isLeafOnly:false,
		  	checkMode:false
		}],
		title: '选择部门',
		dataItems: [],
		callback:function(data){
			var deptNames="";
			var deptIds="";
			for(var i=0;i<data.length;i++){
				var dept = data[i];
				deptNames += dept.name + ",";
				deptIds += dept.id + ",";
			}
			if(i>0){
				deptNames = deptNames.substring(0,deptNames.length-1);
				deptIds = deptIds.substring(0,deptIds.length-1);
			}
			Ext.getCmp(selectDepts._deptName).setValue(deptNames);
			Ext.getCmp(selectDepts._deptId).setValue(deptIds);
			
			if(selectDepts._type == "mailto"||selectDepts._type == "notice"){
				var node = findXmlNodeByName("event-listener",Ext.getCmp(selectDepts._type+"DescriptionBox").getValue(),selectDepts._type);
				if(node != null){
					var rcode = selectDepts._type;
					if(selectDepts._type == "mailto")
						rcode = "mail";
					var nodeField = findXmlAreaValueByName(node,rcode+"_dept");
					if(deptIds == ""){
						if(nodeField != null)
							node.removeChild(nodeField);
					}else{
						if(nodeField == null)
							nodeField = addEventXmlNode(node,rcode+"_dept",selectDepts._type+"DeptIdBox",selectDepts._type+"DeptBox");
						nodeField.firstChild.setAttribute("value",deptIds);
						nodeField.firstChild.setAttribute("name",deptNames);
					}
				}
			}else if(selectDepts._type == "autoDelegate"){
				var node = findXmlNodeByTitle("event-listener",eventsrc.id,"autoDelegate");
				if(node == null){
					addXmlNodeByName("autoDelegate",Ext.getCmp("baseName").getValue(),xmlNode.parentNode);
					node = findXmlNodeByTitle("event-listener",eventsrc.id,"autoDelegate");
				}
				if(node != null){
					var nodeField = findXmlAreaValueByName(node,"auto_dept");
					var nextTask = findXmlNodeByName("task",xmlNode.getAttribute("to"),null);
					if(deptIds == ""){
						if(nodeField != null)
							node.removeChild(nodeField);
						if(node.childNodes.length == 1){
							if(node.parentNode.childNodes.length == 1)
								node.parentNode.parentNode.removeChild(node.parentNode);
							else
								node.parentNode.removeChild(node);
						}
						if(nextTask != null&&(Ext.getCmp("autoDelegateRoleBox").disabled||Ext.getCmp("autoDelegateRoleBox").getValue()==""))
							nextTask.removeAttribute("candidate-groups");
					}else{
						if(nodeField == null)
							nodeField = addEventXmlNode(node,"auto_dept",selectDepts._type+"DeptIdBox",selectDepts._type+"DeptBox");
						nodeField.firstChild.setAttribute("value",deptIds);
						nodeField.firstChild.setAttribute("name",deptNames);
						if(nextTask != null)
							nextTask.setAttribute("candidate-groups","${groups_"+hex_md5(Ext.getCmp("baseName").getValue())+"}");
					}
				}
			}else{
				selectChangeXml(selectDepts._type,deptIds,deptNames,"depts");
			}
			sign_callback("dept",deptIds);
		}
	});
	selectDepts.dataItems = joindata;
	selectDepts._type = type;
	selectDepts._deptName = deptName;
	selectDepts._deptId = deptId;
	selectDepts.show();
}

/*********************************通用方法*************************************/
//会签用户、部门、角色通用选择框回调
function sign_callback(_field,_value){
	var fieldNode = findXmlAreaValueByName(xmlNode,"signCandidateHandler");
	var fieldObject  = null;
	if(fieldNode != null){
		fieldObject = findXmlNodeByParentNode("object",fieldNode);
	}
	if(fieldObject != null){
		if(_field == "user")
			var nodeField = findXmlAreaValueByName(fieldObject,"sign_users");
		else if(_field == "role")
			var nodeField = findXmlAreaValueByName(fieldObject,"sign_roles");
		else
			var nodeField = findXmlAreaValueByName(fieldObject,"sign_depts");
		nodeField.firstChild.setAttribute("value",_value);
	}
}
//添加会签<field name="signCandidateHandler">节点
function signField(_fNode,_fObject,_attr,_value){
	if(_fNode == null){
		var _fNode = xml.createElement("field");
		_fNode.setAttribute("name","signCandidateHandler");
		_fObject = xml.createElement("object");
		_fNode.appendChild(_fObject);
		_fNode.firstChild.setAttribute("class","com.huateng.sys.jbpm.listener.SignCandidateHandler");
		xmlNode.appendChild(_fNode);
	}
	addEventXmlNode(_fObject,_attr,_value,null);
}
//将名字和ID组装成对象数组
function join(names,ids){
	var join = [];
	if(ids == "")
		return join;
	idss = ids.split(",")
	namess = names.split(",");
	for(var i=0;i<idss.length;i++){
		join.push({id:idss[i],name:namess[i]});
	}
	return join;
}
//根据通用框的选中改变xml节点的属性
function selectChangeXml(type,_ids,_names,code){
	var nNode = null;
	if(type == "swimlane")
		nNode = findXmlNodeByName("swimlane",Ext.getCmp("swimlaneDescriptionBox").getValue());
	else
		nNode = xmlNode;
	if(nNode != null){
		var rcode = "";
		if(code == "depts")
			rcode = "Role";
		else
			rcode = "Dept";
		if(_ids == ""){
			nNode.removeAttribute("candidate-"+code);
			nNode.removeAttribute(code);
			if(Ext.getCmp(type+rcode+"IdBox").getValue() != "" && !Ext.getCmp(type+rcode+"Box").disabled)
				nNode.setAttribute("candidate-groups",Ext.getCmp(type+rcode+"IdBox").getValue());
			else
				nNode.removeAttribute("candidate-groups");
		}else{
			nNode.setAttribute("candidate-"+code,_ids);
			nNode.setAttribute(code,_names);
			if(Ext.getCmp(type+rcode+"IdBox").getValue() != "" && !Ext.getCmp(type+rcode+"Box").disabled)
				nNode.setAttribute("candidate-groups",Ext.getCmp(type+rcode+"IdBox").getValue() + "," + _ids);
			else
				nNode.setAttribute("candidate-groups",_ids);
		}
	}
}
//添加监听节点的子节点
function addEventXmlNode(event_listener,field_name,_valuebox,_namebox){
	var _field = xml.createElement("field");
	_field.setAttribute("name",field_name);
	event_listener.appendChild(_field);
	var _value = xml.createElement("string");
	_value.setAttribute("value",Ext.getCmp(_valuebox).getValue());
	if(_namebox != null)
		_value.setAttribute("name",Ext.getCmp(_namebox).getValue());
	_field.appendChild(_value);
	return _field;
}
//参与人员、角色、部门控件的禁用与启用
function partDisableOrEnable(_check,_box,_action){
	/*
	 *为什么需要两次为checked赋值？
	 *elements的checked会改变checkbox的checked值，才能触发check事件，但是不会改变勾选的显示
	 *dom的checked不会改变checkbox的checked值，但是会改变勾选的显示
	 *所以需要两个同时作用
	*/
	if(_action == "enable"){
		Ext.getDom(_check).checked = true;
		Ext.getCmp(_check).checked = true;
		Ext.getCmp(_box).enable();
	}else{
		Ext.getDom(_check).checked = false;
		Ext.getCmp(_check).checked = false;
		Ext.getCmp(_box).disable();
	}
}

/***********************************表单中按钮事件**************************************/
//case表单按钮事件
function caseAddCase(){
	var caseLeftValue = Ext.getCmp("caseLeftValueBox").getValue();
	var caseCompare = Ext.getCmp("caseCompareCombo").getValue();
	var caseRightValue = Ext.getCmp("caseRightValueBox").getValue();
	var caseRelation = Ext.getCmp("caseRelationCombo").getValue();
	if(caseLeftValue==""||caseCompare==""||caseRightValue==""){
		Ext.MessageBox.alert(htTip,'判断条件不完整！');
		return false;
	}
	if(caseRelation == ""){
		Ext.MessageBox.alert(htTip,'请选择条件关系！');
		return false;
	}
	var expr = caseLeftValue + " " + caseCompare + " " + caseRightValue;
	if(xmlNode != null){
		var conditionNode = findXmlNodeByNodeName(xmlNode,"condition");
		if(conditionNode == null){
			conditionNode = xml.createElement("condition");
			xmlNode.appendChild(conditionNode);
			conditionNode.setAttribute("expr","${("+expr+")}");
		}else{
			var hisExpr = conditionNode.getAttribute("expr");
			hisExpr = hisExpr.substring(0,hisExpr.length-1);
			hisExpr = hisExpr.substring(3,hisExpr.length);
			conditionNode.setAttribute("expr","${("+hisExpr+") "+caseRelation+" ("+expr+")}");
		}
		Ext.getCmp("caseExpressionBox").setValue(conditionNode.getAttribute("expr"));
		//清空表单
		Ext.getCmp("caseLeftValueBox").setValue("");
		Ext.getCmp("caseCompareCombo").setValue("");
		Ext.getCmp("caseRightValueBox").setValue("");
		Ext.getCmp("caseRelationCombo").setValue("");
	}
}