var flowManage={
	flowId: null,
	MSG_NOSELECT:htTipSelectEdit,
	MSG_SINGLE:htTipSelectOneEdit,
	ds: null,
	init:function(){
		this.ds=new Ext.data.JsonStore({
			root:'rows',
			totalProperty:'total',
			url:"FlowManageAction!getFlowList.action",
			fields:['flowId',
					'name',
					'description',
					'flowKey',
					'createDate',
					'xmlFilePath',
					'isSys',
					'deploymentId'
				]
		});
		var selModel=new Ext.grid.CheckboxSelectionModel();
		var colModel = new Ext.grid.ColumnModel([
			new Ext.grid.RowNumberer(),
			selModel,
			{header:flowTextHeader1,dataIndex:'name'},
			{header:flowTextHeader2,dataIndex:'description'},
			{header:flowTextHeader3,dataIndex:'flowKey'},
			{header:flowTextHeader4,dataIndex:'createDate',renderer:Ext.util.Format.dateRenderer('Y-m-d H:i:s')},
			{header:flowTextHeader5,align:'center',xtype:'templatecolumn',tpl:['<tpl><a style="cursor:pointer" title="'+flowTextDownload+'" target="_bank" href="',htSystemPath,'{xmlFilePath}" ><span class="icon16_16 icon38" ></span></a></tpl>']},
			{header:flowTextHeader6,dataIndex:'deploymentId',renderer:function(value){
				return value?'<font color="green">'+flowTextDeploymented+'</font>':'<font color="red">'+flowTextUndeployment+'</font>';
			}}
		]);
		var bbar=new Ext.PagingToolbar({
				pageSize:20,
				store: this.ds,
				displayInfo: true,
				displayMsg: htTextDisplayMsg,
				emptyMsg: htTextEmptyMsg,
				plugins : [new Ext.ux.PageSizePlugin()]
		});
		/*
		var toolbar=[];
		HT_A.addToArray(toolbar,'addFlow',{handler:this.addFlow,scope:this});
		HT_A.addToArray(toolbar,'editFlow',{handler:this.editFlow,scope:this});
		HT_A.addToArray(toolbar,'deploy',{handler:this.deploy,scope:this});
		HT_A.addToArray(toolbar,'delDeploy',{handler:this.delDeploy,scope:this});
		HT_A.addToArray(toolbar,'delFlow',{handler:this.delFlow,scope:this});
		HT_A.addSeparator(toolbar);
		toolbar.push(new Ext.form.Checkbox({
     		name: 'saveInfo',
     		id: 'saveInfo',
     		fieldLabel: '1',
    	   		boxLabel: htTextOperateSucTip,
    	   		checked: true
    	}));
    	*/
    	var toolbar = new Ext.Toolbar({
			region: 'north',
			border: false,
			height: 32,
			items: [
				{text: '新增流程',iconCls:'icon04',handler:this.addFlow,scope:this},'-',
				{text: '编辑流程',iconCls:'icon122',handler:this.editFlow,scope:this},'-',
				{text: '部署流程',iconCls: 'icon210',handler:this.deploy,scope:this},'-',
	         	{text: '删除部署',iconCls: 'icon36',handler:this.delDeploy,scope:this},'-',
	         	{text: '删除流程',iconCls: 'icon32',handler:this.delFlow,scope:this},'-',
				new Ext.form.Checkbox({
					name: 'saveInfo',
					id:　'saveInfo',
					fieldLabel: '1',
					boxLabel: htTextOperateSucTip,
					checked: true
				})
			]
		});
    	
		this.grid=new Ext.grid.GridPanel({
			store:this.ds,
			cm:colModel,
			sm:selModel,
			loadMask:{msg: htTipMsg}, 
			bbar:bbar,
			tbar:toolbar
		});
		//if(HT_A.hasAction('editFlow'))
		this.grid.on('rowdblclick',this.editFlow,this);
		this.ds.load({params:{start:0,limit:20}});
		new Ext.Viewport({
			layout:'fit',
			items:this.grid
		}).show();
	},
	addFlow:function(){
		if (!window.ActiveXObject){
			Ext.MessageBox.alert(htTip,"请使用IE浏览器浏览");
			return;
		}
		this.flowId = null;
		DesignConfig.newProcess();
		DesignConfig.winShow();
	},
	saveFlow:function(){
		if(!DesignConfig.validate){
			return ;
		}else{
			flowManage.showMask();
			Ext.Ajax.request({
				url:'FlowManageAction!saveOrUpdateFlow.action',
				method: 'POST',
				params: {flowId: flowManage.flowId,xml: DesignConfig.getXml(),name:xml.documentElement.getAttribute("name"),description:xml.documentElement.getAttribute("description")},
				success:function(response){
					flowManage.hideMask();
					if(Ext.getDom("saveInfo").checked){
						Ext.MessageBox.alert(htTip,htTipSaveSuccess);
					}
					if(flowManage.flowId == null)
						flowManage.flowId = response.responseText;
					flowManage.ds.reload();
				},
				callback:function(){
					flowManage.hideMask();
				},
				scope: this
			});
		}
	},
	editFlow : function(){
		if (!window.ActiveXObject){
			Ext.MessageBox.alert(htTip,"请使用IE浏览器浏览");
			return;
		}
		var row = this.grid.getSelectionModel().getSelections();
		if(row.length == 1){
			this.flowId = row[0].get("flowId");
			this.grid.loadMask.show();
			Ext.Ajax.request({
				url:'FlowManageAction!getFlow.action',
				method: 'post',
				success: function(response){
					DesignConfig.loadXml(response.responseText);
					DesignConfig.winShow();
				},
				callback: function(){
					this.grid.loadMask.hide();
				},
				params:{flowId:this.flowId},
				scope: this
			});
		}else if(row.length<=0){
			Ext.MessageBox.alert(htTip,htTipSelectEdit);
		}else{
			Ext.MessageBox.alert(htTip,htTipSelectOneEdit)
		}
	},
	delFlow : function(){
		var records = this.grid.getSelectionModel().getSelections();
		if(records.length<=0){
			Ext.MessageBox.alert(htTip,this.MSG_NOSELECT);
		}else{
			Ext.MessageBox.confirm(htTip,htTipSureDelData,function(btn){
				if(btn =='yes'){
					var jsonData = "";
					for(var i = 0,len = records.length;i<len;i++){
						if(i==0){
							jsonData = jsonData + records[i].get("flowId");
						}else{
							jsonData = jsonData+ "," +records[i].get("flowId");
						}
						flowManage.grid.getStore().remove(records[i]);
					}
					flowManage.grid.loadMask.show();
					Ext.Ajax.request({
						url: 'FlowManageAction!deleteFlow.action',
						method: 'post',
						success: function(response){
							if(Ext.getDom('saveInfo').checked){
								Ext.MessageBox.alert(htTip,htTipDelSuccess);
							}
							flowManage.grid.getStore().reload();
						},
						callback: function(){
							flowManage.grid.loadMask.hide();
						},
						params:{flowId:jsonData},
						scope: this
					})
				}
			}
		)}
	},
	deploy:function(){
		var records=this.grid.getSelectionModel().getSelections();
		if(records.length<1){
			Ext.Msg.alert(htTip,this.MSG_NOSELECT);
		}
		else if(records.length>1){
			Ext.Msg.alert(htTip,this.MSG_SINGLE);
		}
		else{
			var data=records[0].data;
			if(null!=data['deploymentId']){
				Ext.Msg.alert(htTip,flowTipDeploymented);
			}
			else{
				this.grid.loadMask.show();
				Ext.Ajax.request({
					url:'FlowManageAction!deploy.action',
					params:{flowId:data['flowId']},
					success:function(resposne){
						if(this.isPrompt())Ext.Msg.alert(htTip,htTipOperateSuccess);
						this.grid.getStore().reload();
					},
					callback:function(){
						this.grid.loadMask.hide();
					},
					scope:this
				})
			}
		}
	},
	delDeploy:function(){
		var records=this.grid.getSelectionModel().getSelections();
		if(records.length<1){
			Ext.Msg.alert(htTip,this.MSG_NOSELECT);
		}
		else if(records.length>1){
			Ext.Msg.alert(htTip,this.MSG_SINGLE);
		}
		else{
			var data=records[0].data;
			if(null == data['deploymentId']){
				Ext.Msg.alert(htTip,flowTipUndeployment);
			}
			else{
				this.grid.loadMask.show();
				Ext.Ajax.request({
					url:'FlowManageAction!delDeploy.action',
					params:{flowId:data['flowId']},
					success:function(resposne){
						if(this.isPrompt())Ext.Msg.alert(htTip,htTipDelSuccess);
						this.grid.getStore().reload();
					},
					callback:function(){
						this.grid.loadMask.hide();
					},
					scope:this
				})
			}
		}
	},
	isPrompt:function(){
		if(Ext.getDom('saveInfo')){
			return Ext.getDom(saveInfo).checked;
		}
		else{
			return true;
		}
	},
	showMask:function(msg){
		if(!this.waitMask){
			this.waitMask=new Ext.LoadMask(designWin.bwrap,{
				msg: msg
			})
		}
		if(designWin.isVisible())
		 	this.waitMask.show();
	},
	hideMask:function(){
		if(this.waitMask) 
			this.waitMask.hide();
	}
}