Ext.namespace("FormTree");
var FormTree = {
	contextMenu : '',
	loader: '',
	root: '',
	formMainPanel: '',
	formName : '',
	moduleName: '',
	moduleId: '',
	formId: '',
	isNewForm : true,
	isLoader : true,
	tree: null,
	formWin: '',
	initForm : function(){
		Huateng.Util.Validator.defaultGetMsgName=function(el){
			return el.parentNode.previousSibling.innerHTML;
		};
		//创建模块表单树
		FormTree.loader = new Ext.tree.TreeLoader({dataUrl:'FormAction!getFormList.action'});
		FormTree.root = new Ext.tree.AsyncTreeNode({
			id: '#',
			text: formText,
			expanded: false,
			loader: FormTree.loader
		});
		var formTree = new Ext.tree.TreePanel({
			border: true,
			rootVisible: false,
			split: true,
			region: 'west',
			title: formText,
			iconCls: 'icon248',
			collapsible: true,
			autoScroll : true,
			width: 200,
			minSize: 200,
		    maxSize: 200,
		    root: FormTree.root
		});
		this.tree = formTree;
		var buttonItems = [
			{text: htTextEdit+formText,iconCls: 'icon122',handler: FormTree.editForm},'-',
			{text: htTextDel+formText,iconCls: 'icon32',handler: FormTree.delForm}
		];
		//创建表单工具条
		var head = new Ext.Toolbar({
			region: 'north',
			border: false,
			height: 32,
			items: [
				{text: htTextFile,iconCls:'icon139',menu:{items:[{text: htTextAdd+formText,iconCls: 'icon04',handler:FormTree.addForm}]}},'-',
				{text: htTextEdit,iconCls:'icon138',menu:{items: buttonItems}},'-',
				{text: htTextAdd+formText,iconCls: 'icon04',handler: FormTree.addForm},'-',
	         	{text: htTextEdit+formText,iconCls: 'icon122',handler: FormTree.editForm},'-',
	         	{text: htTextDel+formText,iconCls: 'icon32',handler: FormTree.delForm},'-',
				new Ext.form.Checkbox({
					name: 'saveInfo',
					id:　'saveInfo',
					fieldLabel: '1',
					boxLabel: htTextOperateSucTip,
					checked: true
				})
			]
		});
		//创建表单操作区
//		FormTree.formMainPanel = new Ext.Panel({
//			region: 'center',
//			id: 'formMainPanel',
//			modal: true,
//			autoLoad: {url:htSystemPath + "sys/jsp/action/action.jsp",scripts: true, nocache: true},
//			border: true
//		});
		var rightPanel = new Ext.TabPanel({
	    	region: 'center',
	    	border: true,
	    	id: 'tablePanel',
	    	activeTab:0,
	    	items: [ActionConfig.grid,SearchConfig.grid]
	    })
		//创建布局
		var formViewPort = new Ext.Viewport({
			layout: 'border',
			items: [head,formTree,rightPanel]
		});
//		//加载表单的按钮
//		ActionConfig.ds = new Ext.data.Store({
//			proxy : new Ext.data.HttpProxy({url:'FunAction!getActionList.action'}),
//			reader: new Ext.data.JsonReader({totalProperty: 'totalProperty',root: 'root'},[
//				{name: 'actionId'},
//				{name: 'name'},
//				{name: 'formName'},
//				{name: 'callback'},
//				{name: 'icon'},
//				{name: 'key'},
//				{name: 'description'}
//			])
//		});
//		//加载分页插件
//		ActionConfig.pageBar = new Ext.PagingToolbar({
//			pageSize:10,
//			store: ActionConfig.ds,
//			displayInfo: true,
//			displayMsg: '显示第{0}条到{1}条记录，一共{2}条',
//			emptyMsg: '没有记录',
//			plugins : [new Ext.ux.PageSizePlugin()]
//		});
		//初始化窗口
		
//		formWin.show();
//		formWin.hide();
		
		//默认选中节点
		formTree.on('load',function(node){
			var fNode = node.firstChild;
			if(node.id == '#'){
				formTree.selectPath("/"+formTree.root.id+"/"+fNode.id);
				this.fireEvent('click',fNode);
				//FormTree.formExpand();
			}
		})
		//为表单模块树添加点击事件
		formTree.on('click',function(nodeAttr){
			FormTree.getForm(nodeAttr);
			FormTree.isLoader = true;
		})
		//创建右键菜单
		FormTree.contextMenu = new Ext.menu.Menu({
			id: 'menu',
			items:[{
				text: htTextAdd+formText,
				id:'add',
				iconCls: 'icon04',
				handler: FormTree.addForm
			},{
				text: htTextEdit+formText,
				id: 'edit',
				iconCls: 'icon122',
				handler: FormTree.editForm
			},{
				text: htTextDel+formText,
				id: 'del',
				iconCls: 'icon32',
				handler: FormTree.delForm
			}]
		})
		//为表单模块树添加右击事件
		formTree.on('contextMenu',function(nodeAttr,e){
			e.preventDefault();
			FormTree.contextMenu.showAt(e.getXY());
			nodeAttr.select();
			FormTree.isLoader = false;
			FormTree.getForm(nodeAttr);
		})
	},
	formWinInit : function(){
		if(!FormTree.formWin){
			FormTree.formWin = new Ext.Window({
				title: htTextAdd+formText,
				layout: 'fit',
				 width: 500,
		        height: 300,
		  		autoScroll: true,
		  		bodyStyle: {background: '#ffffff'}, 
		        plain: false,
		  		modal: true,
		  		iconCls: 'icon248',
		  		closeAction: 'hide',
		  		contentEl: 'formHtml',
		  		 buttons: [
		        	{
		            	text: htTextSaveAndAdd,
		            	iconCls: 'icon187',
		            	handler: function(){FormTree.saveForm();FormTree.formWin.show();FormTree.addForm();}
		        	},{
		            	text: htTextSaveAndClose,
		            	iconCls: 'icon153',
		            	handler: function(){FormTree.saveForm();}
		        	},{
		            	text: htTextCancel,
		            	iconCls: 'icon163',
		            	handler: function(){FormTree.formWin.hide();}
		    	}]
			});
			Ext.get("formHtml").dom.style.display = 'block';
		}
	},
	//新增表单
	addForm : function(){
		if(FormTree.moduleName==''){
			Ext.MessageBox.alert(htTip,formTipSelectModule);
			return ;
		}
		FormTree.formWinInit();
		FormTree.formWin.setTitle(htTextAdd+formText);
		FormTree.formWin.buttons[0].show();
		FormTree.isNewForm = true;
		Huateng.Util.Form.formClear("formForm");
		Ext.getDom("formForm").moduleName.value = FormTree.moduleName;
		Ext.getDom("formForm").moduleId.value = FormTree.moduleId;
		FormTree.formWin.show();
	},
	//修改表单
	editForm : function(){
		if(FormTree.moduleName!=''){
			Ext.MessageBox.alert(htTip,formTipSelectForm);
			return ;
		}
		FormTree.formWinInit();
		FormTree.formWin.buttons[0].hide();
		FormTree.formWin.setTitle(htTextEdit+formText);
		FormTree.isNewForm = false;
		Ext.Ajax.request({
			url: 'FormAction!getForm.action',
			method: 'post',
			success: function(response){
				var json = eval("("+response.responseText+")");
				Huateng.Util.Form.formFill("formForm",json);
//				Ext.getDom("name").value = json.name;
//				Ext.getDom("moduleName").value = json.moduleName;
//				Ext.getDom("moduleId").value = json.moduleId;
//				Ext.getDom("target").value=json.target;
//				Ext.getDom("description").value=json.description;
				FormTree.formWin.show();
			},
			params: {formId:FormTree.formId}
		})
	},
	//保存表单
	saveForm : function(){
		if(!Huateng.Util.Validator.formValidate("formForm")){
			return ;
		}
		var params = '';
		if(FormTree.isNewForm){
			//new
			params = {formId:''}
		}else{
			//修改
			params = {formId:FormTree.formId}
		}
		Ext.Ajax.request({
			url: 'FormAction!addOrUpdata.action',
			method: 'post',
			success: function(response){
				if(Ext.getDom("saveInfo").checked){
					Ext.MessageBox.alert(htTip,htTipSaveSuccess);
				}
				if(FormTree.isNewForm){
					var json = eval("("+response.responseText+")")
					var child = new Ext.tree.TreeNode({
						'id': json.formId,
						'text': json.name,
						'leaf': true
					})
					FormTree.getSelectNode().appendChild(child);
					FormTree.getSelectNode().expand();
				}else{
					FormTree.getSelectNode().setText(Ext.getDom("formForm").name.value);
				}
			},
			params: params,
			form: 'formForm'
		})
		FormTree.formWin.hide();
	},
	//删除表单
	delForm : function(){
		if(FormTree.moduleName!=''){
			Ext.MessageBox.alert(htTip,formTipSelectForm);
			return ;
		}else{
			Ext.MessageBox.confirm(htTip,htTipOperUnrecoverable,function(button,text){
				if(button=="yes"){
					Ext.Ajax.request({
						url: 'FormAction!delForm.action',
						method: 'post',
						success: function(response){
							if(Ext.getDom("saveInfo").checked){
								Ext.MessageBox.alert(htTip,htTipDelSuccess);
							}
							FormTree.getSelectNode().remove();
						},
						params: {formId:FormTree.formId}
					})
				}
			})
		}
	},
	//初始化表单项
	getForm : function(nodeAttr){
		if(!nodeAttr.leaf){
			//根
			FormTree.moduleName = nodeAttr.text;
			FormTree.moduleId = nodeAttr.id;
			FormTree.formId = '';
			FormTree.formName = '';
			FormTree.contextMenu.items.get('add').enable();
			FormTree.contextMenu.items.get('edit').disable();
			FormTree.contextMenu.items.get('del').disable();
			return ;
		}else{
			
			FormTree.moduleName = '';
			FormTree.formName = nodeAttr.text;
			FormTree.formId = nodeAttr.id;
			FormTree.contextMenu.items.get('add').disable();
			FormTree.contextMenu.items.get('edit').enable();
			FormTree.contextMenu.items.get('del').enable();
		}
//		Ext.Ajax.request({
//			url:'FunAction!getActionList.action',
//			method: 'post',
//			success: function(response){
//				var json = response.responseText;
////				FormTree.moduleName = nodeAttr.text
////				FormTree.moduleId = FormTree.getSelectNode().parentNode.text;
//			},
//			params:{formId:nodeAttr.id,start:0,limit:ActionConfig.pageBar.pageSize}
//		})
		ActionConfig.pageBar.store.baseParams = {formId:nodeAttr.id};
		SearchConfig.pageBar.store.baseParams = {formId:nodeAttr.id};
		if(FormTree.isLoader){
			ActionConfig.ds.load({url:'FunAction!getActionList.action',params:{start:0,limit:ActionConfig.pageBar.pageSize}});
			SearchConfig.ds.load({url:'SearchAction!getSearchList.action',params:{start:0,limit:SearchConfig.pageBar.pageSize}})
		}
	},
	//取得选择点
	getSelectNode: function(){
		return FormTree.tree.getSelectionModel().getSelectedNode();	
	},
	//单个展开
	formExpand: function(){
		FormTree.getSelectNode().expand();
	},
	//全部展开
	formExpandAll: function(){
		FormTree.getSelectNode().expand(true);
	}

}