Ext.ns("Huateng", "Huateng.Sys", "Huateng.Util");   
Huateng.Sys.LeftMenu = function(config){
	//通过Function类的call方法来改变Panel类的作用域为当前类的作用域
	//同时也把配置项也传递给Panel类，继承Ext.Panel类中的构建函数功能
	var d = Ext.apply({
		split: true,
		region: 'west',
		width: 200,
		minSize: 200,
        maxSize: 200,
        defaults: {border: false,autoScroll: true},
        layout:'card',
        menuTreeUrl:'MenuAction!getMenuList.action',
        appUrl:'AppAction!getAppsJson.action',
        autoInitApps:true,
        activeItem:0,
        layoutConfig:{deferredRender:true}
		},config||{});
	Huateng.Sys.LeftMenu.superclass.constructor.call(this,d);
};
//采用Ext.extend函数，把Panel类中所有的方法都继承到当前类来
Ext.extend(Huateng.Sys.LeftMenu, Ext.Panel, {
	initComponent:function(){
		Huateng.Sys.LeftMenu.superclass.initComponent.call(this);
		this.addEvents('nodeClick');
		if(this.autoInitApps) this.initApps();
	},
	initApps:function(){
		Ext.Ajax.request({
		url:this.appUrl,
		success:function(response){
			var apps=eval("("+response.responseText+")");
			for(var i=0;i<apps.length;i++){
				this.addApp(apps[i]);
			}
			this.layout.setActiveItem(0);
		},
		scope:this
	})
	},
	addApp:function(app){
		var modules=app.modules;
		var treeNodeClickCb=function(node,event){
			if (node && node.isLeaf()) {
				event.stopEvent();
				this.fireEvent('nodeClick', node.attributes);
			}
		};
		var treeActiveCb=function(tree){
			tree.expandAll();
		}
		var trees=[];
		for(var i=0;i<modules.length;i++){
			var module=modules[i];
			var tree = new Ext.tree.TreePanel({
				border: false,
				rootVisible: false,
				autoScroll: true,
				title:module.name,
				iconCls: module.icon,
				root: new Ext.tree.AsyncTreeNode({
					id: module.moduleId,
					text: module.name,
					expanded: false,
					loader: new Ext.tree.TreeLoader({dataUrl:this.menuTreeUrl})
				})				
			});
			tree.on('click',treeNodeClickCb,this);
			tree.on('activate',treeActiveCb);
			trees.push(tree);
		}
		var ct=new Ext.Container({
			layout:'accordion',
			items:trees,
			appObject:app,
			id:"app-"+app.appId
		});
		ct.on('activate',function(cmp){
			this.setTitle(cmp.appObject.name);
			this.setIconClass(cmp.appObject.icon);
		},this);
		this.add(ct);
	},
	setActiveItem:function(item){
		this.layout.setActiveItem(item);
	}
})