Ext.ns("Huateng", "Huateng.Sys", "Huateng.Util");
Huateng.Sys.MainPanel = Ext.extend(Ext.TabPanel, {
	enableTabScroll: true,
	plugins: [
		new Ext.ux.TabCloseMenu(),
		new Ext.ux.TabScrollerMenu({
			maxText : 15,
			pageSize : 5
		})
	],
	initComponent : function() {
		// 一些初始化工作
		Huateng.Sys.MainPanel.superclass.initComponent.call(this);
		this._cache = {};
	},
	loadTab : function(node) {
		var n = this.getComponent(node.formId);
		if (n) {
			this.setActiveTab(n);
			if(node.formId != 'null'){
				n.destroy();
				this.loadTab(node);
			}
		} else {
			var c = {
				id:node.formId,
				title: node.text,
				iconCls: node.iconCls,
				url: "form.to?formId="+node.formId+"&icon="+node.iconCls+"&action="+node.action,
				loadMask:{msg:htTipMsg},
				closable : true
			};
			n = this.add(node.formId != 'null' ? new Ext.ux.IFrameComponent(c) : Ext.apply(c, {
				html : node.text
			}));
			n.show();
		}
	},
	addTab : function(action,method,title,icon,formId,params,params_extend) {
		var n = this.getComponent(action);
		var url = action+"!"+method+".action?formId="+formId+"&action="+action+"&icon="+icon;
		if(params != ""&&params != null)
			url += "&" + params;
		if(!!params_extend)
			url += params_extend;
		if(n)
			n.destroy();
		var c = {
			id: action,
			title: title,
			iconCls: icon,
			formId: formId,
			pid: this.getActiveTab().id,
			url: url,
			loadMask:{msg:htTipMsg},
			closable : true
		};
		n = this.add(new Ext.ux.IFrameComponent(c));
		var pid  = this.getActiveTab().id;
		n.on('destroy',function(){
			if(n.reload=="true"){
				mainTab.reloadTab(pid);
			}
		});
		n.show();
	},
	destoryTab : function(action,reload){
		//var n = this.getComponent(action);
		var n = this.getActiveTab();
		if(n.pid!=null){
			var p = this.getComponent(n.pid);
			this.setActiveTab(p);
			if(p&&reload)
				try{
					p.reload();
				}catch(e){
				
				}
		}
		if(n)
			n.destroy();
	},
	findPanel : function(name) {
		var ret = this._cache[name];
		if (!ret) {
			var pn = (this.ns ? this.ns : 'Huateng.Sys') + "."
					+ Ext.util.Format.capitalize(name) + 'Panel';
			var ret = eval(pn);
		}
		return ret;
	},
	addPanel : function(name, panel) {
		if (!this._cache)
			this._cache = {};
		this._cache[name] = panel;
	}
});