$(function(){
	$("#pattern").change(function(){
		showPatternDemo(this.value);
	});
	showPatternDemo($("#pattern").val());
});

function showPatternDemo(ptn){
	if($.trim(ptn)){
		$("#patternDemo").text(NOPattern.format(ptn,new Date(),1));
	}
	else{
		$("#patternDemo").text("");
	}
}

var NOPattern=(function(){
	
	var parsePtn=/(\{+)([^{}]+)(\}+)/g;
	var countPtn=/^X+$/;
	
	function format(p,d,c){
		var re=[];
		parsePtn.lastIndex=0;
		var rr=parsePtn.exec(p);
		var ss=0;
		while(rr!=null){
			var llen=rr[1].length;
			var rlen=rr[3].length;
			if(llen%2==1&&rlen%2==1){
				var v=getPartValue(rr[2],d,c);
				if(v!=null){
					var fe=rr.index+llen-1;
					if(fe>ss){
						re.push(escFiexdStr(p.substring(ss,fe)));
					}
					re.push(v);
					if(rlen>1) re.push(rr[3].substr(0,rlen-1));
					ss=rr.lastIndex;
				}
				
			}
			rr=parsePtn.exec(p);
		}
		if(p.length>ss) re.push(p.substr(ss));
		return re.join("");
	}
	
	function getPartValue(pp,d,c){
		var pt=pp.toUpperCase();
		if(countPtn.test(pt)){
			return fixedStrLen(c,pt.length,'0');
		}
		switch(pt){
			case "YY":
				return fixedStrLen(d.getFullYear(),2,'0');
				break;
			case "YYYY":
				return fixedStrLen(d.getFullYear(),4,'0');
				break;
			case "MM":
				return fixedStrLen(d.getMonth()+1,2,'0');
				break;
			case "DDD":
				return fixedStrLen(getDayOfYear(d),3,'0');
				break;
			case "DD":
				return fixedStrLen(d.getDate(),2,'0');
				break;
		}
		return null;
	}
	
	function escFiexdStr(str){
		return str.replace("{{","{").replace("}}","}");
	}
	
	function fixedStrLen(str,len,c){
		var s="";
		str=str+"";
		var cw=len-str.length;
		if(cw>0){
			for(var i=0;i<cw;i++) 
				s+=c;
			s+=str;
		}
		else if(cw<0){
			s=str.substr(-cw);
		}
		else
			s=str;
		return s;
	}
	
	function getDayOfYear(d){
		var year=d.getFullYear();
		var sd=new Date(year,0,1);
		var mms=d.getTime()-sd.getTime();
		return parseInt(mms/86400000+1);
	}
	
	return {
		format:format
	}
})()