art.dialog.notice = function (options) {
    var opt = options || {},
        api, aConfig, hide, wrap, top,
        duration = 800;
        
    var config = {
        id: 'Notice',
        left: '100%',
        top: '100%',
        fixed: true,
        drag: false,
        resize: false,
        follow: null,
        lock: false,
        initFn: function(here){
            api = this;
            aConfig = api.config;
            wrap = api.DOM.wrap;
            top = parseInt(wrap[0].style.top);
            hide = top + wrap[0].offsetHeight;
            
            wrap.css('top', hide + 'px')
                .animate({top: top + 'px'}, duration, function () {
                    opt.initFn && opt.initFn.call(api, here);
                });
        },
        closeFn: function(here){
            wrap.animate({top: hide + 'px'}, duration, function () {
                opt.closeFn && opt.closeFn.call(this, here);
                aConfig.closeFn = $.noop;
                api.close();
            });
            
            return false;
        }
    };	
    
    for (var i in opt) {
        if (config[i] === undefined) config[i] = opt[i];
    };
    return art.dialog(config);
};
var remind = function(){
	art.dialog.notice({
	    title: '消息提示',
	    width: 220,// 必须指定一个像素宽度值或者百分比，否则浏览器窗口改变可能导致artDialog收缩
	    content: '你有 1 条新的短消息',
	    icon: 'face-sad',
	    time: 5
	});
}
//setInterval("remind()",5000);