Ext.namespace("SearchConfig");
var SearchConfig = {
	searchWin: '',
	searchId: '',
	ds : '',
	grid : '',
	pageBar : '',
	isNewSearch : true,
	initSearch : function(){	
		var sm = new Ext.grid.CheckboxSelectionModel();
		var cm = new Ext.grid.ColumnModel([
			new Ext.grid.RowNumberer(),
			sm,
//			{header: '搜索ID',dataIndex: 'searchId',width:200},
			{header: '搜索名称',dataIndex: 'label',width:70},
			{header: '所属表单',dataIndex: 'formName',width:100},
			{header: '属性名',dataIndex: 'name',width:100},
			{header: '参数',dataIndex: 'params',width:100},
			{header: '级别',dataIndex: 'level',width:50,renderer:function(value){if(value=='1')return '<font color=\"green\">默认</font>';else return '<font color=\"blue\">高级</font>';}},
			{header: '类型',dataIndex: 'type',width:70,renderer:function(value){if(value=='test'){return '文本框';}else if(value=='select-dict'){ return '下拉框（字典）';}else if(value=='select-defin'){ return '下拉框（自定义）';}else if(value=='date'){ return '日期框';}else if(value=='tree'){ return '通用选择框';}}},
			{header: '排序',dataIndex: 'seqNo',width:50}
		]);
		cm.defaultSortable = true;
		//加载表单的搜索
		SearchConfig.ds = new Ext.data.Store({
			proxy : new Ext.data.HttpProxy({url:'SearchAction!getSearchList.action'}),
			reader: new Ext.data.JsonReader({totalProperty: 'totalProperty',root: 'root'},[
				{name: 'searchId'},
				{name: 'name'},
				{name: 'formName'},
				{name: 'params'},
				{name: 'label'},
				{name: 'level'},
				{name: 'type'},
				{name: 'seqNo'}
			])
		});
		//加载分页插件
		SearchConfig.pageBar = new Ext.PagingToolbar({
			pageSize:10,
			store: SearchConfig.ds,
			displayInfo: true,
			displayMsg: '显示第{0}条到{1}条记录，一共{2}条',
			emptyMsg: '没有记录',
			plugins : [new Ext.ux.PageSizePlugin()]
		});
		SearchConfig.grid = new Ext.grid.GridPanel({
			title :'搜索',
			id: 'searchPanel',
			region: 'center',
			layout: 'fit',
			border: true,
			iconCls: 'icon307',
//			height: 400,
			tbar: new Ext.Toolbar([
				{text: '新增',iconCls: 'icon04',handler: SearchConfig.addSearch},'-',
				{text: '修改',iconCls: 'icon122',handler: SearchConfig.editSearch},'-',
				{text: '删除',iconCls: 'icon32',handler: SearchConfig.delSearch}
			]),
			viewConfig: {
				forceFit: true,
				columnsText: '显示的列',
				scrollOffset: 16,
				sortAscText: '升序',
				sortDescText: '降序'
			},
			loadMask: {msg:"加载中..."},
			autoScroll: false,
			stripeRows: true,
			ds: SearchConfig.ds,
			cm: cm,
			sm: sm,
			bbar: SearchConfig.pageBar
		});
		
//		SearchConfig.grid.render();//放到items中不要再渲染，不然会出现布局会出问题
		//为表单添加双击修改事件
		SearchConfig.grid.on('rowdblclick',SearchConfig.editSearch);
		SearchConfig.searchWin = new Ext.Window({
			title: '新建搜索',
			layout: 'fit',
			width: 500,
			height: 335,
			autoScroll: true,
			bodyStyle: {background: '#ffffff'},
			plain: false,
			modal: true,
			iconCls: 'icon231',
			closeAction: 'hide',
			contentEl: 'searchItem',
			buttons: [
				{
					text:'保存并新增下一个',
					iconCls: 'icon187',
					handler:function(){SearchConfig.saveSearch();SearchConfig.addSearch()}
				},{
					text:'保存并关闭',
					iconCls: 'icon153',
					handler:function(){SearchConfig.saveSearch();}
				},{
					text:'取消',
					iconCls: 'icon163',
					handler:function(){SearchConfig.searchWin.hide();}
				}
			]
		});
		SearchConfig.searchWin.show();
		SearchConfig.searchWin.hide();
		Ext.getDom("searchItem").style.display = "block";
		
		
	},
	addSearch : function(){
		if(FormTree.formId!=''){
			SearchConfig.isNewSearch = true;
			SearchConfig.searchId = '';
			SearchConfig.searchWin.buttons[0].show();
			Huateng.Util.Form.formClear("searchForm");
			SearchConfig.searchWin.setTitle("新增搜索");
			SearchConfig.searchWin.show();
			Ext.getDom("searchForm").formName.value = FormTree.formName;
			Ext.getDom("searchForm").formId.value = FormTree.formId;
			Ext.getDom("searchForm").level2.checked = true;
		}else{
			Ext.MessageBox.alert(htTip,"请先选择表单，再添加");
			return;
		}
	},
	editSearch : function(){
		SearchConfig.isNewSearch = false;
		var allSelect = SearchConfig.grid.getSelectionModel().getSelections();
		var len = allSelect.length;
		if(len<1){
			Ext.MessageBox.alert(htTip,"请选择要修改的搜索");
			return ;
		}else if(len>1){
			Ext.MessageBox.alert(htTip,"请选择一项要修改的搜索")
		}else{
			SearchConfig.searchWin.buttons[0].show();
			Huateng.Util.Form.formClear("searchForm");
			SearchConfig.searchWin.setTitle("新增搜索");
			SearchConfig.searchId = allSelect[0].get("searchId");
			if(allSelect[0].get("name") != 'null')
				Ext.getDom("searchForm").name.value = allSelect[0].get("name")==null?'':allSelect[0].get("name");
			Ext.getDom("searchForm").formId.value = FormTree.formId;
			if(allSelect[0].get("formName") != 'null')
				Ext.getDom("searchForm").formName.value = allSelect[0].get("formName")==null?'':allSelect[0].get("formName");
			if(allSelect[0].get("params") != 'null')
				Ext.getDom("searchForm").params.value = allSelect[0].get("params")==null?'':allSelect[0].get("params");
			if(allSelect[0].get("label") != 'null')
				Ext.getDom("searchForm").label.value = allSelect[0].get("label")==null?'':allSelect[0].get("label");
			if(allSelect[0].get("seqNo") != 'null')
				Ext.getDom("searchForm").seqNo.value = allSelect[0].get("seqNo")==null?'':allSelect[0].get("seqNo");
			if(allSelect[0].get("type") != 'null'){
				Ext.getDom("searchForm").type.value = allSelect[0].get("type")==null?'':allSelect[0].get("type");
			}
			if(allSelect[0].get("level") != 'null'){
				if(allSelect[0].get("level")=='1'){
					Ext.getDom("searchForm").level1.checked=true;
					Ext.getDom("searchForm").level2.checked=false;
				}else{
					Ext.getDom("searchForm").level1.checked=false;
					Ext.getDom("searchForm").level2.checked=true;
				}
			}
			SearchConfig.searchWin.show();
		}
	},
	delSearch : function(){
		var allSelect = SearchConfig.grid.getSelectionModel().getSelections();
		var len = allSelect.length;
		if(len<1){
			Ext.MessageBox.alert(htTip,"请选择要删除的搜索！");
			return ;
		}
		var dataItems = '';
		for(var i=0;i<len;i++){
			dataItems += allSelect[i].get("searchId");
			if(i<len-1){
				dataItems += ",";
			}
		}
		Ext.MessageBox.confirm(htTip,'你确定要删除这些数据吗',function(btn){
			if(btn == 'yes'){
				Ext.Ajax.request({
					url : 'SearchAction!delSearch.action',
					method: 'post',
					success : function(response){
						if(Ext.getDom("saveInfo").checked){
							Ext.MessageBox.alert(htTip,"删除信息成功！");
							}
						SearchConfig.ds.load({params:{start:0,limit:SearchConfig.pageBar.pageSize}});
					},
					params: {searchId:dataItems}
				})
			}
		})
		
	},
	saveSearch : function(){
		if(!Huateng.Util.Validator.formValidate("searchForm")){
			return ;
		}else{
			var params = '';
			if(SearchConfig.isNewSearch){
				params = {searchId:''}
			}else{
				params = {searchId: SearchConfig.searchId}
			}
			Ext.Ajax.request({
					url: 'SearchAction!addOrUpdata.action',
					method: 'post',
					success: function(response){
						if(Ext.getDom("saveInfo").checked){
							Ext.MessageBox.alert(htTip,"保存信息成功！");
						}
						SearchConfig.ds.load({params:{start:0,limit:SearchConfig.pageBar.pageSize}});
					},
					form: 'searchForm',
					params : params
			})
		}
		SearchConfig.searchWin.hide();
	}
}