Ext.ns('Huateng','Huateng.Util');
Huateng.DictMgr=Huateng.Util.DictMgr={
	dictUrl:'DictAction!getChildDicts.action',
	__DictMap:{},
	__DictCache:{},
	__reqQueue:{},
	cacheable:true,
	//初始全局
	initGlobal:function(){
		var es=Ext.query('select[dictId],select[cascade],input[dictId],input[cascade]');
		for(var i=0;i<es.length;i++) this.initItem(es[i]);
	},
	//初始化一个项
	initItem:function(el,cacheable,handler){
		el=Ext.getDom(el);
		if(!el) return;	
		if(el.getAttribute('isInitDict')===true) return;
		var did=el.getAttribute('dictId');
		var cid=el.getAttribute('cascade');
		if(!Ext.isEmpty(cid)){
			var cel=Ext.fly(cid,'_dictCas');
			var opts={el:el};
			if(cel) cel.on('change',this.__cascadeHander,this,opts);
			el.setAttribute('isInitDict',true);
		}
		if(!Ext.isEmpty(did)){
			var opts={el:el,dictId:did,clear:true,cacheable:cacheable,callback:handler||this.defaultHandler};
			this.__loadDict(opts);
			el.setAttribute('isInitDict',true);
		}
	},
	refurbishItem:function(el,value,cacheable){
		el=Ext.getDom(el);
		if(!el) return;
		var dictId;
		if(el.getAttribute('isInitDict')!==true) return;
		var did=el.getAttribute('dictId');
		var cid=el.getAttribute('cascade');
		if(!Ext.isEmpty(did)) dictId=did;
		else if(!Ext.isEmpty(cid)){
			var cel=Ext.getDom(cid);
			if(cel) dictId=cel.options[cel.selectedIndex].getAttribute('_dictId');
		}
		opts={el:el,value:value,dictId:dictId,clear:true,cacheable:cacheable,callback:this.defaultHandler};
		this.__loadDict(opts);
	},
	setSelValue:function(el,value){
		el=Ext.getDom(el);
		if(!el) return;
		if(value==null) value='';
		el.value=value;
		this.__fireChange(el);
		el.setAttribute('_dvalue',value);
	},
	//调用处理函数
	defaultHandler:function(data,opts){
		var handler=opts.el.tagName;
		if(handler=='INPUT'&&this.handlers['INPUT_'+opts.el.type])
			handler='INPUT_'+opts.el.type;
		if(this.handlers[handler]) this.handlers[handler](data,opts);
	},
	//载入字典项
	__loadDict:function(opts){
		if(!opts.dictId||''==opts.dictId){
			opts.callback.call(this,[],opts);
			return;
		}
		if(!Ext.isDefined(opts.cacheable)) opts.cacheable=this.cacheable;
		if(opts.cacheable!==false&&this.__DictCache[opts.dictId]){
			opts.isCache=true;
			if(Ext.isFunction(opts.callback))
				opts.callback.call(this,this.__DictCache[opts.dictId],opts);
			return;
		}
		opts.isCache=false;
		var url=opts.dictUrl||this.dictUrl;
		if(url==this.dictUrl){
			if(this.__reqQueue[opts.dictId]){
				this.__reqQueue[opts.dictId].push(opts);
				return;
			}
			else{
				this.__reqQueue[opts.dictId]=[opts];
			}
		}
		Ext.Ajax.request({
			url:url,
			method:'POST',
			params:{dictId:opts.dictId},
			opts:opts,
			success:this.__requestSuccess,
			scope:this
		});
	},
	//请求成功回调
	__requestSuccess:function(response,options){
		var opts=options.opts;
		var data=eval('('+response.responseText+')');
		this.__DictCache[opts.dictId]=data;
		if(this.__reqQueue[opts.dictId]){
			var queue=this.__reqQueue[opts.dictId];
			for(var i=0;i<queue.length;i++){
				var opt=queue[i];
				if(Ext.isFunction(opt.callback)){
					try{
						opt.callback.call(opt.scope||this,data,opt);
					}
					catch(ex){
					}
				}
			}
			delete this.__reqQueue[opts.dictId];
		}
		else{
			if(Ext.isFunction(opts.callback))
				opts.callback.call(opts.scope||this,data,opts);
		}
	},
	//请求结果处理函数集
	handlers:{
		SELECT:function(data,opts){
			if(opts.clear) opts.el.innerHTML=null;
			if(opts.el.length==0){
				var op=document.createElement('option');
				op.text='---请选择---';
				op.value='';
				try{opts.el.add(op);}catch(ex){opts.el.add(op,null);}
			}
			for(var i=0;i<data.length;i++){
				var op=document.createElement('option');
				op.value=data[i].value;
				op.text=data[i].name;
				op.setAttribute('_dictId',data[i].dictId);
				try{
					opts.el.add(op); // IE only
				}
				catch(ex){
					opts.el.add(op,null);
				}
			}
			var val=opts.el.getAttribute('_dvalue');
			if(opts.value) opts.el.value=opts.value;
			else if(val) opts.el.value=val;
			Huateng.Util.DictMgr.__fireChange(opts.el);
		},
		INPUT:function(data,opts){
			var el=opts.el;
			if(el.type!='checkbox'&&el.type!='radio') return;
			var gname=opts.el.name;
			var clos=Ext.num(el.getAttribute('dcols'),0);
			var cktpl={tag:'input',type:el.type,name:gname};
			if(el.getAttribute('cls')) cktpl.cls=el.getAttribute('cls');
			if(el.getAttribute('cstyle')) cktpl.style=el.getAttribute('cstyle');
			var labtpl={tag:'label'};
			for(var i=0;i<data.length;i++){
				cktpl.value=data[i].value;
				cktpl._dictId=data[i].dictId;
				el=Ext.DomHelper.insertAfter(el,cktpl,true);
				labtpl['for']=el.id;
				labtpl['html']=data[i].name;
				el=Ext.DomHelper.insertAfter(el,labtpl,true);
				if(clos>0&&(i+1)%clos==0&&i+1<data.length) el=Ext.DomHelper.insertAfter(el,{tag:'br'},true);
			}
		}
	},
	//级联处理
	__cascadeHander:function(event,eo,option){
		var dictId=eo.options[eo.selectedIndex].getAttribute('_dictId');
		var opts={el:option.el,clear:true,dictId:dictId,callback:this.defaultHandler};
		if(!Ext.isDefined(option.cacheable)) opts.cacheable=option.cacheable;
		this.__loadDict(opts);
	},
	//模拟change事件
	__fireChange:function(el){
		if (document.fireEvent){
       		el.fireEvent('onchange');
     	}else{
       		var evt = document.createEvent("HTMLEvents");
       		evt.initEvent("change", true, true);
       		el.dispatchEvent(evt);
     	}
	},
	//设置一个字典映射
	setDictMap:function(dname,dictId,callback,scope,cacheable){
		var map={};
		if(typeof dname=='object'){
			map=dname;
			cacheable=scope;
			scope=callback;
			callback=dictId;
		}
		else map[dname]=dictId;
		if(typeof callback=='boolean') cacheable=callback;
		var total=0;
		for(var key in  map) total++;
		var counter={total:total,count:0};
		for(var key in  map){
			var opts={mapName:key,dictId:map[key],cacheable:cacheable,handler:callback,scope:scope,callback:this.__mapHandler,map:map,counter:counter};
			if(Ext.isDefined(cacheable)) opts.cacheable=cacheable;
			this.__loadDict(opts);
		}
	},
	//映射处理
	__mapHandler:function(data,opts){
		var dm={};
		for(var i=0;i<data.length;i++){
			dm[data[i].value]=data[i].name;
		}
		this.__DictMap[opts.mapName]=dm;
		opts.counter.count++;
		var callback=opts.handler,scope=opts.scope;
		delete opts.callback;
		delete opts.scope;
		if(opts.counter.count==opts.counter.total&&typeof callback=='function')
			callback.call(scope||window,opts);
	},
	//取得字典name
	getDictName:function(dname,value){
		if(!this.__DictMap[dname]) return value;
		else  return this.__DictMap[dname][value];
	},
	//取得
	getDictMapFun:function(dname){
		return function(value){
					return Huateng.Util.DictMgr.getDictName(dname,value);
				};
	},
	//加载一个字典
	loadDict:function(opts){
		if(Ext.isString(opts)){
			opts={dictId:opts};
		}
		if(opts.dictId==null||opts.dictId==''){
			return;
		}
		this.__loadDict(opts);
	}
}

Ext.onReady(function(){
    Huateng.Util.DictMgr.initGlobal();
});