var DictMgr={
	dictUrl:'DictAction!getChildDicts.action',
	__DictMap:{},
	__DictCache:{},
	__reqQueue:{},
	_sid:1,
	cacheable:true,
	//初始全局
	initGlobal:function(){
		this.init('select[dictId],select[cascade],input[dictId],input[cascade]');
	},
	
	init:function(selector,cacheable,handler){
		var els=$(selector);
		for(var i=0;i<els.length;i++) this.initItem(els[i]);
	},
	//初始化一个项
	initItem:function(el,cacheable,handler){
		if(!el) return;	
		if(el.getAttribute('isInitDict')===true) return;
		var did=el.getAttribute('dictId');
		var cid=el.getAttribute('cascade');
		if(cid){
			var cel=$('#'+cid);
			var opts={el:el};
			var eData={opts:opts,thiz:this};
			if(cel.length>0) cel.change(eData,this.__cascadeHander);
			el.setAttribute('isInitDict',true);
		}
		if(did){
			var opts={el:el,dictId:did,clear:true,cacheable:cacheable,callback:handler||this.defaultHandler};
			this.__loadDict(opts);
			el.setAttribute('isInitDict',true);
		}
	},
	refurbishItem:function(el,value,cacheable){
		el=el.nodeType?el:document.getElementById(el);
		if(!el) return;
		var dictId;
		if(el.getAttribute('isInitDict')!==true) return;
		var did=el.getAttribute('dictId');
		var cid=el.getAttribute('cascade');
		if(did) dictId=did;
		else if(cid){
			var cel=document.getElementById(cid);
			if(cel) dictId=cel.options[cel.selectedIndex].getAttribute('_dictId');
		}
		opts={el:el,value:value,dictId:dictId,clear:true,cacheable:cacheable,callback:this.defaultHandler};
		this.__loadDict(opts);
	},
	setSelValue:function(el,value){
		el=el.nodeType?el:document.getElementById(el);
		if(!el) return;
		if(value==null) value='';
		el.value=value;
		$(el).trigger('change');
		el.setAttribute('_dvalue',value);
	},
	//调用处理函数
	defaultHandler:function(data,opts){
		var handler=opts.el.tagName;
		if(handler=='INPUT'&&this.handlers['INPUT_'+opts.el.type])
			handler='INPUT_'+opts.el.type;
		if(this.handlers[handler]) this.handlers[handler](data,opts);
	},
	//载入字典项
	__loadDict:function(opts){
		if(!opts.dictId||''==opts.dictId){
			opts.callback.call(this,[],opts);
			return;
		}
		if(typeof opts.cacheable!='undefined') opts.cacheable=this.cacheable;
		if(opts.cacheable!==false&&this.__DictCache[opts.dictId]){
			opts.isCache=true;
			if($.isFunction(opts.callback))
				opts.callback.call(this,this.__DictCache[opts.dictId],opts);
			return;
		}
		opts.isCache=false;
		var url=opts.dictUrl||this.dictUrl;
		if(url==this.dictUrl){
			if(this.__reqQueue[opts.dictId]){
				this.__reqQueue[opts.dictId].push(opts);
				return;
			}
			else{
				this.__reqQueue[opts.dictId]=[opts];
			}
		}
		var context={thiz:this,opts:opts};
		$.ajax({
			url:url,
			cache:false,
			type:'POST',
			context:context,
			data:{dictId:opts.dictId},
			success:this.__requestSuccess
		});
	},
	//请求成功回调
	__requestSuccess:function(data, textStatus,jqXHR){
		var opts=this.opts;
		var thiz=this.thiz;
		var data=eval('('+jqXHR.responseText+')');
		thiz.__DictCache[opts.dictId]=data;
		if(thiz.__reqQueue[opts.dictId]){
			var queue=thiz.__reqQueue[opts.dictId];
			for(var i=0;i<queue.length;i++){
				var opt=queue[i];
				if($.isFunction(opt.callback)){
					try{	
						opt.callback.call(opt.scope||thiz,data,opt);
					}
					catch(ex){
					}
				}
			}
			delete thiz.__reqQueue[opts.dictId];
		}
		else{
			if($.isFunction(opts.callback))
				opts.callback.call(opts.scope||thiz,data,opts);
		}
	},
	//请求结果处理函数集
	handlers:{
		SELECT:function(data,opts){
			if(opts.clear) opts.el.innerHTML=null;
			if(opts.el.length==0){
				var op=document.createElement('option');
				op.text='---请选择---';
				op.value='';
				try{opts.el.add(op);}catch(ex){opts.el.add(op,null);}
			}
			for(var i=0;i<data.length;i++){
				var op=document.createElement('option');
				op.value=data[i].value;
				op.text=data[i].name;
				op.setAttribute('_dictId',data[i].dictId);
				try{
					opts.el.add(op); // IE only
				}
				catch(ex){
					opts.el.add(op,null);
				}
			}
			var val=opts.el.getAttribute('dvalue');
			if(opts.value) opts.el.value=opts.value;
			else if(val) opts.el.value=val;
			$(opts.el).trigger('change');
		},
		INPUT:function(data,opts){
			var el=opts.el;
			if(el.type!='checkbox'&&el.type!='radio') return;
			var gname=opts.el.name;
			var clos=Number(el.getAttribute('dcols'));
			if(isNaN(clos)) clos=0;
			var cktplh='<input type="'+el.type+'" name="'+gname+'" ' //{tag:'input',type:el.type,name:gname};
			if(el.getAttribute('cls')) cktplh+='class="'+el.getAttribute('cls')+'" ';
			if(el.getAttribute('cstyle')) cktplh+='style="'+el.getAttribute('cstyle')+'" ';
			cktplh+='id="'
			var labtpl='<label ';
			var html=[];
			for(var i=0;i<data.length;i++){
				var cid="dictbox_"+DictMgr._sid++;
				html.push(cktplh,cid,'" value="',data[i].value,'" _dictId="',data[i].dictId,'" />');
				html.push(labtpl,'for="',cid,'">');
				html.push(data[i].name,"</label>");
				if(clos>0&&(i+1)%clos==0&&i+1<data.length) html.push("<br />");;
			}
			$(el).after(html.join(''));
		}
	},
	//级联处理
	__cascadeHander:function(event){
		var dictId=this.options[this.selectedIndex].getAttribute('_dictId');
		var option=event.data.opts;
		var thiz=event.data.thiz;
		var opts={el:option.el,clear:true,dictId:dictId,callback:thiz.defaultHandler,cacheable:option.cacheable};
		thiz.__loadDict(opts);
	},
	//设置一个字典映射
	setDictMap:function(dname,dictId,callback,scope,cacheable){
		var map={};
		if(typeof dname=='object'){
			map=dname;
			cacheable=scope;
			scope=callback;
			callback=dictId;
		}
		else map[dname]=dictId;
		if(typeof callback=='boolean') cacheable=callback;
		var total=0;
		for(var key in  map) total++;
		var counter={total:total,count:0};
		for(var key in  map){
			var opts={mapName:key,dictId:map[key],cacheable:cacheable,handler:callback,scope:scope,callback:this.__mapHandler,map:map,counter:counter,cacheable:cacheable};
			this.__loadDict(opts);
		}
	},
	//映射处理
	__mapHandler:function(data,opts){
		var dm={};
		for(var i=0;i<data.length;i++){
			dm[data[i].value]=data[i].name;
		}
		this.__DictMap[opts.mapName]=dm;
		opts.counter.count++;
		var callback=opts.handler,scope=opts.scope;
		delete opts.callback;
		delete opts.scope;
		if(opts.counter.count==opts.counter.total&&typeof callback=='function')
			callback.call(scope||window,opts);
	},
	//取得字典name
	getDictName:function(dname,value){
		if(!this.__DictMap[dname]) return value;
		else  return this.__DictMap[dname][value];
	},
	//取得
	getDictMapFun:function(dname){
		return function(value){
					return DictMgr.getDictName(dname,value);
				};
	},
	//加载一个字典
	loadDict:function(opts){
		if(typeof opts=='string'){
			opts={dictId:opts};
		}
		if(opts.dictId==null||opts.dictId==''){
			return;
		}
		this.__loadDict(opts);
	}
}

$(function(){
    DictMgr.initGlobal();
});