Ext.ns("Huateng.Util");

Huateng.Util.IconPicker= Ext.extend(Ext.BoxComponent,{
	cls:'x-icon-picker',
	value:null,
	clickEvent:'click',
	allowReselect:true,
	iconCssPrefix:'',
	icons:[],
	width:200,
	height:100,
	iconSize:[16,16],
	momeryPaging:true,
	rows:5,
	cols:10,
	paging:true,
	ctype:'Huateng.Util.IconPicker',
	initComponent:function(){
		Huateng.Util.IconPicker.superclass.initComponent.call(this);
		this.tpl=this.tpl||new Ext.XTemplate(
			'<div class="x-icon-picker-body"></div>',
			this.paging==true?'<div class="x-icon-picker-paging"></div>':''
		);
		this.internalTpl=this.internalTpl||new Ext.XTemplate(
			'<tpl for=".">',
			'<a href="#" class="icon-{.}" hidefocus="on">',
			'<span class="x-icon-item {.}" title="{.}" style="width:',this.iconSize[0],'px;height:',this.iconSize[1],'px;" unselectable="on">&nbsp;</span>',
			'</a></tpl>'
		);
		this.addEvents(
			'select'
		);
		if(this.handler){
			this.on('select',this.handler,this.scope,true);
		}
		this.loading=0;
	},
	
	onRender:function(container,position){
		Huateng.Util.IconPicker.superclass.onRender.call(this,container,position);
		this.tpl.overwrite(this.el);
		this.body=this.el.child('div.x-icon-picker-body');
		this.initDate();
        if(this.paging===true){
        	this.body.setHeight((this.iconSize[1]+6)*this.rows);
        	this.initPaging();
        }
	},
	initDate:function(){
		if(this.url){
			this.loading=1;
			Ext.Ajax.request({
				url:this.url,
				params:this.params,
				scope:this,
				success:function(response){
					var data=Ext.decode(response.responseText);
					this.icons=data;
					this.loading=0;
					if(this.pagingToolbar) this.pagingToolbar.onLoad();
					this.refresh();
					this.setValue(this.value,true);
				},
				failure:function(response){
					this.loading=2;
					this.refresh();
				}
			});
		}
	},
	initPaging:function(){
		var pdiv=this.el.child('div.x-icon-picker-paging',true);
		this.pagingToolbar=new Huateng.Util.IconPicker.PagingToolBar({
			iconPicker:this,
			pageSize:this.rows*this.cols,
			renderTo:pdiv
		})
		this.pagingToolbar.on('change',this.refresh,this);
	},
    afterRender : function(container){
        Huateng.Util.IconPicker.superclass.afterRender.call(this);
        this.setWidth((this.iconSize[0]+6)*this.cols);
        var el=this.getTemplateTarget();
		this.mon(el, this.clickEvent, this.handleClick, this, {delegate: 'a'});
        if(this.clickEvent != 'click'){
        	this.mon(el, 'click', Ext.emptyFn, this, {delegate: 'a', preventDefault: true});
        }
        this.refresh();
        this.setValue(this.value,true);
    },
	refresh : function(){
		var el=this.getTemplateTarget();
		if(this.loading==1){
			if(el.isMasked()) el.unmask();
			el.mask('加载中...','x-mask-loading');
		}
		else if(this.loading==2){
			if(el.isMasked()) el.unmask();
			el.mask('加载失败!');
			this.loading==3;
		}
		else if(this.loading==3){
			if(el.isMasked()) el.unmask();
			el.mask('加载中...');
			this.initDate();
		}
		else{
			if(el.isMasked())el.unmask();
			var data=this.paging===true?this.icons.slice(this.pagingToolbar.cursor,this.pagingToolbar.cursor+this.cols*this.rows):this.icons;
			this.internalTpl.overwrite(el,data);
			this.select(this.value,true);
		}
	},
	getTemplateTarget: function(){
        return this.body;
    },
    // private
    handleClick : function(e, t){
        e.preventDefault();
        if(!this.disabled){
            var c = t.className.match(/(?:^|\s)icon-([-\w]+)(?:\s|$)/)[1];
            this.select(c);
        }
    },
    select : function(icon, suppressEvent){
    	if(this.loading!=0) return;
        if(icon != this.value || this.allowReselect){
            var el = this.body;
            if(this.value){
                var ci=el.child('a.icon-'+this.value);
                if(ci)ci.removeClass('x-icon-item-sel');
            }
            if(el.child('a.icon-'+icon))
            el.child('a.icon-'+icon).addClass('x-icon-item-sel');
            this.value = icon;
            if(suppressEvent !== true){
                this.fireEvent('select', this, icon);
            }
        }
    },
    setValue:function(value,suppressEvent){ 
	    if(this.rendered){
	    	if(this.paging===true){
	       	  var ci=this.icons.indexOf(value);
	       	  if(ci>0){
		       	  var pageSize=this.cols*this.rows;
		       	  var apage=Math.floor(ci/pageSize);
				  var cursor=apage*pageSize;
				  if(this.pagingToolbar.cursor!=cursor){
				  	this.pagingToolbar.doLoad(cursor);
				  }
	       	  }
	        }
    		this.select(value,suppressEvent);
    	}
    	else this.value=value;
    },
    getValue:function(){
     	return this.value;
    },
    onDestroy:function(){
    	Ext.destroy(this.pagginToolbar);
        Huateng.Util.IconPicker.superclass.onDestroy.call(this);
    }
});
Ext.reg('iconpicker', Huateng.Util.IconPicker);

Huateng.Util.IconPicker.PagingToolBar=Ext.extend(Ext.PagingToolbar,{
	firstText:'首页',
	prevText:'上一页',
	nextText:'下一页',
	lastText:'末页',
	beforePageText:'',
	afterPageText:'/{0}',
	autoHeight:true,
	autoWidth:true,
	initComponent:function(){
		Huateng.Util.IconPicker.PagingToolBar.superclass.initComponent.call(this);
	},
	onFirstLayout : function(){
            this.onLoad();
    },
	doLoad : function(start){
		var o = {start:start,limit:this.pageSize};
        if(this.fireEvent('beforechange', this, o) !== false){
        	this.cursor=start;
        	this.onLoad();
        }
    }, 
    onLoad : function(){
        if(!this.rendered){
            return;
        }
        var d=this.getPageData(),ap = d.activePage, ps = d.pages;
        this.afterTextItem.setText(String.format(this.afterPageText, d.pages));
        this.inputItem.setValue(ap);
        this.first.setDisabled(ap == 1);
        this.prev.setDisabled(ap == 1);
        this.next.setDisabled(ap == ps);
        this.last.setDisabled(ap == ps);
        this.refresh.enable();
        this.updateInfo();
        this.fireEvent('change', this, d);
    },
    getPageData : function(){
        var total = this.iconPicker.icons.length;
        return {
            total : total,
            activePage : Math.ceil((this.cursor+this.pageSize)/this.pageSize),
            pages :  total < this.pageSize ? 1 : Math.ceil(total/this.pageSize)
        };
    },
    changePage : function(page){
        this.doLoad(((page-1) * this.pageSize).constrain(0, this.iconPicker.icons.length));
    },
    moveLast : function(){
        var total = this.iconPicker.icons.length,
            extra = total % this.pageSize;
        this.doLoad(extra ? (total - extra) : total - this.pageSize);
    },
    bindStore : Ext.emptyFn
});

Huateng.Util.IconMenu=Ext.extend(Ext.menu.Menu, {
	enableScrolling : false,
	hideOnClick : true,
    cls : 'x-icon-menu',
    iconPickerId:null,
    iconPicker:null,
	ctype:'Huateng.Util.IconMenu',
    initComponent : function(){
    	if(!this.iconPicker){
    		var config=Ext.applyIf({
                id: this.iconPickerId
            }, this.initialConfig);
            config.autoHeight=true;
            config.autoWidth=true;
            delete config.cls;
    		this.iconPicker = new Huateng.Util.IconPicker(config);
    	}
        Ext.apply(this, {
            plain: true,
            showSeparator: false,
            items: this.iconPicker
        });     
        this.iconPicker.purgeListeners();
        Huateng.Util.IconMenu.superclass.initComponent.call(this);
        this.relayEvents(this.iconPicker, ['select']);
        this.on('select', this.menuHide, this);
        if(this.handler){
            this.on('select', this.handler, this.scope || this);
        }
    },
    
    menuHide : function(){
        if(this.hideOnClick){
            this.hide(true);
        }
    },
    onDestroy:function(){
    	Ext.destroy(this.iconPicker);
        Huateng.Util.IconMenu.superclass.onDestroy.call(this);
    }
});

Ext.reg('iconmneu', Huateng.Util.IconMenu);

Huateng.Util.IconSelect=Ext.extend(Ext.BoxComponent, {
	cls:'x-icon-filed',
	createHiddenField:true,
	name:'',
	value:'',
	iconSize:[16,16],
	initComponent : function(){
    	Huateng.Util.IconSelect.superclass.initComponent.call(this);
        this.addEvents(
            'select'
    	);
    	this.on('select',this.onSelect,this);
    	if(this.iconMenu instanceof Huateng.Util.IconMenu){
			this.relayEvents(this.iconMenu, ['select']);
    	}
	},
	onSelect:function(o,value){
		this.setValue(value);
	},
	onRender:function(ct, position){
		Huateng.Util.IconSelect.superclass.onRender.call(this, ct, position);
		var content='<span class="x-icon">&nbsp;</span><span title="点击选择" class="x-icon-btn"></span>'
		if(this.createHiddenField){ 
			content+='<input type="hidden" name="'+this.name+'" value="'+this.value+'" />'
		}
		Ext.DomHelper.overwrite(this.el,content);
		this.iconEl=this.el.child('span.x-icon');
		this.iconEl.applyStyles({width:this.iconSize[0]+'px',height:this.iconSize[1]+'px'});
		this.iconEl.on('click',this.onClick,this);
		this.el.child('span.x-icon-btn').on('click',this.onClick,this);
		if(this.createHiddenField)	this.hiddenField=this.el.child('input',true);
		if(this.value) this.setValue(this.value);
	},
	onClick:function(){
		if(this.disabled===true) return;
		if(!(this.iconMenu instanceof Huateng.Util.IconMenu)){
			var config=this.iconMenu||{};
			config.value=this.value;
			Ext.applyIf(config,{iconSize:this.iconSize});
			this.iconMenu=new Huateng.Util.IconMenu(config);
			this.relayEvents(this.iconMenu, ['select']);
		}
		if(this.hiddenField&&this.hiddenField.vlue) this.value=this.hiddenField.vlue;
		this.iconMenu.iconPicker.setValue(this.value);
		this.iconMenu.show(this.el,'bl-tl');
	},
	onDestroy:function(){
    	Ext.destroy(this.iconMenu);
        Huateng.Util.IconSelect.superclass.onDestroy.call(this);
    },
	setValue:function(value){
		this.iconEl.replaceClass(this.value,value);
		this.iconEl.set({title:value});
		this.value=value;
		if(this.hiddenField) this.hiddenField.value=value;
	},
	getValue:function(){
		return this.value;
	},
	onDisable:function(){
		Huateng.Util.IconSelect.superclass.onDisable.call(this);
		if(this.hiddenField) this.hiddenField.disabled=true;
	},
	onEnable:function(){
		Huateng.Util.IconSelect.superclass.onEnable.call(this);
		if(this.hiddenField) this.hiddenField.disabled=false;
	}
});
Ext.reg('iconselect', Huateng.Util.IconSelect);