Ext.ns("Huateng.Util");
Huateng.Util.WebOfficeComponent=Ext.extend(Ext.BoxComponent,{
	webOfficeWidth:'100%',
	webOfficeHeight:'100%',
	classid:'clsid:E77E049B-23FC-4DB8-B756-60529A35FAD5',
	codebase:'',
	width:800,
	height:600,
	encode:true,
	fileField:'file',
	showToolBar:true,
	checkAlert:true,
	saveToServer:null,
	initComponent:function(){
		Huateng.Util.WebOfficeComponent.superclass.initComponent.call(this);
		this.addEvents(
			'initialize',
			'toolbarclick',
			'beforeloadfile',
			'loadfile',
			'beforenewfile',
			'newfile',
			'beforesubmit',
			'submit'
		);
		this.tpl = this.tpl||[
		     '<tpl>',
		     '<object id="{id}" height="{height}" width="{width}"',
		     ' classid="{classid}"  codebase="{codebase}" >',
		     '<p style="margin-top:20px;text-align:center;font-size:20px">该浏览器不支持WebOffice,要使用此功能请使用Internet Explorer。</p>',
		     '<tpl for="params">',
		     '<param name="{name}" value="{value}" />',
		     '</tpl></object></tpl>'
		];
		this.objectParams=Ext.apply({
			_Version:65536,
			_ExtentX:2646,
			_ExtentY:1323,
			_StockProps:0
		},this.objectParams);
	},
	onRender:function(ct, position){
		Huateng.Util.WebOfficeComponent.superclass.onRender.call(this,ct, position);
		var params=[];
		for(var p in this.objectParams)
			params.push({name:p,value:this.objectParams[p]});
		var data={
			params:params,
			width:this.webOfficeWidth,
			height:this.webOfficeHeight,
			classid:this.classid,
			codebase:this.codebase,
			id:'webOffice'+(++Ext.Component.AUTO_ID)
		};
		if (!this.tpl.compile)
            this.tpl = new Ext.XTemplate(this.tpl);
        this.tpl.overwrite(this.el,data);
        this.webOffice=Ext.getDom(data.id);
        if(this.showToolBar==false) this.webOffice.ShowToolBar=0;
	},
	afterRender:function(ct){
		Huateng.Util.WebOfficeComponent.superclass.afterRender.call(this,ct);
		Ext.EventManager.on(window,'unload',this.close,this);
		this.addLis("NotifyCtrlReady",this.onInitialize,this);
		this.addLis("NotifyToolBarClick",this.onToolBarClick,this);
		this.addLis("NotifyWordEvent",this.onWordEvent,this);
	},
	onInitialize:function(){
		this.fireEvent('initialize',this);
		
	},
	onToolBarClick:function(iIndex){
		if(this.fireEvent('toolbarclick',this,iIndex)===false)
				this.webOffice.lEventRet=0;
	},
	onWordEvent:function(strEventName){
		//alert(1);
	},
	checkWebOffice:function(ca){
		if(this.webOffice&&this.webOffice.Version) return true;
		else{
			if(typeof ca!='boolean') ca=this.checkAlert;
			if(ca) Ext.Msg.alert('提示','webOffic没有正常载入！');
			return false;
		}
	},
	close:function(){
		if(this.webOffice) this.webOffice.close();
	},
	beforeDestroy:function(){
		Huateng.Util.WebOfficeComponent.superclass.beforeDestroy.call(this);
		this.close();
		Ext.EventManager.un(window,'unload',this.close);
		this.webOffice=null;
	},
	isOpened:function(){
		if(!this.checkWebOffice()) return 0;
		return this.webOffice.IsOpened();
	},
	getDocumentObject:function(){
		if(this.checkWebOffice()) 
			return this.webOffice.getDocumentObject();
		else return null;
	},
	syncSubmit:function(opt){
		if(!this.checkWebOffice()) return false;
		opt=Ext.apply({},opt,{url:this.defaultUrl,fileField:this.fileField,fileName:''});
		var fileName=opt.fileName;
		if(this.fireEvent('beforesubmit',this,opt)===false) return null;
		this.webOffice.HttpInit();
		if(opt.params){
			for(var p in opt.params){
				if(this.encode) 
				 	this.webOffice.HttpAddPostString(p,encodeURIComponent(opt.params[p]));	
				else
					this.webOffice.HttpAddPostString(p,opt.params[p]);
			}
		}
		fileName=this.encode?encodeURIComponent(fileName):fileName;
		if(this.webOffice.IsOpened())
			this.webOffice.HttpAddPostCurrFile(opt.fileField,fileName);
		var re=this.webOffice.HttpPost(opt.url);
		this.fireEvent('submit',this,re,opt);
		return re;
	},
	submit:function(cfg){
		return this.syncSubmit(cfg);
		/*if(!this.checkWebOffice()) return false;
		cfg=cfg||{};
		if(!cfg.url) cfg.url=this.defaultUrl;
		if(!cfg.fileField) cfg.fileField=this.fileField;
		var fileName=cfg.fileName||'';
		this.webOffice.HttpInit();
		cfg.headers=cfg.headers||{};
		cfg.method='POST';
		cfg.headers["Content-Type"]="multipart/form-data; boundary=--MULTI-PARTS-FORM-DATA-BOUNDARY";
		if(this.webOffice.IsOpened())
			this.webOffice.HttpAddPostCurrFile(cfg.fileField,fileName);
		cfg.params=this.webOffice.GetHttpPostFormatData(1);
		Ext.Ajax.request(cfg);*/
	},
	loadFile:function(url,type){
		if(!this.checkWebOffice()) return false;
		if(!type) type='doc';
		if(this.fireEvent('beforeloadfile',this,url,type)===false) return false;
		var re=this.webOffice.LoadOriginalFile(url,type);
		this.fireEvent('loadfile',this,!!re,url,type);
		return !!re;
	},
	newFile:function(type){
		if(!this.checkWebOffice()) return false;
		if(!type) type='doc';
		if(this.fireEvent('beforenewfile',this,type)===false) return false;
		var re=this.webOffice.LoadOriginalFile('',type);
		this.fireEvent('newfile',this,!!re,type);
		return !!re;
	},
	applyTemplate:function(url){
		if(!this.isOpened()) return false;
		this.webOffice.SetFieldValue("mark_1","","::ADDMARK::")
		return this.webOffice.SetFieldValue("mark_1",url,"::FILE::");
	},
	setWebOfficeToolBtn:function(index,text){
		if(!this.checkWebOffice()) return false;
		this.webOffice.SetCustomToolBtn(index,text);
	},
	//取得ActiveDocument
	getDocumentObject:function(){
		return this.webOffice.getDocumentObject();
	},
	getDocVariables:function(){
		return this.getDocumentObject().Variables;
	},
	getDocVariable:function(name){
		return this.getDocumentObject().Variables(name);
	},
	getDocFields:function(){
		return this.getDocumentObject().Fields;
	},
	getDocField:function(name){
		return this.getDocumentObject().Fields(name);
	},
	setDocVariable:function(name,value){
		var v=this.getDocumentObject().Variables(name);
		try{
			if(null==value||''===value){
				v.name;
				v.value='';
			}
			else
				v.value=value;
		}
		catch(e){
		}
	},
	setDocVariables:function(obj,eachCb){
		var vs=this.getDocVariables();
		if(eachCb instanceof Function){
			for(var p in obj){
				eachCb(p,obj[p],vs);
			}
			return;
		}
		for(var p in obj){
			var v=obj[p];
			if(v==null){
				vs(p).value='';
			}
			else if(typeof v!="object"){
				vs(p).value=obj[p];
			}
			else{
				this.setDocVariables(obj[p]);
			}
		}
	},
	clearDocVariable:function(name){ 
		try{
			var v=this.getDocVariable(name);
			v.name;
			v.value='';
		}
		catch(e){
			return false;
		}
		return true;
	},
	clearDocVariables:function(){
		var vs=this.getDocVariables();
		for(var i=1;i<=vs.Count;i++){
			vs(i).value='';
		}
	},
	deleteDocVariable:function(name){
		try{
		 	this.getDocVariable(name)['delete']();
		}catch(e){
			return false;
		}
		return true;
	},
	updateField:function(name){
		var field=null;
		if(name) field=this.getDocField(name);
		if(field) return field.update()==0;
		return false;
	},
	updateFields:function(){
		var fs=this.getDocFields();
		var vs=this.getDocVariables();
		for(var i=1;i<=fs.count;i++){
			if(fs(i).Type!=64) continue;
			var f=fs(i);
			try{
			  var vn=(/^ DOCVARIABLE +(.+)\ +(?:\s+$|[^\\]\\\*.+)/.exec(f.code))[1];
			  if(vn.length>2&&vn.charAt(0)=='"') vn=vn.substring(1,vn.length-2);
			  vs(vn).name;
			  f.update();
			}
			catch(e){
				if(e.number==-2146822463)
					f.Result.text='';
			}
			
		}
	},
	//private
	addLis:function(ename,fn,scope){
		if(scope) fn=fn.createDelegate(scope);
		if(window.attachEvent){
			this.webOffice.attachEvent(ename,fn);
		}
		else if(window.addEventListener){
			this.webOffice.addEventListener(ename,fn,false);
		}
	},
	//private
	removeLis:function(ename,fn){
		if(window.detachEvent){
			this.webOffice.detachEvent(ename,fn);
		}
		else if(window.removeEventListener){
			this.webOffice.removeEventListener(ename,fn,false);
		}
	},
	addSaveButton:function(num,name){
		this.webOffice.SetCustomToolBtn(num,name);
	},
	 
	hideSaveButton:function(code){
		 this.webOffice.HideMenuItem(code);
	}
})
Ext.reg('weboffice',Huateng.Util.WebOfficeComponent);
Huateng.Util.WebOfficeComponent.TOOLBARS={
	ID_RETURN : 32769,
	ID_NEW : 32770,
	ID_OPEN : 32771,
	ID_SAVEAS : 32772,
	ID_FULLSCREAN : 32773,
	ID_PRINT : 32774,
	ID_PRINTVIEW : 32775,
	ID_SHOWHIDEMENU : 32781	
}
Huateng.Util.WebOfficeComponent.prototype.codebase=htSystemPath+'js/util/weboffice_v6.0.5.0.cab#Version=6,0,5,0';