if(typeof Huateng=='undefined') Huateng={};
if(!Huateng.Util) Huateng.Util={};
Ht=Huateng.Util;
Huateng.Util.Validator = {
	tip: '提示',
	Notnull : /^(.+)?\S+(.+)?$/,
	Require : /.+/,
	Email : /^((\s?)+$)|(\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*)$/,
	Phone : /^((\(\d{3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}$/,
	Mobile : /^((\(\d{3}\))|(\d{3}\-))?1\d{10}$/,
	Url : /^http:\/\/[A-Za-z0-9]+\.[A-Za-z0-9]+[\/=\?%\-&_~`@[\]\':+!]*([^<>\"\"])*$/,
	IdCard : /^\d{15}(\d{2}[xX0-9])?$/,
	Currency : /^\d+(\.\d+)?$/,
	Number : /^\d+$/,
	Zip : /^[1-9]\d{5}$/,
	QQ : /^[1-9]\d{4,9}$/,
	Integer : /^[-\+]?\d+$/,
	Double : /^[-\+]?\d+(\.\d+)?$/,
	English : /^[A-Za-z]+$/,
	Chinese :  /^[\u0391-\uFFE5]+$/,
	UnSafe : /^(([A-Z]*|[a-z]*|\d*|[-_\~!@#\$%\^&\*\.\(\)\[\]\{\}<>\?\\\/\'\"]*)|.{0,5})$|\s/,
	IsSafe : function(str){return !this.UnSafe.test(str);},
	defaultMsg:'{name}格式不正确！',
	_Range:/^\[(\d+)?-(\d+)?\]$/,
	_Length:/^\((\d+)?(-(\d+)?)?\)$/,
	_Equal:/^=#(\w+)$/,
	failMsgs:{
		Notnull:'{name}不能为空!',
		Require:'{name}不能为空!',
		Email:'Email格式不对!',
		Range:'{name}应在{min}到{max}之间',
		Range1:'{name}应不小于{min}',
		Range2:'{name}应不大于{max}',
		Length:'{name}长度应为{min}-{max}位',
		Length1:'{name}长度应为{min}位',
		Length2:'{name}应不小于{min}',
		Length3:'{name}应不大于{max}',
		CheckBoxLen:'{name}应该选择{min}-{max}个',
		CheckBoxLen1:'{name}应该选择{min}个',
		CheckBoxLen2:'{name}应该选择不少于{min}个',
		CheckBoxLen3:'{name}应该选择不多于{max}个',
		CompEqual:'{name}与{name1}不一致'
	},
	//验证表单
	formValidate : function(formId,vall,callback){
		if(typeof vall=='function'){
			callback=vall;
			vall=undefined;		
		}
		if(typeof vall!='boolean'){
			var form=document.getElementById(formId);
			if(form.getAttribute('vAll')=='true') vall=true;
			else vall=false;
		}
		if(!callback) callback=this.defaultcallback;
		var errors=this.validate(formId,vall);
		var re=callback(errors,formId);
		if(re===true||re===false) return re;
		else return errors.length==0;
	},
	//private
	validate:function(formId,vall){
		var form=document.getElementById(formId);
		var elements=form.elements;
		var errors=[];
		//取得所有表单元素
		for(var i=0;i<elements.length;i++){
			var e=elements[i];
			var it=this.validateItem(e);
			if(it){ 
			   errors.push(it);
			   if(!vall) break;
			}
		}
		return errors;
	},
    /**
     * 对一个表单元素进行验证
     * @param {} e 一个表单元素
     */
	validateItem:function(e){
		if(typeof e=='string') e=document.getElementById(e);
		var error=null;
		if(!e.getAttribute('vType')){return;}	
		var is=e.getAttribute('vType').split(',');
		var isEmpty=''==e.value;
		if(e.type=='checkbox'||e.type=='radio'){
			isEmpty=0==this.getCheckedCount(e);
		}
		for(var ii=0;ii<is.length;ii++){
			var v=is[ii]; 
			if(isEmpty&&v=='Require'){
				error={element:e,message:this.getErrMsg(e,v)};
			}else if(!isEmpty){	
					error=this._parse(e,v,ii);
			}
			if(error){
				error.vType=v;
				break;
			}
		}
		return error;
	},
	//private
	_parse:function(e,v,i){
		var p;
		var vt=v;
		if(this.hasOwnProperty(v)) p=this[v];
		else p=v;
		var error=null;
		switch(Object.prototype.toString.call(p)){
			case '[object RegExp]':
				if(!p.test(e.value))
					error={element:e,type:vt,message:this.getErrMsg(e,v,i)};
				break;
			case '[object String]':
				var re=null;
				if(re=this._Range.exec(p)){
				  if(re[1]=='') re[1]=undefined; //没捕获 ie返回'' firefox 返回undefined
				  if(re[2]=='') re[2]=undefined;
				  var params={min:re[1],max:re[2]};
				  if(!this._inRange(e.value,re[1],re[2])) error={element:e,type:vt,message:this.getErrMsg(e,'Range',i,params)};
				}
				else if(re=this._Length.exec(p)){
				  if(re[1]=='') re[1]=undefined; //没捕获 ie返回'' firefox 返回undefined
				  if(re[2]=='') re[2]=undefined;
				  if(re[3]=='') re[3]=undefined;
				  v='';
				  if(re[1]&&!re[2]){v='1'; re[3]=re[1];}
				  if(re[1]&&re[2]&&!re[3]) v='2';
				  if(!re[1]&&re[3]) v='3';
				  v=(e.type=='checkbox'?'CheckBoxLen':'Length')+v;
				  var params={min:re[1],max:re[3]};
				  var len=e.type=='checkbox'?this.getCheckedCount(e):e.value.length;
				  if(!this._inRange(len,re[1],re[3])) error={element:e,type:vt,message:this.getErrMsg(e,v,i,params)};
				}
				else if(re=this._Equal.exec(p)){
					var o=document.getElementById(re[1]);
					if(!o||!o.value) o=e.form[re[1]];
					v='CompEqual';
					var params={name1:this.getDisplayName(o)};
					if(o.value!=e.value) error={element:e,type:vt,message:this.getErrMsg(e,v,i,params)};
				}
				break;
			case '[object Function]':
				break;
		}
		return error;
	},
	//private
	_inRange:function(v,min,max){
		if(!min) min=0;
		else min=Number(min);
		if(!max) max=Number.MAX_VALUE;
		else max=Number(max);	
		v=Number(v);
		if(isNaN(v)) return false;
		return v>=min&&v<=max; 
	}
	,
	/**
	 * 获取元素的验证失败提示
	 * @param {} element
	 * @param {} vType
	 * @return {}
	 */
	getErrMsg:function(element,vType,i,params){
		if(!params) params={};
		if(!params.name){
			params.name=this.getDisplayName(element);
		}
		var errmsg=element.getAttribute('vMsg');
		if(errmsg) errmsg=errmsg.split(',')[i];
		var fmsg;
		if(errmsg&&errmsg!='') 
			fmsg=errmsg;
		else
			fmsg=this.failMsgs[vType];
		if(!fmsg) fmsg=this.defaultMsg;
		fmsg=fmsg.replace(/\{(\w+)\}/g,function($0,$1){
			if(params[$1]) return params[$1];
		    else return '';
		});
		return fmsg;
	},
	getCheckedCount:function(e){
		var form=e.form;
		var es=form[e.name];
		var n=0;
		for(var i=0;i<es.length;i++)
			if(es[i].checked) n++;
		return n;
	},
	getDisplayName:function(e){
		var name=e.getAttribute('vName');
		if(!name&&e.form.getMsgName) name=e.form.getMsgName(e);
		if(!name) name=this.defaultGetMsgName(e);
		return name;
	},
	defaultcallback:function(errors){
		if(errors.length>0){
			Ext.MessageBox.alert('提示',errors[0].message,function(){
				try{
					errors[0].element.focus();
				}
				catch(e){
				}
			});
		}
	},
	defaultGetMsgName:function(e){
		return e.name?e.name:e.id;
	}
}

Huateng.Util.Form={
	//清空表单
	formClear : function(formId){
		var form;
		if(formId&&formId.tagName=='FORM')
		   form=formId;
		 else
		   form =document.getElementById(formId);
		//取得所有表单元素
		var es = form.elements;
		for(var i=0;i<es.length;i++){
			var e=es[i];
			if(e.type=='checkbox'||e.type=='radio'){
			   e.checked=false;	
			}
			else if(e.type=='select-one'){
				e.selectedIndex=0;
			}
			else if(e.type=="file"){
				if(e.value){
					var ne=e.cloneNode(false);
					e.parentNode.replaceChild(ne,e);
				}
			}
			else if(e.type!='button'&&e.type!='reset'&&e.type!='submit'){
				e.value='';
			}
		}
	},
	//填充表单
	formFill:function(formId,data){
		var form;
		if(formId&&formId.tagName=='FORM')
		   form=formId;
		else
		   form =document.getElementById(formId);
		for(var p in data){	
			var el=form[p];
			if(!el||el[0]&&!el[0].tagName||!el[0]&&!el.tagName){
//				el=document.getElementById(p);
//				if(!el||el.form!=form)
				continue;
			}
			var d=data[p];
			if(el.length&&!el.type){//checkbox和radio
				var vs=[];
				if(el[0].type=='radio') 
					vs.push(d);
				else if(typeof d=='string') 
					vs=d.split(',');
				else if(d instanceof Array) vs=d;
				else vs.push(d);
				if(el[0].type=='radio'||el[0].type=='checkbox'){
					for(var i=0;i<vs.length;i++)
					  for(var j=0;j<el.length;j++)
							if(el[j].value==vs[i]) el[j].checked=true;
				}
				else{
					var n=vs.length<el.length?vs.length:el.length;
					for(var i=0;i<n;i++) el[i].value=vs[i];
				}
			}
			else{
				if(el.type=='checkbox'||el.type=='radio'){
					if(el.value==d) el.checked=true;
					else if(d) el.checked=false;
				}
				else{
					if(!d||d=='null') el.value='';
					else el.value=d;
				}
			}
		}
	},
	readOnly:function(formId){
		var form;
		if(formId&&formId.tagName=='FORM')
		   form=formId;
		else
		   form =document.getElementById(formId);
		var es = form.elements;
		for(var i=0;i<es.length;i++){
			var e=es[i];
			if(e.type=='checkbox'||e.type=='radio'||e.tagName=='SELECT'){
				if(e.disable)
					e.__dis=true;
				else
					e.disabled=true;
			}
			else {
				if(e.readOnly)
					e.__ro=true;
				else
					e.readOnly=true;
			}
		}
	},
	editable:function(formId){
		var form;
		if(formId&&formId.tagName=='FORM')
		   form=formId;
		else
		   form =document.getElementById(formId);
		var es = form.elements;
		for(var i=0;i<es.length;i++){
			var e=es[i];
			if(e.type=='checkbox'||e.type=='radio'||e.tagName=='SELECT'){
				if(!e.__dis)
					e.disabled=false;
			}
			else {
				if(!e.__ro)
					e.readOnly=false;
			}
		}
	}
}