Ext.ns("Huateng.Util");
Ext.ns("Huateng.Select");

/**
 * 
 * @class Huateng.Util.Select
 * @extends Ext.Window
 * 
 */
Huateng.Select=Ext.extend(Ext.Window,{
	width:500,
	height:400,
	minWidth:300,
	closeAction:'hide',
	modal:true,
	constrainHeader:true,
	title:'通用选择框',
	showType:true,
	typeTitle:'选择类型',
	iconCls: 'icon10',
	plain:true, 
	activeIndex:0,
	isSingle:false,
	layout:'hbox',
	layoutConfig:{
		align:'stretch'
	},
	selectDefaults:{
		showAction:'reload'
	},
	initComponent:function(){
		if(!this.tbar) this.tbar=[];
		Huateng.Select.superclass.initComponent.call(this);
        this.addEvents(
        	'selectchange'
        );
		this.initButtons();
		this.initResult();
        this.initSelects();
	},
	initButtons:function(){
		this.addButton('确定',this.ok,this);
		this.addButton('取消',this.cancel,this);
		this.commButtons=[{
			text:'添加',
			handler:this.addItem,
			scope:this
		},{
			text:'移除',
			handler:this.removeItem,
			scope:this
		},{
			text:'全添',
			handler:this.addAllItem,
			scope:this
		},{
			text:'全删',
			handler:this.removeAllItem,
			scope:this
		}]
	},
	dblclickHandler:function(node,e){
		if(!node.getOwnerTree().isLeafOnly||node.isLeaf()){
			if(node.getUI().checkbox){
				node.getUI().checkbox.checked=true;
				node.attributes.checked=true;
			}
			var at=Ext.apply({},node.attributes);
 			delete at.loader;
			this.addResult(at);
		}
	},
	initResult:function(){
		var result=this.result||{};
		if(Ext.isArray(result)) result={data:result};
		if(result.multiple==null) result.multiple=true;
		if(!Ext.isDefined(result.showAction)) result.showAction='removeAll';
		result.flex=1;
		delete this.result;
		this.resultSelect=new Huateng.Select.HtmlSelect(result);
		//this.resultSelect.on("dbclick");
	},
	initSelects:function(){
		var types=[];
        if(this.selects&&this.selects.length>0){
			for(var i=0,len=this.selects.length;i<len;i++){
				var si=this.selects[i];
				Ext.applyIf(si,this.selectDefaults);
				var label=si.name||'选择'+i;
				types.push({
					xtype:'radio',
					boxLabel:label,
					inputValue:i,
					name:this.id+'_r',
					style:'margin-left:8px',
					listeners:{check:{fn:this.radioCheck,scope:this}}
				});
				if(si.type=='select'){
					this.selects[i]=this.initSel(si);
				}
				else if(si.type=='tree'){
					this.selects[i]=this.initTree(si);
				}
			}
			this.activeSelect=this.selects[this.activeIndex];
        }
        if(types.length>0){
        	types[this.activeIndex].checked=true;
        	this.topToolbar.add(types);
        }
        this.topToolbar.setVisible(this.showType);
        if(this.showType&&types.length<2){
        	this.topToolbar.setVisible(false);
        }
	},
	initSel:function(si){
		return new Huateng.Select.HtmlSelect(Ext.applyIf(si,{multiple:!this.isSingle}));
	},
	initTree:function(si){
		var ts=new Huateng.Select.TreeSelect(Ext.applyIf(si,{isSingle:this.isSingle}));
		ts.on("dblclick",this.dblclickHandler,this);
		return ts;
	},
	//private 类型选择处理时间
	radioCheck:function(r,checked){
		if(!checked) return;
		this.activeIndex=r.getRawValue();
		this.activeSelect=this.selects[this.activeIndex];
		this.selectsCt.layout.setActiveItem(this.activeSelect);
	},
	onRender:function(ct, position)
	{
		Huateng.Select.superclass.onRender.call(this,ct, position); 
		this.selectsCt=new Ext.Container({
			layout:'card',
			layoutConfig:{
				deferredRender:true
			},
			activeItem:this.activeIndex,
			items:this.selects,
			flex:1
		});
		this.add(this.selectsCt);
		this.add({
			xtype:'container',
			width:65,
			layout:'vbox',
			layoutConfig:{
				pack:'center',
				align:'center',
				defaultMargins:"10 0 0 0"
			},
			defaults:{
				width:60,
				xtype:'button'
			},
			items:this.commButtons
		});
		this.add(this.resultSelect);
	},
	show:function(animateTarget, cb, scope){
		var rendered=this.rendered;
		Huateng.Select.superclass.show.call(this,animateTarget, cb, scope);
		var vs = this.container.getViewSize(false);
		var width=this.width>vs.width?vs.width:this.width;
		var height=this.height>vs.height?vs.height:this.height;
        this.setSize(width,height);
        this.center();
        if(rendered){
        	var len=this.selects.length;
        	for(var i=0;i<len;i++){
        		var select=this.selects[i];
        		if(select.showAction&&typeof select[select.showAction=='function']){
        			select[select.showAction]();
        		}
        	}
        	if(this.resultSelect.showAction&&typeof this.resultSelect[this.resultSelect.showAction=='function']){
        		this.resultSelect[this.resultSelect.showAction]();
        	}
        }
	},
	setActiveSelect:function(index){
		if(index>=this.selects.length||index<0) return;
		if(this.rendered){
			this.topToolbar.items.items[index].setValue(true);
		}
		else{
			this.activeIndex=index;
		}
	},
	addItem:function(){
		if(this.activeSelect){
			var items=this.activeSelect.getSelecteds();
			this.addResult(items,this.activeSelect.mapping);
		}
	},
	removeItem:function(){
		if(this.resultSelect)
			this.resultSelect.removeSelecteds();
	},
	addAllItem:function(){
		var items=this.activeSelect.getAll();
		this.addResult(items,this.activeSelect.mapping);
	},
	removeAllItem:function(){
		this.resultSelect.removeAll();
	},
	addResult:function(items,mapping){
		if(this.isSingle){
			if(Ext.isArray(items)&&items.length>0){
				items=items[0];
			}
			if(items){
				this.resultSelect.removeAll();
			}
		}
		this.resultSelect.add(items,mapping);
	},
	ok:function(){
		var data=this.resultSelect.getAll();
		this[this.closeAction]();
		if(typeof this.callback=='function') this.callback.call(this.scope||window,data);
	},
	cancel:function(){
		this[this.closeAction]();
	},
	getResults:function(){
		return this.resultSelect.getAll();
	},
	updateResult:function(){
		
	}
});


Huateng.Select.HtmlSelect=Ext.extend(Ext.BoxComponent,{
	multiple:false,//是否多选
	name:'',
	autoLoad:true,
	itemUnique:false,
	initComponent:function(){
		Huateng.Select.HtmlSelect.superclass.initComponent.call(this);
		this.addEvents(
			'add',
			'insert',
			'change',
			'click',
			'dblclikc'
		);
		this.mapping=Ext.apply({},this.mapping,{text:'text',value:'id'});
		this.tpl='<select id="{id}" name="{name}" size="2" style="width:100%;height:100%"></select>';
		this.items=new Ext.util.MixedCollection(false,function(o){
			return o.data[o.mapping.value];
		});
		if(this.data){
			this.add(this.data,true);
			delete this.data;
		}
	},
	onRender:function(container, position){
		Huateng.Select.HtmlSelect.superclass.onRender.call(this,container,position);
		var sid='sel'+(++Ext.Component.AUTO_ID);
		var data={
			id:sid,
			name:this.name
		};
		if (!this.tpl.compile)
            this.tpl = new Ext.Template(this.tpl);
        this.tpl.overwrite(this.el,data);
        this.select=Ext.getDom(sid);
        this.select.multiple=this.multiple;
        var sel=Ext.fly(this.select);
        sel.on("change",this.onChange,this);
        sel.on("click",this.onClick,this);
        sel.on("dblclick",this.onDblclick,this);
        this.refurbish();
        if(this.autoLoad&&this.dataUrl) this.load();
	},
	load:function(cfg){
		cfg=cfg||{};
		Ext.applyIf(cfg,{dataUrl:this.dataUrl,dataParams:this.dataParams});
		Ext.Ajax.request({
			url:cfg.dataUrl,
			params:cfg.dataParams,
			success:this.loadSuccessHandler,
			scope:this
		});
	},
	reload:function(){
		if(this.dataUrl){
			this.removeAll();
			this.load();
		}
	},
	loadSuccessHandler:function(rep){
		var data=Ext.decode(rep.responseText);
		this.add(data);
	},
	onChange:function(e,t){
		this.fireEvent('change',this,e);
	},
	onClick:function(e,t){
		this.fireEvent('click',this,e);	
	},
	onDblclick:function(e,t){
		this.fireEvent('dblclick',this,e);	
	},
	add:function(item,mapping,suppressEvent){
		if(Ext.isBoolean(mapping)){
			suppressEvent=mapping;
		}
		if(!Ext.isObject(mapping)){
			mapping=this.mapping;
		}
		if(Ext.isArray(item)){
			for(var i=0;i<item.length;i++){
				this.doAdd(item[i],mapping,suppressEvent);
			}
		}
		else{
			this.doAdd(item,mapping,suppressEvent);
		}
	},
	doAdd:function(item,mapping,suppressEvent){
		var id=item[this.mapping.value];
		var mi={mapping:mapping,data:item};
		if(!this.items.containsKey(id)){
			this.items.add(mi);
			if(this.rendered){
				var option=this.addOption(mi)		
			}
			if(suppressEvent!==true)
				this.fireEvent('add',this,item,mapping);
		}
	},
	refurbish:function(){
		if(this.rendered){
			this.select.innerHTML='';
			this.items.each(function(item){
				this.addOption(item);
			},this)
		}
	},
	getItemCount:function(){
		return this.items.getCount();
	},
	insert:function(item,index){
	},
	setMultiple:function(mu){
		this.multiple=!!mu;
		if(this.rendered){
			this.select.multiple=this.multiple;
		}
	},
	getSelectedIndex:function(){
		return this.select.selectedIndex;
	},
	getSelecteds:function(){
		var items=[];
		if(false==this.multiple){
			var index=this.getSelectedIndex();
			if(index>=0){
				items.push(this.items.itemAt(index).data);
			}
		}
		else{
			for(var i=0;i<this.select.length;i++){
				var op=this.select.options[i];
				if(op.selected===true){
					items.push(this.items.itemAt(i).data);
				}
			}
		}
		return items;
	},
	getAll:function(){
		var items=this.items.getRange();
		var data=[];
		for(var i=0;i<items.length;i++){
			data.push(items[i].data);
		}
		return data;
	},
	getRange:function(startIndex,endIndex){
		var items=this.items.getRange(startIndex,endIndex);
		var data=[];
		for(var i=0;i<items.length;i++){
			data.push(items[i].data);
		}
		return data;
	},
	removeSelecteds:function(){
		var items=[];
		if(this.multiple=false){
			var index=this.getSelectedIndex();
			if(index>=0){
				items.push[this.removeAt(index)];
			}
		}
		else{
			for(var i=this.select.length-1;i>=0;i--){
				var op=this.select.options[i];
				if(op.selected===true){
					items.push(this.removeAt(i));
				}
			}
		}
		return items;
	},
	removeAt:function(index){
			if(index>=this.getItemCount()) return null;
			this.select.remove(index);
			return this.items.removeAt(index);
	},
	removeAll:function(){
		var items=this.getAll();
		this.items.clear();
		if(this.rendered) this.select.innerHTML='';
		return items;
	},
	//private
	addOption:function(item){
		var option=document.createElement('option');
		option.text=item.data[item.mapping.text];
		option.value=item.data[item.mapping.value];
		try{
			this.select.add(option,null);
		}
		catch(e){
			this.select.add(option);
		}
		return option;
	}
})

Huateng.Select.TreeSelect=Ext.extend(Ext.tree.TreePanel,{
	rootId:'#',
	checkMode:'ccs',
	isLeafOnly:false,
	showReload:true,
	autoScroll:true,
    rootVisible: false,
	initComponent:function(){
		this.mapping=Ext.apply({},this.mapping,{text:'text',value:'id'});
		if(!this.loader&&this.dataUrl){
			this.loader=new Ext.tree.TreeLoader({
		 		dataUrl:this.dataUrl,
		 		baseParams:this.dataParams,
		 		baseAttrs:{
		 			checked:false
		 		}
			});
		}
		if(!this.root){
			this.root ={
				id:this.rootId,
				expanded: false,
				checked:false
			};
		}
		Huateng.Select.TreeSelect.superclass.initComponent.call(this);
		this.on('checkchange',this.checkChangeHandler,this);
	},
	reload:function(){
		if(!this.rendered) return;
		var root=this.getRootNode();
		if(root.reload) root.reload();
	},
	checkChangeHandler:function(node,checked){
		if(this.isSingle&&checked){
			var checks=node.getOwnerTree().getChecked();
			for(var i=0;i<checks.length;i++)
				if(checks[i]!=node){
					checks[i].getUI().checkbox.checked=false;
					checks[i].getUI().onCheckChange();
				}
			return;
		}
		if(!node.isLeaf()&&(this.checkMode=='cs'||this.checkMode=='ccs')){
	   		node.expand(false,true,function(nd){ 
				nd.eachChild(function(cnd){
					cnd.getUI().checkbox.checked=checked;
					cnd.getUI().onCheckChange();
			  	});  	 
			});
		}
		if(checked&&(this.checkMode=='cs'||this.checkMode=='pcs')){
			var pn=node;
			while(1){
				pn=pn.parentNode;
				if(pn&&pn.attributes.checked==false&&(this.rootVisible||pn!=pn.getOwnerTree().root)){
					pn.getUI().checkbox.checked=true;
					pn.attributes.checked=true;
				}
				else break;
			}
		}
	},
	getSelecteds:function(){
		var re=[];
 		var cs=this.getChecked();
 		for(var i=0,n=cs.length;i<n;i++){
 			if(this.isLeafOnly&&!cs[i].isLeaf()) continue;
 			 var at=Ext.apply({},cs[i].attributes);
 			 delete at.loader;
 			 re.push(at);
 		}
 		return re;
	},
	getAll:function(){
		return this.getSelecteds();
	}
})

//var win;
//Ext.onReady(function(){
// win=new Huateng.Select({
// 	selects:[{
// 		name:'s1', 
// 		type:'tree', //类型
// 		dataUrl:'DictAction!getDictList.action', //数据来源
// 		checkMode:'ccs',         //选择框关联模式 : ccs父关联子  ， pcs子关联父 ， cs双向关联
// 		isLeafOnly:true
/* 		name:'ssasdsad',
 		type:'select',
 		data:[{id:'1',text:'sdf'},{id:'2',text:'sdfas'}]
 		//dataUrl:'DictAction!getDictList.action'
 	},{
 		name:'asd',
 		type:'tree',
 		mapping:{id:'value',text:'text'},
 		checkMode:'pcs',
 		dataUrl:'DictAction!getDictList.action'
 		//data:[{value:'3',text:'sasdsdf'},{value:'4',text:'sdfasdas'}] 		
 	}
 ],
  result:{
 	 	data:[{id:"r1",name:"aa",type:1},{id:"r2",name:"bb",type:2}],
 	 	mapping:{text:'name'}
  }, //结果数据
  //isSingle:true,  //是否单选
  callback:function(data){  //确定回调 
    	if(data){
		    alert(Ext.encode(data));
    	}
   }
 });
win.show();
});*/
