Ext.ns("Huateng.Util");

/**
 * 
 * @class Huateng.Util.Select
 * @extends Ext.Window
 * 
 */
Huateng.Util.Select=Ext.extend(Ext.Window,{
	width:500,
	height:400,
	minWidth:300,
	closeAction:'hide',
	modal:true,
	title:'通用选择框',
	showType:false,
	typeTitle:'选择类型',
	iconCls: 'icon10',
	plain:true, 
	currSelIndex:0,
	isSingle:false,
	defalutMap:{text:'name',value:'id'},
	commButtons:[{
		text:'添加',
		handler:function(){this.ownerCt.add()}
	},{
		text:'移除',
		handler:function(){this.ownerCt.del()}
	},{
		text:'全添',
		handler:function(){this.ownerCt.addAll()}
	},{
		text:'全删',
		handler:function(){this.ownerCt.delAll()}
	}],
	initComponent:function(){
		Huateng.Util.Select.superclass.initComponent.call(this);
		this.addButton('确定',function(){ this.ok();},this);
		this.addButton('取消',function(){ this.cancel();},this);
		this.ininCommButtons();
        this.initSelects();
        this.vMap=Ext.apply({},this.resultMap,this.defalutMap);
	},
	initResult:function(){
		this.result={};
		if(!this.dataItems) return;
		var data=this.dataItems;
		if(typeof this.dataItems=='string'){
			data=eval('('+this.dataItems+')');
		}
		if(data.length>0){
			for(var i=0,n=data.length;i<n;i++)
			  if(!this.result.hasOwnProperty(data[i][this.vMap.value])){
			  	  var ro={text:data[i][this.vMap.text],attributes:data[i]};
			  	  this.result[data[i][this.vMap.value]]=ro;
			  	  if(this.isSingle) break;
			  }
		}
		//this.dataItems=null;
	},
	ininCommButtons:function(){
		 if(this.commButtons){
            var btns = this.commButtons;
            this.commButtons = [];
            for(var i = 0, len = btns.length; i < len; i++) {
                if(btns[i].render){ // button instance
                    this.commButtons.push(btns[i]);
                }else{
                    this.addCommButton(btns[i]);
                }
            }
        }
	},
	deaultSelRead:function(all){
        var re=[];
       	for(var i=0;i<this.select.length;){
		    var opt=this.select.options[i];
		    if(all||opt.selected){ 
		    	var at=Ext.apply({},opt._attributes);
				re.push({text:opt.text,value:opt.value,attributes:at});
				//this.select.remove(i); 
				i++;
				if(this.isSingle) break;
			}
			else{
			 	i++;
			}
		}
	 	return re;
     },
    defaultSelWrite:function(data){
    	var n=0;
		if(data&&data.length>0)
			for(i=0;i<data.length;i++){
				var op=document.createElement('option');
				op.text=data[i][this.map.text];
				op.value=data[i][this.map.value];
				op._attributes=data[i];
				try{
					this.select.add(op,null);	
				}
				catch(ex){
					this.select.add(op);
				}
				n++;
			}
		return n;		
    },
	initSel:function(si){
		if(!si.map) si.map={};
		Ext.applyIf(si.map,this.defalutMap);
		if(typeof si.read!='function') si.read=this.deaultSelRead;
		if(typeof si.write!='function') si.write=this.defaultSelWrite;
	},
	//scope select
	checkChangeHandler:function(node,checked){
		if(this.tree.ownerCt.isSingle&&checked){
			var checks=node.getOwnerTree().getChecked();
			for(var i=0;i<checks.length;i++)
				if(checks[i]!=node){
					checks[i].getUI().checkbox.checked=false;
					checks[i].getUI().onCheckChange();
				}
			return;
		}
		if(!node.isLeaf()&&(this.checkMode=='cs'||this.checkMode=='ccs')){
	   		node.expand(false,true,function(nd){ 
				nd.eachChild(function(cnd){
					cnd.getUI().checkbox.checked=checked;
					cnd.getUI().onCheckChange();
			  	});  	 
			});
		}
		if(checked&&(this.checkMode=='cs'||this.checkMode=='pcs')){
			if(node.parentNode&&!node.parentNode.attributes.checked){
				node.parentNode.getUI().checkbox.checked=true;
				node.parentNode.attributes.checked=true;
			}
		}
	},
	dblclickHandler:function(node,e){
		if(node.getUI().checkbox){
            var checked=node.getUI().checkbox.checked;
            /*if(!node.isLeaf()){
				node.getUI().checkbox.checked=!checked;
				node.parentNode.attributes.checked=!checked;
            }*/
            if(checked){
            	if(!this.isLeafOnly||node.isLeaf())
				  this.tree.ownerCt.resultAdd([{text:node.text,value:node.id,attributes:node.attributes}]);
            }
		}
	},
	defaultTreeRead:function(all){
		var re=[];
 		var cs=this.tree.getChecked();
 		for(var i=0,n=cs.length;i<n;i++){
 			if(this.isLeafOnly&&!cs[i].isLeaf()) continue;
 			 var at=Ext.apply({},cs[i].attributes);
 			 delete at.loader;
 			 re.push({text:cs[i].text,value:cs[i].id,attributes:at});
 		}
 		return re;
	},
	initTree:function(si){
		if(si.tree) return;	
		if(!si.loader&&si.dataUrl){
			si.loader=new Ext.tree.TreeLoader({
		 		dataUrl:si.dataUrl,
		 		baseParams:si.dataParams,
		 		baseAttrs:{
		 			checked:false
		 		}
			});
		}
		if(si.loader){
			var root = new Ext.tree.AsyncTreeNode({
					id:si.rootId,
					expanded: false,
					loader: si.loader,
					checked:false
				});
			si.tree=new Ext.tree.TreePanel({
				    root:root,
				    autoScroll:true,
				    rootVisible: false
				});
			si.tree.ownerCt=this; 
			si.tree.on('checkchange',this.checkChangeHandler,si);
			si.tree.on('dblclick',this.dblclickHandler,si);
		}
	}
	,
	initSelects:function(){
        if(this.selects&&this.selects.length>0)
        {
        	var treeDefault={rootId:'#',checkMode:'ccs',read:this.defaultTreeRead,isLeafOnly:false,showReload:true};
			for(var i=0,len=this.selects.length;i<len;i++){
				var si=this.selects[i];
				Ext.applyIf(si,this.selectBaseAttrs);
				if(si.type=='select'){
					this.initSel(si);
				}
				else if(si.type=='tree'){
					Ext.applyIf(si,treeDefault);
					this.initTree(si);
				}
				if(!si.write) si.write=function(){};
				
			}
			if(this.selects.length>0) this.currSelect=this.selects[this.currSelIndex];
        }
	},
	addCommButton : function(config, handler, scope){
        var bc = {
            handler: handler,
            scope: scope,
            minWidth: this.minButtonWidth,
            hideParent:true
        };
        if(typeof config == "string"){
            bc.text = config;
        }else{
            Ext.apply(bc, config);
        }
        var btn = new Ext.Button(bc);
        btn.ownerCt = this;
        if(!this.commButtons){
            this.commButtons = [];
        }
        this.commButtons.push(btn);
        return btn;
    },
	onRender:function(ct, position)
	{
		Huateng.Util.Select.superclass.onRender.call(this,ct, position);
		var ttc='<table  cellpadding="0" cellspacing="0" style="width:100%;height:100%"><tbody><tr><td height="80px" ></td></tr><tr><td style="width:100%;height:100%"><td></tr></tbody></table>';
		var tt=this.body.createChild({html:ttc});
		tt.applyStyles('width:100%;height:100%');
		var tb=tt.dom.firstChild.firstChild;
		this.selectContent=Ext.get(tb.lastChild.firstChild);
		this.typeContent=Ext.get(tb.firstChild.firstChild);
		this.typeContent.setVisibilityMode(Ext.Element.DISPLAY);
		if(!this.showType) this.typeContent.setVisible(false); 
		var sctt='<tr><td width="40%" height="100%"></td><td width="15%" height="100%"></td><td width="40%" height="100%"></td><td width="5%" height="100%"></td></tr>';
		var sct=this.selectContent.createChild({html:'<table  border="0" style="width:100%;height:100%"><tbody>'+sctt+'</tbody></table>'})
		sct.applyStyles('width:100%;height:100%');
		var sttr=sct.dom.firstChild.firstChild.firstChild;
		this.sc1=Ext.get(sttr.childNodes[0]);
		if(this.currSelect&&this.currSelect.type=='select'){
			var htmlstr='<select ';
			if(!this.isSingle) htmlstr+='multiple="multiple" ';
			else htmlstr+='size="10" '
			htmlstr+='style="width:100%;height:100%"></sclect>';
			var ss=this.sc1.createChild({html:htmlstr});
			ss.applyStyles('width:100%;height:100%');
			this.currSelect.select=ss.dom.firstChild;
			Ext.get(this.currSelect.select).on('dblclick',this.add,this);
		}
		else if(this.currSelect&&this.currSelect.tree&&this.currSelect.type=='tree'){
			this.currSelect.tree.render(this.sc1);
			this.currSelect.tree.bwrap.parent().setStyle("height","100%");
			this.currSelect.tree.bwrap.setStyle("height","100%");
			this.currSelect.tree.body.setStyle("height","100%");
		}
		this.sc2=Ext.get(sttr.childNodes[1]);		
		this.sc3=Ext.get(sttr.childNodes[2]);
		this.sc4=Ext.get(sttr.childNodes[3]);
		if(this.commButtons && this.commButtons.length > 0){
		 	var ul=this.sc2.createChild({html:'<ul></ul>'},null,true).firstChild;
		 	for(var ii=0;ii<this.commButtons.length;ii++){
		 		var b = this.commButtons[ii];
		 		var li=document.createElement('li');
		 		li.style.cssText="margin-top:10px";
		 		b.render(ul.appendChild(li));
		 	}
		 }
		var sc3d=this.sc3.createChild({html:'<select multiple="true" style="width:100%;height:100%"></sclect>'});
		sc3d.applyStyles('width:100%;height:100%');
		this.resultSelect=sc3d.dom.firstChild;
		Ext.get(this.resultSelect).on('dblclick',this.del,this);	
	},
	show:function(animateTarget, cb, scope){
		Huateng.Util.Select.superclass.show.call(this,animateTarget, cb, scope);
		var vs = this.container.getViewSize(false);
		var width=this.width>vs.width?vs.width:this.width;
        var height=this.height>vs.height?vs.height:this.height;
        this.setSize(width,height);
        this.center();
		this.initResult();
		this.updateResult();
		if(this.currSelect){
		   if(this.currSelect.type=='tree'&&this.currSelect.showReload){
				this.currSelect.tree.root.reload();
		   }
		   else if(this.currSelect.type=='select'&&this.currSelect.dataUrl){
		   	    this.currSelect.select.innerHTML=null;
		   	    Ext.Ajax.request({
		   	    	url:this.currSelect.dataUrl,
		   	    	params:this.currSelect.dataParams,
		   	    	success:function(response){
		   	    	    this.write(eval('('+response.responseText+')'));
		   	    	},
		   	       scope:this.currSelect
		   	    });
		   }
		   else if(this.currSelect.data){
				this.currSelect.write(this.currSelect.data);
		   }
		}
	},
	add:function(){
		if(this.currSelect)
		  this.resultAdd(this.currSelect.read());
	},
	del:function(){
		/*if(this.currSelect)
			this.currSelect.write(this.resultRemove());*/
		this.resultRemove();
	},
	addAll:function(){
		this.resultAdd(this.currSelect.read(true));
	},
	delAll:function(){
		//this.currSelect.write(this.resultRemove(true));
		this.resultRemove(true);
	},
	ok:function(){
		var data=[];
		for(var pt in this.result){
			var item={};
			for(var k in this.result[pt].attributes){
				item[k]=this.result[pt].attributes[k]
			}
			item[this.vMap.value]=pt;
			item[this.vMap.text]=this.result[pt].text;
			data.push(item);
		}
		this[this.closeAction]();
		if(typeof this.callback=='function') this.callback.call(this.scope||window,data);
	},
	cancel:function(){
		this[this.closeAction]();
	},
	updateResult:function()
	{
		this.resultSelect.innerHTML=null;
		for(var it in this.result){
			var op=document.createElement('option');
			op.text=this.result[it].text;
			op.value=it;
			try{
			  this.resultSelect.add(op,null);	
			}
			catch(ex){
				this.resultSelect.add(op);
			}
		}
	},
	resultAdd:function(data){
		var n=0;

		if(data&&data.length>0){
			for(i=0;i<data.length;i++){
				if(!this.result.hasOwnProperty(data[i].value))
				{
					if(this.isSingle){
						this.resultSelect.innerHTML=null;
						this.result={};
					}
					var ro={text:data[i].text,attributes:data[i].attributes};
					this.result[data[i].value]=ro;
					var op=document.createElement('option');
					op.text=data[i].text;
					op.value=data[i].value;
					try{
					  this.resultSelect.add(op,null);	
					}
					catch(ex){
						this.resultSelect.add(op);
					}
					if(this.isSingle) break;
					n++;
				}
			}
		}
		return n;
	},
	resultRemove:function(all){
	   var re=[];
       for(var i=0;i<this.resultSelect.length;){
       	 var opt=this.resultSelect.options[i];
       	 if(all||opt.selected){ 
       	 	if(this.result.hasOwnProperty(opt.value)){
       	 		re.push({text:opt.text,value:opt.value});
       	 		delete this.result[opt.value];
       	 	}
       	 	this.resultSelect.remove(i);    	 	
       	 }
       	 else{
       	 	i++;
       	 }
       }
       return re;
	}
});
/*Ext.onReady(function(){
 var tt=new Huateng.Util.Select({
 	selects:[{
 		name:'s1', 
 		type:'tree', //类型
 		dataUrl:'DictAction!getDictList.action', //数据来源
 		checkMode:'ccs',         //选择框关联模式 : ccs父关联子  ， pcs子关联父 ， cs双向关联
 		isLeafOnly:true
 		//name:'ss',
 		//type:'select',
 		//map:{value:'value',text:'text'},
 		//data:[{value:'1',text:'sdf'},{value:'22',text:'sdfas'}]
 		//dataUrl:'DictAction!getDictList.action'
 	}],
 	dataItems:'[{id:"1",name:"aa",type:1},{id:"2",name:"bb",type:2}]', //结果数据
 	//isSingle:true,  //是否单选
    callback:function(data){  //确定回调 
    	if(data){
    		var s="";
		    for(var i=0;i<data.length;i++){ 
		    	s+='{';
		    	for(var k in data[i]){
		    		s+=k+":"+data[i][k]+",";
		    	}
		    	s+='}\n';
		    }
		    alert(s);
    	}
    }
 });
 Ext.get("aaa").on("click",function(){tt.show();});
});*/
