<%@page contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="s" uri="/struts-tags"%>
<%@ taglib prefix="h" uri="/platform_taglib" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<html>
<head>
	<%@include file="../../system/jquerySession.jsp"%> 
	<title><%=global_title %></title>
	<script type="text/javascript" src="<%=htSystemPath%>js/common/form.js"></script>
	<script type="text/javascript" src="<%=htSystemPath%>js/util/formJs2.js"></script>
</head>
<body>  
${buttons }  
<div id="fbody">
	<form>
		<table cellspacing="0" class="ftable" cellpadding="0" border="0" width="100%">
			<tr><td class="tdTitle" colspan="2">收款分配</td></tr>
			<tr>
				<td class="tdLabelTitle" width="20%">案件名称：</td>
				<td class="tdLabelContent">${model.caseName}&nbsp;</td>
			</tr>
			<tr>
				<td class="tdLabelTitle">案件编号：</td>
				<td class="tdLabelContent">${model.caseCode}&nbsp;</td>
			</tr>
			<tr>
				<td class="tdLabelTitle">客户名称：</td>
				<td class="tdLabelContent">${model.cusName}&nbsp;</td>
			</tr>
			<tr><td class="tdTitle" colspan="2">
				律师信息&nbsp;&nbsp;&nbsp;&nbsp;
				总额：${payment.alreadyMoney }&nbsp;&nbsp;&nbsp;&nbsp;
				已分配金额：${model.distributeMoney }
			</td></tr>
			<tr>
				<td class="tdLabelContent" colspan="2" valign="top" align="center" style="height:80px;">
					<table cellspacing='0' class='utable' cellpadding='0' border='0'>
						<tr>
							<th width='5%'>&nbsp;</th>
							<th width='25%'>律师</th>
							<th width='30%'>职务</th>
							<th width='20%'>金额分配</th>
							<th width='20%'>分配比例</th>
						</tr>
						<s:iterator status="no" value="#request.lawCase.lawRelatedLawyers" var="lawyer">
						<tr>
							<td>${no.count}<input type="hidden" name="relatedLawyerId" value="${lawyer.relatedLawyerId }" /></td>
							<td>${lawyer.lawyerName }&nbsp;</td>
							<td>${lawyer.lawyerPost}&nbsp;</td>
							<td>${lawyer.distributeMoney}&nbsp;</td>
							<td><fmt:formatNumber type="number" value="${(lawyer.distributeMoney/payment.alreadyMoney)*100}" maxFractionDigits="2"/> %</td>
						</tr>
						</s:iterator>
					</table>
				</td>
			</tr>
			<tr><td class="tdTitle" colspan="2">收款信息</td></tr>
			<tr>
				<td class="tdLabelContent" colspan="2" valign="top" align="center" style="height:80px;">
					<table cellspacing='0' id='t-billing' class='utable' cellpadding='0' border='0'>
						<tr>
							<th width='5%'><span class='icon311'>&nbsp;&nbsp;&nbsp;&nbsp;</span></th>
							<th width='10%'>费用类别</th>
							<th width='10%'>收款金额（元）</th>
							<th width='10%'>支付方式</th>
							<th width='10%'>凭证号</th>
							<th width='10%'>收款日期</th>
							<th width='14%'>备注</th>
							<th width='6%'>记录人</th>
							<th width='10%'>发票是否已开</th>
							<th width='5%'><span class='icon180'>&nbsp;&nbsp;&nbsp;&nbsp;</span></th>
						</tr>
						<s:iterator status="no" value="#request.payment.billingInfos" var="billing">
						<tr>
							<td>${no.count}</td>
							<td>${billing.billingCostType}&nbsp;</td>
							<td style="text-align:right;">${billing.billingMoney}&nbsp;</td>
							<td>${billing.billingPaymentMethod}&nbsp;</td>
							<td>${billing.billingCertNo}&nbsp;</td>
							<td>${billing.billingDate}&nbsp;</td>
							<td>${billing.billingRemarks}&nbsp;</td>
							<td>${billing.billingRecordPerson}&nbsp;</td>
							<td><input type="checkbox" ${billing.billingInvoice=="true"?'checked="checked"':""} /></td>
							<td><span class="icon310">&nbsp;&nbsp;&nbsp;&nbsp;</span></td>
						</tr>
						</s:iterator>
						<tr>
							<th width='15%' colspan="2" style="text-align:center;background:#fff;font-weight:bold;">合计</th>
							<th width='10%' style="text-align:right;background:#fff;border-right:none;color:blue;font-weight:normal;">
								${billingSum }&nbsp;
							</th>
							<th colspan="7" style="text-align:left;background:#fff;font-weight:bold;">
								&nbsp;
							</th>
						</tr>
					</table>
				</td>
			</tr>
			<tr><td class="tdTitle" colspan="2">退费信息</td></tr>
			<tr>
				<td class="tdLabelContent" colspan="2" valign="top" align="center" style="height:80px;">
					<table cellspacing='0' id='t-refund' class='utable' cellpadding='0' border='0'>
						<tr>
							<th width='5%'><span class='icon311'>&nbsp;&nbsp;&nbsp;&nbsp;</span></th>
							<th width='10%'>退款时间</th>
							<th width='10%'>退款金额（元）</th>
							<th width='10%'>支付方式</th>
							<th width='20%'>退款事由</th>
							<th width='10%'>收回发票号</th>
							<th width='10%'>补开发票号</th>
							<th width='10%'>记录人</th>
							<th width='5%'><span class='icon180'>&nbsp;&nbsp;&nbsp;&nbsp;</span></th>
						</tr>
						<s:iterator status="no" value="#request.payment.refundInfos" var="refund">
						<tr>
							<td>${no.count}</td>
							<td>${refund.refundDate }&nbsp;</td>
							<td style="text-align:right;">${refund.refundMoney }&nbsp;</td>
							<td>${refund.refundPaymentMethod}&nbsp;</td>
							<td>${refund.refundCause }&nbsp;</td>
							<td>${refund.refundInvoice }&nbsp;</td>
							<td>${refund.refundOpenInvoice }&nbsp;</td>
							<td>${refund.refundRecordPerson }&nbsp;</td>
							<td><span class='icon310'>&nbsp;&nbsp;&nbsp;&nbsp;</span></td>
						</tr>
						</s:iterator>
						<tr>
							<th width='15%' colspan="2" style="text-align:center;background:#fff;font-weight:bold;">合计</th>
							<th width='10%' style="text-align:right;background:#fff;border-right:none;color:blue;font-weight:normal;">
								${refundSum }&nbsp;
							</th>
							<th colspan="7" style="text-align:left;background:#fff;font-weight:bold;">
								&nbsp;
							</th>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</form>
</div>
</body>
</html>
