<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<%@page import="java.util.*,com.huateng.sys.pojo.SysDict" %>
<%@page contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="s" uri="/struts-tags"%>
<html>
<head>
	<%@include file="../../../system/jquerySession.jsp"%>
	<script type="text/javascript" src="<%=htSystemPath%>js/highchart/highcharts.js"></script>
	<title><%=global_title %></title>
	<%
		int first=0,second=0,third=0;
		List<Integer> applyList = (List<Integer>)request.getAttribute("applyList");
		List<Integer> handleList = (List<Integer>)request.getAttribute("handleList");
		List<Integer> closeList = (List<Integer>)request.getAttribute("closeList");
		
		List<Integer> subtotalList = (List<Integer>)request.getAttribute("subtotalList");
		List<Integer> totalList = (List<Integer>)request.getAttribute("totalList");
		Integer allTotal[] = (Integer[])request.getAttribute("allTotal");
		
		List<Integer> firstCols = (List<Integer>)request.getAttribute("firstCols");
		List<Integer> secondCols = (List<Integer>)request.getAttribute("secondCols");
		List<SysDict> firstDicts = (List<SysDict>)request.getAttribute("firstDicts");
		List<SysDict> secondDicts = (List<SysDict>)request.getAttribute("secondDicts");
		List<SysDict> thirdDicts = (List<SysDict>)request.getAttribute("thirdDicts");
		
		StringBuilder firstCategories = new StringBuilder();
		firstCategories.append("[");
		for(int i=0;i<firstDicts.size();i++){
			firstCategories.append("'").append(firstDicts.get(i).getName()).append("'");
			if(i<firstDicts.size()-1)
				firstCategories.append(",");
		}
		firstCategories.append("]");
		
		List<StringBuilder> secondCategories = new ArrayList<StringBuilder>();
		List<StringBuilder> secondCount = new ArrayList<StringBuilder>();
		String funId = secondDicts.get(0).getFunId();
		StringBuilder sec = new StringBuilder();
		StringBuilder bac = new StringBuilder();
		
		StringBuilder csec = new StringBuilder();
		StringBuilder cbac = new StringBuilder();
		bac.append("[");
		cbac.append("[");
		for(int i=0;i<secondDicts.size();i++){
			SysDict dict = secondDicts.get(i);
			if(!funId.equals(dict.getFunId())){
				sec.append(bac.deleteCharAt(bac.length()-1)).append("]");
				bac = new StringBuilder();
				bac.append("'").append(dict.getName()).append("',");
				secondCategories.add(sec);
				funId = dict.getFunId();
				sec = new StringBuilder();
				sec.append("[");
				
				csec.append(cbac.deleteCharAt(cbac.length()-1)).append("]");
				cbac = new StringBuilder();
				cbac.append(subtotalList.get(i)).append(",");
				secondCount.add(csec);
				csec = new StringBuilder();
				csec.append("[");
			}else{
				bac.append("'").append(dict.getName()).append("',");
				cbac.append(subtotalList.get(i)).append(",");
			}
		}
		secondCategories.add(sec.append(bac.deleteCharAt(bac.length()-1)).append("]"));
		secondCount.add(csec.append(cbac.deleteCharAt(cbac.length()-1)).append("]"));
	%>
	<script type="text/javascript">
		var chart;
		$(document).ready(function() {
			$("#container").height($(document.body).height()-100).width($(document.body).width()-100);
			var colors = Highcharts.getOptions().colors,
				categories = <%=firstCategories.toString()%>,
				name = '案件分类',
				data = [
				<%
					for(int i=0;i<firstDicts.size();i++){
				%>
						{ 
							y: <%=totalList.get(i)%>,
							color: colors[<%=i%>],
							drilldown: {
								name: '<%=firstDicts.get(i).getName()%>',
								categories: <%=secondCategories.get(i).toString()%>,
								data: <%=secondCount.get(i).toString()%>,
								color: colors[<%=i%>]
							}
						}
				<%
						if(i<firstDicts.size()-1) out.print(",");
					}
				%>
				];
			function setChart(name, categories, data, color) {
				chart.xAxis[0].setCategories(categories);
				chart.series[0].remove();
				chart.addSeries({
					name: name,
					data: data,
					color: color || 'white'
				});
			}
			chart = new Highcharts.Chart({
				chart: {
					renderTo: 'container', 
					type: 'column'
				},
				title: {
					text: '${startTime} 至 ${endTime} 个人业务分类统计图'
				},
				subtitle: {
					text: '点击查看二级分类. 再次点击返回一级分类.'
				},
				xAxis: {
					categories: categories,
					labels: {
						style: {
							 font: 'normal 13px 宋体'
						}
					}					
				},
				yAxis: {
					title: {
						text: '案件数量'
					}
				},
				plotOptions: {
					column: {
						cursor: 'pointer',
						point: {
							events: {
								click: function() {
									var drilldown = this.drilldown;
									if (drilldown) { // drill down
										setChart(drilldown.name, drilldown.categories, drilldown.data, drilldown.color);
									} else { // restore
										setChart(name, categories, data);
									}
								}
							}
						},
						dataLabels: {
							enabled: true,
							color: colors[0],
							style: {
								fontWeight: 'bold'
							},
							formatter: function() {
								return this.y==0?"":this.y +'件';
							}
						}					
					}
				},
				tooltip: {
					formatter: function() {
						var point = this.point,
							s = this.x +':<b>'+ this.y +'件</b><br/>';
						if (point.drilldown) {
							s += '点击查看'+ point.category +'分类';
						} else {
							s += '点击返回上级分类';
						}
						return s;
					}
				},
				series: [{
					name: name,
					data: data,
					color: colors[0]
				}],
				credits: {
					enabled: false
				}
			});
		});
	</script>
</head>
<body style="overflow:auto;">
	<div id="container" style="width:90%;height:600px;margin:50px auto"></div>
</body>
</html>
