﻿//初始化
$(function(){
	$("#content").height($("#form-design").height()-40);
	KE.init({
		id: 'content',
		resizeMode: 0,
		newlineTag: 'br',
		cssPath: htUrl + '/jsp/sys/formDesign/css/extend_editor.css',
		items : [
			'source', '|', 'undo', 'redo', 'print', 'cut', 'copy', 'paste',
			'plainpaste', 'wordpaste', '|', 'justifyleft', 'justifycenter', 'justifyright',
			'justifyfull', 'insertorderedlist', 'insertunorderedlist', 'indent', 'outdent', 'subscript',
			'superscript', '|', 'selectall', '-',
			'title', 'fontname', 'fontsize', '|', 'textcolor', 'bgcolor', 'bold',
			'italic', 'underline', 'strikethrough', 'removeformat', '|', 'image',
			'advtable', 'hr', 'link', 'unlink', 'clear', 'template', '@',
			'text','textarea','select','check','grid','macro','date','calc','general','data','-','save','preview','close'
		]
	});
	KE.create('content');
	var content = $(KE.g['content'].iframeDoc);
	eleCounter = {
		'text': content.find("input[class*=fd_input]").length,
		'textarea': content.find("textarea[class*=fd_textarea]").length,
		'select': content.find("select").length,
		'check': content.find("input[type=checkbox],input[type=radio]").length,
		'grid': content.find(".fdgrid").length,
		'macro': content.find("[value='{宏控件}']").length,
		'date': content.find("input[class*=Wdate]").length,
		'calc': content.find("input[class*=calc]").length,
		'general': content.find("input[class*=general],textarea[class*=general]").length,
		'data': content.find("input[class*=data]").length
	};
});
//表单设计器
(function(undifined){
	var FOD = {};

	FOD.version = 'v1.0.0 (2011-12-25)';

	FOD.browser = (function() {
		var ua = navigator.userAgent.toLowerCase();
		return {
			VERSION: ua.match(/(msie|firefox|webkit|opera)[\/:\s](\d+)/) ? RegExp.$2 : '0',
			IE: (ua.indexOf('msie') > -1 && ua.indexOf('opera') == -1),
			GECKO: (ua.indexOf('gecko') > -1 && ua.indexOf('khtml') == -1),
			WEBKIT: (ua.indexOf('applewebkit') > -1),
			OPERA: (ua.indexOf('opera') > -1)
		};
	})();

	FOD.$ = function(id, doc){
		var doc = doc || document;
		return doc.getElementById(id);
	};

	FOD._$ = function(name, doc){
		var doc = doc || document;
		return doc.getElementsByName(name);
	};

	FOD.$$ = function(name, doc){
		var doc = doc || document;
		return doc.createElement(name);
	};

	if (window.FOD === undefined) window.FOD = FOD;
	window.FormDesign = FOD;

	FOD.util = {
		changeName : function(ele,val){
			if(FOD.browser.IE){
				ele.removeAttribute("name");
				ele.NAME = val;
				ele.name = val;
			}else{
				ele.name = val;
			}
		},
		getRadioValueByName : function(name, doc){
			var eles = FOD._$(name,doc);
			for(var i=0;i<eles.length;i++){
				if(eles[i].checked) return eles[i].value;
			}
			return null;
		}
	}
})();
//KE扩展
var HTplugin = ['text','textarea','select','check','grid','macro','date','calc','general','data','save','preview','close'];
//自定义控件名
KE.lang['clear'] = "清空内容";
KE.lang['template'] = "插入模板";
KE.lang['text'] = "单行输入框";
KE.lang['textarea'] = "多行输入框";
KE.lang['select'] = "下拉菜单";
KE.lang['check'] = "选择框";
KE.lang['grid'] = "列表控件";
KE.lang['macro'] = "宏控件";
KE.lang['date'] = "日历控件";
KE.lang['calc'] = "计算控件";
KE.lang['general'] = "通用选择控件";
KE.lang['data'] = "数据选择控件";

KE.lang['cell'] = "单元格";

KE.lang['save'] = "保存表单";
KE.lang['preview'] = "预览表单";
KE.lang['close'] = "关闭设计器";
//公用属性名
KE.lang.util = {
	"percent" : "%",
	"px" : "px",
	"alignDefault" : "默认",
	"alignLeft" : "左对齐",
	"alignCenter" : "居中",
	"alignRight" : "右对齐",
	"valignTop" : "顶部",
	"valignMiddle" : "中部",
	"valignBottom" : "底部",
	"invalidWidth" : "宽度必须为数字！",
	"invalidHeight" : "高度必须为数字！",
	"invalidBorder" : "边框必须为数字！"
}
//右键菜单名及弹出框名称
KE.lang.plugins.text = {
	"prop" : "单行输入框属性",
	"delete" : "删除单行输入框",
	"name" : "单行输入框名字",
	"size" : "单行输入框大小",
	"width" : "宽度",
	"height" : "高度",
	"default" : "输入框默认值",
	"type" : "单行输入框类型",
	"inputType" : "输入框输入类型",
	"string" : "字符串",
	"number" : "数字",
	"isNull" : "是否允许为空值",
	"allow" : "允许",
	"notAllow" : "不允许",
	"text" : "文本",
	"password" : "密码",
	"hidden" : "隐藏域",
	"file" : "文件上传",
	"hiddenkey" : "隐藏域主键",
	"invalidName" : "单行输入框名字不能为空！"
};
KE.lang.plugins.textarea = {
	"prop" : "多行输入框属性",
	"delete" : "删除多行输入框",
	"name" : "多行输入框名字",
	"size" : "多行输入框大小",
	"width" : "宽度",
	"height" : "高度",
	"defaultValue" : "输入框默认值",
	"isNull" : "是否允许为空值",
	"allow" : "允许",
	"notAllow" : "不允许",
	"htmlTextarea" : "HTML编辑框",
	"invalidName" : "多行输入框名字不能为空！"
};
KE.lang.plugins.select = {
	"prop" : "下拉菜单属性",
	"isNull" : "是否允许为空",
	"allow" : "允许",
	"notAllow" : "不允许",
	"delete" : "删除下拉菜单",
	"name" : "下拉菜单名字",
	"option" : "下拉菜单选项",
	"invalidName" : "下拉菜单名字不能为空！"
};
KE.lang.plugins.check = {
	"prop" : "选择框属性",
	"delete" : "删除选择框",
	"name" : "选择框名字",
	"type" : "选择框类型",
	"isNull" : "是否允许空",
	"allow" : "允许",
	"notAllow" : "不允许",
	"checkbox" : "多选框",
	"radio" : "单选框",
	"option" : "选择框选项",
	"invalidName" : "选择框名字不能为空！"
};
KE.lang.plugins.grid = {
	"prop" : "列表控件属性",
	"delete" : "删除列表控件",
	"name" : "列表控件名字",
	"gridWidth" : "列表控件宽度",
	"number" : "序号",
	"header" : "列表控件表头",
	"field" : "字段名",
	"type" : "类型",
	"width" : "宽度(%)",
	"total" : "合计",
	"formula" : "计算公式",
	"sort" : "顺序",
	"option" : "列表控件字段",
	"allowNull" : "不可空",
	"#" : "#",
	"operate" : "操作",
	"invalidName" : "列表控件名字不能为空！"
};
KE.lang.plugins.macro = {
	"prop" : "宏控件属性",
	"delete" : "删除宏控件",
	"name" : "宏控件名字",
	"obj" : "宏应用对象",
	"type" : "宏控件类型",
	"query" : "宏查询语句",
	"text_currentDate" : "当前日期",
	"text_currentTime" : "当前时间",
	"text_currentDateTime" : "当前日期+时间",
	"text_currentUserId" : "当前用户ID",
	"text_currentUserName" : "当前用户姓名",
	"text_currentUserDept" : "当前用户部门",
	"text_currentUserRole" : "当前用户角色",
	"text_currentUserNameDate" : "当前用户姓名+日期",
	"text_currentUserNameDateTime" : "当前用户姓名+日期+时间",
	"text_currentUserIp" : "当前用户IP地址",
	"text_formName" : "表单名称",
	"text_workCode" : "工作名称/文号",
	"text_flowStartDate" : "流程开始日期",
	"text_flowStartDateTime" : "流程开始日期+时间",
	"text_Serial" : "流水号",
	"text_CodeCounter" : "文号计数器",
	"text_currentDeptManager" : "部门主管（本部门）",
	"text_highDeptManager" : "部门主管（上级部门）",
	"text_superDeptManager" : "部门主管（一级部门）",
	"text_sqlQuery" : "来自SQL查询语句",
	"select_deptList" : "部门列表",
	"select_userList" : "人员列表",
	"select_roleList" : "角色列表",
	"select_flowManagerList" : "流程经办人列表",
	"select_currentManagerList" : "本步骤经办人列表",
	"select_currentDeptManagerList" : "部门主管（本部门）",
	"select_highDeptManagerList" : "部门主管（上级部门）",
	"select_superDeptManagerList" : "部门主管（一级部门）",
	"select_sqlQuery" : "来自SQL查询的列表",
	"invalidName" : "宏控件名字不能为空！",
	"invalidObj" : "宏应用对象不能为空！",
	"invalidNoObj" : "宏应用对象不存在！",
	"invalidDisObj" : "宏应用对象不可用！"
};
KE.lang.plugins.date = {
	"prop" : "日历控件属性",
	"delete" : "删除日历控件",
	"name" : "日历控件名字",
	"readonly" : "日历控件模式",
	"readonlytrue" : "只读",
	"readonlyfalse" : "可写入",
	"isNull" : "是否允许空",
	"allow" : "允许",
	"notAllow" : "不允许",
	"defaultValue" : "控件默认值",
	"format" : "日历控件格式",
	"ymdhms" : "日期+时间",
	"ymd" : "日期",
	"hms" : "时间",
	"custom" : "自定义格式",
	"customformat" : "自定义格式",
	"invalidName" : "日历控件名字不能为空！"
};
KE.lang.plugins.calc = {
	"prop" : "计算控件属性",
	"delete" : "删除计算控件",
	"name" : "计算控件名字",
	"readonly" : "计算控件模式",
	"readonlytrue" : "只读",
	"readonlyfalse" : "可写入",
	"isNull" : "是否允许空值",
	"allow" : "允许",
	"notAllow" : "不允许",
	"formula" : "计算控件公式",
	"invalidName" : "计算控件名字不能为空！"
};
KE.lang.plugins.general = {
	"prop" : "通用选择控件属性",
	"delete" : "删除通用选择控件",
	"name" : "通用选择控件名字",
	"width" : "通用选择控件宽度",
	"mode" : "通用选择控件模式",
	"readonlytrue" : "只读",
	"readonlyfalse" : "可写入",
	"isNull" : "是否允许为空值",
	"allow" : "允许",
	"notAllow" : "不允许",
	"type" : "通用选择控件类型",
	"user" : "人员选择",
	"dept" : "部门选择",
	"role" : "角色选择",
	"style" : "通用选择控件样式",
	"ss" : "单选单行",
	"ms" : "多选单行",
	"mm" : "多选多行",
	"invalidName" : "通用选择控件名字不能为空！"
};
KE.lang.plugins.data = {
	"prop" : "数据选择控件属性",
	"delete" : "删除数据选择控件",
	"name" : "数据选择控件名字",
	"width" : "数据选择控件宽度",
	"source" : "选择控件数据来源",
	"tablespace" : "表空间",
	"table" : "数据表",
	"map" : "添加数据映射关系",
	"add" : "添加",
	"isNull" : "是否允许为空值",
	"allow" : "允许",
	"notAllow" : "不允许",
	"relationship" : "映射关系列表",
	"field" : "表字段",
	"widget" : "控件名",
	"field_zh" : "字段中文名",
	"number" : "序号",
	"tfield" : "数据库字段",
	"twidget" : "映射控件名",
	"tfield_zh" : "字段中文名",
	"tsearch" : "模糊查询",
	"tsort" : "排序",
	"sequence" : "顺序调整",
	"operate" : "操作",
	"invalidName" : "数据选择控件名字不能为空！"
};
KE.lang.plugins.cell = {
	"size" : "大小",
	"width" : "宽度",
	"height" : "高度",
	"alignType" : "对齐方式",
	"align" : "水平对齐",
	"valign" : "垂直对齐",
	"border" : "边框样式",
	"borderWidth" : "边框",
	"borderColor" : "颜色",
	"backgroundColor" : "背景颜色"
};

KE.plugin['clear'] = {
	click : function() {
		KE.html('content', '');	
	}
};

KE.plugin['template'] = {
	click : function() {
		//KE.util.selection('content');
		this.dialog = new KE.dialog({
			id : 'content',
			cmd : 'template',
			file : 'formdesign/template.html',
			width : 600,
			height : 400,
			loadingMode : true,
			title : KE.lang['template'],
			yesButton : KE.lang['yes'],
			noButton : KE.lang['no']
		});
		this.dialog.show();
	},
	exec : function(id){
		var dialogDoc = KE.util.getIframeDoc(this.dialog.iframe);
		var source = KE.$('source', dialogDoc).value;
		if(source != "")
			KE.html('content', source);	
		this.dialog.hide();
		KE.util.focus(id);
	}
};

KE.plugin['text'] = {
	getSelectedText : function(id) {
		return KE.getCommonAncestor(KE.g[id].keSel, 'input');
	},
	textprop : function(id) {
		KE.util.selection(id);
		this.dialog = new KE.dialog({
			id : id,
			cmd : 'text',
			file : 'formdesign/text.html',
			width : 500,
			height : 190,
			loadingMode : true,
			title : KE.lang['text'],
			yesButton : KE.lang['yes'],
			noButton : KE.lang['no']
		});
		this.dialog.show();
	},
	textdelete : function(id) {
		var text = this.getSelectedText(id);
		text.parentNode.removeChild(text);
	},
	init : function(id) {
		var self = this;
		var textCmds = 'prop,delete'.split(',');
		for (var i = 0, len = textCmds.length; i < len; i++) {
			var name = 'text' + textCmds[i];
			KE.g[id].contextmenuItems.push({
				text : KE.lang.plugins.text[textCmds[i]],
				click : (function(name) {
					return function(id, menu) {
						if(/delete/.test(name)) KE.util.select(id);
						menu.hide();
						if (self[name] !== undefined) self[name](id);
						if (!/prop/.test(name)) {
							KE.util.execOnchangeHandler(id);
						}
					};
				})(name),
				cond : function(id) {
					return self.getSelectedText(id);
				},
				options : {
					width : '170px',
					iconHtml : '<span class="icon-' + textCmds[i] + '"></span>'
				}
			});
		}
		KE.g[id].contextmenuItems.push('-');
	},
	click : function(id) {
		KE.util.selection(id);
		KE.util.insertHtml(id, '<input type="text" id="text'+eleCounter.text+'" name="text'+eleCounter.text+'" class="fd_input" />');
		KE.util.focus(id);
		eleCounter.text ++;
	},
	exec : function(id){
		var dialogDoc = KE.util.getIframeDoc(this.dialog.iframe);
		var name = KE.$('textName', dialogDoc).value;
		var dfault = KE.$('default', dialogDoc).value;
		var inputType = FOD.util.getRadioValueByName('inputType',dialogDoc);
		var isNull = FOD.util.getRadioValueByName('isNull',dialogDoc);
		var width = KE.$('width',dialogDoc).value;
		var widthType = KE.$('widthType',dialogDoc).value;
		var height = KE.$('height',dialogDoc).value;
		var heightType = KE.$('heightType',dialogDoc).value;
		var type = FOD.util.getRadioValueByName('type',dialogDoc);
		if (name == null || KE.util.trim(name) == "") {
			alert(KE.lang.plugins.text.invalidName);
			KE.$('textName', dialogDoc).focus();
			return false;
		}
		if (!width.match(/^\d*$/)) {
			alert(KE.lang.util['invalidWidth']);
			width = KE.$('width',dialogDoc).focus();
			return false;
		}
		if (!height.match(/^\d*$/)) {
			alert(KE.lang.util['invalidHeight']);
			KE.$('height',dialogDoc).focus();
			return false;
		}
		var text = this.getSelectedText(id);
		if(text){
			var vType = "";
			if(inputType == "number" || isNull == "notAllow"){
				if(inputType == "number" && isNull != "notAllow")
					vType += inputType=="number"?"Number":"";
				else if(inputType != "number" && isNull == "notAllow")
					vType += isNull=="notAllow"?"Require":"";
				else
					vType += "Require,Number";
				vType = "vtype='" + vType + "'";
			}
			if(type == "file")
				var textHtml = '<input '+vType+' id="'+name+'" type="file" name="'+name+'" class="fd_input hide" />';
			if(type == "hidden")
				var textHtml = '<input type="hidden" alt="'+(text.getAttribute("alt")?text.getAttribute("alt"):"")+'" value="'+dfault+'" id="'+name+'" name="'+name+'" class="fd_input hide" />';
			else if(type == "hiddenkey")
				var textHtml = '<input title="key" type="hidden" alt="'+(text.getAttribute("alt")?text.getAttribute("alt"):"")+'" value="'+dfault+'" id="'+name+'" name="'+name+'" class="fd_input hide" />';
			else
				var textHtml = '<input type="'+type+'" '+vType+' alt="'+(text.getAttribute("alt")?text.getAttribute("alt"):"")+'" value="'+dfault+'" id="'+name+'" type="text" style="'+(height==""?"":"height:"+(height+heightType)+";")+'width:'+(width==""?"80%":(width+widthType))+';" name="'+name+'" class="fd_input" />';
			
			KE.util.insertHtml(id, textHtml);
			$(text).remove();
		}
		this.dialog.hide();
		KE.util.focus(id);
	}
};
KE.plugin['textarea'] = {
	getSelectedNode : function(id) {
		return KE.getCommonAncestor(KE.g[id].keSel, 'textarea');
	},
	init : function(id) {
		var self = this;
		KE.g[id].contextmenuItems.push({
			text : KE.lang.plugins.textarea["prop"],
			click : function(id, menu) {
				menu.hide();
				self.dialog = new KE.dialog({
					id : id,
					cmd : 'textarea',
					file : 'formdesign/textarea.html',
					width : 450,
					height : 150,
					loadingMode : true,
					title : KE.lang['textarea'],
					yesButton : KE.lang['yes'],
					noButton : KE.lang['no']
				});
				self.dialog.show();
			},
			cond : function(id) {
				return self.getSelectedNode(id);
			},
			options : {
				width : '170px',
				iconHtml : '<span class="icon-prop"></span>'
			}
		});
		KE.g[id].contextmenuItems.push({
			text : KE.lang.plugins.textarea["delete"],
			click : function(id, menu) {
				KE.util.select(id);
				menu.hide();
				var textarea = self.getSelectedNode(id);
				textarea.parentNode.removeChild(textarea);
				KE.util.execOnchangeHandler(id);
			},
			cond : function(id) {
				return self.getSelectedNode(id);
			},
			options : {
				width : '170px',
				iconHtml : '<span class="icon-delete"></span>'
			}
		});
		KE.g[id].contextmenuItems.push('-');
	},
	click : function(id){
		KE.util.selection(id);
		KE.util.insertHtml(id, '<textarea id="textarea'+eleCounter.textarea+'" name="textarea'+eleCounter.textarea+'" class="fd_textarea"></textarea>');
		KE.util.focus(id);
		eleCounter.textarea ++;
	},
	exec : function(id){
		var dialogDoc = KE.util.getIframeDoc(this.dialog.iframe);
		var name = KE.$('name', dialogDoc).value;
		var width = KE.$('width',dialogDoc).value;
		var widthType = KE.$('widthType',dialogDoc).value;
		var height = KE.$('height',dialogDoc).value;
		var heightType = KE.$('heightType',dialogDoc).value;
		var defaultValue = KE.$('defaultValue', dialogDoc).value;
		var isNull = FOD.util.getRadioValueByName('isNull',dialogDoc);
		var html = KE.$('htmlTextarea',dialogDoc);
		if (name == null || KE.util.trim(name) == "") {
			alert(KE.lang.plugins.textarea.invalidName);
			KE.$('name', dialogDoc).focus();
			return false;
		}
		if (!width.match(/^\d*$/)) {
			alert(KE.lang.util['invalidWidth']);
			width = KE.$('width',dialogDoc).focus();
			return false;
		}
		if (!height.match(/^\d*$/)) {
			alert(KE.lang.util['invalidHeight']);
			KE.$('height',dialogDoc).focus();
			return false;
		}
		var selectNode = this.getSelectedNode(id);
		if(selectNode){
			vType = "";
			if(isNull == "notAllow")
				vType = "vtype='Require'";
			var textareaHtml = '<textarea '+(html.checked?"type='html'":"")+' '+vType+' alt="'+(selectNode.getAttribute("alt")?selectNode.getAttribute("alt"):"")+'" id="'+name+'" style="'+(height==""?"":"height:"+(height+heightType)+";")+'width:'+(width==""?"80%":(width+widthType))+';" name="'+name+'" class="fd_textarea">'+defaultValue+'</textarea>';
			if(FOD.browser.IE) KE.util.insertHtml(id, textareaHtml);
			$(selectNode).remove();
			if(!FOD.browser.IE) KE.util.insertHtml(id, textareaHtml);
		}
		this.dialog.hide();
		KE.util.focus(id);
	}
};
KE.plugin['select'] = {
	getSelectedNode : function(id) {
		return KE.getCommonAncestor(KE.g[id].keSel, 'select');
	},
	selectprop : function(id) {
		KE.util.selection(id);
		this.dialog = new KE.dialog({
			id : id,
			cmd : 'select',
			file : 'formdesign/select.html',
			width : 500,
			height : 300,
			loadingMode : true,
			title : KE.lang['select'],
			yesButton : KE.lang['yes'],
			noButton : KE.lang['no']
		});
		this.dialog.show();
	},
	selectdelete : function(id) {
		var select = this.getSelectedNode(id);
		select.parentNode.parentNode.removeChild(select.parentNode);
	},
	init : function(id) {
		var self = this;
		var cmds = 'prop,delete'.split(',');
		for (var i = 0, len = cmds.length; i < len; i++) {
			var name = 'select' + cmds[i];
			KE.g[id].contextmenuItems.push({
				text : KE.lang.plugins.select[cmds[i]],
				click : (function(name) {
					return function(id, menu) {
						if(/delete/.test(name)) KE.util.select(id);
						menu.hide();
						if (self[name] !== undefined) self[name](id);
						if (!/prop/.test(name)) {
							KE.util.execOnchangeHandler(id);
						}
					};
				})(name),
				cond : function(id) {
					return self.getSelectedNode(id);
				},
				options : {
					width : '170px',
					iconHtml : '<span class="icon-' + cmds[i] + '"></span>'
				}
			});
		}
		KE.g[id].contextmenuItems.push('-');
	},
	click : function(id){
		KE.util.selection(id);
		KE.util.insertHtml(id, '<span><select id="select'+eleCounter.select+'" name="select'+eleCounter.select+'"><option value="">--请选择--</option></select></span>');
		KE.util.focus(id);
		eleCounter.select ++;
	},
	exec : function(id){
		var dialogDoc = KE.util.getIframeDoc(this.dialog.iframe);
		var name = KE.$('name', dialogDoc).value;
		var optext = FOD._$('optext', dialogDoc);
		var opvalue = FOD._$('opvalue', dialogDoc);
		var opselected = FOD._$('selected', dialogDoc);
		var isNull = FOD.util.getRadioValueByName('isNull',dialogDoc);
		if (name == null || KE.util.trim(name) == "") {
			alert(KE.lang.plugins.select.invalidName);
			KE.$('name', dialogDoc).focus();
			return false;
		}
		var selectNode = this.getSelectedNode(id);
		if(selectNode){
			vType = "";
			if(isNull == "notAllow")
				vType = "vtype='Require'";
			var selectHtml = '<select '+vType+' id="'+name+'" alt="'+(selectNode.getAttribute("alt")?selectNode.getAttribute("alt"):"")+'" name="'+name+'">';
			FOD.util.changeName(selectNode,name);
			selectNode.options.length = 0;
			for(var i=0;i<optext.length;i++){
				selectHtml += '<option value="'+opvalue[i].value+'" '+(opselected[i].checked?"selected='selected'":"")+'>'+optext[i].value+'</option>';
			}
			selectHtml += "</select>";
			if(FOD.browser.IE) KE.util.insertHtml(id, selectHtml);
			$(selectNode).remove();
			if(!FOD.browser.IE) KE.util.insertHtml(id, selectHtml);
		}
		this.dialog.hide();
		KE.util.focus(id);
	}
};
KE.plugin['check'] = {
	getSelectedNode : function(id) {
		return KE.getCommonAncestor(KE.g[id].keSel, 'check');
	},
	getSelectedsByName : function(id){
		var selected = this.getSelectedNode(id);
		if(selected)
			return FOD._$(selected.name,KE.g[id].iframeDoc);
		else
			return null;
	},
	checkprop : function(id) {
		this.click(id);
	},
	checkdelete : function(id) {
		var checks = this.getSelectedsByName(id);
		for(var i=0;i<checks.length;i++){
			var label = KE.$("l"+checks[i].id,KE.g[id].iframeDoc);
			$(label).remove();
		}
		$(checks).remove();
	},
	init : function(id) {
		var self = this;
		var cmds = 'prop,delete'.split(',');
		for (var i = 0, len = cmds.length; i < len; i++) {
			var name = 'check' + cmds[i];
			KE.g[id].contextmenuItems.push({
				text : KE.lang.plugins.check[cmds[i]],
				click : (function(name) {
					return function(id, menu) {
						if(/delete/.test(name)) KE.util.select(id);
						menu.hide();
						if (self[name] !== undefined) self[name](id);
						if (!/prop/.test(name)) {
							KE.util.execOnchangeHandler(id);
						}
					};
				})(name),
				cond : function(id) {
					return self.getSelectedNode(id);
				},
				options : {
					width : '170px',
					iconHtml : '<span class="icon-' + cmds[i] + '"></span>'
				}
			});
		}
		KE.g[id].contextmenuItems.push('-');
	},
	click : function(id){
		KE.util.selection(id);
		this.dialog = new KE.dialog({
			id : id,
			cmd : 'check',
			file : 'formdesign/check.html',
			width : 500,
			height : 300,
			loadingMode : true,
			title : KE.lang['check'],
			yesButton : KE.lang['yes'],
			noButton : KE.lang['no']
		});
		this.dialog.show();
	},
	exec : function(id){
		var dialogDoc = KE.util.getIframeDoc(this.dialog.iframe);
		var name = KE.$('name', dialogDoc).value;
		var type = FOD._$('type', dialogDoc);
		var optext = FOD._$('optext', dialogDoc);
		var opvalue = FOD._$('opvalue', dialogDoc);
		var opselected = FOD._$('selected', dialogDoc);
		var isNull = FOD.util.getRadioValueByName('isNull',dialogDoc);
		if (name == null || KE.util.trim(name) == "") {
			alert(KE.lang.plugins.check.invalidName);
			KE.$('name', dialogDoc).focus();
			return false;
		}
		var selectNode = this.getSelectedNode(id);
		var checkHtml = "";
		var checkType = type[0].checked?type[0].value:type[1].value;
		//如果是编辑，必须先找出之前所有的元素放入removeEles，等新元素插入完后循环删除
		if(selectNode){
			var removeEles = []
			var checks = this.getSelectedsByName(id);
			for(var i=0;i<checks.length;i++){
				var label = KE.$("l"+checks[i].id,KE.g[id].iframeDoc);
				removeEles.push(label);
				removeEles.push(checks[i]);
			}
		}
		vType = "";
		if(isNull == "notAllow")
			vType = "vtype='Require'";
		for(var i=0;i<optext.length;i++){
			if(optext[i].value != null&&KE.util.trim(optext[i].value) != ""){
				var checked = opselected[i].checked?"checked":"";
				checkHtml += "<input "+((i==0)?vType:"")+" type='"+checkType+"' name='"+name+"' value='"+opvalue[i].value+"' id='"+(name+i)+"' "+checked+" />";
				checkHtml += "<label title='"+optext[i].value+"' id='l"+(name+i)+"' for='"+(name+i)+"' >"+optext[i].value+"&nbsp;</label>";
			}
		}
		KE.util.selection(id);
		KE.util.insertHtml(id, checkHtml);
		if(selectNode){
			for(var i=0;i<removeEles.length;i++){
				$(removeEles[i]).remove();
			}
		}else{
			eleCounter.check ++;
		}
		this.dialog.hide();
		KE.util.focus(id);
	}
};
KE.plugin['grid'] = {
	getSelectedNode : function(id) {
		return KE.getCommonAncestor(KE.g[id].keSel, 'grid');
	},
	gridprop : function(id) {
		this.click(id);
	},
	griddelete : function(id) {
		var grid = this.getSelectedNode(id);
		grid.parentNode.removeChild(grid);
	},
	init : function(id) {
		var self = this;
		var cmds = 'prop,delete'.split(',');
		for (var i = 0, len = cmds.length; i < len; i++) {
			var name = 'grid' + cmds[i];
			KE.g[id].contextmenuItems.push({
				text : KE.lang.plugins.grid[cmds[i]],
				click : (function(name) {
					return function(id, menu) {
						if(/delete/.test(name)) KE.util.select(id);
						menu.hide();
						if (self[name] !== undefined) self[name](id);
						if (!/prop/.test(name)) {
							KE.util.execOnchangeHandler(id);
						}
					};
				})(name),
				cond : function(id) {
					return self.getSelectedNode(id);
				},
				options : {
					width : '170px',
					iconHtml : '<span class="icon-' + cmds[i] + '"></span>'
				}
			});
		}
		KE.g[id].contextmenuItems.push('-');
	},
	click : function(id){
		KE.util.selection(id);
		this.dialog = new KE.dialog({
			id : id,
			cmd : 'grid',
			file : 'formdesign/grid.html',
			width : 850,
			height : 350,
			loadingMode : true,
			title : KE.lang['grid'],
			yesButton : KE.lang['yes'],
			noButton : KE.lang['no']
		});
		this.dialog.show();
	},
	exec : function(id){
		var dialogDoc = KE.util.getIframeDoc(this.dialog.iframe);
		var name = KE.$('name', dialogDoc).value;
		var width = KE.$('gridWidth',dialogDoc).value;
		var widthType = KE.$('widthType',dialogDoc).value;
		var gtext = FOD._$('gtext', dialogDoc);
		var gwidth = FOD._$('gwidth', dialogDoc);
		var gtotal = FOD._$('gtotal', dialogDoc);
		var gcalc = FOD._$('gcalc', dialogDoc);
		var gnull = FOD._$('gnull', dialogDoc);
		var gtype = FOD._$('gtype', dialogDoc);
		var gfield = FOD._$('gfield', dialogDoc);

		if (name == null || KE.util.trim(name) == "") {
			alert(KE.lang.plugins.grid.invalidName);
			KE.$('name', dialogDoc).focus();
			return false;
		}
		if (!width.match(/^\d*$/)) {
			alert(KE.lang.util['invalidWidth']);
			width = KE.$('gridWidth',dialogDoc).focus();
			return false;
		}
		var selectNode = this.getSelectedNode(id);
		var gridHtml = "<table border='0' id='"+name+"' align='center' class='fdgrid' style='width:"+(width==''?"99%":(width+widthType))+";' cellspacing='0' cellpadding='0'>";
		gridHtml += "<tr>";
		for(var i=0;i<gtext.length;i++){
			if(gtext[i].value != null&&KE.util.trim(gtext[i].value) != ""){
				var alt = (gnull[i]&&gnull[i].checked?'nNull':'aNull')+","+(gtype[i]?gtype[i].value:"string")+","+(gfield[i]?gfield[i].value:"");
				gridHtml += "<th alt='"+(i!=gtext.length-1?alt:"")+"' title='"+(gcalc[i]?gcalc[i].value:"")+"' width='"+(gwidth[i].value?gwidth[i].value+"%":"")+"'>"+gtext[i].value+"</th>";
			}
		}
		gridHtml += "</tr><tr>";
		for(var i=0;i<gtext.length;i++){
			if(gtotal[i]&&gtotal[i].checked){
				gridHtml += "<th class='gtotal'>合计</th>";
			}else{
				gridHtml += "<th>&nbsp;</th>";
			}
		}
		gridHtml += "</tr></table>";
		KE.util.selection(id);
		if(!selectNode){
			eleCounter.grid ++;
		}else{
			$(selectNode).remove();
		}
		KE.util.insertHtml(id, gridHtml);
		this.dialog.hide();
		KE.util.focus(id);
	}
};
KE.plugin['date'] = {
	getSelectedNode : function(id) {
		return KE.getCommonAncestor(KE.g[id].keSel, 'date');
	},
	dateprop : function(id) {
		KE.util.selection(id);
		this.dialog = new KE.dialog({
			id : id,
			cmd : 'date',
			file : 'formdesign/date.html',
			width : 400,
			height : 200,
			loadingMode : true,
			title : KE.lang['date'],
			yesButton : KE.lang['yes'],
			noButton : KE.lang['no']
		});
		this.dialog.show();
	},
	datedelete : function(id) {
		var date = this.getSelectedNode(id);
		date.parentNode.removeChild(date);
	},
	init : function(id) {
		var self = this;
		var cmds = 'prop,delete'.split(',');
		for (var i = 0, len = cmds.length; i < len; i++) {
			var name = 'date' + cmds[i];
			KE.g[id].contextmenuItems.push({
				text : KE.lang.plugins.date[cmds[i]],
				click : (function(name) {
					return function(id, menu) {
						if(/delete/.test(name)) KE.util.select(id);
						menu.hide();
						if (self[name] !== undefined) self[name](id);
						if (!/prop/.test(name)) {
							KE.util.execOnchangeHandler(id);
						}
					};
				})(name),
				cond : function(id) {
					return self.getSelectedNode(id);
				},
				options : {
					width : '170px',
					iconHtml : '<span class="icon-' + cmds[i] + '"></span>'
				}
			});
		}
		KE.g[id].contextmenuItems.push('-');
	},
	click : function(id){
		KE.util.selection(id);
		KE.util.insertHtml(id, '<input type="text" id="date'+eleCounter.date+'" name="date'+eleCounter.date+'" class="Wdate" readonly="readonly" onclick="WdatePicker({dateFmt:\'yyyy-MM-dd HH:mm:ss\'})"/>');
		KE.util.focus(id);
		eleCounter.date ++;
	},
	exec : function(id){
		var dialogDoc = KE.util.getIframeDoc(this.dialog.iframe);
		var name = KE.$('name', dialogDoc).value;
		var readonly = FOD.util.getRadioValueByName('readonly',dialogDoc);
		var format = FOD.util.getRadioValueByName('format',dialogDoc);
		var custom = KE.$('custom', dialogDoc).value; 
		var isNull = FOD.util.getRadioValueByName('isNull',dialogDoc);
		if (name == null || KE.util.trim(name) == "") {
			alert(KE.lang.plugins.date.invalidName);
			KE.$('name', dialogDoc).focus();
			return false;
		}
		var selectNode = this.getSelectedNode(id);
		if(selectNode){
			var vType = "";
			if(isNull == "notAllow")
				vType = "vtype='Require'";
			var dateHtml = '<input '+vType+' alt="'+(selectNode.getAttribute("alt")?selectNode.getAttribute("alt"):"")+'" value="'+(selectNode.getAttribute("value")?selectNode.getAttribute("value"):"")+'" type="text" id="'+name+'" name="'+name+'" class="Wdate" '+(readonly == "readonly"?"readonly='readonly'":"")+' onclick="WdatePicker({dateFmt:\''+(format == "custom"?custom:format)+'\'})"/>';
			KE.util.insertHtml(id, dateHtml);
			$(selectNode).remove();
		}	
		this.dialog.hide();
		KE.util.focus(id);
	}
};
KE.plugin['calc'] = {
	getSelectedNode : function(id) {
		return KE.getCommonAncestor(KE.g[id].keSel, 'calc');
	},
	calcprop : function(id) {
		this.click(id);
	},
	calcdelete : function(id) {
		var calc = this.getSelectedNode(id);
		calc.parentNode.removeChild(calc);
	},
	init : function(id) {
		var self = this;
		var cmds = 'prop,delete'.split(',');
		for (var i = 0, len = cmds.length; i < len; i++) {
			var name = 'calc' + cmds[i];
			KE.g[id].contextmenuItems.push({
				text : KE.lang.plugins.calc[cmds[i]],
				click : (function(name) {
					return function(id, menu) {
						if(/delete/.test(name)) KE.util.select(id);
						menu.hide();
						if (self[name] !== undefined) self[name](id);
						if (!/prop/.test(name)) {
							KE.util.execOnchangeHandler(id);
						}
					};
				})(name),
				cond : function(id) {
					return self.getSelectedNode(id);
				},
				options : {
					width : '170px',
					iconHtml : '<span class="icon-' + cmds[i] + '"></span>'
				}
			});
		}
		KE.g[id].contextmenuItems.push('-');
	},
	click : function(id){
		KE.util.selection(id);
		this.dialog = new KE.dialog({
			id : id,
			cmd : 'calc',
			file : 'formdesign/calc.html',
			width : 500,
			height : 210,
			loadingMode : true,
			title : KE.lang['calc'],
			yesButton : KE.lang['yes'],
			noButton : KE.lang['no']
		});
		this.dialog.show();
	},
	exec : function(id){
		var dialogDoc = KE.util.getIframeDoc(this.dialog.iframe);
		var name = KE.$('name', dialogDoc).value;
		var readonly = FOD.util.getRadioValueByName('readonly',dialogDoc);
		var formula = KE.$('formula', dialogDoc).value;
		var isNull = FOD.util.getRadioValueByName('isNull',dialogDoc);
		if (name == null || KE.util.trim(name) == "") {
			alert(KE.lang.plugins.date.invalidName);
			KE.$('name', dialogDoc).focus();
			return false;
		}
		var selectNode = this.getSelectedNode(id);
		vType = "";
		if(isNull == "notAllow")
			vType = "vtype='Require'";
		if(selectNode)
			var clacHtml = '<input '+vType+' alt="'+(selectNode.getAttribute("alt")?selectNode.getAttribute("alt"):"")+'" value="'+(selectNode.getAttribute("value")?selectNode.getAttribute("value"):"")+'" title="'+formula+'" type="text" id="'+name+'" name="'+name+'" '+(readonly?"readonly='readonly'":"")+' class="calc" />';
		else
			var clacHtml = '<input '+vType+' title="'+formula+'" type="text" id="'+name+'" name="'+name+'" '+(readonly?"readonly='readonly'":"")+' class="calc" />';
		KE.util.insertHtml(id, clacHtml);
		if(selectNode){
			$(selectNode).remove();
		}else{
			eleCounter.calc ++;
		}
		this.dialog.hide();
		KE.util.focus(id);
	}
};
KE.plugin['general'] = {
	getSelectedNode : function(id) {
		return KE.getCommonAncestor(KE.g[id].keSel, "general");
	},
	generalprop : function(id) {
		this.click(id);
	},
	generaldelete : function(id) {
		var generalNode = this.getSelectedNode(id);
		var generalId = KE.$(generalNode.title+"Id",KE.g[id].iframeDoc);
		var generalSelect = KE.$(generalNode.title+"Select",KE.g[id].iframeDoc);
		generalNode.parentNode.removeChild(generalNode);
		generalId.parentNode.removeChild(generalId);
		generalSelect.parentNode.removeChild(generalSelect);
	},
	init : function(id) {
		var self = this;
		var cmds = 'prop,delete'.split(',');
		for (var i = 0, len = cmds.length; i < len; i++) {
			var name = 'general' + cmds[i];
			KE.g[id].contextmenuItems.push({
				text : KE.lang.plugins.general[cmds[i]],
				click : (function(name) {
					return function(id, menu) {
						if(/delete/.test(name)) KE.util.select(id);
						menu.hide();
						if (self[name] !== undefined) self[name](id);
						if (!/prop/.test(name)) {
							KE.util.execOnchangeHandler(id);
						}
					};
				})(name),
				cond : function(id) {
					return self.getSelectedNode(id);
				},
				options : {
					width : '170px',
					iconHtml : '<span class="icon-' + cmds[i] + '"></span>'
				}
			});
		}
		KE.g[id].contextmenuItems.push('-');
	},
	click : function(id){
		KE.util.selection(id);
		this.dialog = new KE.dialog({
			id : id,
			cmd : 'general',
			file : 'formdesign/general.html',
			width : 400,
			height : 180,
			loadingMode : true,
			title : KE.lang['general'],
			yesButton : KE.lang['yes'],
			noButton : KE.lang['no']
		});
		this.dialog.show();
	},
	exec : function(id){
		var dialogDoc = KE.util.getIframeDoc(this.dialog.iframe);
		var name = KE.$('name', dialogDoc).value;
		var width = KE.$('width',dialogDoc).value;
		var widthType = KE.$('widthType',dialogDoc).value;
		var readonly = FOD.util.getRadioValueByName('readonly',dialogDoc);
		var type = FOD.util.getRadioValueByName('type',dialogDoc);
		var style = FOD.util.getRadioValueByName('style',dialogDoc);
		var isNull = FOD.util.getRadioValueByName('isNull',dialogDoc);
		if (name == null || KE.util.trim(name) == "") {
			alert(KE.lang.plugins.date.invalidName);
			KE.$('name', dialogDoc).focus();
			return false;
		}
		if (!width.match(/^\d*$/)) {
			alert(KE.lang.util['invalidWidth']);
			width = KE.$('width',dialogDoc).focus();
			return false;
		}
		var generalHtml = '';
		var selectNode = this.getSelectedNode(id);
		vType = "";
		if(isNull == "notAllow")
			vType = "vtype='Require'";
		if(style == "mm"){
			generalHtml += '<textarea '+vType+' alt="'+(selectNode?(selectNode.getAttribute("alt")?selectNode.getAttribute("alt"):""):"")+'" ondblclick="HT_SELECT.'+type+'({\'valueDom\':\''+name+'Id\',\'textDom\':\''+name+'Name\'},'+(style=="ss"?"true":"false")+')" title="'+name+'" style="width:'+(width==""?"80%":(width+widthType))+';" id="'+name+'Name" name="'+name+'Name" '+(readonly?"readonly='readonly'":"")+' class="general">'+(selectNode?($(selectNode).val()?$(selectNode).val():""):"")+'</textarea>';
		}else{
			generalHtml += '<input '+vType+' alt="'+(selectNode?(selectNode.getAttribute("alt")?selectNode.getAttribute("alt"):""):"")+'" value="'+(selectNode?($(selectNode).val()?$(selectNode).val():""):"")+'" ondblclick="HT_SELECT.'+type+'({\'valueDom\':\''+name+'Id\',\'textDom\':\''+name+'Name\'},'+(style=="ss"?"true":"false")+')" title="'+name+'" type="text" style="width:'+(width==""?"80%":(width+widthType))+';" id="'+name+'Name" name="'+name+'Name" '+(readonly?"readonly='readonly'":"")+' class="general" />';
		}

		generalHtml += '<span id="'+name+'Select" onclick="HT_SELECT.'+type+'({\'valueDom\':\''+name+'Id\',\'textDom\':\''+name+'Name\'},'+(style=="ss"?"true":"false")+')" class="select">&nbsp;</span>';
		generalHtml += '<input class="fd_hidden" id="'+name+'Id" name="'+name+'Id" type="hidden" />';
		
		if(selectNode){
			var removeEles = [];
			removeEles.push(selectNode);
			removeEles.push(KE.$(selectNode.title+"Id",KE.g[id].iframeDoc));
			removeEles.push(KE.$(selectNode.title+"Select",KE.g[id].iframeDoc));
		}
		if(FOD.browser.IE)
			KE.util.insertHtml(id, generalHtml);
		if(selectNode){
			for(var i=0;i<removeEles.length;i++){
				$(removeEles[i]).remove();
			}
		}else{
			eleCounter.general ++;
		}
		if(!FOD.browser.IE)
			KE.util.insertHtml(id, generalHtml);
		KE.util.selection(id);
		this.dialog.hide();
		KE.util.focus(id);
	}
};
KE.plugin['data'] = {
	getSelectedNode : function(id) {
		return KE.getCommonAncestor(KE.g[id].keSel, 'data');
	},
	dataprop : function(id) {
		this.click(id);
	},
	datadelete : function(id) {
		var data = this.getSelectedNode(id);
		var dataId = KE.$(data.title+"Id",KE.g[id].iframeDoc);
		var dataSelect = KE.$(data.title+"Select",KE.g[id].iframeDoc);
		$(KE.g[id].iframeDoc).find("."+data.title).removeClass("dcontrol "+data.name);
		dataId.parentNode.removeChild(dataId);
		dataSelect.parentNode.removeChild(dataSelect);	
		data.parentNode.removeChild(data);
	},
	init : function(id) {
		var self = this;
		var cmds = 'prop,delete'.split(',');
		for (var i = 0, len = cmds.length; i < len; i++) {
			var name = 'data' + cmds[i];
			KE.g[id].contextmenuItems.push({
				text : KE.lang.plugins.data[cmds[i]],
				click : (function(name) {
					return function(id, menu) {
						if(/delete/.test(name)) KE.util.select(id);
						menu.hide();
						if (self[name] !== undefined) self[name](id);
						if (!/prop/.test(name)) {
							KE.util.execOnchangeHandler(id);
						}
					};
				})(name),
				cond : function(id) {
					return self.getSelectedNode(id);
				},
				options : {
					width : '170px',
					iconHtml : '<span class="icon-' + cmds[i] + '"></span>'
				}
			});
		}
		KE.g[id].contextmenuItems.push('-');
	},
	click : function(id){
		KE.util.selection(id);
		this.dialog = new KE.dialog({
			id : id,
			cmd : 'data',
			file : 'formdesign/data.html',
			width : 800,
			height : 350,
			loadingMode : true,
			title : KE.lang['data'],
			yesButton : KE.lang['yes'],
			noButton : KE.lang['no']
		});
		this.dialog.show();
	},
	exec : function(id){
		var dialogDoc = KE.util.getIframeDoc(this.dialog.iframe);
		var name = KE.$('name', dialogDoc).value;
		var width = KE.$('width',dialogDoc).value;
		var widthType = KE.$('widthType',dialogDoc).value;
		var tablespace = KE.$('tablespace',dialogDoc).value;
		var table = KE.$('table',dialogDoc).value;
		var dfield = FOD._$('dfield',dialogDoc);
		var dwidget = FOD._$('dwidget',dialogDoc);
		var dfield_zh = FOD._$('dfield_zh',dialogDoc);
		var dsearch = FOD._$('dsearch',dialogDoc);
		var dsort = FOD._$('dsort',dialogDoc);
		var isNull = FOD.util.getRadioValueByName('isNull',dialogDoc);
		if (name == null || KE.util.trim(name) == "") {
			alert(KE.lang.plugins.date.invalidName);
			KE.$('name', dialogDoc).focus();
			return false;
		}
		if (!width.match(/^\d*$/)) {
			alert(KE.lang.util['invalidWidth']);
			width = KE.$('width',dialogDoc).focus();
			return false;
		}
		var selectNode = this.getSelectedNode(id);
		if(selectNode){
			$(KE.g[id].iframeDoc).find("."+selectNode.title).removeClass("dcontrol "+selectNode.title);
			var removeEles = [];
			removeEles.push(selectNode);
			removeEles.push(KE.$(selectNode.title+"Id",KE.g[id].iframeDoc));
			removeEles.push(KE.$(selectNode.title+"Select",KE.g[id].iframeDoc));
		}
		var click = "HT_DATA_SELECT.dataSelect({'valueDom':'"+name+"Name','textDom':'"+name+"Id','tablespace':'"+tablespace+"','table':'"+table+"'";
		var search = [];
		var sort = [];
		for(var i=0;i<dfield.length;i++){
			$(KE.g[id].iframeDoc).find("[name="+dwidget[i].value+"]").addClass("dcontrol "+name);
			click += ",'"+dwidget[i].value+"':['"+dfield[i].value+"','"+dfield_zh[i].value+"']";
			//模糊查询和排序
			if(dsearch[i].checked) search.push("'"+dsearch[i].value+"'");
			if(dsort[i].checked) sort.push("'"+dsort[i].value+"'");
		}
		click += ",search:["+search+"],sort:["+sort+"]";
		click += "})";
		vType = "";
		if(isNull == "notAllow")
			vType = "vtype='Require'";
		var dataHtml = '<input '+vType+' alt="'+(selectNode?(selectNode.getAttribute("alt")?selectNode.getAttribute("alt"):""):"")+'" value="'+(selectNode?($(selectNode).val()?$(selectNode).val():""):"")+'" type="text" title="'+name+'" ondblclick="'+click+'" id="'+name+'Name" style="width:'+(width==""?"80%":(width+widthType))+';" name="'+name+'Name" class="data dcontrol" />';
		dataHtml += '<span id="'+name+'Select" onclick="'+click+'" class="select">&nbsp;</span>';
		dataHtml += '<input class="fd_hidden" id="'+name+'Id" name="'+name+'Id" type="hidden" />';
		KE.util.insertHtml(id, dataHtml);
		if(selectNode){
			for(var i=0;i<removeEles.length;i++){
				$(removeEles[i]).remove();
			}
		}else{
			eleCounter.data ++;
		}
		this.dialog.hide();
		KE.util.focus(id);
	}
};
KE.plugin['macro'] = {
	getSelectedNode : function(id) {
		return KE.getCommonAncestor(KE.g[id].keSel, 'macro');
	},
	macroprop : function(id) {
		this.click(id);
	},
	macrodelete : function(id) {
		var macro = this.getSelectedNode(id);
		macro.removeAttribute("alt");
		if(macro.tagName.toLowerCase() == "select"){
			macro.options.length = 0;
			macro.options[0] = new Option("--请选择--","");
		}else if(macro.tagName.toLowerCase() == "textarea"){
			macro.innerHTML = "";
		}else{
			macro.setAttribute("value","");
		}
	},
	init : function(id) {
		var self = this;
		var cmds = 'prop,delete'.split(',');
		for (var i = 0, len = cmds.length; i < len; i++) {
			var name = 'macro' + cmds[i];
			KE.g[id].contextmenuItems.push({
				text : KE.lang.plugins.macro[cmds[i]],
				click : (function(name) {
					return function(id, menu) {
						if(/delete/.test(name)) KE.util.select(id);
						menu.hide();
						if (self[name] !== undefined) self[name](id);
						if (!/prop/.test(name)) {
							KE.util.execOnchangeHandler(id);
						}
					};
				})(name),
				cond : function(id) {
					return self.getSelectedNode(id);
				},
				options : {
					width : '170px',
					iconHtml : '<span class="icon-' + cmds[i] + '"></span>'
				}
			});
		}
		KE.g[id].contextmenuItems.push('-');
	},
	click : function(id){
		KE.util.selection(id);
		this.dialog = new KE.dialog({
			id : id,
			cmd : 'macro',
			file : 'formdesign/macro.html',
			width : 500,
			height : 210,
			loadingMode : true,
			title : KE.lang['macro'],
			yesButton : KE.lang['yes'],
			noButton : KE.lang['no']
		});
		this.dialog.show();
	},
	exec : function(id){
		var dialogDoc = KE.util.getIframeDoc(this.dialog.iframe);
		var name = KE.$('name', dialogDoc).value;
		var obj = KE.$('obj', dialogDoc).value;
		var type = KE.$('type', dialogDoc).value;
		var query = KE.$('query', dialogDoc).value; 
		if (name == null || KE.util.trim(name) == "") {
			alert(KE.lang.plugins.macro.invalidName);
			KE.$('name', dialogDoc).focus();
			return false;
		}
		if (obj == null || KE.util.trim(obj) == "") {
			alert(KE.lang.plugins.macro.invalidObj);
			KE.$('obj', dialogDoc).focus();
			return false;
		}
		var macro = $(KE.g[id].iframeDoc).find("[name="+obj+"]")[0];
		if (!macro){
			alert(KE.lang.plugins.macro.invalidNoObj);
			KE.$('obj', dialogDoc).focus();
			return false;
		}
		if(!KE.util.inArray(macro.tagName.toLowerCase(),["input","textarea","select"])){
			alert(KE.lang.plugins.macro.invalidDisObj);
			KE.$('obj', dialogDoc).focus();
			return false;
		}
		if(macro){
			macro.setAttribute("alt","{'macro':'"+name+"','type':'"+type+"','value':'"+query.replace(/\'/g,"\\'")+"'}");
			if(macro.tagName.toLowerCase() == "select"){
				macro.options.length = 0;
				macro.options[0] = new Option("{宏控件}","");
			}else if(macro.tagName.toLowerCase() == "textarea"){
				macro.innerHTML = "{宏控件}";
			}else{
				macro.setAttribute("value","{宏控件}");
			}
		}
		this.dialog.hide();
		KE.util.focus(id);
	}
};

KE.plugin['save'] = {
	click : function() {
		var source = KE.html('content');
		/*source = source.replace(/</ig,"&lt;");
		source = source.replace(/>/ig,"&gt;");
		source = source.replace(/\'/ig,"&#39;");
		source = source.replace(/\"/ig,"&#34;");*/
		var name = $(KE.g['content'].iframeDoc).find("h1,h2,h3,h4").html() || "新建表单";
		var dialog = new KE.dialog({
			id : 'content',
			cmd : 'load',
			file : 'formdesign/loading.html',
			width : 100,
			height : 30,
			loadingMode : true,
			closeMode : true,
			title : '操作中，请稍后...'
		});
		dialog.show();
		$.ajax({
			url: "FormDesignAction!save.action",
			type: 'POST',
			data: {"formDesignId":formDesignId,"formDesignName":name,"formDesignSource":source},
			complete: function(response,status){
				dialog.hide();
				if(status == "success"){
					formDesignId = response.responseText;
					window.opener.location.reload();
					location.href = 'FormDesignAction!edit.action?action=FormDesignAction&formDesignId='+formDesignId;
					alert("保存成功！");
				}else{
					alert("保存失败！");
				}
			}
		});
	}
};
KE.plugin['preview'] = {
	click : function() {
		KE.util.selection('content');
		this.dialog = new KE.dialog({
			id : 'content',
			cmd : 'preview',
			file : 'formdesign/preview.jsp?htUrl='+htUrl,
			width : 800,
			height : 400,
			loadingMode : true,
			title : KE.lang['preview'],
			noButton : KE.lang['no']
		});
		this.dialog.show();
	}
};
KE.plugin['close'] = {
	click : function() {
		window.close();
	}
};
//将kindeditor.js中原本的插件'advtable'移到外部formdesign.js，使表格的右键菜单处于最下方
KE.plugin['advtable'] = {
	// 取得下一行cell的index
	_getCellIndex : function(table, row, cell) {
		var rowSpanCount = 0;
		for (var i = 0, len = row.cells.length; i < len; i++) {
			if (row.cells[i] == cell) {
				break;
			}
			rowSpanCount += row.cells[i].rowSpan - 1;
		}
		return cell.cellIndex - rowSpanCount;
	},
	getSelectedTable : function(id) {
		return KE.getCommonAncestor(KE.g[id].keSel, 'table');
	},
	getSelectedRow : function(id) {
		return KE.getCommonAncestor(KE.g[id].keSel, 'tr');
	},
	getSelectedCell : function(id) {
		return KE.getCommonAncestor(KE.g[id].keSel, 'td');
	},
	tableprop : function(id) {
		this.click(id);
	},
	tablecellprop : function(id){
		KE.util.selection(id);
		var celldialog = new KE.dialog({
			id : id,
			cmd : 'cell',
			file : 'advtable/tablecell.html',
			width : 420,
			height : 150,
			loadingMode : true,
			title : KE.lang['cell'],
			noButton : KE.lang['no'],
			customButton : {
				name : KE.lang['yes'],
				bdial : this.dial,
				click : function() {
					var dialogDoc = KE.util.getIframeDoc(celldialog.iframe);
					var width = KE.$('width',dialogDoc).value;
					var widthType = KE.$('widthType',dialogDoc).value;
					var height = KE.$('height',dialogDoc).value;
					var heightType = KE.$('heightType',dialogDoc).value;
					var align = KE.$('align',dialogDoc).value;
					var valign = KE.$('valign',dialogDoc).value;
					var border = KE.$('border',dialogDoc).value;
					var borderColor = KE.$('borderColor', dialogDoc).innerHTML;
					var bgColor = KE.$('backgroundColor', dialogDoc).innerHTML;
					if (!/^\d*$/.test(width)) {
						alert(KE.lang.util['invalidWidth']);
						KE.$('widthType',dialogDoc).focus();
						return;
					}
					if (!/^\d*$/.test(height)) {
						alert(KE.lang.util['invalidHeight']);
						 KE.$('height',dialogDoc).focus();
						return;
					}
					if (!/^\d*$/.test(border)) {
						alert(KE.lang.util['invalidBorder']);
						KE.$('border',dialogDoc).focus();
						return;
					}
					var cell = KE.plugin.advtable.getSelectedCell(id);
					$(cell).css({
						width : width !== '' ? (width + widthType) : '',
						height : height !== '' ? (height + heightType) : '',
						'background-color' : bgColor,
						'text-align' : align,
						'vertical-align' : valign,
						'border-right-width' : border,
						'border-bottom-width' : border,
						'border-color' : borderColor
					});
					celldialog.hide();
				}
			}
		});
		celldialog.show();
	},
	tableinsert : function(id) {
		this.click(id, 'insert');
	},
	tabledelete : function(id) {
		var table = this.getSelectedTable(id);
		table.parentNode.removeChild(table);
	},
	tablecolinsert : function(id, offset) {
		var table = this.getSelectedTable(id),
			cell = this.getSelectedCell(id),
			index = cell.cellIndex + offset;
		for (var i = 0, len = table.rows.length; i < len; i++) {
			var newCell = table.rows[i].insertCell(index);
			newCell.innerHTML = '&nbsp;';
		}
	},
	tablecolinsertleft : function(id) {
		this.tablecolinsert(id, 0);
	},
	tablecolinsertright : function(id) {
		this.tablecolinsert(id, 1);
	},
	tablerowinsert : function(id, offset) {
		var table = this.getSelectedTable(id),
			row = this.getSelectedRow(id),
			newRow = table.insertRow(row.rowIndex + offset);
		for (var i = 0, len = row.cells.length; i < len; i++) {
			var cell = newRow.insertCell(i);
			cell.innerHTML = '&nbsp;';
		}
	},
	tablerowinsertabove : function(id) {
		this.tablerowinsert(id, 0);
	},
	tablerowinsertbelow : function(id) {
		this.tablerowinsert(id, 1);
	},
	tablerowmerge : function(id) {
		var table = this.getSelectedTable(id),
			row = this.getSelectedRow(id),
			cell = this.getSelectedCell(id),
			rowIndex = row.rowIndex, // 当前行的index
			nextRowIndex = rowIndex + cell.rowSpan, // 下一行的index
			nextRow = table.rows[nextRowIndex]; // 下一行
		// 最后一行不能合并
		if (table.rows.length <= nextRowIndex) {
			return;
		}
		var cellIndex = this._getCellIndex(table, row, cell); // 下一行单元格的index
		if (nextRow.cells.length <= cellIndex) {
			return;
		}
		var nextCell = nextRow.cells[cellIndex]; // 下一行单元格
		// 上下行的colspan不一致时不能合并
		if (cell.colSpan !== nextCell.colSpan) {
			return;
		}
		cell.rowSpan += nextCell.rowSpan;
		nextRow.deleteCell(cellIndex);
	},
	tablecolmerge : function(id) {
		var table = this.getSelectedTable(id),
			row = this.getSelectedRow(id),
			cell = this.getSelectedCell(id),
			rowIndex = row.rowIndex, // 当前行的index
			cellIndex = cell.cellIndex,
			nextCellIndex = cellIndex + 1;
		// 最后一列不能合并
		if (row.cells.length <= nextCellIndex) {
			return;
		}
		var nextCell = row.cells[nextCellIndex];
		// 左右列的rowspan不一致时不能合并
		if (cell.rowSpan !== nextCell.rowSpan) {
			return;
		}
		cell.colSpan += nextCell.colSpan;
		row.deleteCell(nextCellIndex);
	},
	tablerowsplit : function(id){
		var table = this.getSelectedTable(id),
			row = this.getSelectedRow(id),
			cell = this.getSelectedCell(id),
			rowIndex = row.rowIndex;
		// 不是可分割单元格
		if (cell.rowSpan === 1) {
			return;
		}
		var cellIndex = this._getCellIndex(table, row, cell);
		for (var i = 1, len = cell.rowSpan; i < len; i++) {
			var newRow = table.rows[rowIndex + i],
				newCell = newRow.insertCell(cellIndex);
			if (cell.colSpan > 1) {
				newCell.colSpan = cell.colSpan;
			}
			newCell.innerHTML = KE.browser.IE ? '' : '<br />';
			// 调整下一行的单元格index
			cellIndex = this._getCellIndex(table, newRow, newCell);
		}
		cell.removeAttribute('rowSpan');
	},
	tablecolsplit : function(id){
		var table = this.getSelectedTable(id),
			row = this.getSelectedRow(id),
			cell = this.getSelectedCell(id),
			cellIndex = cell.cellIndex;
		// 不是可分割单元格
		if (cell.colSpan === 1) {
			return;
		}
		for (var i = 1, len = cell.colSpan; i < len; i++) {
			var newCell = row.insertCell(cellIndex + i);
			if (cell.rowSpan > 1) {
				newCell.rowSpan = cell.rowSpan;
			}
			newCell.innerHTML = KE.browser.IE ? '' : '<br />';
		}
		cell.removeAttribute('colSpan');
	},
	tablecoldelete : function(id) {
		var table = this.getSelectedTable(id);
		var cell = this.getSelectedCell(id);
		for (var i = 0, len = table.rows.length; i < len; i++) {
			table.rows[i].deleteCell(cell.cellIndex);
		}
	},
	tablerowdelete : function(id) {
		var table = this.getSelectedTable(id);
		var row = this.getSelectedRow(id);
		table.deleteRow(row.rowIndex);
	},
	init : function(id) {
		var self = this;
		var zeroborder = 'ke-zeroborder';
		var tableCmds = 'prop,cellprop,colinsertleft,colinsertright,rowinsertabove,rowinsertbelow,rowmerge,colmerge,rowsplit,colsplit,coldelete,rowdelete,insert,delete'.split(',');
		for (var i = 0, len = tableCmds.length; i < len; i++) {
			var name = 'table' + tableCmds[i];
			KE.g[id].contextmenuItems.push({
				text : KE.lang[name],
				click : (function(name) {
					return function(id, menu) {
						KE.util.select(id);
						menu.hide();
						if (self[name] !== undefined) self[name](id);
						if (!/prop/.test(name)) {
							KE.util.execOnchangeHandler(id);
						}
					};
				})(name),
				cond : (function(name) {
					if (KE.util.inArray(name, ['tableprop', 'tabledelete'])) {
						return function(id) {
							return self.getSelectedTable(id);
						};
					} else {
						return function(id) {
							return self.getSelectedCell(id);
						};
					}
				})(name),
				options : {
					width : '170px',
					iconHtml : '<span class="ke-common-icon ke-common-icon-url ke-icon-' + name + '"></span>'
				}
			});
		}
		KE.g[id].contextmenuItems.push('-');
		KE.g[id].setHtmlHooks.push(function(html) {
			return html.replace(/<table([^>]*)>/ig, function($0, $1) {
				if ($1.match(/\s+border=["']?(\d*)["']?/ig)) {
					var border = RegExp.$1;
					if ($1.indexOf(zeroborder) < 0 && (border === '' || border === '0')) {
						return KE.addClass($0, zeroborder);
					} else {
						return $0;
					}
				} else {
					return KE.addClass($0, zeroborder);
				}
			});
		});
	},
	click : function(id, mode) {
		mode = mode || 'default';
		var cmd = 'advtable';
		KE.util.selection(id);
		this.dialog = new KE.dialog({
			id : id,
			cmd : cmd,
			file : 'advtable/advtable.html?mode=' + mode,
			width : 420,
			height : 220,
			loadingMode : true,
			title : KE.lang['advtable'],
			yesButton : KE.lang['yes'],
			noButton : KE.lang['no']
		});
		this.dialog.show();
	},
	exec : function(id) {
		var zeroborder = 'ke-zeroborder';
		var dialogDoc = KE.util.getIframeDoc(this.dialog.iframe);
		var modeBox = KE.$('mode', dialogDoc);
		var rowsBox = KE.$('rows', dialogDoc);
		var colsBox = KE.$('cols', dialogDoc);
		var widthBox = KE.$('width', dialogDoc);
		var heightBox = KE.$('height', dialogDoc);
		var widthTypeBox = KE.$('widthType', dialogDoc);
		var heightTypeBox = KE.$('heightType', dialogDoc);
		var paddingBox = KE.$('padding', dialogDoc);
		var spacingBox = KE.$('spacing', dialogDoc);
		var alignBox = KE.$('align', dialogDoc);
		var borderBox = KE.$('border', dialogDoc);
		var borderColorBox = KE.$('borderColor', dialogDoc);
		var backgroundColorBox = KE.$('backgroundColor', dialogDoc);
		var rows = rowsBox.value;
		var cols = colsBox.value;
		var width = widthBox.value;
		var height = heightBox.value;
		var widthType = widthTypeBox.value;
		var heightType = heightTypeBox.value;
		var padding = paddingBox.value;
		var spacing = spacingBox.value;
		var align = alignBox.value;
		var border = borderBox.value;
		var borderColor = borderColorBox.innerHTML;
		var backgroundColor = backgroundColorBox.innerHTML;
		if (rows == '' || rows == 0 || !rows.match(/^\d*$/)) {
			alert(KE.lang['invalidRows']);
			rowsBox.focus();
			return false;
		}
		if (cols == '' || cols == 0 || !cols.match(/^\d*$/)) {
			alert(KE.lang['invalidCols']);
			colsBox.focus();
			return false;
		}
		if (!width.match(/^\d*$/)) {
			alert(KE.lang['invalidWidth']);
			widthBox.focus();
			return false;
		}
		if (!height.match(/^\d*$/)) {
			alert(KE.lang['invalidHeight']);
			heightBox.focus();
			return false;
		}
		if (!padding.match(/^\d*$/)) {
			alert(KE.lang['invalidPadding']);
			paddingBox.focus();
			return false;
		}
		if (!spacing.match(/^\d*$/)) {
			alert(KE.lang['invalidSpacing']);
			spacingBox.focus();
			return false;
		}
		if (!border.match(/^\d*$/)) {
			alert(KE.lang['invalidBorder']);
			borderBox.focus();
			return false;
		}
		if (modeBox.value === 'update') {
			var table = this.getSelectedTable(id);
			if (width !== '') {
				table.style.width = width + widthType;
			} else if (table.style.width) {
				table.style.width = '';
			}
			if (table.width !== undefined) {
				table.removeAttribute('width');
			}
			if (height !== '') {
				table.style.height = height + heightType;
			} else if (table.style.height) {
				table.style.height = '';
			}
			if (table.height !== undefined) {
				table.removeAttribute('height');
			}
			if (backgroundColor !== '') {
				table.style.backgroundColor = backgroundColor;
			} else if (table.style.backgroundColor) {
				table.style.backgroundColor = '';
			}
			if (table.bgColor !== undefined) {
				table.removeAttribute('bgColor');
			}
			if (padding !== '') {
				table.cellPadding = padding;
			} else {
				table.removeAttribute('cellPadding');
			}
			if (spacing !== '') {
				table.cellSpacing = spacing;
			} else {
				table.removeAttribute('cellSpacing');
			}
			if (align !== '') {
				table.align = align;
			} else {
				table.removeAttribute('align');
			}
			if (border === '' || border === '0') {
				KE.addClass(table, zeroborder);
			} else {
				KE.removeClass(table, zeroborder);
			}
			if (border !== '') {
				table.setAttribute('border', border);
			} else {
				table.removeAttribute('border');
			}
			if (borderColor !== '') {
				table.setAttribute('borderColor', borderColor);
			} else {
				table.removeAttribute('borderColor');
			}
			KE.util.execOnchangeHandler(id);
		} else {
			var style = '';
			if (width !== '') style += 'width:' + width + widthType + ';';
			if (height !== '') style += 'height:' + height + heightType + ';';
			if (backgroundColor !== '') style += 'background-color:' + backgroundColor + ';';
			var html = '<table';
			if (style !== '') html += ' style="' + style + '"';
			if (padding !== '') html += ' cellpadding="' + padding + '"';
			if (spacing !== '') html += ' cellspacing="' + spacing + '"';
			if (align !== '') html += ' align="' + align + '"';
			if (border === '' || border === '0') html += ' class="' + zeroborder + '"';
			if (border !== '') html += ' border="' + border + '"';
			if (borderColor !== '') html += ' bordercolor="' + borderColor + '"';
			html += '>';
			for (var i = 0; i < rows; i++) {
				html += '<tr>';
				for (var j = 0; j < cols; j++) {
					html += '<td>&nbsp;</td>';
				}
				html += '</tr>';
			}
			html += '</table>';
			KE.util.insertHtml(id, html);
		}
		this.dialog.hide();
		KE.util.focus(id);
	}
};

