<%@ page language="java" import="java.util.*"   pageEncoding="utf-8" %>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<%@include file="jquerySession.jsp"%> 
<script type="text/javascript" src="<%=htSystemPath%>js/jquery/jquery.form.js"></script>
<title><%=global_title%></title>
<script	type="text/javascript">
	function sq(){
		if(!$("#lcfile").val()){
			alert("请选择授权文件!");
			return;
		}
		$("#form1").ajaxSubmit({
			url:"LoginAction!register.action",
			cache:false,
			contentType:"text/html",
			dataType:"json",
			success:function(data){
				if(data.result=="success"){
					alert("注册成功!");
					window.location.reload();
				}
				else{
					if(data.msg){
						alert(data.msg);
					}
					else
						alert("注册失败,可能授权文件无效!");
				}
			},
			error:function(){
				alert("注册失败,可能授权文件无效!");
			}
		});
	}
</script>
</head>
<body>
<form id="form1">
	<table cellspacing="0" class="ftable" cellpadding="0" border="0" align="center" style="width: 700px;margin-top: 50px;">
				<tr>
					<td class="tdTitle" colspan="2">
						授权信息
					</td>
				</tr>
				<tr >
					<td class="tdLabelTitle" width="20%">授权状态:&nbsp;</td>
					<td class="tdLabelContent"  >${isValid?"已授权":"未授权"}</td>
				</tr>
				<c:if test="${isValid}">
					<tr>
						<td class="tdLabelTitle" width="20%">
							授权给：
						</td>
						<td class="tdLabelContent">
							${licenseInfo.customerName}
						</td>
					</tr>
					<tr>
						<td class="tdLabelTitle" width="20%">
							最大用户数：
						</td>
						<td class="tdLabelContent">
							${licenseInfo.maxUserCount}
						</td>
					</tr>
					<tr>
						<td class="tdLabelTitle" width="20%">
							授权时间：
						</td>
						<td class="tdLabelContent">
							<fmt:formatDate pattern="yyyy年MM月dd日" value="${licenseInfo.buyDate}"  />
						</td>
					</tr>
					<tr>
						<td class="tdLabelTitle" width="20%">
							续维时间：
						</td>
						<td class="tdLabelContent">
							<fmt:formatDate pattern="yyyy年MM月dd日" value="${licenseInfo.serviceEnd}"  />
						</td>
					</tr>
					<tr>
						<td class="tdLabelTitle" width="20%">
							客户编号：
						</td>
						<td class="tdLabelContent">
							${licenseInfo.customerID}&nbsp;
						</td>
					</tr>
					<tr>
						<td class="tdLabelTitle" width="20%">
							购买人：
						</td>
						<td class="tdLabelContent">
							${licenseInfo.buyer}&nbsp;
						</td>
					</tr>
				</c:if>
				<c:if test="${!isValid||isAdmin}">
					<tr>
						<td class="tdLabelTitle" width="20%">授权文件：&nbsp;</td>
						<td class="tdLabelContent"  >
							<input id="lcfile" class="uploadBox" name="file" type="file" style="width: 400px;" />
							<input type="button" onclick="sq()" value="${isValid?'重新注册':'注册'}" />
						</td>
					</tr>
				</c:if>
			</table>
		</form>
	</body>
</html>