# 组件默认属性
> 鲁班向自定义组件 默认注入了一些属性，便于开发

### editorMode 编辑器当前模式
  *  preview: 预览模式
  *  edit:   编辑模式

```js
props: {
  editorMode: {
    type: String,
    default: 'edit'
  },
}
```


```js
/**
  * #!zh: 编辑器当前模式：
  *  preview: 预览模式
  *  edit:   编辑模式
  *
  *  通常用在轮播图、单选、多选、提交按钮、视频
  *  因为他们在编辑模式和预览模式下有不同的表现
  *
  *  举例：
  * ================================================================================================================================
  * | 组件名称         |  编辑模式表现               |    预览模式表现                |
  * ================================================================================================================================
  * | 轮播图           |   正在编辑的图片            |      轮播图                   |
  * --------------------------------------------------------------------------------------------------------------------------------
  * | 提交按钮         |   仅可点击, 但不会提交表单    |      可点击, 且可以提交表单     |
  * --------------------------------------------------------------------------------------------------------------------------------
  * | 视频            |   视频占位 icon             |      可播放的视频              |
  * --------------------------------------------------------------------------------------------------------------------------------
  *
  *
  *
  * #!en: current mode for editor
  *  preview: preview mode
  *  edit:    edit mode
  *
  *  commonly used for carousel, checkbox, radio, form submit button、video etc...
  *  Because they have different behaviour in edit mode and preview mode.
  *
  *  Examples:
  * ================================================================================================================================
  * |  Component            |    Edit Mode Behaviour                           |  Preview Mode Behaviour               |
  * ================================================================================================================================
  * |  carousel             |    editing image                                 |  carousel                             |
  * --------------------------------------------------------------------------------------------------------------------------------
  * |  form submit button   |    only clickable, but will not submit the form  |  clickable, can submit the form       |
  * --------------------------------------------------------------------------------------------------------------------------------
  * |  video                |    video placeholder icon                        |  playable video                       |
  * --------------------------------------------------------------------------------------------------------------------------------
  *
  */
```