
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
		Asset("ANIM", "anim/player_wolfgang.zip"),
		Asset("ANIM", "anim/player_wolfgang.zip"),


		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/unik.zip" ),
		Asset( "ANIM", "anim/unik_ins.zip" ),
		Asset( "ANIM", "anim/unik_bus.zip" ),
		Asset( "ANIM", "anim/unik_puk.zip" ),
}
local prefabs = {}


local function applymightiness(inst)

	local scale = 1

	local mighty_scale = 1
	local wimpy_scale = 1


	if inst.strength == "mighty" then
		inst.AnimState:SetBuild("unik_bus")
	elseif inst.strength == "wimpy" then
		inst.AnimState:SetBuild("unik_puk")	
	end

end

local function onhungerchange(inst, data)

	local silent = POPULATING

	if inst.strength == "mighty" then
		if inst.components.hunger.current < 100 then
			inst.strength = "normal"
			inst.AnimState:SetBuild("unik")
			inst:ListenForEvent("sanitydelta", sanitycheck)
			if not silent then
				inst.components.talker:Say("I feel a bit hungry, this is not silly bizniz!")
				inst.sg:PushEvent("powerdown")
			end
		end
	elseif inst.strength == "wimpy" then
		if inst.components.hunger.current > 50 then
			inst.strength = "normal"
			inst:ListenForEvent("sanitydelta", sanitycheck)
			if not silent then
				inst.components.talker:Say("I feel better now!")
				inst.sg:PushEvent("powerup")
			end
			inst.AnimState:SetBuild("unik")
		end
	else
		if inst.components.hunger.current > 100 then
			inst.strength = "mighty"
			inst:ListenForEvent("sanitydelta", sanitycheck)
			inst.AnimState:SetBuild("unik_bus")
			if not silent then
				print ("mighty!", GetTime(), debugstack())
				inst.components.talker:Say("Time for bizniz!")
				inst.sg:PushEvent("powerup")
			end

		elseif inst.components.hunger.current < 50 then
			inst.strength = "wimpy"
			inst.AnimState:SetBuild("unik_puk")
			if not silent then
				inst.sg:PushEvent("powerdown")
				inst.components.talker:Say("I'm so hungry I could puke!")
			end
		end
	end
	end


local function sanitycheck(inst)
local Sanynitycurr = inst.components.sanity.current
local silent = POPULATING
        local attranges = 1
	
        if Sanynitycurr >= 50 then
			inst.components.combat.damagemultiplier = 0.5
			inst:ListenForEvent("hungerdelta", onhungerchange)
        else
			inst.AnimState:SetBuild("unik_ins")
			inst.components.combat.damagemultiplier = 2.5
			inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1.25)
        end
end

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "willow"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "wilson.png" )

	-- todo: Add an example special power here.
	inst.components.health.maxhealth = 120
	inst.components.health:SetPercent(1)
	inst.components.locomotor.runspeed =14
	inst.components.sanity:SetMax(TUNING.WILSON_SANITY * 0.5)
	inst.components.sanity.dapperness = 0.1
	
    --inst:ListenForEvent("sanitydelta", sanitycheck)
	inst.strength = "normal"
	applymightiness(inst)
	--inst:ListenForEvent("hungerdelta", onhungerchange)

end
	--	inst:ListenForEvent("goinsane", firekitty)
	--	inst:ListenForEvent("gosane", firekitty)

STRINGS.CHARACTERS.UNIK = require "speech_unik"
table.insert(CHARACTER_GENDERS.FEMALE, "unik")

return MakePlayerCharacter("unik", prefabs, assets, fn)
