local assets =
{
    Asset("ANIM", "anim/mf.zip"),
    Asset("ANIM", "anim/swap_mf.zip"),
	Asset("IMAGE","images/inventoryimages/mf.tex"),
	Asset("ATLAS","images/inventoryimages/mf.xml")
}

local function onequip(inst, owner)
	inst.Light:Enable(true)
    owner.AnimState:OverrideSymbol("swap_object", "swap_mf", "swap_mf")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
	
end

local function onunequip(inst, owner)
	inst.Light:Enable(true)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
	
end

local function onfinished(inst)
    inst:Remove()
end

local function onattack(inst, owner, target)
	 
        if target and target.components.health and not target.components.health:IsDead() then
			local pos = target:GetPosition()
			SpawnPrefab("lightning").Transform:SetPosition(pos.x,pos.y,pos.z)
			target.components.health:DoDelta(-30)
		end
   
		
	
	if owner.components.sanity and owner.components.sanity:GetPercent() < 1 and not target:HasTag("wall") then
        owner.components.sanity:DoDelta(1)
    end

end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
	inst.entity:AddLight()
    inst.entity:AddNetwork()
	
    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("mf")
    inst.AnimState:SetBuild("mf")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")

    inst.entity:SetPristine()	
	local light = inst.entity:AddLight()
	inst.Light:SetIntensity(0.5)
	inst.Light:SetRadius(1)
	inst.Light:SetFalloff(0.3)
	inst.Light:SetColour(101/255,196/255,210/255)
	inst.Light:Enable(true)

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(60)
    inst.components.weapon.onattack = onattack
    inst.components.weapon:SetRange(2.5, 2.5)
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(500)
    inst.components.finiteuses:SetUses(500)
	
    inst.components.finiteuses:SetOnFinished(onfinished)

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "mf"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/mf.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	inst.components.equippable.walkspeedmult = 1.1



    MakeHauntableLaunch(inst)

    return inst
end

return Prefab( "common/inventory/mf", fn, assets)