PrefabFiles = {
	"rem",
	"rem_bola",
	"rem_meal",
	"rem_armor",
	"rem_icespike",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/rem.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/rem.xml" ),

    Asset( "IMAGE", "bigportraits/rem.tex" ),
    Asset( "ATLAS", "bigportraits/rem.xml" ),
	
	Asset( "IMAGE", "images/map_icons/rem.tex" ),
	Asset( "ATLAS", "images/map_icons/rem.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_rem.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_rem.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_rem.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_rem.xml" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

-- The character select screen lines
STRINGS.CHARACTER_TITLES.rem = "Rem(蕾姆)"
STRINGS.CHARACTER_NAMES.rem = "Rem"
STRINGS.CHARACTER_DESCRIPTIONS.rem = "*鬼族血统\n*吃红宝石升级\n*有专属道具"
STRINGS.CHARACTER_QUOTES.rem = "\"Quote\""

-- Custom speech strings
STRINGS.CHARACTERS.REM = require "speech_rem"

-- The character's name as appears in-game 
STRINGS.NAMES.REM = "Rem"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.REM = 
{
	GENERIC = "It's Rem!",
	ATTACKER = "That Rem looks shifty...",
	MURDERER = "Murderer!",
	REVIVER = "Rem, friend of ghosts.",
	GHOST = "Rem could use a heart.",
}

-- Import the engine.
modimport("engine.lua")

-- Imports to keep the keyhandler from working while typing in chat.
Load "chatinputscreen"
Load "consolescreen"
Load "textedit"

AddMinimapAtlas("images/map_icons/rem.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("rem", "FEMALE")


----全局变量声明
local _G = GLOBAL
local TimeEvent = _G.TimeEvent
local FRAMES = _G.FRAMES
local EQUIPSLOTS = _G.EQUIPSLOTS
local EventHandler = _G.EventHandler
local GetWorld = _G.GetWorld
local SpawnPrefab = _G.SpawnPrefab
local State = _G.State
local DEGREES = _G.DEGREES
local Vector3 = _G.Vector3
local STRINGS = _G.STRINGS
local ACTIONS = _G.ACTIONS
local FOODTYPE = _G.FOODTYPE
local TheNet = _G.TheNet
local TheSim = _G.TheSim
local ProfileStatsAdd = GLOBAL.ProfileStatsAdd

local remtab = AddRecipeTab("Rem", 667, "images/remtab.xml", "remtab.tex", "rembuilder")

--流星锤
local rem_bola = AddRecipe("rem_bola",
{GLOBAL.Ingredient("stinger", 3), GLOBAL.Ingredient("houndstooth", 3)}, 
remtab, GLOBAL.TECH.NONE,
nil, nil, nil, nil, "rembuilder",
"images/rem_bola.xml", "rem_bola.tex")
STRINGS.NAMES.REM_BOLA = "蕾姆的流星锤"
STRINGS.RECIPE_DESC.REM_BOLA = "50damage,150uses"

--豪华大餐
local rem_meal = AddRecipe("rem_meal",
{GLOBAL.Ingredient("meat", 1), GLOBAL.Ingredient("smallmeat", 1), GLOBAL.Ingredient("monstermeat", 1)}, 
remtab, GLOBAL.TECH.NONE,
nil, nil, nil, nil, "rembuilder",
"images/rem_meal.xml", "rem_meal.tex")
STRINGS.NAMES.REM_MEAL = "蕾姆的豪华大餐"
STRINGS.RECIPE_DESC.REM_MEAL = "+50HP,+50Hunger"

--爱心料理
local rem_meal2 = AddRecipe("rem_meal2",
{GLOBAL.Ingredient("red_cap", 1), GLOBAL.Ingredient("green_cap", 1), GLOBAL.Ingredient("blue_cap", 1)}, 
remtab, GLOBAL.TECH.NONE,
nil, nil, nil, nil, "rembuilder",
"images/rem_meal2.xml", "rem_meal2.tex")
STRINGS.NAMES.REM_MEAL2 = "蕾姆的爱心料理"
STRINGS.RECIPE_DESC.REM_MEAL2 = "+50HP,+50Hunger"

--女仆装
STRINGS.NAMES.REM_ARMOR = "蕾姆的女仆装"


STRINGS = GLOBAL.STRINGS
RECIPETABS = GLOBAL.RECIPETABS
Recipe = GLOBAL.Recipe
Ingredient = GLOBAL.Ingredient
TECH = GLOBAL.TECH
_G = GLOBAL

local containers = _G.require "containers"

----女仆装的容器
local params={}

--for k = 0, 4 do
	params["rem_armor"] =
	{
		widget =
		{
			slotpos = {},
			animbank = "ui_krampusbag_2x8",
			animbuild = "ui_krampusbag_2x8",
			
			--animbank = "ui_krampusbag_2x8",
			--animbuild = "rem_armor_3x8",
			
			pos = Vector3(-5, -120, 0),
		},
		issidewidget = true,
		type = "pack",
	}

	for y = 0, 6 do
		table.insert(params["rem_armor"].widget.slotpos, Vector3(-162, -75 * y + 240, 0))
		table.insert(params["rem_armor"].widget.slotpos, Vector3(-162 + 75, -75 * y + 240, 0))
		--table.insert(params["rem_armor"..k].widget.slotpos, Vector3(-162 - 75, -75 * y + 240, 0))
	end
	
	----这句话一定要加上, 这个涉及主机客机传输
	containers.MAXITEMSLOTS = math.max(containers.MAXITEMSLOTS, params["rem_armor"].widget.slotpos ~= nil and #params["rem_armor"].widget.slotpos or 0)
--end

local old_widgetsetup = containers.widgetsetup
function containers.widgetsetup(container, prefab, data)
	local pref = prefab or container.inst.prefab
	if pref == "rem_armor" then
		local t = params[pref]
		if t ~= nil then
			for k, v in pairs(t) do
				container[k] = v
			end
			container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0)
		end
	else
		return old_widgetsetup(container, prefab)
	end
end

--[[
----容器的背景
local function rem_armorfn(self) 
	
	local old_open = self.Open
	function self:Open(container, doer)
		old_open(self, container, doer)
		if container.prefab == "rem_armor" then
			self.bganim:SetScale(1.3,1,1)	
		end
	end
	
end
AddClassPostConstruct("widgets/containerwidget", rem_armorfn)]]

--[[
----网络变量
AddPrefabPostInit("rem", function(inst)
	----整型新体系
	local detail_ushortint1 = 
	{	
		"zg_detail_gunhp", 
	}
	for k, v in pairs(detail_ushortint1) do
		inst["net_"..v] = GLOBAL.net_ushortint( inst.GUID, v, v.."_dirty" )
			inst:ListenForEvent( v.."_dirty", function()
			inst[v] = inst["net_"..v]:value()
		end)
	end
	
	if GLOBAL.TheNet:GetIsServer() then
	
	end
	
end)]]

----UI
local Zg_SkillButton = require("widgets/zg_skillbutton")
local function AddSkillButton(self) 
	if self.owner and self.owner:HasTag("rem_skiller") then
	
		self.skillbutton_li = self:AddChild( Zg_SkillButton( self.owner, "images/rem_li.xml", "rem_li.tex", "rem_li.tex",35,37.5,0) )	
		self.skillbutton_su = self:AddChild( Zg_SkillButton(inst, "images/rem_su.xml", "rem_su.tex", "rem_su.tex",95,37.5,0) )
		self.skillbutton_xue = self:AddChild( Zg_SkillButton(inst, "images/rem_xue.xml", "rem_xue.tex", "rem_xue.tex",155,37.5,0) )
		
		self.skillbutton_r = self:AddChild( Zg_SkillButton(inst, "images/izayoi_theworld.xml", "izayoi_theworld.tex", "izayoi_theworld.tex",215,37.5,0) )
		
		local OnUpdate_base = self.OnUpdate
		self.OnUpdate = function(self, dt)
			OnUpdate_base(self, dt)
			----指示属性点
			local skilltable = 
			{
				"li", "su", "xue"
			}
			for k, v in pairs(skilltable) do
				if self.owner["ulevel_"..v] then
					self["skillbutton_"..v]:Zg_SetColour(0,1,0,1)
					self["skillbutton_"..v]:Zg_SetString( self.owner["ulevel_"..v] )
				end
			end
			
			if self.owner.r_skill ~= true then
				self.skillbutton_r:Zg_SetTint(0.2,0.2,0.2,1)
				self.skillbutton_r:Zg_SetColour(1,0,0,1)
				self.skillbutton_r:Zg_SetString("inCD")
			else
				self.skillbutton_r:Zg_SetTint(1,1,1,1)
				self.skillbutton_r:Zg_SetColour(0,1,0,1)
				self.skillbutton_r:Zg_SetString("R")
			end
			
		end
	
	end
end
AddClassPostConstruct("widgets/controls", AddSkillButton)


local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

local COOK = GLOBAL.ACTIONS.COOK
local old_cook_fn = COOK.fn

local resolvefilepath = GLOBAL.resolvefilepath

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local TECH = GLOBAL.TECH
local STRINGS = GLOBAL.STRINGS

--快速做饭
COOK.fn = function(act, ...)
    local result = old_cook_fn(act)
    local stewer = act.target.components.stewer
    if result and stewer ~= nil and act.doer.prefab == "rem" then
        local fn = stewer.task.fn
        stewer.task:Cancel()
        fn(act.target, stewer)
    end
end
--多倍收获
AddPrefabPostInit("cookpot", function(inst)
    if inst.components.stewer == nil then
        return
    end
    -- using the same harvest logic and repeat the item giving step once
    local old_harvest = inst.components.stewer.Harvest
    inst.components.stewer.Harvest = function(self, harvester)
        if harvester and harvester.prefab == "rem" then
            if self.done and self.product and harvester.components.inventory then
			
				local loot = nil
				local loot2 = nil
			
                loot = GLOBAL.SpawnPrefab(self.product)
				loot2 = GLOBAL.SpawnPrefab(self.product)
				
                if loot ~= nil then
                    if self.spoiltime ~= nil and loot.components.perishable ~= nil then
                        local spoilpercent = self:GetTimeToSpoil() / self.spoiltime
                        loot.components.perishable:SetPercent(self.product_spoilage * spoilpercent)
                        loot.components.perishable:StartPerishing()
                    end
                    harvester.components.inventory:GiveItem(loot, nil, self.inst:GetPosition())
					harvester:DoTaskInTime( 1*GLOBAL.FRAMES, function() 
						if harvester and harvester.components.inventory then
							harvester.components.inventory:GiveItem(loot2, nil, self.inst:GetPosition())
						end
					end)
					
                end
            end
        end
        return old_harvest(self, harvester)
    end
end)


----多倍建造东西,针对非建筑
AddComponentPostInit("builder", function(cmp)

	local old_DoBuild = cmp.DoBuild
	function cmp:DoBuild(recname, pt, rotation, skin)
		if self.inst.prefab == "rem" then
			local recipe = GLOBAL.GetValidRecipe(recname)
			if recipe ~= nil and (self:IsBuildBuffered(recname) or self:CanBuild(recname)) then
				if recipe.placer ~= nil and
					self.inst.components.rider ~= nil and
					self.inst.components.rider:IsRiding() then
					return false, "MOUNTED"
				end

				local wetlevel = self.buffered_builds[recname]
				if wetlevel ~= nil then
					self.buffered_builds[recname] = nil
					self.inst.replica.builder:SetIsBuildBuffered(recname, false)
				else
					local materials = self:GetIngredients(recname)
					wetlevel = self:GetIngredientWetness(materials)
					self:RemoveIngredients(materials, recname)
				end
				self.inst:PushEvent("refreshcrafting")

				local prod = SpawnPrefab(recipe.product, skin, nil, self.inst.userid)
				if prod ~= nil then
					
					pt = pt or self.inst:GetPosition()

					if wetlevel > 0 and prod.components.inventoryitem ~= nil then
						prod.components.inventoryitem:InheritMoisture(wetlevel, self.inst:GetIsWet())
					end

					if prod.components.inventoryitem ~= nil then
						if self.inst.components.inventory ~= nil then
							--self.inst.components.inventory:GiveItem(prod)
							self.inst:PushEvent("builditem", { item = prod, recipe = recipe, skin = skin })
							GLOBAL.ProfileStatsAdd("build_"..prod.prefab)

							if prod.components.equippable ~= nil and self.inst.components.inventory:GetEquippedItem(prod.components.equippable.equipslot) == nil then
								if recipe.numtogive <= 1 then
									--The item is equippable. Equip it.
									self.inst.components.inventory:Equip(prod)
									
									--多一份
									self.inst.components.inventory:GiveItem( SpawnPrefab(recipe.product, skin, nil, self.inst.userid) )
									
								elseif prod.components.stackable ~= nil then
									--The item is stackable. Just increase the stack size of the original item.
									
									--多一份
									prod.components.stackable:SetStackSize(recipe.numtogive * 2)
									
									self.inst.components.inventory:Equip(prod)
								else
									--We still need to equip the original product that was spawned, so do that.
									self.inst.components.inventory:Equip(prod)
									--Now spawn in the rest of the items and give them to the player.
									
									--多一份
									for i = 2, recipe.numtogive * 2 do
										local addt_prod = SpawnPrefab(recipe.product)
										self.inst.components.inventory:GiveItem(addt_prod, nil, pt)
									end
									
								end
							elseif recipe.numtogive <= 1 then
								--Only the original item is being received.
								self.inst.components.inventory:GiveItem(prod, nil, pt)
								
								--多一份
								self.inst.components.inventory:GiveItem( SpawnPrefab(recipe.product, skin, nil, self.inst.userid) )
								
							elseif prod.components.stackable ~= nil then
								--The item is stackable. Just increase the stack size of the original item.
								
								--多一份
								prod.components.stackable:SetStackSize(recipe.numtogive * 2)
								self.inst.components.inventory:GiveItem(prod, nil, pt)
								
							else
								--We still need to give the player the original product that was spawned, so do that.
								self.inst.components.inventory:GiveItem(prod, nil, pt)
								--Now spawn in the rest of the items and give them to the player.
								
								--多一份
								for i = 2, recipe.numtogive * 2 do
									local addt_prod = SpawnPrefab(recipe.product)
									self.inst.components.inventory:GiveItem(addt_prod, nil, pt)
								end
								
							end

							if self.onBuild ~= nil then
								self.onBuild(self.inst, prod)
							end
							prod:OnBuilt(self.inst)

							return true
						end
					else
						prod.Transform:SetPosition(pt:Get())
						--V2C: or 0 check added for backward compatibility with mods that
						--     have not been updated to support placement rotation yet
						prod.Transform:SetRotation(rotation or 0)
						self.inst:PushEvent("buildstructure", { item = prod, recipe = recipe, skin = skin })
						prod:PushEvent("onbuilt", { builder = self.inst })
						GLOBAL.ProfileStatsAdd("build_"..prod.prefab)

						if self.onBuild ~= nil then
							self.onBuild(self.inst, prod)
						end

						prod:OnBuilt(self.inst)

						return true
					end
				end
			end
			--[[
			local recipe = GLOBAL.GetValidRecipe(recname)
			if recipe ~= nil and (self:IsBuildBuffered(recname) or self:CanBuild(recname)) then
				if recipe.placer ~= nil and
					self.inst.components.rider ~= nil and
					self.inst.components.rider:IsRiding() then
					return false, "MOUNTED"
				end

				local wetlevel = self.buffered_builds[recname]
				if wetlevel ~= nil then
					self.buffered_builds[recname] = nil
					self.inst.replica.builder:SetIsBuildBuffered(recname, false)
				else
					local materials = self:GetIngredients(recname)
					wetlevel = self:GetIngredientWetness(materials)
					self:RemoveIngredients(materials, recname)
				end
				self.inst:PushEvent("refreshcrafting")

				local prod = SpawnPrefab(recipe.product, skin, nil, self.inst.userid)
				if prod ~= nil then
					
					pt = pt or self.inst:GetPosition()

					if wetlevel > 0 and prod.components.inventoryitem ~= nil then
						prod.components.inventoryitem:InheritMoisture(wetlevel, self.inst:GetIsWet())
					end

					if prod.components.inventoryitem ~= nil then
						if self.inst.components.inventory ~= nil then
							--self.inst.components.inventory:GiveItem(prod)
							self.inst:PushEvent("builditem", { item = prod, recipe = recipe, skin = skin })
							ProfileStatsAdd("build_"..prod.prefab)

							if prod.components.equippable ~= nil and self.inst.components.inventory:GetEquippedItem(prod.components.equippable.equipslot) == nil then
								if recipe.numtogive <= 1 then
									--The item is equippable. Equip it.
									self.inst.components.inventory:Equip(prod)
								elseif prod.components.stackable ~= nil then
									--The item is stackable. Just increase the stack size of the original item.
									prod.components.stackable:SetStackSize(recipe.numtogive)
									self.inst.components.inventory:Equip(prod)
								else
									--We still need to equip the original product that was spawned, so do that.
									self.inst.components.inventory:Equip(prod)
									--Now spawn in the rest of the items and give them to the player.
									for i = 2, recipe.numtogive do
										local addt_prod = SpawnPrefab(recipe.product)
										self.inst.components.inventory:GiveItem(addt_prod, nil, pt)
									end
								end
							elseif recipe.numtogive <= 1 then
								--Only the original item is being received.
								self.inst.components.inventory:GiveItem(prod, nil, pt)
							elseif prod.components.stackable ~= nil then
								--The item is stackable. Just increase the stack size of the original item.
								prod.components.stackable:SetStackSize(recipe.numtogive)
								self.inst.components.inventory:GiveItem(prod, nil, pt)
							else
								--We still need to give the player the original product that was spawned, so do that.
								self.inst.components.inventory:GiveItem(prod, nil, pt)
								--Now spawn in the rest of the items and give them to the player.
								for i = 2, recipe.numtogive do
									local addt_prod = SpawnPrefab(recipe.product)
									self.inst.components.inventory:GiveItem(addt_prod, nil, pt)
								end
							end

							if self.onBuild ~= nil then
								self.onBuild(self.inst, prod)
							end
							prod:OnBuilt(self.inst)

							return true
						end
					else
						prod.Transform:SetPosition(pt:Get())
						--V2C: or 0 check added for backward compatibility with mods that
						--     have not been updated to support placement rotation yet
						prod.Transform:SetRotation(rotation or 0)
						self.inst:PushEvent("buildstructure", { item = prod, recipe = recipe, skin = skin })
						prod:PushEvent("onbuilt", { builder = self.inst })
						ProfileStatsAdd("build_"..prod.prefab)

						if self.onBuild ~= nil then
							self.onBuild(self.inst, prod)
						end

						prod:OnBuilt(self.inst)

						return true
					end
				end
			end]]
		else
			return old_DoBuild(self, recname, pt, rotation, skin)
		end
	end
	
	--[[
	function cmp:DoBuild(recname, pt, rotation, skin)
		local recipe = GLOBAL.GetValidRecipe(recname)
		if recipe ~= nil and (self:IsBuildBuffered(recname) or self:CanBuild(recname)) then
			if recipe.placer ~= nil and
				self.inst.components.rider ~= nil and
				self.inst.components.rider:IsRiding() then
				return false, "MOUNTED"
			end

			local wetlevel = self.buffered_builds[recname]
			if wetlevel ~= nil then
				self.buffered_builds[recname] = nil
				self.inst.replica.builder:SetIsBuildBuffered(recname, false)
			else
				local materials = self:GetIngredients(recname)
				wetlevel = self:GetIngredientWetness(materials)
				self:RemoveIngredients(materials, recname)
			end
			self.inst:PushEvent("refreshcrafting")

			local prod = SpawnPrefab(recipe.product, skin, nil, self.inst.userid)
			if prod ~= nil then
				
				pt = pt or self.inst:GetPosition()

				if wetlevel > 0 and prod.components.inventoryitem ~= nil then
					prod.components.inventoryitem:InheritMoisture(wetlevel, self.inst:GetIsWet())
				end

				if prod.components.inventoryitem ~= nil then
					if self.inst.components.inventory ~= nil then
						--self.inst.components.inventory:GiveItem(prod)
						self.inst:PushEvent("builditem", { item = prod, recipe = recipe, skin = skin })
						GLOBAL.ProfileStatsAdd("build_"..prod.prefab)

						if prod.components.equippable ~= nil and self.inst.components.inventory:GetEquippedItem(prod.components.equippable.equipslot) == nil then
							if recipe.numtogive <= 1 then
								--The item is equippable. Equip it.
								self.inst.components.inventory:Equip(prod)
								
								--多一份
								self.inst.components.inventory:GiveItem( SpawnPrefab(recipe.product, skin, nil, self.inst.userid) )
								
							elseif prod.components.stackable ~= nil then
								--The item is stackable. Just increase the stack size of the original item.
								
								--多一份
								prod.components.stackable:SetStackSize(recipe.numtogive * 2)
								
								self.inst.components.inventory:Equip(prod)
							else
								--We still need to equip the original product that was spawned, so do that.
								self.inst.components.inventory:Equip(prod)
								--Now spawn in the rest of the items and give them to the player.
								
								--多一份
								for i = 2, recipe.numtogive * 2 do
									local addt_prod = SpawnPrefab(recipe.product)
									self.inst.components.inventory:GiveItem(addt_prod, nil, pt)
								end
								
							end
						elseif recipe.numtogive <= 1 then
							--Only the original item is being received.
							self.inst.components.inventory:GiveItem(prod, nil, pt)
							
							--多一份
							self.inst.components.inventory:GiveItem( SpawnPrefab(recipe.product, skin, nil, self.inst.userid) )
							
						elseif prod.components.stackable ~= nil then
							--The item is stackable. Just increase the stack size of the original item.
							
							--多一份
							prod.components.stackable:SetStackSize(recipe.numtogive * 2)
							self.inst.components.inventory:GiveItem(prod, nil, pt)
							
						else
							--We still need to give the player the original product that was spawned, so do that.
							self.inst.components.inventory:GiveItem(prod, nil, pt)
							--Now spawn in the rest of the items and give them to the player.
							
							--多一份
							for i = 2, recipe.numtogive * 2 do
								local addt_prod = SpawnPrefab(recipe.product)
								self.inst.components.inventory:GiveItem(addt_prod, nil, pt)
							end
							
						end

						if self.onBuild ~= nil then
							self.onBuild(self.inst, prod)
						end
						prod:OnBuilt(self.inst)

						return true
					end
				else
					prod.Transform:SetPosition(pt:Get())
					--V2C: or 0 check added for backward compatibility with mods that
					--     have not been updated to support placement rotation yet
					prod.Transform:SetRotation(rotation or 0)
					self.inst:PushEvent("buildstructure", { item = prod, recipe = recipe, skin = skin })
					prod:PushEvent("onbuilt", { builder = self.inst })
					GLOBAL.ProfileStatsAdd("build_"..prod.prefab)

					if self.onBuild ~= nil then
						self.onBuild(self.inst, prod)
					end

					prod:OnBuilt(self.inst)

					return true
				end
			end
		end
	end]]

end)


----R技能
local function r_skill(inst,x,y,z)
	for i = 1, 16 do
		local fx = SpawnPrefab("rem_icespike")
		if fx then
			fx.Transform:SetPosition( inst.Transform:GetWorldPosition() )
			fx.master = inst
			fx.Transform:SetRotation( 360/16 * (i-1) )
			fx.Physics:SetMotorVelOverride(10,0,0) 
		end
    end
end
AddModRPCHandler("rem", "r_skill", r_skill)










