local assets =
{
   Asset("ANIM", "anim/fish_dried.zip"),
    
   Asset("ATLAS", "images/inventoryimages/fish_dried.xml"),
   Asset("IMAGE", "images/inventoryimages/fish_dried.tex"),
}


local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("fish_dried")
    inst.AnimState:SetBuild("fish_dried")
    inst.AnimState:PlayAnimation("idle_fish_dried")
    
    inst:AddTag("meat")
    inst:AddTag("catfood")
    inst:AddTag("cookable")

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/fish_dried.xml"  
	
    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("bait")

    inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = TUNING.GOLD_VALUES.MEAT

    inst:AddComponent("perishable")
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"
    inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
	
    inst:AddComponent("edible")
    inst.components.edible.hungervalue = 18.8
    inst.components.edible.sanityvalue = 12
    inst.components.edible.healthvalue = 20

    return inst
end

return Prefab( "common/inventory/fish_dried", fn, assets)




