local assets =
{
	Asset("ANIM", "anim/jerky_dried.zip"),
	Asset("ANIM", "anim/jerky_dried_idle.zip"),
	Asset("ATLAS", "images/inventoryimages/jerky_dried.xml"),
	Asset("IMAGE", "images/inventoryimages/jerky_dried.tex"),
}


local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("jerky_dried_idle")
    inst.AnimState:SetBuild("jerky_dried_idle")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddTag("meat")
    inst:AddTag("catfood")
    inst:AddTag("cookable")

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/jerky_dried.xml"  
	
    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("bait")

    inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = TUNING.GOLD_VALUES.MEAT

    inst:AddComponent("perishable")
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"
    inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
	
    inst:AddComponent("edible")
	inst.components.edible.foodstate = "DRIED"
    inst.components.edible.hungervalue = 25
    inst.components.edible.sanityvalue = 20
	inst.components.edible.healthvalue = 40

    return inst
end

return Prefab( "common/inventory/jerky_dried", fn, assets)
