Scriptname _VLotusPoisonDialogueQuest extends Quest Conditional

int Property pGivenPoisonRecipeMuiri Auto Conditional
int Property pThreatenedMuiri Auto Conditional
int Property pOfferedBribeMuiri Auto Conditional
int Property pBlackmailMuiri Auto Conditional
int Property pLearnedInterestZaria Auto Conditional
int Property pExperimentRequestZaria Auto Conditional
int Property pGivenPoisonRecipeZaria Auto Conditional

FavorDialogueScript Property pFDS  Auto  
_VLotusPoisonZariaQuest Property pZQS  Auto  

GlobalVariable Property pBribeAmount  Auto  

function SetBribeAmount(Actor pTarget, GlobalVariable aBribeGlobal, float afValue = 1.0, bool abExact = false)
	if abExact
		aBribeGlobal.setValueInt(afValue as int)
	else
		aBribeGlobal.setValueInt((pTarget.GetBribeAmount() * afValue) as int)
	endIf
	UpdateCurrentInstanceGlobal(aBribeGlobal)
endFunction

function Bribe(Actor pTarget, GlobalVariable aBribeGlobal, bool bSkillIncrease = true)
	pFDS.SkillUseMultiplier = pFDS.SpeechSkillMult.value
	pFDS.SkillUseBribe = pFDS.SkillUseMultiplier * Game.GetPlayer().GetAv("Speechcraft")
	if aBribeGlobal.GetValueInt() <= Game.GetPlayer().GetGoldAmount()
		Game.GetPlayer().RemoveItem(pFDS.Gold, aBribeGlobal.GetValueInt())
		pTarget.AddItem(pFDS.Gold, aBribeGlobal.GetValueInt())
		if bSkillIncrease
			pTarget.SetBribed()
			Game.AdvanceSkill("Speechcraft", pFDS.SkillUseBribe)
			Game.IncrementStat("Bribes")
		endIf
	endIf
endFunction

function HelpRelationship(Actor akSpeaker, int aiRank)
	if akSpeaker.GetRelationshipRank(Game.GetPlayer()) < aiRank
		akSpeaker.SetRelationshipRank(Game.GetPlayer(), aiRank)
	endIf
endFunction

function HurtRelationship(Actor akSpeaker, int aiRank)
	if akSpeaker.GetRelationshipRank(Game.GetPlayer()) > aiRank
		akSpeaker.SetRelationshipRank(Game.GetPlayer(), aiRank)
	endIf
endFunction
