Scriptname _VLotusPoisonZariaQuest extends Quest Conditional

int Property pExperimentStatus Auto Conditional

ReferenceAlias Property pSkeeverAlias  Auto  
ReferenceAlias Property pCageDoorAlias  Auto  
ReferenceAlias Property pSkeeverNestAlias  Auto  
ReferenceAlias Property pPoisonedSkeeverFoodAlias  Auto  

Scene Property pEscortToCageScene  Auto  
Scene Property pPoisonTheSkeeverScene  Auto  
Scene Property pCageOpenedScene  Auto  
Scene Property pSkeeverKilledScene  Auto  

GlobalVariable Property pIngredient1Count  Auto  
GlobalVariable Property pIngredient2Count  Auto  
GlobalVariable Property pIngredient3Count  Auto  
Ingredient Property pIngredient1  Auto  
Ingredient Property pIngredient2  Auto  
Ingredient Property pIngredient3  Auto  

float Function ScheduleTime(float duration)
	float open = 8.0 ; Time open for business
	float close = 20.0 ; Time closed for business
	float time = Utility.GetCurrentGameTime()
	time -= Math.Floor(time) ; Remove "previous in-game days passed" bit
	time *= 24.0 ; Convert from fraction of a day to number of hours
	if time + duration > close
		duration += (24.0 - close + open) * (Math.Ceiling(duration / (close - open)))
	endIf
	return duration
EndFunction

; Zaria needs time to create poison formula
Function StartFormula()
	GotoState("Formula")
EndFunction
State Formula
	Event OnBeginState()
		RegisterForSingleUpdateGameTime(ScheduleTime(Utility.RandomFloat(2.0, 4.0)))
	EndEvent
	Event OnUpdateGameTime()
		SetStage(20)
		GotoState("")
	EndEvent
EndState

; Begin the escort to cage scene
Function EscortToCage()
	; Zaria leads player to skeever cage
	SetObjectiveDisplayed(20, false)
	pEscortToCageScene.Start()
	
	; Ready the skeever and lock the cage
	ObjectReference skeever = pSkeeverAlias.GetRef()
	skeever.EnableNoWait()
	skeever.Reset()
	pCageDoorAlias.GetRef().Lock()
	pSkeeverNestAlias.GetRef().SetDestroyed()
EndFunction

; Zaria gives player poisoned skeever food
Function GivePlayerSkeeverFood()
	ObjectReference food = pPoisonedSkeeverFoodAlias.GetRef()
	food.EnableNoWait()
	Game.GetPlayer().AddItem(food)
	pSkeeverNestAlias.GetRef().SetDestroyed(false)
EndFunction

; Zaria feeds the skeever the poisoned food for you
Function ZariaFeedsSkeever()
	Actor player = Game.GetPlayer()
	ObjectReference food = pPoisonedSkeeverFoodAlias.GetRef()
	ObjectReference nest = pSkeeverNestAlias.GetRef()
	player.RemoveItem(food, akOtherContainer=player)
	food.MoveTo(nest, afZOffset=-100)
	food.DisableNoWait()
	nest.SetDestroyed()
	(pSkeeverAlias.GetRef() as Actor).SetGhost()
	pExperimentStatus = 2
	pPoisonTheSkeeverScene.Start()
	pCageDoorAlias.GetRef().SetDestroyed()
EndFunction

; Skeever eats poisoned food
Function SkeeverEatsFood()
	Actor skeever = pSkeeverAlias.GetRef() as Actor
	skeever.SetGhost(false)
	skeever.Kill(skeever)
	pCageDoorAlias.GetRef().SetDestroyed(false)
	pExperimentStatus = 3
EndFunction

; Manage ingredient fetch quest objectives
Function IngredientCount(Ingredient akIngredient)
	if GetStage() == 60
		Actor player = Game.GetPlayer()
		int currentCount
		if akIngredient == pIngredient1
			currentCount = player.GetItemCount(pIngredient1)
			pIngredient1Count.SetValueInt(currentCount)
			UpdateCurrentInstanceGlobal(pIngredient1Count)
			if currentCount >= 8
				SetObjectiveCompleted(60)
				SetObjectiveDisplayed(70)
			else
				SetObjectiveCompleted(60, false)
				SetObjectiveDisplayed(70, false)
				SetObjectiveDisplayed(60)
			endIf
		elseIf akIngredient == pIngredient2
			currentCount = player.GetItemCount(pIngredient2)
			pIngredient2Count.SetValueInt(currentCount)
			UpdateCurrentInstanceGlobal(pIngredient2Count)
			if currentCount >= 5
				SetObjectiveCompleted(61)
				SetObjectiveDisplayed(71)
			else
				SetObjectiveCompleted(61, false)
				SetObjectiveDisplayed(71, false)
				SetObjectiveDisplayed(61)
			endIf
		elseIf akIngredient == pIngredient3
			currentCount = player.GetItemCount(pIngredient3)
			pIngredient3Count.SetValueInt(currentCount)
			UpdateCurrentInstanceGlobal(pIngredient3Count)
			if currentCount >= 3
				SetObjectiveCompleted(62)
				SetObjectiveDisplayed(72)
			else
				SetObjectiveCompleted(62, false)
				SetObjectiveDisplayed(72, false)
				SetObjectiveDisplayed(62)
			endIf
		endIf
	endIf
EndFunction
