local assets =
{
	Asset( "ANIM", "anim/rem_armor.zip" ),
	Asset( "ATLAS", "images/rem_armor.xml" ),
}

local maxlevel = 4

local function onequip(inst, owner) 
	if owner.prefab == "rem" then
		--owner.AnimState:OverrideSymbol("swap_body", "rem_armor", "swap_body")
		owner.AnimState:ClearOverrideSymbol("swap_body")
		--if inst.components.container ~= nil then
		--	inst.components.container:Open(owner)
		--end
	else
		owner:DoTaskInTime(0, function()
			local inv = owner.components.inventory 
			if inv then
				inv:GiveItem(inst)
			end
			local talker = owner.components.talker 
			if talker then
				talker:Say("This is only for Rem!")
			end
		end)
	end
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	if inst.components.container ~= nil then
        inst.components.container:Close(owner)
    end
end

----可扩展
local function applyupgrades(inst, giver)
    local max_upgrades = maxlevel
	inst.level = math.min(inst.level, max_upgrades)
	inst.components.container:WidgetSetup("rem_armor"..inst.level)
	
	if giver then
		inst.components.container:Close(giver)
		if giver.components.talker then
			local str = "Dress's Level"..( inst.level >= max_upgrades and " Max" or "")..": "..inst.level
			giver.components.talker:Say(str)
		end
	end
	
end

local function onpreload(inst, data)
    inst.level = data and data.level or 0
	applyupgrades(inst)
end

local function onsave(inst, data)
    data.level = inst.level or 0
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("rem_armor")
    inst.AnimState:SetBuild("rem_armor")
    inst.AnimState:PlayAnimation("anim")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "rem_armor"
    inst.components.inventoryitem.atlasname = "images/rem_armor.xml"

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	
	--容器组建
	inst:AddComponent("container")
	inst.components.container:WidgetSetup("rem_armor0")
	
	inst.level = 0
	applyupgrades(inst)
	
	--升级
	local function AcceptTest(inst, item)
		return item and item.prefab == "purplegem" and inst.level < maxlevel
	end
	local function OnGetItemFromPlayer(inst, giver, item)
		if item and item.prefab == "purplegem" then
			inst.level = inst.level + 1
			applyupgrades(inst, giver)
		end
	end
	local function OnRefuseItem(inst, giver, item)
		if giver and giver.components.talker then
			if item and item.prefab ~= "purplegem" then
				giver.components.talker:Say("Use purplegem to upgrade the dress.")
			elseif inst.level >= maxlevel then
				giver.components.talker:Say("The dress is at Max Level "..inst.level)
			end
		end
	end
	inst:AddComponent("trader")
    inst.components.trader:SetAcceptTest(AcceptTest)
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader.onrefuse = OnRefuseItem
	
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload

    return inst
end

return Prefab("rem_armor", fn, assets)
